/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.SSLClient;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.PebAccessoryReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebProcessOrderCountBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.api.PebExtFscShouldRefundPayCrateAtomService;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreOrderShipAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderDetailAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderItemListAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.api.UocReturnFeeAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.ShipCruxFieldBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOryOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderDetailRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderItemListRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipItemReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomRspBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebOrderDeliveryBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdShipRejectionMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdConfirmItemMapper;
import com.tydic.uoc.dao.UocOrdConfirmMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdShipRejectionPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdConfirmItemPO;
import com.tydic.uoc.po.UocOrdConfirmPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebOrderDeliveryBusiServiceImpl
implements PebOrderDeliveryBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderDeliveryBusiServiceImpl.class);
    private static final Integer PURCHASE_TYPE_MATERIAL = 1;
    private static final Integer ORDER_METHOD_UNIT_PRICE = 1;
    private static final Integer ORDER_METHOD_TOTAL_PRICE = 2;
    private static final Integer ORDER_METHOD_FRAME = 3;
    private static final String DIC_QRY_KEY = "unit_order_ship_limit";
    private static final String DIC_QRY_PCODE = "UNIT_ORDER_SHIP_LIMIT";
    @Autowired
    private UocCoreQryOrderDetailAtomService uocCoreQryOrerDetailAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocCoreQryOrderItemListAtomService uocCoreQryOrderItemListAtomService;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreOrderShipAtomService uocCoreOrderShipAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private UocOrdConfirmMapper uocOrdConfirmMapper;
    @Autowired
    private UocOrdConfirmItemMapper uocOrdConfirmItemMapper;
    @Autowired
    private UocProShouldPayOrDeductDealAtomService uocProShouldPayOrDeductDealAtomService;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${POLL_MAP_URL:http://poll.kuaidi100.com/pollmap}")
    private String pollMapUrl;
    @Value(value="${EXPERSS_CALL_BACK_URL:https://ego.chinacoal.com/dyc/busicommon/order/noauth/shipCall}")
    private String callbackUrl;
    @Value(value="${KUAIDI_100_KEY:DQkMzooN6154}")
    private String key;
    @Autowired
    private PebExtFscShouldRefundPayCrateAtomService pebExtFscShouldRefundPayCrateAtomService;
    @Autowired
    private UocReturnFeeAtomService uocReturnFeeAtomService;
    @Autowired
    private OrdShipRejectionMapper ordShipRejectionMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebOrderDeliveryAbilityRspBO dealPebOrderDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        DateTime beginDate;
        List pebProcessOrderCountBOList;
        UocCoreQryOrderDetailRspBO uocCoreQryOrderDetailRspBO;
        this.validateArg(reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getShipAdress())) {
            String shippingAddressName = "";
            if (reqBO.getProvinceName() != null) {
                shippingAddressName = shippingAddressName + reqBO.getProvinceName();
            }
            if (reqBO.getCityName() != null) {
                shippingAddressName = shippingAddressName + reqBO.getCityName();
            }
            if (reqBO.getCountyName() != null) {
                shippingAddressName = shippingAddressName + reqBO.getCountyName();
            }
            if (reqBO.getTownName() != null) {
                shippingAddressName = shippingAddressName + reqBO.getTownName();
            }
            if (reqBO.getDetailAddress() != null) {
                shippingAddressName = shippingAddressName + reqBO.getDetailAddress();
            }
            reqBO.setShipAdress(shippingAddressName);
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
            reqBO.setActionCode("ACTPEB005");
        }
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        UocCoreOryOrderReqBO uocCoreOryOrderReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderReqBO.setOrderId(reqBO.getOrderId());
        if (StringUtils.isEmpty((CharSequence)reqBO.getTransportMode()) || "2".equals(reqBO.getTransportMode())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO.setPackageId(reqBO.getProcessNum());
            int count = this.ordShipMapper.getCheckBy(ordShipPO);
            if (count > 0) {
                throw new UocProBusinessException("100001", "\u914d\u9001\u5355\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
        if (!"0000".equals((uocCoreQryOrderDetailRspBO = this.uocCoreQryOrerDetailAtomService.qryCoreQryOrderDetail(uocCoreOryOrderReqBO)).getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreQryOrderDetailRspBO.getRespDesc());
        }
        if (uocCoreQryOrderDetailRspBO.getOrderRspBO() == null || uocCoreQryOrderDetailRspBO.getOrdSaleRspBO() == null) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:\u6ca1\u6709\u67e5\u8be2\u5230\u76f8\u5173\u5355\u636e!");
        }
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
        OrdSaleRspBO ordSaleRspBO = uocCoreQryOrderDetailRspBO.getOrdSaleRspBO();
        UocCoreOryOrderReqBO uocCoreOryOrderItemReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderItemReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderItemReqBO.setPageNo(1);
        uocCoreOryOrderItemReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOryOrderItemReqBO.setPageSize(200);
        UocCoreQryOrderItemListRspBO uocCoreQryOrderItemListRspBO = this.uocCoreQryOrderItemListAtomService.qryCoreQryOrderItemList(uocCoreOryOrderItemReqBO);
        if (!"0000".equals(uocCoreQryOrderItemListRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreQryOrderItemListRspBO.getRespDesc());
        }
        List rows = uocCoreQryOrderItemListRspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:\u6ca1\u6709\u67e5\u8be2\u5230\u660e\u7ec6\u4fe1\u606f!");
        }
        DicDictionaryBO codeByVal = this.dicDictionaryService.getCodeByVal(DIC_QRY_KEY, DIC_QRY_PCODE);
        int multiple = 1;
        if (codeByVal != null) {
            multiple = Integer.parseInt(codeByVal.getDescrip());
        }
        if (!CollectionUtils.isEmpty((Collection)(pebProcessOrderCountBOList = reqBO.getPebProcessOrderCountBOList()))) {
            for (PebProcessOrderCountBO pebProcessOrderCountBO : pebProcessOrderCountBOList) {
                for (OrdItemRspBO ordItemRspBO : rows) {
                    BigDecimal newSendCount;
                    if (!ordItemRspBO.getOrdItemId().equals(pebProcessOrderCountBO.getOrdItemId())) continue;
                    pebProcessOrderCountBO.setUnitName(ordItemRspBO.getUnitName());
                    BigDecimal purchaseCount = ordItemRspBO.getPurchaseCount();
                    BigDecimal sendCount = ordItemRspBO.getSendCount();
                    if (sendCount == null) {
                        sendCount = new BigDecimal(0);
                    }
                    if ((newSendCount = sendCount.add(pebProcessOrderCountBO.getProcessCount())).compareTo(purchaseCount) > 0) {
                        BigDecimal modVal = newSendCount.remainder(purchaseCount).setScale(0, RoundingMode.HALF_UP);
                        if (newSendCount.multiply(new BigDecimal(multiple)).compareTo(purchaseCount) > 0) {
                            throw new UocProBusinessException("100001", "\u53d1\u8d27\u91cf\u4e0d\u80fd\u5927\u4e8e\u672a\u53d1\u8d27\u91cf");
                        }
                    }
                    ordItemRspBO.setSendCount(newSendCount);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getActionCode()) && !PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO pebOperationPermissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            pebOperationPermissionsCheckingAtomReqBO.setActionCode(reqBO.getActionCode());
            pebOperationPermissionsCheckingAtomReqBO.setAuthCtrl(reqBO.getAuthCtrl());
            pebOperationPermissionsCheckingAtomReqBO.setOrderId(reqBO.getOrderId());
            pebOperationPermissionsCheckingAtomReqBO.setStationId(reqBO.getStationId());
            pebOperationPermissionsCheckingAtomReqBO.setMemId(reqBO.getMemId());
            pebOperationPermissionsCheckingAtomReqBO.setMemId(reqBO.getMemIdIn());
            PebOperationPermissionsCheckingAtomRspBO pebOperationPermissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(pebOperationPermissionsCheckingAtomReqBO);
            if (!"0000".equals(pebOperationPermissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u6743\u9650\u6821\u9a8c\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + pebOperationPermissionsCheckingAtomRspBO.getRespDesc());
            }
        }
        UocCoreOrderShipReqBO uocCoreOrderShipReqBO = new UocCoreOrderShipReqBO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setShipStatus("1201");
        uocCoreOrderShipReqBO.setIsStartProcess(true);
        uocCoreOrderShipReqBO.setPackageId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setExtOrderId(reqBO.getExtOrderId());
        uocCoreOrderShipReqBO.setShipName(reqBO.getProcessName());
        uocCoreOrderShipReqBO.setShipPhone(reqBO.getProcessPhone());
        uocCoreOrderShipReqBO.setSubmit(reqBO.getSubmit());
        uocCoreOrderShipReqBO.setExt1(reqBO.getUsername());
        uocCoreOrderShipReqBO.setExt2(reqBO.getName());
        uocCoreOrderShipReqBO.setReceiverAddressId(reqBO.getReceiverAddressId());
        uocCoreOrderShipReqBO.setReceiverAddressName(reqBO.getReceiverAddressName());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryTime())) {
            beginDate = DateTime.parse((String)reqBO.getDeliveryTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setShipTime(beginDate.toDate());
        } else {
            uocCoreOrderShipReqBO.setShipTime(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEstimatedArrivalTime())) {
            beginDate = DateTime.parse((String)reqBO.getEstimatedArrivalTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setEstimateArrivalTime(beginDate.toDate());
        }
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipCompanyId(reqBO.getTransportMode());
        uocCoreOrderShipReqBO.setShipCompanyName(reqBO.getLogisticsExecutionUnit());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipOrderNo())) {
            uocCoreOrderShipReqBO.setShipVoucherCode(reqBO.getShipOrderNo());
        } else {
            uocCoreOrderShipReqBO.setShipVoucherCode(this.buildNo(uocCoreQryOrderDetailRspBO.getOrdPurchaseRspBO().getPurchaseVoucherNo(), "FHD", "ORDER_SHIP_NO", uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getOrderSource()));
        }
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        ArrayList<ShipCruxFieldBO> shipCruxFieldBOList = new ArrayList<ShipCruxFieldBO>();
        ShipCruxFieldBO shipCruxFieldBO = new ShipCruxFieldBO();
        shipCruxFieldBO.setFieldCode("processDate");
        shipCruxFieldBO.setFieldName("\u65bd\u5de5\u3001\u670d\u52a1\u5904\u7406\u65f6\u95f4");
        shipCruxFieldBO.setFieldValue(reqBO.getProcessDate());
        shipCruxFieldBOList.add(shipCruxFieldBO);
        uocCoreOrderShipReqBO.setCruxFieldList(shipCruxFieldBOList);
        if (!CollectionUtils.isEmpty((Collection)pebProcessOrderCountBOList)) {
            ArrayList<UocCoreShipItemReqBO> uocCoreShipItemReqBOList = new ArrayList<UocCoreShipItemReqBO>();
            for (Object pebProcessOrderCountBO : pebProcessOrderCountBOList) {
                if (pebProcessOrderCountBO.getProcessCount().compareTo(BigDecimal.ZERO) == 0) continue;
                UocCoreShipItemReqBO uocCoreShipItemReqBO = new UocCoreShipItemReqBO();
                uocCoreShipItemReqBO.setOrdItemId(pebProcessOrderCountBO.getOrdItemId());
                uocCoreShipItemReqBO.setSendCount(pebProcessOrderCountBO.getProcessCount());
                uocCoreShipItemReqBO.setOrderId(reqBO.getOrderId());
                uocCoreShipItemReqBO.setUnitName(pebProcessOrderCountBO.getUnitName());
                uocCoreShipItemReqBO.setFileList(pebProcessOrderCountBO.getFileList());
                uocCoreShipItemReqBOList.add(uocCoreShipItemReqBO);
            }
            if (CollectionUtils.isEmpty(uocCoreShipItemReqBOList)) {
                throw new UocProBusinessException("102033", "\u4e0d\u80fd\u6240\u6709\u5546\u54c1\u53d1\u8d27\u6570\u91cf\u90fd\u4e3a0");
            }
            uocCoreOrderShipReqBO.setShipItemList(uocCoreShipItemReqBOList);
        }
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setIsStartProcess(true);
        uocCoreOrderShipReqBO.setProcKey("peb_el_ship_order_order_status");
        uocCoreOrderShipReqBO.setShipAdress(reqBO.getShipAdress());
        uocCoreOrderShipReqBO.setCarNumber(reqBO.getCarNumber());
        uocCoreOrderShipReqBO.setDriverName(reqBO.getDriverName());
        uocCoreOrderShipReqBO.setDriverPhone(reqBO.getDriverPhone());
        uocCoreOrderShipReqBO.setProvinceId(reqBO.getProvinceId());
        uocCoreOrderShipReqBO.setProvinceName(reqBO.getProvinceName());
        uocCoreOrderShipReqBO.setCityId(reqBO.getCityId());
        uocCoreOrderShipReqBO.setCityName(reqBO.getCityName());
        uocCoreOrderShipReqBO.setCountyId(reqBO.getCountyId());
        uocCoreOrderShipReqBO.setCountyName(reqBO.getCountyName());
        uocCoreOrderShipReqBO.setTownId(reqBO.getTownId());
        uocCoreOrderShipReqBO.setTownName(reqBO.getTownName());
        uocCoreOrderShipReqBO.setDetailAddress(reqBO.getDetailAddress());
        uocCoreOrderShipReqBO.setOrganizationIdNew(reqBO.getOrganizationIdNew());
        uocCoreOrderShipReqBO.setOrganizationNameNew(reqBO.getOrganizationNameNew());
        UocCoreOrderShipRspBO uocCoreOrderShipRspBO = this.uocCoreOrderShipAtomService.dealCoreOrderShip(uocCoreOrderShipReqBO);
        if (!"0000".equals(uocCoreOrderShipRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u751f\u6210\u53d1\u8d27,\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreOrderShipRspBO.getRespDesc());
        }
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(uocCoreOrderShipRspBO.getShipVoucherId());
        boolean isAll = true;
        for (OrdItemRspBO ordItemRspBO : rows) {
            if (ordItemRspBO.getSendCount().compareTo(ordItemRspBO.getPurchaseCount()) >= 0) continue;
            isAll = false;
            break;
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(reqBO.getOrderId());
        ordSalePo = this.ordSaleMapper.getModelBy(ordSalePo);
        Boolean auto = false;
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(ordSalePo.getSaleState())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setObjId(reqBO.getSaleVoucherId());
            processRunReqBO.setOrderId(reqBO.getOrderId());
            processRunReqBO.setOperId(reqBO.getMemIdIn() + "");
            processRunReqBO.setOperId(reqBO.getMemId() + "");
            processRunReqBO.setOperName(reqBO.getUsername());
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("cancelFlag", 0);
            processRunReqBO.setVariables(param);
            UocProcessRunRspBO start = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(start.getRespCode())) {
                throw new UocProBusinessException("100001", "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + start.getRespDesc());
            }
            auto = start.getAuto();
        }
        this.saveFile(uocCoreOrderShipRspBO.getShipVoucherId(), reqBO);
        this.subscribeMap(reqBO, ordSalePo);
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        pebOrderDeliveryAbilityRspBO.setAuto(auto);
        return pebOrderDeliveryAbilityRspBO;
    }

    private void saveFile(Long shipId, PebOrderDeliveryAbilityReqBO reqBO) {
        List pebAccessoryReqBOList = reqBO.getPebAccessoryReqBOList();
        if (!CollectionUtils.isEmpty((Collection)pebAccessoryReqBOList)) {
            for (PebAccessoryReqBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                uocCoreCreateAccessoryReqBO.setObjectId(shipId);
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    @Override
    public PebOrderDeliveryAbilityRspBO dealUpdateDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        int count;
        DateTime beginDate;
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(reqBO.getShipVoucherId());
        if (PebExtConstant.YES.equals(reqBO.getIsFile())) {
            if (Objects.nonNull(reqBO.getWarehouseAgrArriveTime())) {
                OrdShipPO ordShipModel = new OrdShipPO();
                ordShipModel.setShipVoucherId(reqBO.getShipVoucherId());
                ordShipModel.setOrderId(reqBO.getOrderId());
                ordShipModel.setWarehouseAgrArriveTime(reqBO.getWarehouseAgrArriveTime());
                this.ordShipMapper.updateById(ordShipModel);
                return pebOrderDeliveryAbilityRspBO;
            }
            OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
            accessoryPO.setOrderId(reqBO.getOrderId());
            accessoryPO.setObjectId(reqBO.getShipVoucherId());
            accessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
            accessoryPO.setRemark("ACTPEB004");
            this.ordAccessoryMapper.deleteBy(accessoryPO);
            reqBO.setActionCode("ACTPEB004");
            this.saveFile(reqBO.getShipVoucherId(), reqBO);
            return pebOrderDeliveryAbilityRspBO;
        }
        if (PebExtConstant.YES.toString().equals(reqBO.getIsDelete())) {
            OrdShipPO shipPO = new OrdShipPO();
            return pebOrderDeliveryAbilityRspBO;
        }
        OrdShipPO uocCoreOrderShipReqBO = new OrdShipPO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setPackageId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setExtOrderId(reqBO.getExtOrderId());
        uocCoreOrderShipReqBO.setShipName(reqBO.getProcessName());
        uocCoreOrderShipReqBO.setShipPhone(reqBO.getProcessPhone());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryTime())) {
            beginDate = DateTime.parse((String)reqBO.getDeliveryTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setShipTime(beginDate.toDate());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEstimatedArrivalTime())) {
            beginDate = DateTime.parse((String)reqBO.getEstimatedArrivalTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setEstimateArrivalTime(beginDate.toDate());
        }
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipCompanyId(reqBO.getTransportMode());
        uocCoreOrderShipReqBO.setShipCompanyName(reqBO.getLogisticsExecutionUnit());
        uocCoreOrderShipReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        uocCoreOrderShipReqBO.setProvinceId(reqBO.getProvinceId());
        uocCoreOrderShipReqBO.setProvinceName(reqBO.getProvinceName());
        uocCoreOrderShipReqBO.setCityId(reqBO.getCityId());
        uocCoreOrderShipReqBO.setCityName(reqBO.getCityName());
        uocCoreOrderShipReqBO.setCountyId(reqBO.getCountyId());
        uocCoreOrderShipReqBO.setCountyName(reqBO.getCountyName());
        uocCoreOrderShipReqBO.setTownId(reqBO.getTownId());
        uocCoreOrderShipReqBO.setTownName(reqBO.getTownName());
        uocCoreOrderShipReqBO.setDetailAddress(reqBO.getDetailAddress());
        uocCoreOrderShipReqBO.setUpdateTown(Integer.valueOf(1));
        uocCoreOrderShipReqBO.setReceiverAddressId(reqBO.getReceiverAddressId());
        uocCoreOrderShipReqBO.setOrganizationIdNew(reqBO.getOrganizationIdNew());
        uocCoreOrderShipReqBO.setOrganizationNameNew(reqBO.getOrganizationNameNew());
        uocCoreOrderShipReqBO.setDriverName(reqBO.getDriverName());
        uocCoreOrderShipReqBO.setDriverPhone(reqBO.getDriverPhone());
        uocCoreOrderShipReqBO.setReceiverAddressName(reqBO.getReceiverAddressName());
        this.ordShipMapper.updateById(uocCoreOrderShipReqBO);
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        if (PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getTransportMode()) || "2".equals(reqBO.getTransportMode())) {
                OrdShipPO ordShipPO = new OrdShipPO();
                ordShipPO.setOrderId(reqBO.getOrderId());
                ordShipPO.setPackageId(reqBO.getProcessNum());
                ordShipPO.setShipVoucherIdNot(reqBO.getShipVoucherId());
                int count2 = this.ordShipMapper.getCheckBy(ordShipPO);
                if (count2 > 0) {
                    throw new UocProBusinessException("100001", "\u914d\u9001\u5355\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
            }
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            processRunReqBO.setObjId(reqBO.getShipVoucherId());
            processRunReqBO.setOrderId(reqBO.getOrderId());
            processRunReqBO.setOperId(reqBO.getMemIdIn() + "");
            processRunReqBO.setOperId(reqBO.getMemId() + "");
            processRunReqBO.setOperName(reqBO.getUsername());
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("submit", 1);
            processRunReqBO.setVariables(param);
            UocProcessRunRspBO start = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(start.getRespCode())) {
                throw new UocProBusinessException("100001", "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + start.getRespDesc());
            }
        }
        OrdShipItemPO itemPO = new OrdShipItemPO();
        itemPO.setShipVoucherId(reqBO.getShipVoucherId());
        List list = this.ordShipItemMapper.getList(itemPO);
        Map<Long, OrdShipItemPO> map = list.stream().collect(Collectors.toMap(OrdShipItemPO::getShipItemId, i -> i));
        ArrayList<Long> shipItemIds = new ArrayList<Long>(reqBO.getPebProcessOrderCountBOList().size());
        ArrayList<OrdAccessoryPO> accessoryPOList = new ArrayList<OrdAccessoryPO>();
        for (PebProcessOrderCountBO countBO : reqBO.getPebProcessOrderCountBOList()) {
            shipItemIds.add(countBO.getShipItemId());
            if (!CollectionUtils.isEmpty((Collection)countBO.getFileList())) {
                for (PebAccessoryReqBO pebAccessoryReqBO : countBO.getFileList()) {
                    OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
                    accessoryPO.setId(Long.valueOf(this.sequence.nextId()));
                    accessoryPO.setOrderId(reqBO.getOrderId());
                    accessoryPO.setObjectId(countBO.getShipItemId());
                    accessoryPO.setObjectType(UocConstant.OBJ_TYPE.SHIP_ITEM);
                    accessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
                    accessoryPO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                    accessoryPO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                    accessoryPO.setCreateTime(new Date());
                    accessoryPO.setRemark("ACTPEB0051");
                    if (reqBO.getUserId() != null) {
                        accessoryPO.setCreateOperId(reqBO.getUserId() + "");
                    }
                    accessoryPOList.add(accessoryPO);
                }
            }
            OrdShipItemPO shipItemPO = map.get(countBO.getShipItemId());
            BigDecimal num = countBO.getProcessCount().subtract(shipItemPO.getSendCount());
            if (countBO.getProcessCount().compareTo(BigDecimal.ZERO) == 0) {
                this.ordShipItemMapper.deleteById(shipItemPO.getShipItemId().longValue());
            } else {
                OrdShipItemPO update = new OrdShipItemPO();
                update.setShipItemId(shipItemPO.getShipItemId());
                update.setSendCount(num);
                update.setOrderId(reqBO.getOrderId());
                this.ordShipItemMapper.updateCounts(update);
            }
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setSendCount(num);
            ordItemPO.setOrdItemId(shipItemPO.getOrdItemId());
            ordItemPO.setOrderId(reqBO.getOrderId());
            this.ordItemMapper.updateCounts(ordItemPO);
        }
        if (!CollectionUtils.isEmpty(shipItemIds)) {
            OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
            accessoryPO.setOrderId(reqBO.getOrderId());
            accessoryPO.setObjectType(UocConstant.OBJ_TYPE.SHIP_ITEM);
            accessoryPO.setObjectIds(shipItemIds);
            int count3 = this.ordAccessoryMapper.deleteShipItemFile(accessoryPO);
            if (count3 < 0) {
                throw new UocProBusinessException("8888", "\u5220\u9664\u53d1\u8d27\u660e\u7ec6\u9644\u4ef6\u4fe1\u606f\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty(accessoryPOList) && (count = this.ordAccessoryMapper.insertBatch(accessoryPOList)) != accessoryPOList.size()) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u53d1\u8d27\u660e\u7ec6\u9644\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
        for (OrdItemPO po : ordItemPOS) {
            if (po.getPurchaseCount().compareTo(po.getSendCount()) >= 0) continue;
            throw new UocProBusinessException("104025", po.getSkuName() + "\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u91c7\u8d2d\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u518d\u63d0\u4ea4");
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getActionCode())) {
            OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
            accessoryPO.setOrderId(reqBO.getOrderId());
            accessoryPO.setObjectId(reqBO.getShipVoucherId());
            accessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
            accessoryPO.setRemark(reqBO.getActionCode());
            this.ordAccessoryMapper.deleteBy(accessoryPO);
        }
        this.saveFile(reqBO.getShipVoucherId(), reqBO);
        return pebOrderDeliveryAbilityRspBO;
    }

    private void validateArg(PebOrderDeliveryAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPebProcessOrderCountBOList())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PebProcessOrderCountBO proBo : reqBO.getPebProcessOrderCountBOList()) {
            if (ObjectUtil.isEmpty((Object)proBo)) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)proBo.getOrdItemId())) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)proBo.getProcessCount())) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[processCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (proBo.getProcessCount().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[processCount]\u5fc5\u987b\u5927\u4e8e0");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessName())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessPhone())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processPhone]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessNum())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setProcessNum(reqBO.getProcessNum().trim());
    }

    private String buildNo(String saleVoucherNo, String start, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102033", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(saleVoucherNo, start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String buildNo(String saleVoucherNo, String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return saleVoucherNo + "-" + start + "-" + date + time.substring(time.length() - 3);
    }

    @Override
    public PebOrderDeliveryAbilityRspBO dealPurDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        ArrayList confirmIdList = new ArrayList();
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cancelFlag", "0");
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
            salePO.setSaleState(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED);
        }
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        Map<Long, OrdItemPO> map = list.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, i -> i));
        Long confirmId = this.idUtil.nextId();
        OrdShipPO uocCoreOrderShipReqBO = new OrdShipPO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        if (PebExtConstant.YES.equals(reqBO.getConfirm())) {
            uocCoreOrderShipReqBO.setShipStatus("2203");
        } else {
            uocCoreOrderShipReqBO.setShipStatus("2206");
        }
        uocCoreOrderShipReqBO.setShipTime(new Date());
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipVoucherCode(this.buildNo(salePO.getSaleVoucherNo(), "FHD", "ORDER_SHIP_NO", salePO.getOrderSource()));
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setShipTime(new Date());
        uocCoreOrderShipReqBO.setSupAccount("\u7cfb\u7edf");
        uocCoreOrderShipReqBO.setArriveTime(new Date());
        uocCoreOrderShipReqBO.setShipVoucherId(Long.valueOf(this.idUtil.nextId()));
        uocCoreOrderShipReqBO.setReceiverContact(reqBO.getReceiverContact());
        uocCoreOrderShipReqBO.setReceiverRemark(reqBO.getRemark());
        uocCoreOrderShipReqBO.setReceiverTime(new Date());
        uocCoreOrderShipReqBO.setReceiverUser(reqBO.getName());
        uocCoreOrderShipReqBO.setReceiverNo(reqBO.getUsername());
        uocCoreOrderShipReqBO.setArriveTime(new Date());
        uocCoreOrderShipReqBO.setReceiverAddressId(reqBO.getReceiverAddressId());
        if (null != reqBO.getIsConfirm() && 1 == reqBO.getIsConfirm()) {
            OrdShipRejectionPO shipReject = this.ordShipRejectionMapper.getModelById(Long.valueOf(reqBO.getRejectShipVoucherId()).longValue());
            uocCoreOrderShipReqBO.setShipVoucherId(Long.valueOf(shipReject.getExt3()));
            uocCoreOrderShipReqBO.setReceiverTime(new Date());
            uocCoreOrderShipReqBO.setReceiverUser(shipReject.getReceiverUser());
            uocCoreOrderShipReqBO.setReceiverNo(shipReject.getReceiverNo());
            uocCoreOrderShipReqBO.setArriveTime(new Date());
            uocCoreOrderShipReqBO.setRemark(shipReject.getRemark());
            shipReject.setIsConfirm(Integer.valueOf(1));
            shipReject.setReasonForRejection(reqBO.getRejectionConfirmationRemark());
            shipReject.setExt4(DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            shipReject.setExt5("1");
            this.ordShipRejectionMapper.updateById(shipReject);
        }
        uocCoreOrderShipReqBO.setExt2("\u7cfb\u7edf\u751f\u6210");
        this.startProcess(uocCoreOrderShipReqBO.getShipVoucherId(), uocCoreOrderShipReqBO.getOrderId(), "peb_el_ship_order_order_status", "3");
        this.ordShipMapper.insert(uocCoreOrderShipReqBO);
        ArrayList<OrdShipItemPO> insert = new ArrayList<OrdShipItemPO>();
        ArrayList<UocOrdConfirmPO> confirmPOS = new ArrayList<UocOrdConfirmPO>();
        ArrayList<UocOrdConfirmItemPO> confirmItemPOS = new ArrayList<UocOrdConfirmItemPO>();
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal purFee = BigDecimal.ZERO;
        BigDecimal totalNoTaxProFee = BigDecimal.ZERO;
        BigDecimal totalProTaxFee = BigDecimal.ZERO;
        for (PebProcessOrderCountBO countBO : reqBO.getPebProcessOrderCountBOList()) {
            OrdItemPO po = map.get(countBO.getOrdItemId());
            if (countBO.getProcessCount().compareTo(po.getPurchaseCount().subtract(po.getSendCount())) > 0 && (null == reqBO.getIsConfirm() || 1 != reqBO.getIsConfirm())) {
                throw new UocProBusinessException("102033", po.getSkuName() + "\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u4ee5\u53d1\u8d27\u6570\u91cf");
            }
            OrdShipItemPO shipItemPO = new OrdShipItemPO();
            shipItemPO.setShipVoucherId(uocCoreOrderShipReqBO.getShipVoucherId());
            shipItemPO.setOrdItemId(po.getOrdItemId());
            shipItemPO.setSendCount(countBO.getProcessCount());
            if (PebExtConstant.YES.equals(reqBO.getConfirm())) {
                shipItemPO.setArriveCount(countBO.getProcessCount());
                shipItemPO.setRefuseCount(BigDecimal.ZERO);
            } else {
                shipItemPO.setArriveCount(BigDecimal.ZERO);
                shipItemPO.setRefuseCount(countBO.getProcessCount());
            }
            shipItemPO.setOrderId(reqBO.getOrderId());
            shipItemPO.setUnitName(po.getUnitName());
            shipItemPO.setShipItemId(Long.valueOf(this.idUtil.nextId()));
            shipItemPO.setReturnCount(BigDecimal.ZERO);
            shipItemPO.setAcceptanceCount(BigDecimal.ZERO);
            shipItemPO.setRhCount(BigDecimal.ZERO);
            insert.add(shipItemPO);
            OrdItemPO update = new OrdItemPO();
            update.setOrderId(reqBO.getOrderId());
            update.setOrdItemId(po.getOrdItemId());
            update.setSendCount(countBO.getProcessCount());
            if (PebExtConstant.YES.equals(reqBO.getConfirm())) {
                update.setArriveCount(countBO.getProcessCount());
            } else {
                update.setRefuseCount(countBO.getProcessCount());
            }
            if (null == reqBO.getIsConfirm() || 1 != reqBO.getIsConfirm()) {
                this.ordItemMapper.updateCounts(update);
            }
            fee = fee.add(shipItemPO.getRefuseCount().multiply(po.getSaleDecimalPrice()).setScale(2, RoundingMode.HALF_UP));
            purFee = purFee.add(shipItemPO.getRefuseCount().multiply(po.getPurchaseDecimalPrice()).setScale(2, RoundingMode.HALF_UP));
            BigDecimal pur = shipItemPO.getRefuseCount().multiply(po.getPurchaseDecimalPrice()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal tax = new BigDecimal(po.getTax()).multiply(new BigDecimal("0.01"));
            BigDecimal noTaxProFee = pur.divide(BigDecimal.ONE.add(tax), 2, RoundingMode.HALF_UP).stripTrailingZeros();
            totalNoTaxProFee = totalNoTaxProFee.add(noTaxProFee);
            totalProTaxFee = totalProTaxFee.add(pur.subtract(noTaxProFee));
            if (!PebExtConstant.YES.equals(reqBO.getConfirm())) continue;
            UocOrdConfirmItemPO uocOrdConfirmItemPO = new UocOrdConfirmItemPO();
            uocOrdConfirmItemPO.setShipItemId(shipItemPO.getShipItemId());
            uocOrdConfirmItemPO.setShipVoucherId(shipItemPO.getShipVoucherId());
            uocOrdConfirmItemPO.setShipVoucherNo(uocCoreOrderShipReqBO.getShipVoucherCode());
            uocOrdConfirmItemPO.setConfirmCount(shipItemPO.getArriveCount());
            uocOrdConfirmItemPO.setId(Long.valueOf(this.idUtil.nextId()));
            uocOrdConfirmItemPO.setOrderId(shipItemPO.getOrderId());
            uocOrdConfirmItemPO.setOrdItemId(shipItemPO.getOrdItemId());
            uocOrdConfirmItemPO.setConfirmId(confirmId);
            confirmItemPOS.add(uocOrdConfirmItemPO);
        }
        String confirmNo = null;
        if (PebExtConstant.YES.equals(reqBO.getConfirm())) {
            UocOrdConfirmPO uocOrdConfirmPO = new UocOrdConfirmPO();
            uocOrdConfirmPO.setArriveRemark(reqBO.getRemark());
            uocOrdConfirmPO.setConfirmCode(this.buildNo(salePO.getSaleVoucherNo(), "DHD", "ORDER_SHIP_NO", salePO.getOrderSource()));
            uocOrdConfirmPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uocOrdConfirmPO.setCreateOperName(reqBO.getName());
            uocOrdConfirmPO.setCreateTime(new Date());
            uocOrdConfirmPO.setId(confirmId);
            uocOrdConfirmPO.setModifyOperId(String.valueOf(reqBO.getUserId()));
            uocOrdConfirmPO.setModifyTime(new Date());
            uocOrdConfirmPO.setOrderId(reqBO.getOrderId());
            uocOrdConfirmPO.setReceiverContact(reqBO.getReceiverContact());
            uocOrdConfirmPO.setReceiverNo(reqBO.getUsername());
            uocOrdConfirmPO.setReceiverRemark(reqBO.getRemark());
            uocOrdConfirmPO.setReceiverTime(new Date());
            uocOrdConfirmPO.setReceiverUser(reqBO.getConsignee());
            confirmPOS.add(uocOrdConfirmPO);
            confirmNo = uocOrdConfirmPO.getConfirmCode();
        }
        this.ordShipItemMapper.insertBatch(insert);
        if (!CollectionUtils.isEmpty(confirmItemPOS)) {
            this.uocOrdConfirmItemMapper.insertBatch(confirmItemPOS);
            this.uocOrdConfirmMapper.insertBatch(confirmPOS);
            confirmIdList.addAll(confirmPOS.stream().map(UocOrdConfirmPO::getId).collect(Collectors.toList()));
        }
        reqBO.setActionCode("ACTPEB0027");
        this.saveFile(uocCoreOrderShipReqBO.getShipVoucherId(), reqBO);
        ArrayList<Long> sendOrderIdList = new ArrayList<Long>();
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(uocCoreOrderShipReqBO.getShipVoucherId());
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        if (!UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(salePO.getOrderSource()) && !UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(salePO.getOrderSource())) {
            if (this.judgeIsAllReceive(reqBO.getOrderId())) {
                this.executeUpdateSaleOrdState(salePO.getOrderId(), salePO.getSaleVoucherId(), PebExtConstant.YES.equals(reqBO.getConfirm()), uocCoreOrderShipReqBO.getShipVoucherId());
            }
        } else {
            this.dealOrderState(reqBO, salePO, uocCoreOrderShipReqBO.getShipVoucherId());
        }
        if (PebExtConstant.YES.equals(reqBO.getConfirm())) {
            UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
            uocProShouldPayOrDeductDealAtomReqBo.setOrderId(reqBO.getOrderId());
            uocProShouldPayOrDeductDealAtomReqBo.setObjId(confirmId);
            uocProShouldPayOrDeductDealAtomReqBo.setConfirmNo(confirmNo);
            uocProShouldPayOrDeductDealAtomReqBo.setObjNo(confirmNo);
            uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            uocProShouldPayOrDeductDealAtomReqBo.setObjDate(new Date());
            uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.THE_ARRIVAL);
            UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
            if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
            }
        } else {
            UocReturnFeeAtomReqBO atomReqBO = new UocReturnFeeAtomReqBO();
            try {
                atomReqBO.setFee(fee);
                atomReqBO.setProFee(purFee);
                atomReqBO.setProTaxFee(totalProTaxFee);
                atomReqBO.setNoTaxProFee(totalNoTaxProFee);
            }
            catch (Exception shouldPayOrDeductDealAtomRspBo) {
                // empty catch block
            }
            atomReqBO.setOrderId(reqBO.getOrderId());
            atomReqBO.setObjId(uocCoreOrderShipReqBO.getShipVoucherId());
            atomReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            atomReqBO.setRefundType(FscConstants.RefundType.RETURN_GOODS);
            UocReturnFeeAtomRspBO returnFeeAtomRspBO = this.uocReturnFeeAtomService.returnFee(atomReqBO);
            if (!"0000".equals(returnFeeAtomRspBO.getRespCode())) {
                throw new UocProBusinessException(returnFeeAtomRspBO.getRespCode(), returnFeeAtomRspBO.getRespDesc());
            }
            if (returnFeeAtomRspBO.getIsFl().booleanValue()) {
                atomReqBO.setOrderId(reqBO.getOrderId());
                pebOrderDeliveryAbilityRspBO.setReqJsonStr(JSON.toJSONString((Object)atomReqBO));
            }
            if (returnFeeAtomRspBO.getSendFlag() != null && returnFeeAtomRspBO.getSendFlag().booleanValue()) {
                sendOrderIdList.add(atomReqBO.getOrderId());
                pebOrderDeliveryAbilityRspBO.setSendOrderIdList(sendOrderIdList);
            }
        }
        pebOrderDeliveryAbilityRspBO.setConfirmIdList(confirmIdList);
        return pebOrderDeliveryAbilityRspBO;
    }

    private void dealOrderState(PebOrderDeliveryAbilityReqBO reqBO, OrdSalePO salePO, Long shipId) {
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(salePO.getSaleState())) {
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            List list = this.ordItemMapper.getList(itemPO);
            boolean notAllShip = false;
            for (OrdItemPO ordItemPO : list) {
                if (ordItemPO.getPurchaseCount().compareTo(ordItemPO.getSendCount()) <= 0) continue;
                notAllShip = true;
                break;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (PebExtConstant.YES.equals(reqBO.getConfirm())) {
                if (notAllShip) {
                    map.put("arrive", "1");
                } else {
                    map.put("arrive", "2");
                }
            } else if (notAllShip) {
                map.put("arrive", "1");
            } else {
                map.put("rejectFlag", "1");
            }
            reqBO.setPreStatus(UocConstant.SALE_ORDER_STATUS.DJ);
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
            return;
        }
        if (!(UocConstant.SALE_ORDER_STATUS.DJ.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PART_DJ.equals(salePO.getSaleState()))) {
            return;
        }
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        boolean allShip = true;
        for (OrdItemPO ordItemPO : list) {
            if (ordItemPO.getPurchaseCount().compareTo(ordItemPO.getSendCount()) <= 0) continue;
            allShip = false;
            break;
        }
        boolean allArrive = true;
        boolean allConfirm = true;
        boolean allRefuse = true;
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setOrderId(reqBO.getOrderId());
        List ordShipPoList = this.ordShipMapper.getList(ordShipModel);
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if ("2204".equals(ordShipPo.getShipStatus()) || "2207".equals(ordShipPo.getShipStatus()) || "2208".equals(ordShipPo.getShipStatus()) || "2209".equals(ordShipPo.getShipStatus())) {
                allArrive = false;
                continue;
            }
            if ("2210".equals(ordShipPo.getShipStatus()) || "2206".equals(ordShipPo.getShipStatus())) {
                allConfirm = false;
                continue;
            }
            allRefuse = false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!allShip || !allArrive) {
            if (allConfirm) {
                if (UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState())) {
                    return;
                }
                map.put("arrive", 1);
                this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
                return;
            }
            return;
        }
        if (allConfirm) {
            map.put("arrive", 2);
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
        } else {
            if (UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState())) {
                map.put("arrive", 2);
            } else if (allRefuse) {
                map.put("rejectFlag", 1);
            } else {
                map.put("rejectFlag", 2);
            }
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
        }
    }

    private void run(PebOrderDeliveryAbilityReqBO reqBO, Integer objType2, Long objId, Map<String, Object> map) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setObjType(objType2);
        processRunReqBO.setObjId(objId);
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        processRunReqBO.setVariables(map);
        processRunReqBO.setPreState(reqBO.getPreStatus());
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102098", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        processRunReqBO.setPreState(null);
    }

    private void executeUpdateSaleOrdState(Long orderId, Long saleVoucherId, boolean confirm, Long shipId) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setOrderId(orderId);
        List ordShipPoList = this.ordShipMapper.getList(ordShipModel);
        boolean needUpdateOrderStatus = true;
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if ("2204".equals(ordShipPo.getShipStatus()) || "2208".equals(ordShipPo.getShipStatus()) || "2209".equals(ordShipPo.getShipStatus())) {
                return;
            }
            if (shipId.equals(ordShipPo.getShipVoucherId()) || "2205".equals(ordShipPo.getShipStatus()) || "2206".equals(ordShipPo.getShipStatus())) continue;
            needUpdateOrderStatus = false;
        }
        int isAllReceived = 0;
        boolean isPart = false;
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if ("2210".equals(ordShipPo.getShipStatus())) {
                isPart = true;
            }
            if (!"2206".equals(ordShipPo.getShipStatus())) continue;
            ++isAllReceived;
        }
        Integer rejectFlag = null;
        rejectFlag = isAllReceived == 0 ? PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED : (isAllReceived == ordShipPoList.size() ? PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR : PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED);
        if (isPart) {
            rejectFlag = PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED;
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleVoucherId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId("0");
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        processRunReqBO.setVariables(map);
        map.put("rejectFlag", rejectFlag);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102098", "\u901a\u8fc7\u5165\u53c2\uff1a" + (Object)((Object)processRunReqBO) + "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        if (!confirm && needUpdateOrderStatus) {
            processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setObjId(saleVoucherId);
            processRunReqBO.setOrderId(orderId);
            processRunReqBO.setOperId("0");
            uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
                throw new UocProBusinessException("102098", "\u901a\u8fc7\u5165\u53c2\uff1a" + (Object)((Object)processRunReqBO) + "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
            }
        }
    }

    private boolean judgeIsAllReceive(Long orderId) {
        OrdShipRejectionPO ordShipPO = new OrdShipRejectionPO();
        ordShipPO.setIsConfirm(Integer.valueOf(0));
        ordShipPO.setOrderId(orderId);
        Integer count = this.ordShipRejectionMapper.getCheckBy(ordShipPO);
        if (null != count && count > 0) {
            return false;
        }
        OrdItemPO ordItemModel = new OrdItemPO();
        ordItemModel.setOrderId(orderId);
        List ordItemPoList = this.ordItemMapper.getList(ordItemModel);
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalArriveCount = new BigDecimal(0);
        for (OrdItemPO ordItemPo : ordItemPoList) {
            totalPurchaseCount = totalPurchaseCount.add(ordItemPo.getPurchaseCount());
            BigDecimal arriveCount = ordItemPo.getArriveCount().add(ordItemPo.getRefuseCount());
            totalArriveCount = totalArriveCount.add(arriveCount);
        }
        return totalArriveCount.equals(totalPurchaseCount);
    }

    private void startProcess(Long objId, Long orderId, String procKey, String submit) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefKey(procKey);
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        processStartReqBO.setOrderId(orderId);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("submit", submit);
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO processStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(processStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101059", "\u901a\u8fc7\u5165\u53c2\uff1a" + processStartReqBO + "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25\u539f\u56e0\uff1a" + processStartRspBO.getRespDesc());
        }
    }

    private void subscribeMap(PebOrderDeliveryAbilityReqBO reqBO, OrdSalePO salePO) {
        boolean flag;
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        boolean bl = flag = "1".equals(salePO.getOrderSource()) && (orderPO.getOrderType().equals(PebExtConstant.OrderType.GC) || orderPO.getOrderType().equals(PebExtConstant.OrderType.FL));
        if (!flag) {
            flag = PebExtConstant.ER.toString().equals(reqBO.getTransportMode());
        }
        if (flag) {
            OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
            ordLogisticsRelaPO.setOrderId(reqBO.getOrderId());
            ordLogisticsRelaPO.setContactId(salePO.getContactId());
            OrdLogisticsRelaPO relaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            try {
                paramMap.put("schema", "json");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("key", (Object)this.key);
                jsonObject.put("company", (Object)reqBO.getLogisticsExecutionUnit());
                jsonObject.put("number", (Object)reqBO.getProcessNum());
                jsonObject.put("from", (Object)reqBO.getShipAdress());
                jsonObject.put("to", (Object)(relaPO.getContactProvinceName() + relaPO.getContactCityName()));
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("callbackurl", this.callbackUrl);
                parameters.put("resultv2", "5");
                parameters.put("phone", relaPO.getContactMobile() != null ? relaPO.getContactMobile() : reqBO.getProcessPhone());
                jsonObject.put("parameters", parameters);
                paramMap.put("param", jsonObject.toJSONString());
                log.info("\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
                String respStr = SSLClient.doPost((String)this.pollMapUrl, paramMap, null);
                log.info("\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u51fa\u53c2\uff1a" + respStr);
                if (org.springframework.util.StringUtils.isEmpty((Object)respStr)) {
                    throw new UocProBusinessException("8888", "\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01\uff01");
                }
                JSONObject parseObject = JSONObject.parseObject((String)respStr);
                if (!"200".equals(parseObject.getString("returnCode"))) {
                    throw new UocProBusinessException("8888", "\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u5931\u8d25\uff1a" + parseObject.getString("message"));
                }
            }
            catch (UocProBusinessException e) {
                log.error("\u5feb\u9012100\u8ba2\u9605\u5730\u56fe\u8f68\u8ff9\u5931\u8d25\uff1a" + e.getMessage() + "\uff0c\u8ba2\u5355id\uff1a" + reqBO.getOrderId() + "\uff0c\u5165\u53c2" + JSONObject.toJSONString(paramMap));
            }
        }
    }
}

