/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.busi.api.UocAuditTaskBusiService;
import com.tydic.uoc.common.busi.bo.UocAuditTaskBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocAuditTaskBusiRspBo;
import com.tydic.uoc.common.busi.bo.UocProcessTaskBo;
import com.tydic.uoc.dao.UocOrderTaskInstMapper;
import com.tydic.uoc.dao.UocSignatureInitMapper;
import com.tydic.uoc.po.UocOrderTaskInstPo;
import com.tydic.uoc.po.UocSignatureInitPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocAuditTaskBusiServiceImpl
implements UocAuditTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocAuditTaskBusiServiceImpl.class);
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocSignatureInitMapper uocSignatureInitMapper;

    @Override
    public UocAuditTaskBusiRspBo auditTask(UocAuditTaskBusiReqBo reqBo) {
        UocAuditTaskBusiRspBo rspBo = new UocAuditTaskBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty(reqBo.getWithInstBo().getTaskList())) {
            ArrayList<UocOrderTaskInstPo> orderTaskInstPos = new ArrayList<UocOrderTaskInstPo>(reqBo.getWithInstBo().getTaskList().size());
            HashMap<Long, UocSignatureInitPo> signatureInitPoMap = new HashMap<Long, UocSignatureInitPo>();
            for (UocProcessTaskBo processTaskBo : reqBo.getWithInstBo().getTaskList()) {
                UocSignatureInitPo signatureInitPo;
                UocOrderTaskInstPo orderTaskInstPo = new UocOrderTaskInstPo();
                orderTaskInstPo.setId(Long.valueOf(this.idUtil.nextId()));
                orderTaskInstPo.setObjId(Long.valueOf(processTaskBo.getPartitionKey()));
                if (signatureInitPoMap.containsKey(orderTaskInstPo.getObjId())) {
                    signatureInitPo = (UocSignatureInitPo)signatureInitPoMap.get(orderTaskInstPo.getObjId());
                } else {
                    UocSignatureInitPo uocSignatureInitPo = new UocSignatureInitPo();
                    uocSignatureInitPo.setSignatureInitId(orderTaskInstPo.getObjId());
                    signatureInitPo = this.uocSignatureInitMapper.getModelBy(uocSignatureInitPo);
                    signatureInitPoMap.put(orderTaskInstPo.getObjId(), signatureInitPo);
                }
                orderTaskInstPo.setOrderId(signatureInitPo.getOrderId());
                orderTaskInstPo.setTaskInstId(processTaskBo.getApproveTaskId());
                orderTaskInstPo.setProcInstId(processTaskBo.getProcInstId());
                orderTaskInstPo.setParentProcInstId(processTaskBo.getParentProcInstId());
                orderTaskInstPo.setProcDefId(processTaskBo.getProcDefId());
                orderTaskInstPo.setObjType(UocConstant.OBJ_TYPE.SIGNATURE_INIT);
                orderTaskInstPo.setProcState(processTaskBo.getStepId());
                orderTaskInstPo.setFinishTag(UocConstant.VALID_FLAG.NO);
                orderTaskInstPo.setFinishTime(null);
                orderTaskInstPo.setDelTag(UocConstant.VALID_FLAG.NO);
                orderTaskInstPo.setDealOperId(Long.valueOf(processTaskBo.getUserId()));
                orderTaskInstPo.setDealOperName(processTaskBo.getLoginName());
                orderTaskInstPo.setDealName(processTaskBo.getUserName());
                orderTaskInstPo.setDealResult(null);
                orderTaskInstPo.setDealRemark(null);
                orderTaskInstPo.setTaskSignTag(Integer.valueOf(0));
                orderTaskInstPo.setIsDelete(UocConstant.VALID_FLAG.NO);
                orderTaskInstPo.setRemark(null);
                orderTaskInstPo.setProcTaskId(processTaskBo.getTaskId());
                orderTaskInstPo.setDealOperOrgCode(processTaskBo.getOrgCode());
                orderTaskInstPo.setCreateTime(new Date());
                orderTaskInstPos.add(orderTaskInstPo);
            }
            this.uocOrderTaskInstMapper.insertBatch(orderTaskInstPos);
        }
        return rspBo;
    }
}

