/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscEfficiencyIndexAbilityService;
import com.tydic.fsc.common.ability.bo.FscEfficiencyIndexAbilityBO;
import com.tydic.fsc.common.ability.bo.FscEfficiencyIndexAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEfficiencyIndexAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtSendMessageRspBO;
import com.tydic.uoc.common.ability.bo.UocSendMessageReqBO;
import com.tydic.uoc.common.busi.api.UocDealEfficiencyIndexBusiService;
import com.tydic.uoc.common.busi.bo.UocDealEfficiencyIndexBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocDealEfficiencyIndexBusiRspBO;
import com.tydic.uoc.common.enums.UocEfficiencyIndexNoticeEnum;
import com.tydic.uoc.common.utils.UocNotificationUtil;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdEfficiencyIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocDealEfficiencyIndexBusiServiceImpl
implements UocDealEfficiencyIndexBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocDealEfficiencyIndexBusiServiceImpl.class);
    public static final String LEVEL_ONE = "1";
    public static final String LEVEL_TWO = "2";
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocNotificationUtil uocNotificationUtil;
    @Autowired
    private FscEfficiencyIndexAbilityService fscEfficiencyIndexAbilityService;

    @Override
    public UocDealEfficiencyIndexBusiRspBO dealEfficiencyIndex(UocDealEfficiencyIndexBusiReqBO reqBO) {
        this.dealNotDispatchLongTime(reqBO);
        UocDealEfficiencyIndexBusiRspBO rspBO = new UocDealEfficiencyIndexBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealNotReceiveReceipt(UocDealEfficiencyIndexBusiReqBO reqBO) {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime startTimeTime = now.minusHours(1440L);
        Date startTime = Date.from(startTimeTime.toInstant());
        List orderList = this.orderMapper.getNotReceiveReceipt(startTime);
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            String saleVoucherNo = orderInfo.getSaleVoucherNo();
            Long orderId = orderInfo.getOrderId();
            FscEfficiencyIndexAbilityReqBO indexAbilityReqBO = new FscEfficiencyIndexAbilityReqBO();
            indexAbilityReqBO.setOrderNo(saleVoucherNo);
            indexAbilityReqBO.setOrderId(orderId);
            indexAbilityReqBO.setOrderState(Integer.valueOf(1003));
            FscEfficiencyIndexAbilityRspBO indexAbilityRspBO = this.fscEfficiencyIndexAbilityService.qryFscInfoByOrderId(indexAbilityReqBO);
            if (!indexAbilityRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)indexAbilityRspBO.getList())) continue;
            List list = indexAbilityRspBO.getList();
            for (FscEfficiencyIndexAbilityBO indexAbilityBO : list) {
                List<Object> messageUserList = new ArrayList();
                Integer updateDaysDif = indexAbilityBO.getUpdateDaysDif();
                String orderNo = indexAbilityBO.getOrderNo();
                if (updateDaysDif >= 60) {
                    messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_RECEIVE_RECEIPT.getCode(), LEVEL_ONE);
                    if (LEVEL_ONE.equals(orderInfo.getExt1())) continue;
                }
                if (CollectionUtils.isEmpty(messageUserList)) {
                    log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.NOT_RECEIVE_RECEIPT.getName());
                    continue;
                }
                log.error("\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
                UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
                uocSendMessageReqBO.setUserId(Long.valueOf(1L));
                uocSendMessageReqBO.setReceiveIds(messageUserList);
                String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e\u5f02\u5e38", orderNo);
                uocSendMessageReqBO.setTitel(title);
                String text = MessageFormat.format("\u3010\u8d85\u5e02\u7ed3\u7b97\u5355\u3010{0}\u3011\uff0c\u5df2\u5f00\u5177\u53d1\u7968\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u4ed8\u6b3e\u3011", orderNo, orderInfo.getDaysDif());
                uocSendMessageReqBO.setText(text);
                log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e3a:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
                PebExtSendMessageRspBO sendMessageRspBO = this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
                if (!sendMessageRspBO.getRespCode().equals("0000") || updateDaysDif < 14) continue;
                OrdSalePO ordSalePO = new OrdSalePO();
                ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
                ordSalePO.setExt1(LEVEL_ONE);
                this.ordSaleMapper.updateById(ordSalePO);
            }
        }
    }

    private void dealNotIssueTaxInvoice(UocDealEfficiencyIndexBusiReqBO reqBO) {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime startTimeTime = now.minusHours(336L);
        Date startTime = Date.from(startTimeTime.toInstant());
        List orderList = this.orderMapper.getNotIssueTaxInvoice(startTime);
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            String saleVoucherNo = orderInfo.getSaleVoucherNo();
            Long orderId = orderInfo.getOrderId();
            FscEfficiencyIndexAbilityReqBO indexAbilityReqBO = new FscEfficiencyIndexAbilityReqBO();
            indexAbilityReqBO.setOrderNo(saleVoucherNo);
            indexAbilityReqBO.setOrderId(orderId);
            FscEfficiencyIndexAbilityRspBO indexAbilityRspBO = this.fscEfficiencyIndexAbilityService.qryFscInfoByOrderId(indexAbilityReqBO);
            if (!indexAbilityRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)indexAbilityRspBO.getList())) continue;
            List list = indexAbilityRspBO.getList();
            for (FscEfficiencyIndexAbilityBO indexAbilityBO : list) {
                List<Object> messageUserList = new ArrayList();
                Integer createDaysDif = indexAbilityBO.getCreateDaysDif();
                Date createTime = indexAbilityBO.getCreateTime();
                String orderNo = indexAbilityBO.getOrderNo();
                if (createDaysDif >= 14) {
                    messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_ISSUE_TAX_INVOICE.getCode(), LEVEL_ONE);
                    if (LEVEL_ONE.equals(orderInfo.getExt1())) continue;
                }
                if (CollectionUtils.isEmpty(messageUserList)) {
                    log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.NOT_ISSUE_TAX_INVOICE.getName());
                    continue;
                }
                log.error("\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
                UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
                uocSendMessageReqBO.setUserId(Long.valueOf(1L));
                uocSendMessageReqBO.setReceiveIds(messageUserList);
                String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968\u5f02\u5e38", orderNo);
                uocSendMessageReqBO.setTitel(title);
                String text = MessageFormat.format("\u3010\u8d85\u5e02\u7ed3\u7b97\u5355_\u3010{0}\u3011\u5f00\u7968\u8d85\u671f\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u5f00\u7968\uff0c\u8bf7\u8ddf\u8fdb\u5f00\u7968\u8fdb\u5ea6\u3011", orderNo, orderInfo.getDaysDif());
                uocSendMessageReqBO.setText(text);
                log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e3a:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
                PebExtSendMessageRspBO sendMessageRspBO = this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
                if (!sendMessageRspBO.getRespCode().equals("0000") || createDaysDif < 14) continue;
                OrdSalePO ordSalePO = new OrdSalePO();
                ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
                ordSalePO.setExt1(LEVEL_ONE);
                this.ordSaleMapper.updateById(ordSalePO);
            }
        }
    }

    private void dealDispatchLongTimeArrived(UocDealEfficiencyIndexBusiReqBO reqBO) {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime startTimeTime = now.minusHours(600L);
        Date startTime = Date.from(startTimeTime.toInstant());
        List orderList = this.orderMapper.getDispatchLongTimeArrived(startTime);
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            OrdSalePO ordSalePO;
            Integer daysDif = orderInfo.getDaysDif();
            List<Object> messageUserList = new ArrayList();
            if (daysDif >= 25 && daysDif < 40) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getCode(), LEVEL_ONE);
                if (LEVEL_ONE.equals(orderInfo.getExt1())) {
                    continue;
                }
            } else if (daysDif >= 40) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getCode(), LEVEL_TWO);
                if (LEVEL_TWO.equals(orderInfo.getExt1())) continue;
            }
            if (CollectionUtils.isEmpty(messageUserList)) {
                log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getName());
                continue;
            }
            log.error("\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
            UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
            uocSendMessageReqBO.setUserId(Long.valueOf(1L));
            uocSendMessageReqBO.setReceiveIds(messageUserList);
            String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295\u5f02\u5e38", orderInfo.getSaleVoucherNo());
            uocSendMessageReqBO.setTitel(title);
            String text = MessageFormat.format("\u3010\u8d85\u5e02\u8ba2\u5355\u3010{0}\u3011\u7269\u6d41\u8d85\u671f\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u59a5\u6295\uff0c\u8bf7\u8ddf\u8fdb\u7269\u6d41\u8fdb\u5ea6\u3011", orderInfo.getSaleVoucherNo(), orderInfo.getDaysDif());
            uocSendMessageReqBO.setText(text);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e3a:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
            PebExtSendMessageRspBO sendMessageRspBO = this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
            if (!sendMessageRspBO.getRespCode().equals("0000")) continue;
            if (daysDif >= 25 && daysDif < 40) {
                ordSalePO = new OrdSalePO();
                ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
                ordSalePO.setExt1(LEVEL_ONE);
                this.ordSaleMapper.updateById(ordSalePO);
                continue;
            }
            if (daysDif < 40) continue;
            ordSalePO = new OrdSalePO();
            ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
            ordSalePO.setExt1(LEVEL_TWO);
            this.ordSaleMapper.updateById(ordSalePO);
        }
    }

    private void dealNotDispatchLongTime(UocDealEfficiencyIndexBusiReqBO reqBO) {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime startTimeTime = now.minusHours(600L);
        Date startTime = Date.from(startTimeTime.toInstant());
        List orderList = this.orderMapper.getNotDispatchLongTime(startTime);
        log.error("\u67e5\u8be2\u51fa\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderList));
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            OrdSalePO ordSalePO;
            Integer daysDif = orderInfo.getDaysDif();
            List<Object> messageUserList = new ArrayList();
            if (daysDif >= 25 && daysDif < 40) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getCode(), LEVEL_ONE);
                if (LEVEL_ONE.equals(orderInfo.getExt1())) {
                    continue;
                }
            } else if (daysDif >= 40) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getCode(), LEVEL_TWO);
                if (LEVEL_TWO.equals(orderInfo.getExt1())) continue;
            }
            if (CollectionUtils.isEmpty(messageUserList)) {
                log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getName());
                continue;
            }
            log.error("\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
            UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
            uocSendMessageReqBO.setUserId(Long.valueOf(1L));
            uocSendMessageReqBO.setReceiveIds(messageUserList);
            String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u957f\u65f6\u95f4\u672a\u53d1\u8d27\u5f02\u5e38", orderInfo.getSaleVoucherNo());
            uocSendMessageReqBO.setTitel(title);
            String text = MessageFormat.format("\u3010\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011\u53d1\u8d27\u5f02\u5e38\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3011", orderInfo.getSaleVoucherNo(), orderInfo.getDaysDif());
            uocSendMessageReqBO.setText(text);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e3a:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
            PebExtSendMessageRspBO sendMessageRspBO = this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
            if (!sendMessageRspBO.getRespCode().equals("0000")) continue;
            if (daysDif >= 25 && daysDif < 40) {
                ordSalePO = new OrdSalePO();
                ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
                ordSalePO.setExt1(LEVEL_ONE);
                log.error("\u5f00\u59cb\u4fee\u6539\u4fee\u6539\u63a8\u9001\u7ad9\u5185\u4fe1\u6807\u8bc6\uff1a{}", (Object)JSON.toJSONString((Object)ordSalePO));
                this.ordSaleMapper.updateById(ordSalePO);
                continue;
            }
            if (daysDif < 40) continue;
            ordSalePO = new OrdSalePO();
            ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
            ordSalePO.setExt1(LEVEL_TWO);
            log.error("\u5f00\u59cb\u4fee\u6539\u4fee\u6539\u63a8\u9001\u7ad9\u5185\u4fe1\u6807\u8bc6\uff1a{}", (Object)JSON.toJSONString((Object)ordSalePO));
            this.ordSaleMapper.updateById(ordSalePO);
        }
    }

    private List<Long> getMessageUserList(OrdEfficiencyIndexPO orderInfo, String code, String level) {
        ArrayList<Long> messageUserList = new ArrayList<Long>();
        if (UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getCode().equals(code)) {
            if (level.equals(LEVEL_ONE)) {
                messageUserList.add(120052L);
            } else if (level.equals(LEVEL_TWO)) {
                messageUserList.add(120052L);
            } else {
                log.error("\u9884\u8b66\u7b49\u7ea7\u9519\u8bef");
            }
        }
        return messageUserList;
    }
}

