/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.umc.supplier.ability.api.DycUmcQuerySupplierListAbilityService;
import com.tydic.umc.supplier.ability.bo.DycUmcQuerySupplierListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.DycUmcQuerySupplierListAbilityRspBO;
import com.tydic.umc.supplier.ability.bo.SupplierSignContractBO;
import com.tydic.umc.supplier.ability.bo.SupplierSignContractSalesBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionItemListBO;
import com.tydic.uoc.common.ability.bo.UocProTransactionServiceSupplierInfoBo;
import com.tydic.uoc.common.busi.api.UocEsQryTransactionServiceListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryTransactionServiceListReqBo;
import com.tydic.uoc.common.busi.bo.UocEsQryTransactionServiceListRspBo;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocEsQryTransactionServiceListBusiServiceImpl
implements UocEsQryTransactionServiceListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocEsQryTransactionServiceListBusiServiceImpl.class);
    @Autowired
    private UocEsConfig uocEsConfig;
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;
    @Autowired
    private DycUmcQuerySupplierListAbilityService umcQuerySupplierListAbilityService;

    @Override
    public UocEsQryTransactionServiceListRspBo esQryTransactionServiceList(UocEsQryTransactionServiceListReqBo reqBo) {
        String result;
        UocEsQryTransactionServiceListRspBo rspBo = new UocEsQryTransactionServiceListRspBo();
        Map<String, String> serviceFeeRateMap = null;
        if (!CollectionUtils.isEmpty(reqBo.getSupNoList())) {
            serviceFeeRateMap = this.queryTransactionServiceRule(reqBo);
        }
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryTransactionServiceEsSql(reqBo);
        log.info("ES\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u6761\u4ef6\uff1a{}", (Object)qryString);
        String endPoint = "/" + this.uocEsConfig.getServiceIndexName() + "/" + this.uocEsConfig.getServiceIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getServiceIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u6210\u4ea4\u670d\u52a1\u8d39\u7d22\u5f15\u5931\u8d25");
                    rspBo.setRespCode("100001");
                    rspBo.setRespDesc("\u81ea\u52a8\u521b\u5efa\u6210\u4ea4\u670d\u52a1\u8d39\u7d22\u5f15\u5931\u8d25");
                    return rspBo;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBo.setRespCode("102074");
                    rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBo;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBo.setRespCode("102074");
            rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u4fe1\u606f\u6210\u4ea4\u670d\u52a1\u8d39!");
            return rspBo;
        }
        log.debug("ES\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39result\uff1a{}", (Object)result);
        this.resolveReturnData(result, rspBo, reqBo, serviceFeeRateMap);
        return rspBo;
    }

    private void resolveReturnData(String result, UocEsQryTransactionServiceListRspBo rspBo, UocEsQryTransactionServiceListReqBo reqBo, Map<String, String> serviceFeeRateMap) {
        rspBo.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBo.setPageNo(1);
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(total);
            rspBo.setRows(new ArrayList());
            rspBo.setSupplierInfoBos(new ArrayList<UocProTransactionServiceSupplierInfoBo>());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u6210\u4ea4\u670d\u52a1\u8d39\u4fe1\u606f!");
            return;
        }
        if (null != reqBo.getIsQuerySupplierId() && reqBo.getIsQuerySupplierId().booleanValue()) {
            ArrayList<Long> supNoList = new ArrayList<Long>(listObject.size());
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                supNoList.add(data.getLong("supNo"));
            }
            rspBo.setSupNoList(supNoList);
        } else if (null != reqBo.getIsQuerySupplier() && reqBo.getIsQuerySupplier().booleanValue()) {
            ArrayList<UocProTransactionServiceSupplierInfoBo> supplierInfoBos = new ArrayList<UocProTransactionServiceSupplierInfoBo>(listObject.size());
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UocProTransactionServiceSupplierInfoBo transactionServiceSupplierInfoBo = new UocProTransactionServiceSupplierInfoBo();
                transactionServiceSupplierInfoBo.setSupNo(data.getString("supNo"));
                transactionServiceSupplierInfoBo.setSupName(data.getString("supName"));
                supplierInfoBos.add(transactionServiceSupplierInfoBo);
            }
            rspBo.setSupplierInfoBos(supplierInfoBos);
        } else {
            ArrayList<UocInspectionDetailsListBO> rows = new ArrayList<UocInspectionDetailsListBO>(listObject.size());
            boolean isServiceFeeRate = false;
            if (!CollectionUtils.isEmpty(serviceFeeRateMap)) {
                isServiceFeeRate = true;
            }
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                String objJsonStr = data.getString("objJson");
                JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
                UocInspectionDetailsListBO esQryTransactionServiceListSingleBO = (UocInspectionDetailsListBO)JSON.toJavaObject((JSON)objJson, UocInspectionDetailsListBO.class);
                if (isServiceFeeRate) {
                    BigDecimal serPriceMoney = BigDecimal.ZERO;
                    for (UocInspectionItemListBO inspectionItemListBO : esQryTransactionServiceListSingleBO.getInspectionItemInfo()) {
                        String serviceFeeRate = serviceFeeRateMap.get(esQryTransactionServiceListSingleBO.getSupNo() + inspectionItemListBO.getSkuCommodityTypeId());
                        if (!StringUtils.hasText((String)serviceFeeRate)) continue;
                        inspectionItemListBO.setSerPriceMoney(new BigDecimal(inspectionItemListBO.getInspSaleMoney()).multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING));
                        serPriceMoney = serPriceMoney.add(inspectionItemListBO.getSerPriceMoney());
                    }
                    esQryTransactionServiceListSingleBO.setSerPriceMoney(serPriceMoney);
                }
                rows.add(esQryTransactionServiceListSingleBO);
            }
            rspBo.setRows(rows);
        }
        int totalPageNo = total % reqBo.getPageSize() == 0 ? total / reqBo.getPageSize() : total / reqBo.getPageSize() + 1;
        rspBo.setTotal(totalPageNo);
        rspBo.setRecordsTotal(total);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRespDesc("\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u5217\u8868\u4fe1\u606f\u6210\u529f");
    }

    private Map<String, String> queryTransactionServiceRule(UocEsQryTransactionServiceListReqBo reqBo) {
        DycUmcQuerySupplierListAbilityReqBO supplierListAbilityReqBO = new DycUmcQuerySupplierListAbilityReqBO();
        supplierListAbilityReqBO.setSupplierIds(reqBo.getSupNoList());
        log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u7b7e\u7ea6\u5355\u96c6\u5408\u8be6\u60c5\u5165\u53c2\uff1a{} ", (Object)JSON.toJSONString((Object)supplierListAbilityReqBO));
        DycUmcQuerySupplierListAbilityRspBO supplierListAbilityRspBO = this.umcQuerySupplierListAbilityService.querySupplierList(supplierListAbilityReqBO);
        log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u7b7e\u7ea6\u5355\u96c6\u5408\u8be6\u60c5\u51fa\u53c2\uff1a{} ", (Object)JSON.toJSONString((Object)supplierListAbilityRspBO));
        if (!"0000".equals(supplierListAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException(supplierListAbilityRspBO.getRespCode(), "\u67e5\u8be2\u4f9b\u5e94\u5546\u7b7e\u7ea6\u5355\u96c6\u5408\u8be6\u60c5\u5931\u8d25\uff1a" + supplierListAbilityRspBO.getRespDesc());
        }
        HashMap<String, String> serviceFeeRateMap = null;
        if (!CollectionUtils.isEmpty((Collection)supplierListAbilityRspBO.getSignContractBOS())) {
            ArrayList<Long> supNoRuleList = new ArrayList<Long>(supplierListAbilityRspBO.getSignContractBOS().size());
            serviceFeeRateMap = new HashMap<String, String>(supplierListAbilityRspBO.getSignContractBOS().size() * 20);
            for (SupplierSignContractBO signContractBO : supplierListAbilityRspBO.getSignContractBOS()) {
                if (CollectionUtils.isEmpty((Collection)signContractBO.getSalesBOS())) continue;
                supNoRuleList.add(Long.valueOf(signContractBO.getSupplierId() + signContractBO.getMonthReceiveNode()));
                for (SupplierSignContractSalesBO salesBO : signContractBO.getSalesBOS()) {
                    serviceFeeRateMap.put(String.valueOf(signContractBO.getSupplierId()) + salesBO.getItemCatId(), salesBO.getServiceFeeRate());
                }
            }
            if (!CollectionUtils.isEmpty(supNoRuleList)) {
                reqBo.setSupNoRuleList(supNoRuleList);
                reqBo.setSupNoList(null);
            }
        }
        return serviceFeeRateMap;
    }
}

