/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocAttachmentBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractCreateReqBo;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractCreateRspBO;
import com.tydic.uoc.common.busi.api.UocExtensionOfflineContractCreateBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocContractPayConfMapper;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocContractPayConfPO;
import com.tydic.uoc.po.UocOfflineContractPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UocExtensionOfflineContractCreateBusiServiceImpl
implements UocExtensionOfflineContractCreateBusiService {
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocContractPayConfMapper uocContractPayConfMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;

    @Override
    public UocExtensionOfflineContractCreateRspBO dealOfflineContract(UocExtensionOfflineContractCreateReqBo reqBo) {
        UocOfflineContractPO contractPO = (UocOfflineContractPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocOfflineContractPO.class);
        Date now = new Date();
        if (now.getTime() >= reqBo.getEffectiveDate().getTime() && now.getTime() <= reqBo.getExpirationDate().getTime()) {
            contractPO.setContractStatus(UocConstant.OfflineContractStatus.TOOK_EFFECT);
        } else {
            contractPO.setContractStatus(UocConstant.OfflineContractStatus.PENDING);
        }
        if ("1".equals(Convert.toStr((Object)reqBo.getDealType()))) {
            contractPO.setContractId(Long.valueOf(this.idUtil.nextId()));
            contractPO.setCreateTime(new Date());
            contractPO.setCreateUserId(reqBo.getUserId());
            contractPO.setCreateUserName(reqBo.getName());
            this.uocOfflineContractMapper.insert(contractPO);
        } else {
            UocOfflineContractPO getModel = new UocOfflineContractPO();
            getModel.setContractId(reqBo.getContractId());
            UocOfflineContractPO modelBy = this.uocOfflineContractMapper.getModelBy(getModel);
            if (modelBy == null) {
                throw new UocProBusinessException("100002", "\u4fee\u6539\u65e0\u5bf9\u5e94\u6570\u636e");
            }
            contractPO.setUpdateTime(new Date());
            contractPO.setUpdateUserId(reqBo.getUserId());
            contractPO.setUpdateUserName(reqBo.getName());
            UocOfflineContractPO wherePo = new UocOfflineContractPO();
            wherePo.setContractId(reqBo.getContractId());
            contractPO.setContractId(null);
            this.uocOfflineContractMapper.updateBy(contractPO, wherePo);
            contractPO.setContractId(reqBo.getContractId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPayList())) {
            this.buildPay(reqBo, contractPO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getFileList())) {
            this.buildFiles(reqBo, contractPO);
        }
        UocExtensionOfflineContractCreateRspBO rspBO = new UocExtensionOfflineContractCreateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildFiles(UocExtensionOfflineContractCreateReqBo reqBo, UocOfflineContractPO contractPO) {
        OrdAccessoryPO deleteFilePo = new OrdAccessoryPO();
        deleteFilePo.setObjectId(contractPO.getContractId());
        deleteFilePo.setObjectType(Integer.valueOf(101));
        deleteFilePo.setAttachmentType(Integer.valueOf(0));
        if (!ObjectUtils.isEmpty((Object)deleteFilePo.getObjectId())) {
            this.ordAccessoryMapper.deleteBy(deleteFilePo);
        }
        ArrayList<OrdAccessoryPO> addFileList = new ArrayList<OrdAccessoryPO>();
        for (UocAttachmentBO uocAttachmentBO : reqBo.getFileList()) {
            OrdAccessoryPO addFilePo = new OrdAccessoryPO();
            addFilePo.setId(Long.valueOf(this.idUtil.nextId()));
            addFilePo.setObjectId(contractPO.getContractId());
            addFilePo.setObjectType(Integer.valueOf(101));
            addFilePo.setOrderId(contractPO.getContractId());
            addFilePo.setAttachmentType(Integer.valueOf(0));
            addFilePo.setAccessoryName(uocAttachmentBO.getFileName());
            addFilePo.setAccessoryUrl(uocAttachmentBO.getFileUrl());
            addFilePo.setCreateTime(new Date());
            addFilePo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
            addFileList.add(addFilePo);
        }
        this.ordAccessoryMapper.insertBatch(addFileList);
    }

    private void buildPay(UocExtensionOfflineContractCreateReqBo reqBo, UocOfflineContractPO contractPO) {
        UocContractPayConfPO deletePayPo = new UocContractPayConfPO();
        deletePayPo.setContractId(contractPO.getContractId());
        if (!ObjectUtils.isEmpty((Object)deletePayPo.getContractId())) {
            this.uocContractPayConfMapper.deleteBy(deletePayPo);
        }
        List addPayList = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBo.getPayList()), UocContractPayConfPO.class);
        for (UocContractPayConfPO addPayPo : addPayList) {
            addPayPo.setId(Long.valueOf(this.idUtil.nextId()));
            addPayPo.setContractId(contractPO.getContractId());
            addPayPo.setCreateTime(new Date());
        }
        this.uocContractPayConfMapper.insertBatch(addPayList);
    }
}

