/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.busi.api.UocExtensionOfflineContractDealBusiService;
import com.tydic.uoc.common.busi.bo.UocExtensionOfflineContractDealBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocExtensionOfflineContractDealBusiRspBO;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.po.UocOfflineContractPO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocExtensionOfflineContractDealBusiServiceImpl
implements UocExtensionOfflineContractDealBusiService {
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;

    @Override
    public UocExtensionOfflineContractDealBusiRspBO dealOfflineContract(UocExtensionOfflineContractDealBusiReqBO reqBO) {
        UocOfflineContractPO qryPo = new UocOfflineContractPO();
        qryPo.setContractIds(reqBO.getContractIds());
        List list = this.uocOfflineContractMapper.getList(qryPo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new UocProBusinessException("100002", "\u65e0\u5bf9\u5e94\u7684\u7ebf\u4e0b\u5408\u540c");
        }
        List updateListIds = list.stream().map(UocOfflineContractPO::getContractId).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateListIds)) {
            UocOfflineContractPO wherePo = new UocOfflineContractPO();
            wherePo.setContractIds(updateListIds);
            UocOfflineContractPO setPo = new UocOfflineContractPO();
            if (UocCoreConstant.OffLineOperationType.TERMINATION.equals(reqBO.getOperationType())) {
                setPo.setContractStatus(UocConstant.OfflineContractStatus.LOSE_EFFECTIVENESS);
            } else if (UocCoreConstant.OffLineOperationType.DELETE.equals(reqBO.getOperationType())) {
                setPo.setContractStatus(UocConstant.OfflineContractStatus.DELETE);
            } else if (UocCoreConstant.OffLineOperationType.ENABLE.equals(reqBO.getOperationType())) {
                setPo.setContractStatus(UocConstant.OfflineContractStatus.TOOK_EFFECT);
            }
            this.uocOfflineContractMapper.updateBy(setPo, wherePo);
        }
        UocExtensionOfflineContractDealBusiRspBO rspBO = new UocExtensionOfflineContractDealBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

