/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocWarehouseFileBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocWarehouseSyncShipStatusBusiService;
import com.tydic.uoc.common.busi.bo.UocWarehouseSyncShipStatusBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocWarehouseSyncShipStatusBusiRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocWarehouseSyncShipStatusBusiServiceImpl
implements UocWarehouseSyncShipStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocWarehouseSyncShipStatusBusiServiceImpl.class);
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    private static final Integer WAREHOUSE_STATUS_SYNC_IN = 1;
    private static final Integer WAREHOUSE_STATUS_SYNC_OUT = 2;
    private static final Integer WAREHOUSE_STATUS_SYNC_ARRIVE = 3;
    private static final Integer WAREHOUSE_STATUS_SYNC_FILE = 4;
    private static final Integer WAREHOUSE_STATUS_SYNC_ERROR = 9;

    @Override
    public UocWarehouseSyncShipStatusBusiRspBO dealSyncShipStatus(UocWarehouseSyncShipStatusBusiReqBO reqBO) {
        UocWarehouseSyncShipStatusBusiRspBO rspBO = new UocWarehouseSyncShipStatusBusiRspBO();
        OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBO.getShipId().longValue());
        if (ordShipPO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u6570\u636e\uff01");
        }
        if (WAREHOUSE_STATUS_SYNC_IN.equals(reqBO.getStatus())) {
            OrdSalePO ordSalePO;
            if (!("1202".equals(ordShipPO.getShipStatus()) || "1203".equals(ordShipPO.getShipStatus()) || "3204".equals(ordShipPO.getShipStatus()))) {
                throw new UocProBusinessException("8888", "\u53d1\u8d27\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u5165\u5e93");
            }
            OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
            ordStateChgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            if ("1202".equals(ordShipPO.getShipStatus())) {
                ordStateChgLogPO.setOldState(Integer.valueOf(Integer.parseInt("1203")));
            } else {
                ordStateChgLogPO.setOldState(Integer.valueOf(Integer.parseInt(ordShipPO.getShipStatus())));
            }
            OrdShipPO updateOrdShipPO = new OrdShipPO();
            updateOrdShipPO.setOrderId(ordShipPO.getOrderId());
            updateOrdShipPO.setShipVoucherId(ordShipPO.getShipVoucherId());
            updateOrdShipPO.setShipStatus("3201");
            updateOrdShipPO.setWarehouseInTime(DateUtil.strToDateLong((String)reqBO.getDealTime()));
            updateOrdShipPO.setRemark(reqBO.getRemark());
            this.ordShipMapper.updateById(updateOrdShipPO);
            this.ordShipItemMapper.updateWarehouseNum(ordShipPO.getShipVoucherId(), WAREHOUSE_STATUS_SYNC_IN, ordShipPO.getOrderId());
            OrdShipPO checkPO = new OrdShipPO();
            ArrayList<String> shipStatusList = new ArrayList<String>();
            shipStatusList.add("3203");
            shipStatusList.add("3201");
            shipStatusList.add("3202");
            shipStatusList.add("1205");
            checkPO.setNotShipStatusList(shipStatusList);
            checkPO.setOrderId(ordShipPO.getOrderId());
            int i = this.ordShipMapper.getCheckBy(checkPO);
            if (i < 1 && UocConstant.SALE_ORDER_STATUS.DS_TT.equals((ordSalePO = this.qryOrdSale(ordShipPO.getOrderId(), null)).getSaleState())) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("rejectFlag", 1);
                this.runProcess(ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId(), UocConstant.SALE_ORDER_STATUS.DS_TT, variables);
            }
            ordStateChgLogPO.setOrderId(ordShipPO.getOrderId());
            ordStateChgLogPO.setNewState(Integer.valueOf(Integer.parseInt("3201")));
            ordStateChgLogPO.setStateType("A02");
            ordStateChgLogPO.setChgTime(new Date());
            this.ordStateChgLogMapper.insert(ordStateChgLogPO);
        } else if (WAREHOUSE_STATUS_SYNC_ERROR.equals(reqBO.getStatus())) {
            OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
            ordStateChgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            if ("1202".equals(ordShipPO.getShipStatus())) {
                ordStateChgLogPO.setOldState(Integer.valueOf(Integer.parseInt("1203")));
            } else {
                ordStateChgLogPO.setOldState(Integer.valueOf(Integer.parseInt(ordShipPO.getShipStatus())));
            }
            OrdShipPO updateOrdShipPO = new OrdShipPO();
            updateOrdShipPO.setOrderId(ordShipPO.getOrderId());
            updateOrdShipPO.setShipVoucherId(ordShipPO.getShipVoucherId());
            updateOrdShipPO.setShipStatus("3204");
            updateOrdShipPO.setWarehouseAbnormalRemark(reqBO.getRemark());
            updateOrdShipPO.setWarehouseErrorTime(DateUtil.strToDateLong((String)reqBO.getDealTime()));
            this.ordShipMapper.updateById(updateOrdShipPO);
            ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getFiles().size());
            for (UocWarehouseFileBO fileBO : reqBO.getFiles()) {
                OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
                ordAccessoryPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
                ordAccessoryPO.setCreateTime(new Date());
                ordAccessoryPO.setOrderId(ordShipPO.getOrderId());
                ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.SHIP_WAREHOUSE_ERROR_FILES);
                ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                ordAccessoryPO.setAccessoryName(fileBO.getFileName());
                ordAccessoryPO.setAccessoryUrl(fileBO.getFileUrl());
                ordAccessoryPO.setObjectId(ordShipPO.getShipVoucherId());
                list.add(ordAccessoryPO);
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.ordAccessoryMapper.insertBatch(list);
            }
            ordStateChgLogPO.setOrderId(ordShipPO.getOrderId());
            ordStateChgLogPO.setNewState(Integer.valueOf(Integer.parseInt("3204")));
            ordStateChgLogPO.setStateType("A02");
            ordStateChgLogPO.setChgTime(new Date());
            this.ordStateChgLogMapper.insert(ordStateChgLogPO);
        } else if (WAREHOUSE_STATUS_SYNC_FILE.equals(reqBO.getStatus())) {
            OrdShipPO updateOrdShipPO = new OrdShipPO();
            updateOrdShipPO.setOrderId(ordShipPO.getOrderId());
            updateOrdShipPO.setShipVoucherId(ordShipPO.getShipVoucherId());
            updateOrdShipPO.setWarehouseFileTime(DateUtil.strToDateLong((String)reqBO.getDealTime()));
            this.ordShipMapper.updateById(updateOrdShipPO);
            ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getFiles().size());
            for (UocWarehouseFileBO fileBO : reqBO.getFiles()) {
                OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
                ordAccessoryPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
                ordAccessoryPO.setCreateTime(new Date());
                ordAccessoryPO.setOrderId(ordShipPO.getOrderId());
                ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.SHIP_WAREHOUSE_FILES);
                ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                ordAccessoryPO.setAccessoryName(fileBO.getFileName());
                ordAccessoryPO.setAccessoryUrl(fileBO.getFileUrl());
                ordAccessoryPO.setObjectId(ordShipPO.getShipVoucherId());
                list.add(ordAccessoryPO);
            }
            this.ordAccessoryMapper.insertBatch(list);
        } else {
            OrdShipPO updateOrdShipPO = new OrdShipPO();
            updateOrdShipPO.setOrderId(ordShipPO.getOrderId());
            updateOrdShipPO.setShipVoucherId(ordShipPO.getShipVoucherId());
            ArrayList<String> shipStatusList = new ArrayList<String>();
            shipStatusList.add("1205");
            if (WAREHOUSE_STATUS_SYNC_OUT.equals(reqBO.getStatus())) {
                if (!"3201".equals(ordShipPO.getShipStatus())) {
                    throw new UocProBusinessException("8888", "\u53d1\u8d27\u5355\u672a\u5165\u5e93\uff0c\u65e0\u6cd5\u51fa\u5e93");
                }
                updateOrdShipPO.setShipStatus("3202");
                updateOrdShipPO.setWarehouseOutTime(DateUtil.strToDateLong((String)reqBO.getDealTime()));
                shipStatusList.add("3203");
                shipStatusList.add("3202");
            } else if (WAREHOUSE_STATUS_SYNC_ARRIVE.equals(reqBO.getStatus())) {
                if (!"3202".equals(ordShipPO.getShipStatus())) {
                    throw new UocProBusinessException("8888", "\u53d1\u8d27\u5355\u672a\u51fa\u5e93\uff0c\u65e0\u6cd5\u7b7e\u6536");
                }
                updateOrdShipPO.setShipStatus("3203");
                updateOrdShipPO.setWarehouseArriveTime(DateUtil.strToDateLong((String)reqBO.getDealTime()));
                shipStatusList.add("3203");
            }
            this.ordShipMapper.updateById(updateOrdShipPO);
            this.ordShipItemMapper.updateWarehouseNum(ordShipPO.getShipVoucherId(), reqBO.getStatus(), ordShipPO.getOrderId());
            OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
            ordStateChgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            ordStateChgLogPO.setOrderId(ordShipPO.getOrderId());
            ordStateChgLogPO.setOldState(Integer.valueOf(Integer.parseInt(ordShipPO.getShipStatus())));
            ordStateChgLogPO.setNewState(Integer.valueOf(Integer.parseInt(updateOrdShipPO.getShipStatus())));
            ordStateChgLogPO.setStateType("A02");
            ordStateChgLogPO.setChgTime(new Date());
            this.ordStateChgLogMapper.insert(ordStateChgLogPO);
            OrdShipPO checkPO = new OrdShipPO();
            checkPO.setNotShipStatusList(shipStatusList);
            checkPO.setOrderId(ordShipPO.getOrderId());
            int i = this.ordShipMapper.getCheckBy(checkPO);
            if (i < 1) {
                OrdSalePO ordSalePO = this.qryOrdSale(ordShipPO.getOrderId(), null);
                if ("3202".equals(updateOrdShipPO.getShipStatus())) {
                    if (UocConstant.SALE_ORDER_STATUS.WAREHOUSE_IN.equals(ordSalePO.getSaleState())) {
                        this.runProcess(ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId(), UocConstant.SALE_ORDER_STATUS.WAREHOUSE_IN, null);
                    }
                } else if ("3203".equals(updateOrdShipPO.getShipStatus()) && UocConstant.SALE_ORDER_STATUS.WAREHOUSE_OUT.equals(ordSalePO.getSaleState())) {
                    this.runProcess(ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId(), UocConstant.SALE_ORDER_STATUS.WAREHOUSE_OUT, null);
                    rspBO.setIsPushTodo(true);
                }
            }
        }
        rspBO.setOrderId(ordShipPO.getOrderId());
        rspBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        rspBO.setSaleVoucherId(ordShipPO.getSaleVoucherId());
        rspBO.setSubmitTime(reqBO.getDealTime());
        rspBO.setSubmitStatus(reqBO.getStatus());
        rspBO.setRespDesc("0");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private OrdSalePO qryOrdSale(Long orderId, Long saleVoucherId) {
        try {
            OrdSalePO ordSalePO;
            OrdSalePO ordSaleModel = new OrdSalePO();
            ordSaleModel.setOrderId(orderId);
            if (saleVoucherId != null && saleVoucherId != 0L) {
                ordSaleModel.setSaleVoucherId(saleVoucherId);
            }
            if ((ordSalePO = this.ordSaleMapper.getModelBy(ordSaleModel)) == null) {
                throw new UocProBusinessException("102071", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
            }
            return ordSalePO;
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new UocProBusinessException("102071", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6570\u636e\u5e93\u5f02\u5e38!");
        }
    }

    private void runProcess(Long objId, Long orderId, Integer preState, Map<String, Object> variables) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setPreState(preState);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId("01");
        processRunReqBO.setVariables(variables);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102071", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u901a\u8fc7\u5165\u53c2[" + processRunReqBO.toString() + "]\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

