/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomRspBO;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushAcceptanceContractService;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushContractService;
import com.tydic.uoc.common.busi.bo.CheckIsNormalContractOrderBO;
import com.tydic.uoc.common.busi.bo.PebSyncHtAcceptanceArriveAtomBO;
import com.tydic.uoc.common.busi.bo.PebSyncHtAcceptanceDetailArriveAtomBO;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.PebSyncHtAcceptanceArriveAtomPO;
import com.tydic.uoc.po.PebSyncHtAcceptanceDetailArriveAtomPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="UccGateWayApplicationPushAcceptanceContractService")
public class UccGateWayApplicationPushAcceptanceContractServiceImpl
implements UccGateWayApplicationPushAcceptanceContractService {
    private static final Logger log = LoggerFactory.getLogger(UccGateWayApplicationPushAcceptanceContractServiceImpl.class);
    @Autowired
    private ContractHtQryListAbilityService contractHtQryListAbilityService;
    @Autowired
    private UccGateWayApplicationPushContractService uccGateWayApplicationPushContractService;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${ESB_ARRIVEE_CONTRACT_PUSH_URL:http://172.16.192.83:30080/hitf/v1/rest/invoke?namespace=zm_admin&serverCode=YIG_FALLBACK&interfaceCode=oc-base.yg.pushAcceptOrder}")
    private String ESP_ARRIVE_CONTRACT_PUSH_URL;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();

    @Override
    public PebSyncHtPurchaseContractAtomRspBO syncHtPurchase(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        PebSyncHtPurchaseContractAtomRspBO rspBO = new PebSyncHtPurchaseContractAtomRspBO();
        rspBO.setRespCode("0000");
        if (reqBO.getOrderId() != null) {
            log.error("\u63a8\u9001\u5355\u6761\u6570\u636e\u5f00\u59cb.....");
            this.pushSingle(reqBO);
        } else if (reqBO.getOrderIds().size() > 0) {
            log.error("\u63a8\u9001\u591a\u6761\u6570\u636e\u5f00\u59cb.....");
            this.threadPush(reqBO);
        } else {
            throw new BusinessException("8888", "\u5165\u53c2 \u4e3a\u7a7a ");
        }
        return rspBO;
    }

    private void pushSingle(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        if (!ObjectUtils.isEmpty((Object)reqBO.getOrderId())) {
            CheckIsNormalContractOrderBO contractOrder = this.uccGateWayApplicationPushContractService.checkIsNormalContractOrder(reqBO);
            log.error("\u5224\u65ad\u662f\u5426\u9700\u8981\u63a8\u9001\u7ed3\u679c\u4e3a\uff1a{}", (Object)contractOrder);
            if (contractOrder.getContractId() != null && contractOrder.getContractId() > 0L) {
                List inspectionIds = this.orderMapper.getInspectionByOrderId(reqBO.getOrderId());
                log.error("\u5f53\u524dOrderId\u4e0b\u7684\u9a8c\u6536\u5355\u6709\uff1a{}", (Object)inspectionIds);
                if (!CollectionUtils.isEmpty((Collection)inspectionIds)) {
                    for (Long inspectionId : inspectionIds) {
                        log.error("\u5f00\u59cb\u5904\u7406\u9a8c\u6536\u5355----->\u5f53\u524d\u7684inspectionId\u4e3a\uff1a{}", (Object)inspectionId);
                        log.error("\u7ec4\u88c5\u53c2\u6570\u5165\u53c2\uff1a reqBO\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
                        List<PebSyncHtAcceptanceArriveAtomPO> pushInfo = this.assembleParams(reqBO, contractOrder, inspectionId);
                        log.error("\u5f00\u59cb\u5904\u7406\u9a8c\u6536\u5355----->\u7ec4\u88c5\u597d\u7684\u6570\u636e\u4e3a\uff1a{}", pushInfo);
                        List<PebSyncHtAcceptanceArriveAtomPO> pushFilterInfo = this.checkIsCanPush(pushInfo);
                        log.error("\u5f00\u59cb\u5904\u7406\u9a8c\u6536\u5355----->\u8fc7\u6ee4\u4e4b\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", pushFilterInfo);
                        if (ObjectUtils.isEmpty(pushFilterInfo)) continue;
                        this.pushData(pushFilterInfo, inspectionId);
                    }
                } else {
                    log.error("\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355\uff0c\u4e0d\u9700\u8981\u63a8\u9001");
                }
            }
        } else {
            throw new BusinessException("8888", "\u5165\u53c2 \u4e3a\u7a7a");
        }
    }

    private void threadPush(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        log.error("---------------------\u7ebf\u7a0b\u5904\u7406\u5f00\u59cb--------------");
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor((int)CPU, CPU * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        for (Long orderId : reqBO.getOrderIds()) {
            fixedThreadPool.submit(() -> {
                try {
                    PebSyncHtPurchaseContractAtomReqBO atomReqBO = new PebSyncHtPurchaseContractAtomReqBO();
                    atomReqBO.setOrderId(orderId);
                    this.pushSingle(atomReqBO);
                }
                catch (Exception e) {
                    log.error("\u5f02\u5e38\u4fe1\u606f {}", (Object)e.getMessage());
                }
            });
        }
        fixedThreadPool.shutdown();
    }

    private List<PebSyncHtAcceptanceArriveAtomPO> assembleParams(PebSyncHtPurchaseContractAtomReqBO reqBO, CheckIsNormalContractOrderBO contractOrder, Long inspectionId) {
        PebSyncHtAcceptanceArriveAtomPO headInfo = this.orderMapper.getAcceptancePushHeadInfo(inspectionId);
        headInfo.setContractId(contractOrder.getContractId());
        headInfo.setContractNum(contractOrder.getContractNo());
        headInfo.setContractUuid(contractOrder.getContractUuid());
        log.error("\u5f00\u59cb\u5904\u7406\u9a8c\u6536\u5355------>\u5934\u4fe1\u606f\u4e3a\uff1a{}", (Object)headInfo);
        List lineInfo = this.orderMapper.getAcceptancePushLineInfo(inspectionId);
        log.error("\u5f00\u59cb\u5904\u7406\u9a8c\u6536\u5355------>\u884c\u4fe1\u606f\u4e3a\uff1a{}", (Object)lineInfo);
        headInfo.setAcceptLists(lineInfo);
        headInfo.setContractUuid(this.getContractUuid(headInfo));
        ArrayList<PebSyncHtAcceptanceArriveAtomPO> pushList = new ArrayList<PebSyncHtAcceptanceArriveAtomPO>();
        pushList.add(headInfo);
        return pushList;
    }

    private List<PebSyncHtAcceptanceArriveAtomPO> checkIsCanPush(List<PebSyncHtAcceptanceArriveAtomPO> pushInfo) {
        log.error("\u5f00\u59cb\u6821\u9a8c\u90a3\u4e9b\u53ef\u4ee5\u63a8\u9001");
        ArrayList<PebSyncHtAcceptanceArriveAtomPO> pushList = new ArrayList<PebSyncHtAcceptanceArriveAtomPO>();
        List contractIds = pushInfo.stream().map(PebSyncHtAcceptanceArriveAtomPO::getContractId).collect(Collectors.toList());
        log.error("\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u5408\u540c\u7684\u5916\u90e8\u4e3b\u952eId\u7684\u5165\u53c2\uff1a{}", contractIds);
        ContractHtQryListAbilityReqBO qryListAbilityReqBO = new ContractHtQryListAbilityReqBO();
        qryListAbilityReqBO.setContractIds(contractIds);
        ContractHtQryListAbilityRspBO rspBO = this.contractHtQryListAbilityService.qryHTList(qryListAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getInfoList())) {
            log.error("\u5916\u90e8\u5408\u540c\u6570\u636e\u4e0d\u4e3a\u7a7a");
            List abilityBOS = rspBO.getInfoList();
            log.error("\u5b58\u5728\u5916\u90e8\u7cfb\u7edf\u4e3b\u952e\u6570\u636e\uff1a{}", (Object)abilityBOS);
            Map<Long, List<ContractHtQryListAbilityBO>> collect = abilityBOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOutContractId())).collect(Collectors.groupingBy(ContractHtQryListAbilityBO::getContractId));
            for (PebSyncHtAcceptanceArriveAtomPO purchaseArriveAtomPO : pushInfo) {
                if (CollectionUtils.isEmpty((Collection)collect.get(purchaseArriveAtomPO.getContractId()))) continue;
                pushList.add(purchaseArriveAtomPO);
            }
        }
        log.error("\u5916\u90e8\u5408\u540c\u6570\u636e\u4e3a\u7a7a");
        return pushList;
    }

    private void pushData(List<PebSyncHtAcceptanceArriveAtomPO> pushList, Long inspectionId) {
        for (PebSyncHtAcceptanceArriveAtomPO arriveAtomBO : pushList) {
            PebSyncHtAcceptanceArriveAtomBO bo = this.removeUnwantedParameters(arriveAtomBO);
            JSONObject push = new JSONObject();
            push.put("payload", (Object)JSON.toJSONString((Object)bo));
            String reqStr = JSON.toJSONString((Object)push);
            boolean flag = this.uccGateWayApplicationPushContractService.dealPushFunction(reqStr, this.ESP_ARRIVE_CONTRACT_PUSH_URL, UocConstant.ContractPushType.INSP, arriveAtomBO.getOrderId());
            if (!flag) continue;
            this.orderMapper.updateIsSuccessPushOfInspection(inspectionId, Integer.valueOf(1));
            log.error("\u9a8c\u6536\u5355\u66f4\u65b0\u63a8\u9001\u6807\u8bc6\u6210\u529f");
        }
    }

    private PebSyncHtAcceptanceArriveAtomBO removeUnwantedParameters(PebSyncHtAcceptanceArriveAtomPO arriveAtomBO) {
        ArrayList<PebSyncHtAcceptanceDetailArriveAtomBO> detailArriveAtomBos = new ArrayList<PebSyncHtAcceptanceDetailArriveAtomBO>();
        if (!CollectionUtils.isEmpty((Collection)arriveAtomBO.getAcceptLists())) {
            for (PebSyncHtAcceptanceDetailArriveAtomPO line : arriveAtomBO.getAcceptLists()) {
                PebSyncHtAcceptanceDetailArriveAtomBO detailArriveAtomBO = new PebSyncHtAcceptanceDetailArriveAtomBO();
                BeanUtils.copyProperties((Object)line, (Object)detailArriveAtomBO);
                detailArriveAtomBos.add(detailArriveAtomBO);
            }
        }
        PebSyncHtAcceptanceArriveAtomBO pebSyncHtAcceptanceArriveAtomBO = new PebSyncHtAcceptanceArriveAtomBO();
        BeanUtils.copyProperties((Object)arriveAtomBO, (Object)pebSyncHtAcceptanceArriveAtomBO);
        pebSyncHtAcceptanceArriveAtomBO.setAcceptLists(detailArriveAtomBos);
        return pebSyncHtAcceptanceArriveAtomBO;
    }

    private String getContractUuid(PebSyncHtAcceptanceArriveAtomPO headInfo) {
        if (StringUtils.isEmpty((Object)headInfo.getContractUuid())) {
            log.error("\u6570\u636e\u5e93\u6ca1\u6709\u5408\u540c\u7cfb\u7edfUUID");
            Long contractId = headInfo.getContractId();
            ArrayList<Long> contractIds = new ArrayList<Long>();
            contractIds.add(contractId);
            ContractHtQryListAbilityReqBO qryListAbilityReqBO = new ContractHtQryListAbilityReqBO();
            qryListAbilityReqBO.setContractIds(contractIds);
            log.error("\u8c03\u7528\u5408\u540c\u670d\u52a1\u67e5\u8be2\u63a5\u53e3\uff0c\u67e5\u8be2\u5408\u540c\u7cfb\u7edfUUID");
            ContractHtQryListAbilityRspBO rspBO = this.contractHtQryListAbilityService.qryHTList(qryListAbilityReqBO);
            log.error("\u67e5\u8be2\u5230\u7684\u5408\u540c\u7cfb\u7edfUUID\u7ed3\u679c\u4e3a\uff1a{}", (Object)rspBO);
            if (rspBO != null && rspBO.getInfoList().get(0) != null) {
                String outContractUuId = ((ContractHtQryListAbilityBO)rspBO.getInfoList().get(0)).getOutContractUuId();
                log.error("\u83b7\u53d6\u5230\u7684\u5408\u540c\u7cfb\u7edfUUID\u4e3a\uff1a{}", (Object)outContractUuId);
                if (!StringUtils.isEmpty((Object)outContractUuId)) {
                    log.error("\u5c06\u5408\u540c\u7cfb\u7edfUUID\u5b58\u5165\u6570\u636e\u5e93");
                    this.orderMapper.updateContractUuidByOrderId(headInfo.getOrderId(), outContractUuId);
                    log.error("\u67e5\u8be2\u5230\u7684\u5408\u540c\u7cfb\u7edfUUID\uff1a{}", (Object)outContractUuId);
                    return outContractUuId;
                }
            }
            return null;
        }
        log.error("\u6570\u636e\u91cf\u6709\u5408\u540c\u7cfb\u7edfUUID\uff1a{}", (Object)headInfo.getContractUuid());
        return headInfo.getContractUuid();
    }
}

