/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocApproveEntrustConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.bo.PebExtCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelRspBO;
import com.tydic.uoc.common.ability.bo.TaskReqBo;
import com.tydic.uoc.common.ability.bo.UocApproveEntrustNotificationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.comb.api.TimerUnpaidOrderCancelComboService;
import com.tydic.uoc.common.comb.api.UocPebOrderCancelCombService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.common.comb.bo.UocPebSaleOrdSevenDayCancelRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSaleForCancelPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TimerUnpaidOrderCancelComboService")
public class TimerUnpaidOrderCancelComboServiceImpl
implements TimerUnpaidOrderCancelComboService {
    private static final Logger log = LoggerFactory.getLogger(TimerUnpaidOrderCancelComboServiceImpl.class);
    private final OrdSaleMapper ordSaleMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    private final PebExtCancelBusiService pebExtCancelBusiService;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    private final UocPebOrderCancelCombService uocPebOrderCancelCombService;
    @Resource(name="mqUocApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqUocApproveEntrustNotificationProvider;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC:UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String uocApproveEntrustNotificationTopic;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String uocApproveEntrustNotificationTag;

    public TimerUnpaidOrderCancelComboServiceImpl(OrdSaleMapper ordSaleMapper, PebExtCancelBusiService pebExtCancelBusiService, UocPebOrderCancelCombService uocPebOrderCancelCombService) {
        this.ordSaleMapper = ordSaleMapper;
        this.pebExtCancelBusiService = pebExtCancelBusiService;
        this.uocPebOrderCancelCombService = uocPebOrderCancelCombService;
    }

    @Override
    public UocPebSaleOrdSevenDayCancelRspBO cancelUnpaidOrder(TaskReqBo reqBO) {
        UocPebSaleOrdSevenDayCancelRspBO rspBO = new UocPebSaleOrdSevenDayCancelRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int executeDay = 7;
        calendar.add(5, -executeDay);
        Date before7days = calendar.getTime();
        OrdSaleForCancelPO qryOrderReqBO = new OrdSaleForCancelPO();
        qryOrderReqBO.setSaleState(UocConstant.SALE_ORDER_STATUS.PAYING);
        qryOrderReqBO.setCancelTime(before7days);
        qryOrderReqBO.setOrderSourceList(Arrays.asList(PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET, PecConstant.ORDER_SOURCE.ELEC_AREA));
        qryOrderReqBO.setUserTypeList(Arrays.asList("1", "2"));
        Page<OrdSalePO> page = this.setSelectPageSize(100);
        List needCancelOrderList = this.ordSaleMapper.getNeedCancelOrder(qryOrderReqBO, page);
        log.info("\u5206\u9875\u67e5\u8be2\u5230\u76847\u5929\u672a\u4ed8\u6b3e\u8ba2\u5355\u4e3a" + (needCancelOrderList == null ? "0" : Integer.valueOf(needCancelOrderList.size())) + "\u6761");
        if (!CollectionUtils.isEmpty((Collection)needCancelOrderList)) {
            for (OrdSaleForCancelPO orderBO : needCancelOrderList) {
                UocApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO;
                PebExtCancelRspBO pebExtCancelRspBO;
                PebExtCancelReqBO pebExtCancelReqBO;
                log.debug("\u67e5\u8be2\u5230\u7684\u53ef\u53d6\u6d88\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)orderBO));
                if (("" + PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET).equals(orderBO.getOrderSource())) {
                    pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)orderBO), PebExtCancelReqBO.class);
                    pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
                    if (!"0000".equals(pebExtCancelRspBO.getRespCode())) continue;
                    if (!StringUtils.isEmpty((CharSequence)pebExtCancelRspBO.getReqJsonStr())) {
                        this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, pebExtCancelRspBO.getReqJsonStr()));
                    }
                    if (!pebExtCancelRspBO.getPush().booleanValue()) {
                        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)cancelReqBO);
                        cancelReqBO.setCancelDesc("\u672a\u4ed8\u6b3e\u8ba2\u5355\u8d85\u8fc77\u5929\u81ea\u52a8\u53d6\u6d88");
                        cancelReqBO.setSaleVoucherId(orderBO.getSaleVoucherId());
                        cancelReqBO.setCancelOperId("99999999999");
                        this.uocPebOrderCancelCombService.dealOrderCancel(cancelReqBO);
                    }
                    UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
                    syncReqBO.setObjId(orderBO.getSaleVoucherId());
                    syncReqBO.setOrderId(orderBO.getOrderId());
                    syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pebExtCancelRspBO.getAuditNoticeList())) continue;
                    approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
                    try {
                        approveWaitNotificationReqBO.setAuditNoticeList(pebExtCancelRspBO.getAuditNoticeList());
                        approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.CancelOrder);
                        approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.CancelOrder);
                        log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                        this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
                    }
                    continue;
                }
                if (!("" + PecConstant.ORDER_SOURCE.ELEC_AREA).equals(orderBO.getOrderSource())) continue;
                pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)orderBO), PebExtCancelReqBO.class);
                pebExtCancelReqBO.setCancelReason("\u672a\u4ed8\u6b3e\u8ba2\u5355\u8d85\u8fc77\u5929\u81ea\u52a8\u53d6\u6d88");
                pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
                if (!"0000".equals(pebExtCancelRspBO.getRespCode())) {
                    log.info("\u672a\u4ed8\u6b3e\u8ba2\u5355\u8d85\u8fc77\u5929\u81ea\u52a8\u53d6\u6d88\u5931\u8d25\uff1a" + pebExtCancelRspBO.getRespDesc());
                    continue;
                }
                if (!StringUtils.isEmpty((CharSequence)pebExtCancelRspBO.getReqJsonStr())) {
                    this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, pebExtCancelRspBO.getReqJsonStr()));
                }
                UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
                uocOrdIdxSyncReqBO.setObjId(orderBO.getSaleVoucherId());
                uocOrdIdxSyncReqBO.setOrderId(orderBO.getOrderId());
                uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pebExtCancelRspBO.getAuditNoticeList())) continue;
                approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
                try {
                    approveWaitNotificationReqBO.setAuditNoticeList(pebExtCancelRspBO.getAuditNoticeList());
                    approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.CancelOrder);
                    approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.CancelOrder);
                    log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                    this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
                }
                catch (Exception e) {
                    log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Page<OrdSalePO> setSelectPageSize(int i) {
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(i);
        return page;
    }
}

