/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.common.comb.bo.UocTodoCombApprovalRspBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocTodoCombServiceImpl
implements UocTodoCombService {
    private static final Logger log = LoggerFactory.getLogger(UocTodoCombServiceImpl.class);
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;

    @Override
    public String getNextStationId(Long objId, Integer objType) {
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.getUacQryAuditLogRspBO(objId, objType);
        return ((ApprovalLogBO)uacQryAuditLogRspBO.getRows().get(0)).getNextStationId();
    }

    @Override
    public UocTodoCombApprovalRspBO getApprovalLogBO(Long objId, Integer objType) {
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.getQryAuditLogRspBO(objId, objType);
        UocTodoCombApprovalRspBO rspBO = new UocTodoCombApprovalRspBO();
        rspBO.setApprovalLogBO((ApprovalLogBO)uacQryAuditLogRspBO.getRows().get(0));
        rspBO.setCommissionedUserIds(uacQryAuditLogRspBO.getCommissionedUserIds());
        rspBO.setEntrustUserIds(uacQryAuditLogRspBO.getEntrustUserIds());
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private UacQryAuditLogRspBO getUacQryAuditLogRspBO(Long objId, Integer objType) {
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(Integer.valueOf(1));
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(999));
        uacQryAuditLogReqBO.setObjId(String.valueOf(objId));
        uacQryAuditLogReqBO.setObjType(objType);
        log.error("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        log.error("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if (Objects.isNull(uacQryAuditLogRspBO) || !"0000".equals(uacQryAuditLogRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows()) || ((ApprovalLogBO)uacQryAuditLogRspBO.getRows().get(0)).getNextStationId() == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u5ba1\u6279\u6570\u636e" + objId);
        }
        return uacQryAuditLogRspBO;
    }

    private UacQryAuditLogRspBO getQryAuditLogRspBO(Long objId, Integer objType) {
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(Integer.valueOf(1));
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(999));
        uacQryAuditLogReqBO.setObjId(String.valueOf(objId));
        uacQryAuditLogReqBO.setObjType(objType);
        log.error("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        log.error("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if (Objects.isNull(uacQryAuditLogRspBO) || !"0000".equals(uacQryAuditLogRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u5ba1\u6279\u6570\u636e" + objId);
        }
        return uacQryAuditLogRspBO;
    }

    @Override
    public String getNextStationIdByOrderId(Long objId, Integer objType) {
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(Integer.valueOf(1));
        uacQryAuditLogReqBO.setPageSize(Integer.valueOf(999));
        uacQryAuditLogReqBO.setOrderId(objId);
        uacQryAuditLogReqBO.setObjType(objType);
        log.error("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
        log.error("\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if (Objects.isNull(uacQryAuditLogRspBO) || !"0000".equals(uacQryAuditLogRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows()) || ((ApprovalLogBO)uacQryAuditLogRspBO.getRows().get(0)).getNextStationId() == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0b\u4e00\u5ba1\u6279\u6570\u636e" + objId);
        }
        List collect = uacQryAuditLogRspBO.getRows().stream().sorted(Comparator.comparing(ApprovalLogBO::getCreateTime).reversed()).collect(Collectors.toList());
        return ((ApprovalLogBO)collect.get(0)).getNextStationId();
    }

    @Override
    public List<UserBO> qryDealApprovalPersons(String stationId, Long orgId, List<Long> entrustUserIds, List<Long> commissionedUserIds) {
        log.error("\u83b7\u53d6\u5c97\u4f4d\u5bf9\u5e94\u7684\u5ba1\u6279\u4eba\u5217\u8868----\u5f00\u59cb");
        log.error("\u5165\u53c2stationId\uff1a{}", (Object)stationId);
        log.error("\u5165\u53c2orgId\uff1a{}", (Object)orgId);
        List<Object> userBOList = new ArrayList<UserBO>();
        if (!StringUtils.isEmpty((Object)stationId)) {
            String[] split = stationId.split(",");
            ArrayList<Long> ids = new ArrayList<Long>();
            for (String id : split) {
                ids.add(Long.valueOf(id));
            }
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationIds(ids);
            dycStationOrgSelectUserNameReqBO.setCommissionedUserIds(commissionedUserIds);
            dycStationOrgSelectUserNameReqBO.setEntrustUserIds(entrustUserIds);
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserNameList(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && !dycStationOrgSelectUserNameRspBO.getUserList().isEmpty()) {
                userBOList.addAll(dycStationOrgSelectUserNameRspBO.getUserList());
            }
            log.error("userBOList\u4e3a\uff1a{}", userBOList);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(userBOList)) {
                userBOList = userBOList.stream().distinct().collect(Collectors.toList());
            }
        }
        log.error("\u83b7\u53d6\u5c97\u4f4d\u5bf9\u5e94\u7684\u5ba1\u6279\u4eba\u5217\u8868----\u7ed3\u675f");
        return userBOList;
    }

    @Override
    public Long getChangeOrderIdByOrderId(Long orderId) {
        return this.ordAgreementMapper.getChangeOrderIdByOrderId(orderId);
    }

    @Override
    public List<ApprovalLogBO> getApprovalLogBOList(Long orderId, Integer objType) {
        UacQryAuditLogRspBO uacQryAuditLogRspBO = this.getQryAuditLogRspBO(orderId, objType);
        return uacQryAuditLogRspBO.getRows();
    }
}

