/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ard.security.utils.StringUtils;
import com.ard.security.utils.sm3.SM3Digest;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncUpdateConsumerVO;
import com.tydic.uoc.common.vo.UocESGOrderSyncRspConsumerVO;
import com.tydic.uoc.common.vo.UocESGOrderUpdateConsumerVO;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocEsgPushLogMapper;
import com.tydic.uoc.dao.UocEsgPushLogPreMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocEsgPushLogPO;
import com.tydic.uoc.po.UocEsgPushLogPrePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class UocESGUpdateOrderConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocESGUpdateOrderConsumer.class);
    @Resource
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private UocEsgPushLogMapper uocEsgPushLogMapper;
    @Resource
    private UocEsgPushLogPreMapper uocEsgPushLogPreMapper;
    @Autowired
    private UocESGConfig uocESGConfig;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u8d39\u8005");
        try {
            log.info("---------------\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            UocESGOrderSyncUpdateConsumerVO reqConsumerVO = (UocESGOrderSyncUpdateConsumerVO)JSON.parseObject((String)message.getContent(), (TypeReference)new TypeReference<UocESGOrderSyncUpdateConsumerVO>(){}, (Feature[])new Feature[0]);
            if (Objects.isNull(reqConsumerVO) || Objects.isNull(reqConsumerVO.getOrderId())) {
                log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u8d39\u8005\u6d88\u606f\u4f53\u4e3a\u7a7a\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.info("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u4f53\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqConsumerVO));
            UocESGOrderUpdateConsumerVO reqVO = this.orderData(reqConsumerVO);
            if (Objects.isNull(reqVO)) {
                log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u7ec4\u88c5\u63a8\u9001\u6570\u636e\u4e3a\u7a7a");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            int status = 0;
            String respData = null;
            JSONObject param = JSON.parseObject((String)JSON.toJSONString((Object)reqVO));
            this.insertLogPre(reqConsumerVO.getOrderId(), status, JSON.toJSONString((Object)reqConsumerVO));
            String response = this.send(this.uocESGConfig.getUpdateUrl(), param);
            if (StringUtils.isNotBlank((CharSequence)response)) {
                UocESGOrderSyncRspConsumerVO rspConsumerVO = (UocESGOrderSyncRspConsumerVO)JSON.parseObject((String)response, UocESGOrderSyncRspConsumerVO.class);
                if (!"200".equals(rspConsumerVO.getApistatus())) {
                    log.error("\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff1a" + rspConsumerVO.getMsg());
                } else {
                    status = 1;
                }
                respData = JSON.toJSONString((Object)rspConsumerVO);
            }
            this.insertLog(reqConsumerVO, status, JSON.toJSONString((Object)reqVO), respData);
        }
        catch (Exception e) {
            log.error("\u5165\u53c2\uff1a{} \u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff1a" + e, (Object)message.getContent());
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        stopWatch.stop();
        log.error(stopWatch.getLastTaskName() + "\u8017\u65f6:" + stopWatch.getTotalTimeMillis() + "s");
        log.info("---------------\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u72b6\u6001\u53d8\u66f4\u540c\u6b65\u6d88\u8d39\u8005\u7ed3\u675f---------------");
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void insertLog(UocESGOrderSyncUpdateConsumerVO reqConsumerVO, int status, String pushDate, String respDate) {
        UocEsgPushLogPO uocEsgPushLogPO = new UocEsgPushLogPO();
        uocEsgPushLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uocEsgPushLogPO.setObjectId(reqConsumerVO.getOrderId());
        uocEsgPushLogPO.setPushStatus(Integer.valueOf(status));
        uocEsgPushLogPO.setType(reqConsumerVO.getOrderStatus());
        uocEsgPushLogPO.setPushData(pushDate);
        uocEsgPushLogPO.setRespData(respDate);
        uocEsgPushLogPO.setPushTime(new Date());
        this.uocEsgPushLogMapper.insert(uocEsgPushLogPO);
    }

    private void insertLogPre(Long orderId, int status, String pushDate) {
        UocEsgPushLogPrePO prePO = new UocEsgPushLogPrePO();
        prePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        prePO.setObjectId(orderId);
        prePO.setPushStatus(Integer.valueOf(status));
        prePO.setType(Integer.valueOf(1));
        prePO.setPushData(pushDate);
        prePO.setPushTime(new Date());
        this.uocEsgPushLogPreMapper.insert(prePO);
    }

    public UocESGOrderUpdateConsumerVO orderData(UocESGOrderSyncUpdateConsumerVO reqVO) {
        UocESGOrderUpdateConsumerVO rspVO = new UocESGOrderUpdateConsumerVO();
        UocOrdZmInfoPO ordZmInfoPOReq = new UocOrdZmInfoPO();
        ordZmInfoPOReq.setOrderId(reqVO.getOrderId());
        UocOrdZmInfoPO ordZmInfoPO = this.uocOrdZmInfoMapper.selectOne(ordZmInfoPOReq);
        if (Objects.isNull(ordZmInfoPO) || StringUtils.isEmpty((String)ordZmInfoPO.getAssistDistName())) {
            log.error("\u8ba2\u5355\u53f7\uff1a{} \u4e0d\u662f\u6276\u8d2b\u4e13\u533a\u8ba2\u5355\uff0c\u65e0\u9700\u63a8\u9001", (Object)reqVO.getOrderId());
            return null;
        }
        UocEsgPushLogPO uocEsgPushLogPO = new UocEsgPushLogPO();
        uocEsgPushLogPO.setObjectId(reqVO.getOrderId());
        uocEsgPushLogPO.setPushStatus(Integer.valueOf(1));
        List pushLogPOList = this.uocEsgPushLogMapper.getList(uocEsgPushLogPO);
        if (CollectionUtils.isEmpty((Collection)pushLogPOList)) {
            log.error("\u8ba2\u5355\u53f7\uff1a{} \u672a\u6210\u529f\u63a8\u9001\u8ba2\u5355\u540c\u6b65\u6570\u636e\uff0c\u5f53\u524d\u72b6\u6001\u65e0\u9700\u63a8\u9001", (Object)reqVO.getOrderId());
            return null;
        }
        List typeList = pushLogPOList.stream().map(UocEsgPushLogPO::getType).collect(Collectors.toList());
        if (!typeList.contains(1)) {
            log.error("\u8ba2\u5355\u53f7\uff1a{} \u672a\u6210\u529f\u63a8\u9001\u8ba2\u5355\u540c\u6b65\u6570\u636e\uff0c\u5f53\u524d\u72b6\u6001\u65e0\u9700\u63a8\u9001", (Object)reqVO.getOrderId());
            return null;
        }
        if (typeList.contains(reqVO.getOrderStatus())) {
            log.error("\u8ba2\u5355\u53f7\uff1a{} \u91cd\u590d\u63a8\u9001\uff0c\u5f53\u524d\u65e0\u9700\u63a8\u9001", (Object)reqVO.getOrderId());
            return null;
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqVO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (Objects.isNull(orderPO)) {
            return null;
        }
        rspVO.setCentralName(this.uocESGConfig.getCentralName());
        rspVO.setPlatformName(this.uocESGConfig.getPlatformName());
        rspVO.setOrderCode(String.valueOf(reqVO.getOrderId()));
        rspVO.setOrderOldCode(String.valueOf(reqVO.getOrderId()));
        rspVO.setOrderStatus(String.valueOf(reqVO.getOrderStatus()));
        rspVO.setOperTime(DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        rspVO.setOrderType(Objects.nonNull(orderPO.getOrderType()) && orderPO.getOrderType() == 7 ? "2" : "1");
        return rspVO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String send(String url, JSONObject param) throws IOException {
        String body = "";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            JSONObject paramJson = new JSONObject();
            paramJson.put("param", (Object)JSONObject.toJSONString((Object)param));
            String signcf = "h5_iden:" + new Date().getTime() + param.getString("orderOldCode");
            paramJson.put("sign_cf", (Object)signcf);
            String s = this.replaceParam(signcf, JSON.toJSONString((Object)paramJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}));
            String signYq = SM3Digest.sm3Digest((String)s);
            paramJson.put("sign_yq", (Object)signYq);
            Set keySet = paramJson.keySet();
            for (String key : keySet) {
                ContentType contentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (String)"UTF-8");
                builder.addPart(key, (ContentBody)new StringBody(paramJson.getString(key), contentType));
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            log.info("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            try {
                Throwable throwable;
                CloseableHttpResponse response;
                block36: {
                    String string;
                    block37: {
                        response = client.execute((HttpUriRequest)httpPost);
                        throwable = null;
                        if (!Objects.isNull(response)) break block36;
                        log.error("\u5bf9\u63a5\u5174\u519c\u8282\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        string = null;
                        if (response == null) return string;
                        if (throwable == null) break block37;
                        try {
                            response.close();
                            return string;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return string;
                        }
                    }
                    response.close();
                    return string;
                }
                try {
                    HttpEntity responseEntity = response.getEntity();
                    body = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf8");
                    log.info("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u8fd4\u56de\u7ed3\u679c\uff1a" + body);
                    EntityUtils.consume((HttpEntity)entity);
                    return body;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5f02\u5e38\uff1a" + e);
                return body;
            }
        }
        catch (Exception e) {
            log.error("\u5bf9\u63a5\u5174\u519c\u8282\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5f02\u5e38\uff1a" + e);
        }
        return body;
    }

    public String replaceParam(String sign_cf, String requstParam) {
        requstParam = requstParam.replaceAll("\\[|\\]", "");
        if (sign_cf.contains("h5_iden:")) {
            requstParam = requstParam.replaceAll("\\[|\\]|\\+|\\\\r|\\\\n|\\\\t|\\\\|\\/|\"|'|\\s*|\\s|\\<|\\>", "");
            String regEx = "[@`~#\uffe5%&*\u2018\u201c\u2019\u201d\"'<>?=.;^]";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(requstParam);
            requstParam = matcher.replaceAll("");
            requstParam = requstParam.replaceAll(" ", "");
            requstParam = requstParam.replaceAll(" ", "");
        }
        return requstParam;
    }
}

