/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;

public class PdfReportM1HeaderFooterUtil
extends PdfPageEventHelper {
    public int presentFontSize = 8;
    public Rectangle pageSize = PageSize.A4;
    public PdfTemplate total;
    public BaseFont bf = null;
    public Font fontDetail = null;
    public Phrase footerDetailOne;
    public Phrase footerDetailTwo;

    public PdfReportM1HeaderFooterUtil() {
    }

    public PdfReportM1HeaderFooterUtil(Phrase footerDetailOne, Phrase footerDetailTwo) {
        this.footerDetailOne = footerDetailOne;
        this.footerDetailTwo = footerDetailTwo;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(50.0f, 50.0f);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            if (this.bf == null) {
                this.bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            if (this.fontDetail == null) {
                this.fontDetail = new Font(this.bf, (float)this.presentFontSize, 0);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int pageS = writer.getPageNumber();
        String foot1 = "\u7b2c  " + pageS + "  \u9875  \u5171";
        Phrase footer = new Phrase(foot1, this.fontDetail);
        if (this.bf == null) {
            return;
        }
        float len = this.bf.getWidthPoint(foot1, (float)this.presentFontSize);
        PdfContentByte cb = writer.getDirectContent();
        ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)this.footerDetailOne, (float)(document.left() + 35.0f), (float)(document.bottom() - 15.0f), (float)0.0f);
        ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)this.footerDetailTwo, (float)(document.left() + 35.0f), (float)(document.bottom() - 30.0f), (float)0.0f);
        ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)footer, (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left() - len) / 2.0f + 20.0f), (float)(document.bottom() - 50.0f), (float)0.0f);
        cb.addTemplate(this.total, (document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f + 20.0f, document.bottom() - 50.0f);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.bf, (float)this.presentFontSize);
        String foot2 = "  " + writer.getPageNumber() + "  \u9875";
        this.total.showText(foot2);
        this.total.endText();
        this.total.closePath();
    }
}

