/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.PebAfterSalesServiceApprovalAbilityService;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalInfoBo;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalRspBO;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneDealReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncUpdateConsumerVO;
import com.tydic.uoc.common.busi.api.EsMsgLogBusiService;
import com.tydic.uoc.common.busi.api.PebAfterSalesServiceApprovalBusiService;
import com.tydic.uoc.common.busi.bo.EsMsgLogReqBO;
import com.tydic.uoc.common.busi.bo.EsMsgLogRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.config.aop.DuplicateCommitLimit;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebAfterSalesServiceApprovalAbilityService"})
public class PebAfterSalesServiceApprovalAbilityServiceImpl
implements PebAfterSalesServiceApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebAfterSalesServiceApprovalAbilityServiceImpl.class);
    @Autowired
    PebAfterSalesServiceApprovalBusiService pebAfterSalesServiceApprovalBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private EsMsgLogBusiService esMsgLogBusiService;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_UPDATE_ORDER_TOPIC:UOC_UPDATE_ORDER_TOPIC}")
    private String updateTopic;
    @Value(value="${UOC_UPDATE_ORDER_TAG:*}")
    private String updateTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;

    @DuplicateCommitLimit
    @PostMapping(value={"dealPebAfterSalesServiceApproval"})
    public PebAfterSalesServiceApprovalRspBO dealPebAfterSalesServiceApproval(@RequestBody PebAfterSalesServiceApprovalReqBO reqBO) {
        this.validateParams(reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
            reqBO.setActionCode("ACTPEB015");
        }
        if (UocConstant.ACTION_RESULT.PASS.equals(reqBO.getAuditResult())) {
            reqBO.setAfsActionCode(UocConstant.AFS_ACTION_CODE.CONFIRMING);
        } else if (UocConstant.ACTION_RESULT.NO_PASS.equals(reqBO.getAuditResult())) {
            reqBO.setAfsActionCode(UocConstant.AFS_ACTION_CODE.NOT_AGREE);
        }
        PebAfterSalesServiceApprovalRspBO rspBO = (PebAfterSalesServiceApprovalRspBO)UocProRspBoUtil.success(PebAfterSalesServiceApprovalRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAfterSaleInfoBOS())) {
            StringBuilder str = new StringBuilder();
            for (PebAfterSalesServiceApprovalInfoBo afterSalesServiceApprovalInfoBo : reqBO.getAfterSaleInfoBOS()) {
                if (str.toString().contains(String.valueOf(afterSalesServiceApprovalInfoBo.getAfterServId()))) continue;
                str.append(afterSalesServiceApprovalInfoBo.getAfterServId()).append(",");
                reqBO.setAfterServId(afterSalesServiceApprovalInfoBo.getAfterServId());
                reqBO.setOrderId(afterSalesServiceApprovalInfoBo.getOrderId());
                rspBO = this.pebAfterSalesServiceApprovalBusiService.dealPebAfterSalesServiceApproval(reqBO);
                if ("0000".equals(rspBO.getRespCode())) {
                    this.idxSync(reqBO, rspBO);
                    this.dealEsOrderList(rspBO);
                    this.dealEsInspectionList(rspBO);
                    if (StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) continue;
                    this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
                    continue;
                }
                throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
            }
        } else {
            rspBO = this.pebAfterSalesServiceApprovalBusiService.dealPebAfterSalesServiceApproval(reqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                this.idxSync(reqBO, rspBO);
                this.dealEsOrderList(rspBO);
                this.dealEsInspectionList(rspBO);
                if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
                    this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
                }
            }
        }
        if ("0000".equals(rspBO.getRespCode())) {
            this.businessBacklog(reqBO);
            if (UocConstant.AFS_ACTION_CODE.CONFIRMING.equals(reqBO.getAfsActionCode())) {
                this.addBacklog(reqBO);
            }
        }
        return rspBO;
    }

    private void addBacklog(PebAfterSalesServiceApprovalReqBO reqBO) {
        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
        todoBusinessWaitDoneAddBo.setBusiCode("3047");
        todoBusinessWaitDoneAddBo.setCenterCode("order");
        todoBusinessWaitDoneAddBo.setSystemCode("1");
        todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(reqBO.getAfterServId()));
        todoBusinessWaitDoneAddBo.setSubmitUserNo(String.valueOf(reqBO.getUsername()));
        todoBusinessWaitDoneAddBo.setSubmitUserName(reqBO.getName());
        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    private void businessBacklog(PebAfterSalesServiceApprovalReqBO reqBO) {
        UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo dealReqBo = new TodoBusinessWaitDoneDealReqBo();
        dealReqBo.setBusiCode("3045");
        dealReqBo.setObjId(String.valueOf(reqBO.getAfterServId()));
        dealReqBo.setDealUserNo(String.valueOf(reqBO.getUserId()));
        dealReqBo.setDealUserName(reqBO.getName());
        uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25{}", (Object)dealReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)uocBusinessPendingTodoAbilityAtomReqBO));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25", (Throwable)e);
        }
    }

    private Boolean checkIsEmployeeSupermarket(Long orderId) {
        List generateMethods = this.ordExtMapMapper.getFieldValue(orderId);
        log.error("\u67e5\u8be2\u5e95\u88681\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)generateMethods));
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        OrderPO orderInfo = this.orderMapper.getModelBy(orderPO);
        log.error("\u67e5\u8be2\u5e95\u88682\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)orderInfo));
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        OrdSalePO ordSaleInfo = this.ordSaleMapper.getModelBy(ordSalePO);
        log.error("\u67e5\u8be2\u5e95\u88683\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)ordSaleInfo));
        Integer orderType = orderInfo.getOrderType();
        String orderSource = ordSaleInfo.getOrderSource();
        if (!(generateMethods.contains("1") || 4 != orderType && 5 != orderType || !"1".equals(orderSource) && !"2".equals(orderSource))) {
            return true;
        }
        return false;
    }

    private void syncESG(Long orderId) {
        try {
            if (this.uocESGConfig.getAbutmentESGYn().booleanValue() && Objects.nonNull(orderId)) {
                UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                uocOrdZmInfoPO.setOrderId(orderId);
                uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO);
                if (Objects.nonNull(uocOrdZmInfoPO) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) {
                    UocESGOrderSyncUpdateConsumerVO updateConsumerVO = new UocESGOrderSyncUpdateConsumerVO();
                    updateConsumerVO.setOrderId(orderId);
                    updateConsumerVO.setOrderStatus(Integer.valueOf(4));
                    this.uocESGSyncMsgProvider.send(new ProxyMessage(this.updateTopic, this.updateTag, JSONObject.toJSONString((Object)updateConsumerVO)));
                }
            }
        }
        catch (Exception exception) {
            log.error("\u552e\u540e\u5b8c\u6210\u540e\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
        }
    }

    private void idxSync(PebAfterSalesServiceApprovalReqBO reqBO, PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getAfterServId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        try {
            EsMsgLogReqBO logReqBO = new EsMsgLogReqBO();
            logReqBO.setObjId(uocOrdIdxSyncReqBO.getObjId());
            logReqBO.setObjType(uocOrdIdxSyncReqBO.getObjType());
            logReqBO.setOrderId(uocOrdIdxSyncReqBO.getOrderId());
            EsMsgLogRspBO logRspBO = this.esMsgLogBusiService.dealSave(logReqBO);
            uocOrdIdxSyncReqBO.setEsLogId(logRspBO.getId());
        }
        catch (Exception logReqBO) {
            // empty catch block
        }
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setObjId(reqBO.getAfterServId());
        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocPebOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(uocPebOrdIdxSyncReqBO);
        PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
        syncReqBO.setPlanIds(rspBO.getPlanIds());
        this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
    }

    private void dealEsOrderList(PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void dealEsInspectionList(PebAfterSalesServiceApprovalRspBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        if (null != rspBO.getInspectionVoucherId() && 0L != rspBO.getInspectionVoucherId()) {
            uocOrdIdxSyncReqBO.setObjId(rspBO.getInspectionVoucherId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        } else {
            uocOrdIdxSyncReqBO.setObjId(rspBO.getShipVoucherId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        }
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void validateParams(PebAfterSalesServiceApprovalReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAuditResult() == null) {
            throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.PASS) && !reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.NO_PASS)) {
            throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAfterSaleInfoBOS())) {
            if (reqBO.getAfterServId() == null) {
                throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u552e\u540e\u5355id\u3010afterServId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getOrderId() == null) {
                throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            for (PebAfterSalesServiceApprovalInfoBo afterSaleInfoBO : reqBO.getAfterSaleInfoBOS()) {
                if (afterSaleInfoBO.getAfterServId() == null) {
                    throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u552e\u540e\u5355id\u3010afterServId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (afterSaleInfoBO.getOrderId() != null) continue;
                throw new UocProBusinessException("100001", "\u552e\u540e\u670d\u52a1\u5ba1\u6279\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

