/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebBigOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebBigOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebBigOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebBigOrderBusiService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebBigOrderAbilityService"})
public class PebBigOrderAbilityServiceImpl
implements PebBigOrderAbilityService {
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebBigOrderBusiService pebBigOrderBusiService;
    @Value(value="${PUSH_ERP_BIG_ORDER_TOPIC:PUSH_ERP_BIG_ORDER_TOPIC}")
    private String pushBigErpTopic;
    @Value(value="${PUSH_ERP_BIG_ORDER_TOPIC:*}")
    private String pushBigErpTag;
    @Resource(name="pushErpBigOrderOrderProvider")
    private ProxyMessageProducer pushErpBigOrderOrderProvider;

    @PostMapping(value={"dealCreateBigOrder"})
    public PebBigOrderRspBO dealCreateBigOrder(@RequestBody PebBigOrderReqBO reqBO) {
        PebBigOrderRspBO rspBO = this.pebBigOrderBusiService.dealCreateBigOrder(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            for (UocPebDealOrderBO orderBO : reqBO.getOrderInfo()) {
                this.uocPebOrdIdxSync(orderBO);
            }
            PebPushErpReqBO erpReqBO = new PebPushErpReqBO();
            erpReqBO.setBigOrderId(rspBO.getBigOrderId());
            this.pushErpBigOrderOrderProvider.send(new ProxyMessage(this.pushBigErpTopic, this.pushBigErpTag, JSON.toJSONString((Object)erpReqBO)));
        }
        return rspBO;
    }

    private void uocPebOrdIdxSync(UocPebDealOrderBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(rspBO.getSaleVoucherId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }
}

