/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncRspBO;
import com.tydic.uoc.common.ability.impl.PebExtOrdIdxSyncThreadsImpl;
import com.tydic.uoc.common.busi.api.EsMsgLogBusiService;
import com.tydic.uoc.common.busi.api.UocEsDeleteIndexBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncAbnormalListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncAfsListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncInspectionListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncOrderListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncShipListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncStatisticsBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncTransactionServiceListBusiService;
import com.tydic.uoc.common.busi.bo.EsMsgLogReqBO;
import com.tydic.uoc.common.busi.bo.PebExtOrdIdxSyncRspBO;
import com.tydic.uoc.common.busi.bo.UocEsDeleteIndexReqBO;
import com.tydic.uoc.common.busi.bo.UocEsDeleteIndexRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncAbnormalListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncAfsListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncInspectionListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncOrderListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncShipListRspBO;
import com.tydic.uoc.common.comb.api.PebExtOrdIdxSyncCombService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.config.UocThreadPoolExecutorUtil;
import com.tydic.uoc.dao.EsMsgLogMapper;
import com.tydic.uoc.dao.OrdAbnormalMapper;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.EsMsgLogPO;
import com.tydic.uoc.po.OrdAbnormalPO;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService"})
public class PebExtOrdIdxSyncAbilityServiceImpl
implements PebExtOrdIdxSyncAbilityService {
    private static final Logger logger = LoggerFactory.getLogger(PebExtOrdIdxSyncAbilityServiceImpl.class);
    private static final int PAGE_SIZE = 500;
    @Autowired
    private PebExtOrdIdxSyncCombService uocPebOrdIdxSyncCombService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private UocEsSyncOrderListBusiService esSyncOrderListBusiService;
    @Autowired
    private UocEsSyncAfsListBusiService esSyncAfsListBusiService;
    @Autowired
    private UocEsSyncAbnormalListBusiService esSyncAbnormalListBusiService;
    @Autowired
    private UocEsSyncInspectionListBusiService esSyncInspectionListBusiService;
    @Autowired
    private UocEsSyncShipListBusiService esSyncShipListBusiService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocEsSyncStatisticsBusiService esSyncStatisticsBusiService;
    @Autowired
    private UocEsDeleteIndexBusiService esDeleteIndexBusiService;
    @Autowired
    private UocEsSyncTransactionServiceListBusiService esSyncTransactionServiceListBusiService;
    @Autowired
    private EsMsgLogMapper esMsgLogMapper;
    @Autowired
    private EsMsgLogBusiService esMsgLogBusiService;
    private static final ThreadPoolExecutor threadPoolExecutor = UocThreadPoolExecutorUtil.poolExecutor;

    @PostMapping(value={"dealOrdIdxSync"})
    public UocPebOrdIdxSyncRspBO dealOrdIdxSync(@RequestBody UocPebOrdIdxSyncReqBO reqBO) {
        UocPebOrdIdxSyncRspBO rspBO = new UocPebOrdIdxSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (UocCoreConstant.OperationType.DELETE_ES_INDEX.equals(reqBO.getPurIdxFlag())) {
            logger.info("---------------\u624b\u52a8\u5220\u9664ES\u7d22\u5f15\u5f00\u59cb---------------{}", (Object)JSON.toJSONString((Object)reqBO));
            this.deleteEsIndex(reqBO);
            logger.info("---------------\u624b\u52a8\u5220\u9664ES\u7d22\u5f15\u7ed3\u675f---------------");
            return rspBO;
        }
        logger.info("---------------\u624b\u52a8ES\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u7d22\u5f15\u5f00\u59cb---------------{}", (Object)JSON.toJSONString((Object)reqBO));
        this.validateParam(reqBO);
        if (reqBO.getIsAll().booleanValue()) {
            if (null == reqBO.getThreadNum()) {
                reqBO.setThreadNum(Integer.valueOf(0));
            }
            if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
                this.batchDealOrder(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
                this.batchDealAfterService(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.ABNORMAL.equals(reqBO.getObjType())) {
                this.batchDealAbnormal(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
                this.batchDealInspection(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
                this.batchDealShip(reqBO, rspBO);
            }
        } else {
            PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
            combReqBO.setOrderId(reqBO.getOrderId());
            combReqBO.setObjId(reqBO.getObjId());
            combReqBO.setObjType(reqBO.getObjType());
            combReqBO.setIsAll(true);
            combReqBO.setCreateTimeEff("\u9632\u6b62\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f");
            if (reqBO.getIsMQ().booleanValue()) {
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
            } else {
                this.dealEsIdxSync(combReqBO);
            }
        }
        logger.info("---------------\u624b\u52a8ES\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u7d22\u5f15\u7ed3\u675f---------------");
        return rspBO;
    }

    @PostMapping(value={"dealFailSync"})
    public UocPebOrdIdxSyncRspBO dealFailSync(@RequestBody UocPebOrdIdxSyncReqBO reqBO) {
        EsMsgLogPO logPO = new EsMsgLogPO();
        logPO.setDealStatus(Integer.valueOf(3));
        List logPOS = this.esMsgLogMapper.selectByCondition(logPO);
        if (CollectionUtils.isNotEmpty((Collection)logPOS)) {
            for (EsMsgLogPO esMsgLogPO : logPOS) {
                PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                combReqBO.setOrderId(esMsgLogPO.getOrderId());
                combReqBO.setObjId(esMsgLogPO.getObjId());
                combReqBO.setObjType(esMsgLogPO.getObjType());
                combReqBO.setIsAll(false);
                combReqBO.setCreateTimeEff("\u9632\u6b62\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f");
                EsMsgLogReqBO msgLogReqBO = new EsMsgLogReqBO();
                msgLogReqBO.setId(esMsgLogPO.getId());
                msgLogReqBO.setDealCount(1);
                try {
                    this.dealEsIdxSync(combReqBO);
                    msgLogReqBO.setDealStatus(2);
                }
                catch (Exception e) {
                    msgLogReqBO.setDealStatus(3);
                }
                this.esMsgLogBusiService.dealUpdate(msgLogReqBO);
            }
        }
        UocPebOrdIdxSyncRspBO rspBO = new UocPebOrdIdxSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"dealOrdIdxSyncByCondition"})
    public UocPebOrdIdxSyncRspBO dealOrdIdxSyncByCondition(@RequestBody UocPebOrdIdxSyncReqBO reqBO) {
        UocPebOrdIdxSyncRspBO rspBO = new UocPebOrdIdxSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        logger.info("---------------\u5206\u9875\u624b\u52a8ES\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u7d22\u5f15\u5f00\u59cb---------------{}", (Object)JSON.toJSONString((Object)reqBO));
        if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            OrderPO orderPO = new OrderPO();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                orderPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                orderPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
            }
            if (Objects.nonNull(reqBO.getSaleSate())) {
                orderPO.setSaleState(reqBO.getSaleSate());
            }
            orderPO.setOrderType(reqBO.getOrderType());
            orderPO.setOrderIdList(reqBO.getOrderIds());
            orderPO.setOrderSource(reqBO.getOrderSource());
            orderPO.setOrderBy("t.CREATE_TIME DESC");
            int totalCount = this.orderMapper.queryCount(orderPO);
            if (totalCount == 0) {
                rspBO.setRemark("\u672a\u67e5\u8be2\u5230\u9700\u8981\u540c\u6b65\u7684\u6570\u636e!");
                return rspBO;
            }
            int pageCount = totalCount % 500 == 0 ? totalCount / 500 : totalCount / 500 + 1;
            for (int i = 1; i <= pageCount; ++i) {
                Page page = new Page();
                page.setPageNo(i);
                page.setPageSize(500);
                List syncList = this.orderMapper.getSyncListPage(orderPO, page);
                this.dealSaleData(syncList, reqBO);
            }
        } else if (UocCoreConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                ordShipPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                ordShipPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
            }
            ordShipPO.setOrderIdList(reqBO.getOrderIds());
            ordShipPO.setOrderBy("t.CREATE_TIME DESC");
            int totalCount = this.ordShipMapper.queryCount(ordShipPO);
            if (totalCount == 0) {
                rspBO.setRemark("\u672a\u67e5\u8be2\u5230\u9700\u8981\u540c\u6b65\u7684\u6570\u636e!");
                return rspBO;
            }
            int pageCount = totalCount % 500 == 0 ? totalCount / 500 : totalCount / 500 + 1;
            for (int i = 1; i <= pageCount; ++i) {
                Page page = new Page();
                page.setPageNo(i);
                page.setPageSize(500);
                List syncList = this.ordShipMapper.getSyncListPage(ordShipPO, page);
                this.dealShipData(syncList, reqBO);
            }
        } else {
            logger.error("\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u7c7b\u578b\u540c\u6b65");
            throw new UocProBusinessException("102032", "\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u7c7b\u578b\u540c\u6b65");
        }
        return rspBO;
    }

    private void dealShipData(List<OrdShipPO> syncList, UocPebOrdIdxSyncReqBO reqBO) {
        Runnable runnable = () -> {
            if (CollectionUtils.isEmpty((Collection)syncList)) {
                return;
            }
            logger.info("\u5f53\u524d\u7ebf\u7a0b\u540c\u6b65\u8ba2\u5355\u6570\u91cf\uff1a" + syncList.size());
            logger.info("{} \u7ebf\u7a0b\u5f00\u59cb\u540c\u6b65\u6570\u636e...", (Object)Thread.currentThread().getName());
            syncList.forEach(e -> {
                PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                combReqBO.setOrderId(e.getOrderId());
                combReqBO.setObjId(e.getShipVoucherId());
                combReqBO.setObjType(reqBO.getObjType());
                combReqBO.setIsAll(reqBO.getIsAll());
                combReqBO.setCreateTimeEff("\u9632\u6b62\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f");
                try {
                    this.dealEsIdxSync(combReqBO);
                }
                catch (Exception ex) {
                    logger.error("\u8ba2\u5355\u7f16\u53f7\uff1a{} \u540c\u6b65es\u5f02\u5e38\uff1a" + ex + CommUtils.dealStackTrace((Exception)ex), (Object)e.getOrderId());
                }
                logger.info("{} \u7ebf\u7a0b\u540c\u6b65\u8ba2\u5355{}\u7ed3\u675f\uff01", (Object)Thread.currentThread().getName(), (Object)e.getOrderId());
            });
            logger.info("{} \u7ebf\u7a0b\u7ed3\u675f\u540c\u6b65\u6570\u636e...", (Object)Thread.currentThread().getName());
        };
        threadPoolExecutor.submit(runnable);
    }

    private void dealSaleData(List<OrderPO> syncList, UocPebOrdIdxSyncReqBO reqBO) {
        Runnable runnable = () -> {
            if (CollectionUtils.isEmpty((Collection)syncList)) {
                return;
            }
            logger.info("\u5f53\u524d\u7ebf\u7a0b\u540c\u6b65\u8ba2\u5355\u6570\u91cf\uff1a" + syncList.size());
            logger.info("{} \u7ebf\u7a0b\u5f00\u59cb\u540c\u6b65\u6570\u636e...", (Object)Thread.currentThread().getName());
            syncList.forEach(e -> {
                PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                combReqBO.setOrderId(e.getOrderId());
                combReqBO.setObjId(e.getUpperOrderId());
                combReqBO.setObjType(reqBO.getObjType());
                combReqBO.setIsAll(reqBO.getIsAll());
                combReqBO.setCreateTimeEff("\u9632\u6b62\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f");
                try {
                    this.dealEsIdxSync(combReqBO);
                }
                catch (Exception ex) {
                    logger.error("\u8ba2\u5355\u7f16\u53f7\uff1a{} \u540c\u6b65es\u5f02\u5e38\uff1a" + ex + CommUtils.dealStackTrace((Exception)ex), (Object)e.getOrderId());
                }
                logger.info("{} \u7ebf\u7a0b\u540c\u6b65\u8ba2\u5355{}\u7ed3\u675f\uff01", (Object)Thread.currentThread().getName(), (Object)e.getOrderId());
            });
            logger.info("{} \u7ebf\u7a0b\u7ed3\u675f\u540c\u6b65\u6570\u636e...", (Object)Thread.currentThread().getName());
        };
        threadPoolExecutor.submit(runnable);
    }

    private void validateParam(UocPebOrdIdxSyncReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u7d22\u5f15\u540c\u6b65API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("100002", "\u7d22\u5f15\u540c\u6b65API\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealEsIdxSync(PebExtOrdIdxSyncReqBO combReqBO) {
        PebExtOrdIdxSyncRspBO combRspBO = this.uocPebOrdIdxSyncCombService.dealOrdIdxSync(combReqBO);
        if ("0000".equals(combRspBO.getRespCode())) {
            UocEsSyncShipListRspBO esSyncShipListRspBO;
            UocEsSyncInspectionListRspBO esSyncInspectionListRspBO;
            if (UocConstant.OBJ_TYPE.SALE.equals(combReqBO.getObjType())) {
                UocEsSyncOrderListRspBO esSyncOrderListRspBO = this.esSyncOrderListBusiService.esSyncOrderList(combRspBO.getUocEsSyncOrderListReqBO());
                if (!"0000".equals(esSyncOrderListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncOrderListRspBO.getRespCode(), esSyncOrderListRspBO.getRespDesc());
                }
            } else if (PecConstant.OBJ_TYPE.AFTER_SERVICE.equals(combReqBO.getObjType())) {
                UocEsSyncAfsListRspBO esSyncAfsListRspBO = this.esSyncAfsListBusiService.esSyncAfsList(combRspBO.getUocEsSyncAfsListReqBO());
                if (!"0000".equals(esSyncAfsListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncAfsListRspBO.getRespCode(), esSyncAfsListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.ABNORMAL.equals(combReqBO.getObjType())) {
                UocEsSyncAbnormalListRspBO esSyncAbnormalListRspBO = this.esSyncAbnormalListBusiService.esUocEsSyncAbnormalList(combRspBO.getUocEsSyncAbnormalListReqBO());
                if (!"0000".equals(esSyncAbnormalListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncAbnormalListRspBO.getRespCode(), esSyncAbnormalListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.INSPECTION.equals(combReqBO.getObjType())) {
                if (null != combRspBO.getUocEsSyncInspectionListReqBO() && !"0000".equals((esSyncInspectionListRspBO = this.esSyncInspectionListBusiService.esSyncInspection(combRspBO.getUocEsSyncInspectionListReqBO())).getRespCode())) {
                    throw new UocProBusinessException(esSyncInspectionListRspBO.getRespCode(), esSyncInspectionListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.SHIP.equals(combReqBO.getObjType()) && !"0000".equals((esSyncShipListRspBO = this.esSyncShipListBusiService.esSyncShipList(combRspBO.getUocEsSyncShipListReqBO())).getRespCode())) {
                throw new UocProBusinessException(esSyncShipListRspBO.getRespCode(), esSyncShipListRspBO.getRespDesc());
            }
            if (null != combRspBO.getSyncTransactionServiceFeeInfo() && !"0000".equals((esSyncInspectionListRspBO = this.esSyncTransactionServiceListBusiService.esSyncTransactionService(combRspBO.getSyncTransactionServiceFeeInfo())).getRespCode())) {
                throw new UocProBusinessException(esSyncInspectionListRspBO.getRespCode(), esSyncInspectionListRspBO.getRespDesc());
            }
        } else {
            throw new UocProBusinessException(combRspBO.getRespCode(), combRspBO.getRespDesc());
        }
    }

    private void batchDealOrder(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrderPO orderPO = new OrderPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            orderPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            orderPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        orderPO.setOrderType(reqBO.getOrderType());
        orderPO.setOrderIdList(reqBO.getOrderIds());
        orderPO.setOrderSource(reqBO.getOrderSource());
        orderPO.setOrderBy("t.CREATE_TIME DESC");
        if (Objects.nonNull(reqBO.getSaleSate())) {
            orderPO.setSaleState(reqBO.getSaleSate());
        }
        orderPO.setOrderTypes(reqBO.getOrderTypes());
        orderPO.setOrderSources(reqBO.getOrderSources());
        orderPO.setModelSettle(reqBO.getModelSettle());
        orderPO.setObjSates(reqBO.getObjSates());
        List listByCreateTime = this.orderMapper.getListByCreateTime(orderPO);
        boolean isSyncStatistics = false;
        if (StringUtils.isBlank((CharSequence)reqBO.getCreateTimeExp()) && StringUtils.isBlank((CharSequence)reqBO.getCreateTimeEff())) {
            isSyncStatistics = true;
        }
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrderPO po : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)((Object)combReqBO));
                    combReqBO.setOrderId(po.getOrderId());
                    combReqBO.setObjId(po.getUpperOrderId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), isSyncStatistics).booleanValue()) {
                        rspBO.setRespCode("100001");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrderPO po : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(po.getOrderId());
                    combReqBO.setObjId(po.getUpperOrderId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealAfterService(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            ordAfterServicePO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            ordAfterServicePO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        ordAfterServicePO.setOrderBy("t.CREATE_TIME DESC");
        ordAfterServicePO.setOrderIdList(reqBO.getOrderIds());
        List listByCreateTime = this.ordAfterServiceMapper.getListByCreateTime(ordAfterServicePO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdAfterServicePO afterServicePO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(afterServicePO.getOrderId());
                    combReqBO.setObjId(afterServicePO.getAfterServId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("100001");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdAfterServicePO afterServicePO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(afterServicePO.getOrderId());
                    combReqBO.setObjId(afterServicePO.getAfterServId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealAbnormal(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdAbnormalPO abnormalPO = new OrdAbnormalPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            abnormalPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            abnormalPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        abnormalPO.setOrderBy("CREATE_TIME DESC");
        abnormalPO.setOrderIdList(reqBO.getOrderIds());
        List ordAbnormalPOS = this.ordAbnormalMapper.getList(abnormalPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + ordAbnormalPOS.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)ordAbnormalPOS)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdAbnormalPO ordAbnormalPO : ordAbnormalPOS) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordAbnormalPO.getOrderId());
                    combReqBO.setObjId(ordAbnormalPO.getAbnormalVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ABNORMAL);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("100001");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdAbnormalPO ordAbnormalPO : ordAbnormalPOS) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordAbnormalPO.getOrderId());
                    combReqBO.setObjId(ordAbnormalPO.getAbnormalVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ABNORMAL);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealInspection(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdInspectionPO inspectionPO = new OrdInspectionPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            inspectionPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            inspectionPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        inspectionPO.setOrderBy("t.CREATE_TIME DESC");
        inspectionPO.setOrderIdList(reqBO.getOrderIds());
        inspectionPO.setInspectionState(reqBO.getInspectionState());
        inspectionPO.setOrderTypes(reqBO.getOrderTypes());
        inspectionPO.setOrderSources(reqBO.getOrderSources());
        inspectionPO.setModelSettle(reqBO.getModelSettle());
        inspectionPO.setObjSates(reqBO.getObjSates());
        List listByCreateTime = this.ordInspectionMapper.getListByCreateTime(inspectionPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdInspectionPO ordInspectionPO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordInspectionPO.getOrderId());
                    combReqBO.setObjId(ordInspectionPO.getInspectionVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("100001");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdInspectionPO ordInspectionPO : listByCreateTime) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordInspectionPO.getOrderId());
                    combReqBO.setObjId(ordInspectionPO.getInspectionVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealShip(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderBy("CREATE_TIME DESC");
        ordShipPO.setOrderIdList(reqBO.getOrderIds());
        List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + ordShipPOList.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<PebExtOrdIdxSyncReqBO> combReqBOList = new ArrayList<PebExtOrdIdxSyncReqBO>();
                for (OrdShipPO shipPO : ordShipPOList) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(shipPO.getOrderId());
                    combReqBO.setObjId(shipPO.getShipVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
                    combReqBOList.add(combReqBO);
                }
                try {
                    PebExtOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new PebExtOrdIdxSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum(), false).booleanValue()) {
                        rspBO.setRespCode("100001");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u5c11\u4fa0\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdShipPO shipPO : ordShipPOList) {
                    PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                    combReqBO.setOrderId(shipPO.getOrderId());
                    combReqBO.setObjId(shipPO.getShipVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void deleteEsIndex(UocPebOrdIdxSyncReqBO reqBO) {
        UocEsDeleteIndexRspBO deleteIndexRspBO;
        UocEsDeleteIndexReqBO deleteIndexReqBO = new UocEsDeleteIndexReqBO();
        if (UocCoreConstant.OperationType.DELETE_ES_INDEX.equals(reqBO.getSupIdxFlag())) {
            deleteIndexReqBO.setIsDeleteStatistics(true);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getThreadRemark())) {
            deleteIndexReqBO.setIndexName(reqBO.getThreadRemark());
        }
        if (null != reqBO.getObjType()) {
            deleteIndexReqBO.setObjTypeList(Collections.singletonList(reqBO.getObjType()));
        }
        if (!"0000".equals((deleteIndexRspBO = this.esDeleteIndexBusiService.deleteIndex(deleteIndexReqBO)).getRespCode())) {
            throw new UocProBusinessException(deleteIndexRspBO.getRespCode(), deleteIndexRspBO.getRespDesc());
        }
    }
}

