/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessCheckOrderTypeReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessCheckOrderTypeRspBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtOrderSettleTypeUpdateBusiService;
import com.tydic.uoc.common.busi.api.UocBusinessCheckOrderTypeBusiService;
import com.tydic.uoc.common.busi.bo.PebExtOrderSettleTypeUpdateBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtOrderSettleTypeUpdateBusiRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService"})
public class PebExtOrderSettleTypeUpdateAbilityServiceImpl
implements PebExtOrderSettleTypeUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtOrderSettleTypeUpdateAbilityServiceImpl.class);
    @Autowired
    private PebExtOrderSettleTypeUpdateBusiService pebExtOrderSettleTypeUpdateBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocBusinessCheckOrderTypeBusiService uocBusinessCheckOrderTypeBusiService;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @PostMapping(value={"dealOrderSettleType"})
    public PebExtOrderSettleTypeUpdateAbilityRspBO dealOrderSettleType(@RequestBody PebExtOrderSettleTypeUpdateAbilityReqBO reqBO) {
        String reqString = JSONObject.toJSONString((Object)reqBO);
        PebExtOrderSettleTypeUpdateBusiReqBO busiReqBO = (PebExtOrderSettleTypeUpdateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, PebExtOrderSettleTypeUpdateBusiReqBO.class));
        PebExtOrderSettleTypeUpdateBusiRspBO busiRspBO = this.pebExtOrderSettleTypeUpdateBusiService.dealOrderSettleType(busiReqBO);
        if (!CollectionUtils.isEmpty(busiRspBO.getOrderIdList())) {
            this.sendMq(busiRspBO.getOrderIdList());
        }
        if ("0000".equals(busiRspBO.getRespCode()) && !CollectionUtils.isEmpty(busiRspBO.getOrderIdList())) {
            try {
                this.dealBusinessWaitDone(reqBO, busiRspBO);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u4e1a\u52a1\u5f85\u529e\u5f02\u5e38");
            }
        }
        return (PebExtOrderSettleTypeUpdateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtOrderSettleTypeUpdateAbilityRspBO.class);
    }

    private void dealBusinessWaitDone(PebExtOrderSettleTypeUpdateAbilityReqBO reqBo, PebExtOrderSettleTypeUpdateBusiRspBO busiRspBO) {
        List<Long> orderIds = busiRspBO.getOrderIdList();
        for (Long objId : orderIds) {
            UocBusinessCheckOrderTypeReqBo checkReqBo = new UocBusinessCheckOrderTypeReqBo();
            checkReqBo.setOrderId(objId);
            UocBusinessCheckOrderTypeRspBo checkResult = this.uocBusinessCheckOrderTypeBusiService.checkOrderTypeService(checkReqBo);
            if (!"0000".equals(checkResult.getRespCode()) || !checkResult.getFlag().booleanValue()) continue;
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(objId);
            OrderPO orderInfo = this.orderMapper.getModelBy(orderPO);
            if (!PecConstant.PAY_STAT_SUCCESS.equals(orderInfo.getPayState())) {
                return;
            }
            UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
            TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
            todoBusinessWaitDoneAddBo.setBusiCode("3081");
            todoBusinessWaitDoneAddBo.setCenterCode("order");
            todoBusinessWaitDoneAddBo.setSystemCode("1");
            todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
            todoBusinessWaitDoneAddBo.setObjId(String.valueOf(objId));
            todoBusinessWaitDoneAddBo.setSubmitUserNo("\u7ed3\u7b97\u56de\u8c03");
            todoBusinessWaitDoneAddBo.setSubmitUserName("jiesuanhuidiao");
            todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if ("0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) continue;
            log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
        }
    }

    private void sendMq(List<Long> orderIdList) {
        OrdSalePO salePo = new OrdSalePO();
        salePo.setOrderIdList(orderIdList);
        List list = this.ordSaleMapper.getList(salePo);
        for (OrdSalePO salePO : list) {
            UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdSaleIdxSyncReqBO.setObjId(salePO.getSaleVoucherId());
            uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            uocOrdSaleIdxSyncReqBO.setOrderId(salePO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
        }
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setOrderIdList(orderIdList);
        List inspectionList = this.ordInspectionMapper.getList(ordInspectionPO);
        for (OrdInspectionPO inspectionPO : inspectionList) {
            UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdSaleIdxSyncReqBO.setObjId(inspectionPO.getInspectionVoucherId());
            uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
            uocOrdSaleIdxSyncReqBO.setOrderId(inspectionPO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
        }
    }
}

