/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.common.ability.api.PebExtWarehouseOrderCancelAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderCancelAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderCancelBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderCancelItemBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtWarehouseOrderCancelBusiService;
import com.tydic.uoc.common.busi.bo.PebExtWarehouseOrderCancelBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtWarehouseOrderCancelBusiRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtWarehouseOrderCancelAbilityService"})
public class PebExtWarehouseOrderCancelAbilityServiceImpl
implements PebExtWarehouseOrderCancelAbilityService {
    @Autowired
    private PebExtWarehouseOrderCancelBusiService pebExtWarehouseOrderCancelBusiService;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealWarehouseOrderCancel"})
    public PebExtWarehouseOrderCancelAbilityRspBO dealWarehouseOrderCancel(@RequestBody PebExtWarehouseOrderCancelAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (!salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.CANCEL) && !salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.ORDER_DELETE)) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u53d6\u6d88\u6216\u5220\u9664\u72b6\u6001\uff01");
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
        warehousePO.setOrderId(reqBO.getOrderId());
        warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
        if (warehousePO == null) {
            return new PebExtWarehouseOrderCancelAbilityRspBO();
        }
        if (warehousePO.getOrderCancelStatus() != null && warehousePO.getOrderCancelStatus().equals(UocCoreConstant.PUSH_STATUS.SUCCESS)) {
            throw new UocProBusinessException("8888", "\u5df2\u63a8\u9001\u6210\u529f\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        String warehouseId = this.getEcomWarehouseCode(warehousePO.getSupplierId());
        PebExtWarehouseOrderCancelBO orderCancelBO = new PebExtWarehouseOrderCancelBO();
        orderCancelBO.setThirdOrder(salePO.getOrderId());
        orderCancelBO.setWarehouseId(warehouseId);
        ArrayList<PebExtWarehouseOrderCancelItemBO> skuInfos = new ArrayList<PebExtWarehouseOrderCancelItemBO>();
        if (orderPO.getUpperOrderId() != null) {
            orderCancelBO.setThirdOrder(orderPO.getUpperOrderId());
            Map<Object, Object> itemMap = new HashMap();
            OrdItemPO item = new OrdItemPO();
            item.setOrderId(orderPO.getUpperOrderId());
            List itemList = this.ordItemMapper.getList(item);
            itemMap = itemList.stream().collect(Collectors.toMap(OrdItemPO::getSkuId, OrdItemPO::getOrdItemId));
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(salePO.getOrderId());
            List list = this.ordItemMapper.getList(itemPO);
            for (OrdItemPO ordItemPO : list) {
                PebExtWarehouseOrderCancelItemBO cancelItemBO = new PebExtWarehouseOrderCancelItemBO();
                cancelItemBO.setCancelNum(Integer.valueOf(ordItemPO.getPurchaseCount().intValue()));
                cancelItemBO.setItemId((Long)itemMap.get(ordItemPO.getSkuId()));
                skuInfos.add(cancelItemBO);
            }
            orderCancelBO.setSkuInfos(skuInfos);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderCancelBO));
        String signStr = "warehouseId" + jsonObject.getString("warehouseId") + "thirdOrder" + jsonObject.getString("thirdOrder") + "skuInfos" + jsonObject.getString("skuInfos");
        String sign = MD5Util.MD5Encode((String)(signStr + this.warehouseSignKey), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + this.warehouseSignKey), (String)"");
        orderCancelBO.setSign(sign);
        PebExtWarehouseOrderCancelBusiReqBO busiReqBO = new PebExtWarehouseOrderCancelBusiReqBO();
        busiReqBO.setOrderId(salePO.getOrderId());
        busiReqBO.setOrderCancelBO(orderCancelBO);
        busiReqBO.setSupplierId(warehousePO.getSupplierId());
        PebExtWarehouseOrderCancelBusiRspBO busiRspBO = this.pebExtWarehouseOrderCancelBusiService.dealWarehouseOrderCancel(busiReqBO);
        return (PebExtWarehouseOrderCancelAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtWarehouseOrderCancelAbilityRspBO.class);
    }

    private String getEcomWarehouseCode(Long supplierId) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(supplierId + "");
        dictReqBO.setPcode("UOC_ECOM_WAREHOUSE_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (!"0000".equals(dictRspBO.getRespCode()) || dictRspBO.getDicDictionarys() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178");
        }
        return dictRspBO.getDicDictionarys().getDescrip();
    }
}

