/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.base.utils.BeanUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderBatchPrintPurchaseAbilityService;
import com.tydic.uoc.common.ability.api.PebOrderPrintPurchaseAbilityService;
import com.tydic.uoc.common.ability.bo.OrderBatchPrintPurchaseBo;
import com.tydic.uoc.common.ability.bo.OrderBatchPrintPurchaseRepBO;
import com.tydic.uoc.common.ability.bo.OrderPrintPurchaseRepBO;
import com.tydic.uoc.common.ability.bo.OrderPrintPurchaseRspBO;
import com.tydic.uoc.common.ability.bo.PebOrderBatchPrintPurchaseBo;
import com.tydic.uoc.common.ability.bo.PebOrderBatchPrintPurchaseRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderBatchPrintPurchaseAbilityService"})
public class PebOrderBatchPrintPurchaseAbilityServiceImpl
implements PebOrderBatchPrintPurchaseAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderBatchPrintPurchaseAbilityServiceImpl.class);
    @Autowired
    private PebOrderPrintPurchaseAbilityService pebOrderPrintPurchaseAbilityService;
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @PostMapping(value={"batchExtOrder"})
    public PebOrderBatchPrintPurchaseRspBO batchExtOrder(final @RequestBody OrderBatchPrintPurchaseRepBO repBO) {
        Object pebOrderBatchPrintPurchaseBo;
        if (CollectionUtils.isEmpty((Collection)repBO.getOrderIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[\u8ba2\u5355id\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("\u6279\u91cf\u5bfc\u51fa\u8ba2\u5355-thread-call-runner-%d").build();
        int cpu = Runtime.getRuntime().availableProcessors();
        if (cpu < 4) {
            cpu = 4;
        }
        ThreadPoolExecutor threadService = new ThreadPoolExecutor(cpu, 2 * cpu, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(110), namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
        ArrayList<Object> futures = new ArrayList<Object>();
        for (final Long orderId : repBO.getOrderIds()) {
            Future<HashMap<String, Object>> future = threadService.submit(new Callable<HashMap<String, Object>>(){

                @Override
                public HashMap<String, Object> call() {
                    HashMap<String, Object> map = new HashMap<String, Object>(1);
                    OrdSalePO ordSalePO = null;
                    try {
                        OrdSalePO qryOrdSalePO = new OrdSalePO();
                        qryOrdSalePO.setOrderId(orderId);
                        ordSalePO = PebOrderBatchPrintPurchaseAbilityServiceImpl.this.ordSaleMapper.getModelBy(qryOrdSalePO);
                        if (ordSalePO == null) {
                            throw new UocProBusinessException("100200", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u67e5\u8be2\u3010OrdSalePO\u3011\u4e3a\u7a7a\u6216\u67e5\u8be2\u5931\u8d25");
                        }
                        OrderPrintPurchaseRepBO orderPrintPurchaseRepBO = (OrderPrintPurchaseRepBO)JSON.parseObject((String)JSON.toJSONString((Object)repBO), OrderPrintPurchaseRepBO.class);
                        orderPrintPurchaseRepBO.setOrderId(orderId);
                        orderPrintPurchaseRepBO.setIsBatch(Boolean.valueOf(true));
                        OrderBatchPrintPurchaseBo orderBatchPrintPurchaseBo = new OrderBatchPrintPurchaseBo();
                        orderPrintPurchaseRepBO.setOrderBatchPrintPurchaseBo((OrderBatchPrintPurchaseBo)BeanUtils.copyProperties((Object)ordSalePO, (Object)orderBatchPrintPurchaseBo));
                        OrderPrintPurchaseRspBO orderPrintPurchaseRspBO = PebOrderBatchPrintPurchaseAbilityServiceImpl.this.pebOrderPrintPurchaseAbilityService.ExtOrder(orderPrintPurchaseRepBO);
                        if (!"0000".equals(orderPrintPurchaseRspBO.getRespCode())) {
                            throw new UocProBusinessException("8888", orderPrintPurchaseRspBO.getRespDesc());
                        }
                        if (orderPrintPurchaseRspBO.getBuf().length == 0 || StringUtils.isBlank((CharSequence)orderPrintPurchaseRspBO.getSaleVoucherNo())) {
                            throw new UocProBusinessException("8888", "\u751f\u6210\u7684\u6587\u4ef6\u4e3a\u7a7a\u6216\u8005\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
                        }
                        map.put("code", "0");
                        map.put("orderPrintPurchaseRspBO", orderPrintPurchaseRspBO);
                        return map;
                    }
                    catch (Exception e) {
                        log.error("\u751f\u6210\u6587\u6863\u5931\u8d25:{}", (Object)e.getMessage());
                        map.put("code", "1");
                        map.put("message", e.getMessage());
                        map.put("orderId", orderId.toString());
                        if (ordSalePO != null) {
                            map.put("orderNo", ordSalePO.getSaleVoucherNo());
                        }
                        return map;
                    }
                }
            });
            futures.add(future);
        }
        ArrayList<OrderPrintPurchaseRspBO> orderPrintPurchaseRspBos = new ArrayList<OrderPrintPurchaseRspBO>();
        ArrayList<Object> orderBatchPrintPurchaseBoList = new ArrayList<Object>();
        try {
            for (Future future : futures) {
                HashMap map = (HashMap)future.get();
                log.debug("map:{}", (Object)JSON.toJSONString((Object)map));
                if (map.get("code") != null && "1".equals((String)map.get("code"))) {
                    pebOrderBatchPrintPurchaseBo = new PebOrderBatchPrintPurchaseBo();
                    if (map.get("orderId") != null) {
                        pebOrderBatchPrintPurchaseBo.setOrderId((String)map.get("orderId"));
                    }
                    if (map.get("orderNo") != null) {
                        pebOrderBatchPrintPurchaseBo.setSaleVoucherNo((String)map.get("orderNo"));
                    }
                    if (map.get("message") != null) {
                        pebOrderBatchPrintPurchaseBo.setMessage((String)map.get("message"));
                    }
                    log.error("8888", (Object)("\u8ba2\u5355id" + map.get("orderId") + "," + map.get("message")));
                    orderBatchPrintPurchaseBoList.add(pebOrderBatchPrintPurchaseBo);
                    continue;
                }
                if (map.get("orderPrintPurchaseRspBO") == null) continue;
                orderPrintPurchaseRspBos.add((OrderPrintPurchaseRspBO)map.get("orderPrintPurchaseRspBO"));
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", e.getMessage());
        }
        log.debug("orderPrintPurchaseRspBos:{}", (Object)JSON.toJSONString(orderPrintPurchaseRspBos));
        PebOrderBatchPrintPurchaseRspBO rspBO = new PebOrderBatchPrintPurchaseRspBO();
        if (!CollectionUtils.isEmpty(orderPrintPurchaseRspBos)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)byteArrayOutputStream);
                pebOrderBatchPrintPurchaseBo = null;
                try {
                    int i = 1;
                    for (OrderPrintPurchaseRspBO each : orderPrintPurchaseRspBos) {
                        if (StringUtils.isBlank((CharSequence)each.getPdfFileName())) {
                            each.setPdfFileName("\u8ba2\u5355\u5bfc\u51fa");
                        }
                        String fileName = i + "-" + each.getSaleVoucherNo() + each.getPdfFileName();
                        ++i;
                        if ("1".equals(repBO.getExtWord())) {
                            fileName = fileName + ".docx";
                        }
                        ZipEntry zipEntry = new ZipEntry(fileName);
                        zipOut.putNextEntry(zipEntry);
                        zipOut.write(each.getBuf());
                        zipOut.closeEntry();
                    }
                }
                catch (Throwable i) {
                    pebOrderBatchPrintPurchaseBo = i;
                    throw i;
                }
                finally {
                    if (zipOut != null) {
                        if (pebOrderBatchPrintPurchaseBo != null) {
                            try {
                                zipOut.close();
                            }
                            catch (Throwable i) {
                                ((Throwable)pebOrderBatchPrintPurchaseBo).addSuppressed(i);
                            }
                        } else {
                            zipOut.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new UocProBusinessException("8888", e.getMessage());
            }
            String fileUrl = "";
            byte[] zipBytes = byteArrayOutputStream.toByteArray();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            fileUrl = this.fileUpLoad.upload("\u8ba2\u5355\u5bfc\u51fa", zipBytes, ".zip");
            threadService.shutdown();
            rspBO.setOrderPdfUrl(fileUrl);
            rspBO.setOrderBatchPrintPurchaseBoList(orderBatchPrintPurchaseBoList);
            rspBO.setPdfFileName("\u8ba2\u5355\u5bfc\u51fa");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return rspBO;
    }

    private static void downloadFile(OrderPrintPurchaseRspBO orderPrintPurchaseRspBO, Path downloadDir, OrderBatchPrintPurchaseRepBO repBO) throws IOException {
        if (StringUtils.isBlank((CharSequence)orderPrintPurchaseRspBO.getPdfFileName())) {
            orderPrintPurchaseRspBO.setPdfFileName("\u8ba2\u5355\u5bfc\u51fa");
        }
        String fileName = orderPrintPurchaseRspBO.getSaleVoucherNo() + "-" + orderPrintPurchaseRspBO.getPdfFileName();
        if ("1".equals(repBO.getExtWord())) {
            fileName = fileName + ".docx";
        }
        Path filePath = downloadDir.resolve(fileName);
        BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));
        outputStream.write(orderPrintPurchaseRspBO.getBuf());
    }

    private static void addToZipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            int length;
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
        }
        zipOut.closeEntry();
        zipOut.flush();
    }
}

