/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.common.ability.api.PebOrderDeliveryAbilityService;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneDealReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.atom.api.PebSyncESGAtomService;
import com.tydic.uoc.common.atom.api.PebSyncHtArriveAtomService;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomReqBO;
import com.tydic.uoc.common.comb.api.PebOrderDeliveryCombService;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderDeliveryAbilityService"})
public class PebOrderDeliveryAbilityServiceImpl
implements PebOrderDeliveryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderDeliveryAbilityServiceImpl.class);
    public static final Integer INT_1 = 1;
    public static final Integer INT_2 = 2;
    @Autowired
    private PebOrderDeliveryCombService pebOrderDeliveryCombService;
    @Autowired
    private PebSyncESGAtomService pebSyncESGAtomService;
    @Autowired
    private PebSyncHtArriveAtomService pebSyncHtArriveAtomService;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;
    private static final List<Integer> ALLOWED_CONTRACT_TYPES = Arrays.asList(11, 12, 13, 20, 21);

    @PostMapping(value={"dealPebOrderDelivery"})
    public PebOrderDeliveryAbilityRspBO dealPebOrderDelivery(@RequestBody PebOrderDeliveryAbilityReqBO pebOrderDeliveryAbilityReqBO) {
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = this.pebOrderDeliveryCombService.dealPebOrderDelivery(pebOrderDeliveryAbilityReqBO);
        log.error("\u8ba2\u5355\u53d1\u8d27\u5165\u53c2{},\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)pebOrderDeliveryAbilityReqBO), (Object)JSON.toJSONString((Object)pebOrderDeliveryAbilityRspBO));
        if ("0000".equals(pebOrderDeliveryAbilityRspBO.getRespCode())) {
            try {
                this.addBacklog(pebOrderDeliveryAbilityReqBO, pebOrderDeliveryAbilityRspBO);
                this.dealBusinessWaitDone(pebOrderDeliveryAbilityReqBO, pebOrderDeliveryAbilityRspBO);
            }
            catch (Exception e) {
                log.error("\u5f85\u5230\u8d27\u767b\u8bb0\u5f85\u529e\u63a8\u9001", (Throwable)e);
            }
        }
        return pebOrderDeliveryAbilityRspBO;
    }

    private void dealBusinessWaitDone(PebOrderDeliveryAbilityReqBO reqBO, PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO) {
        Boolean flag = this.checkIsEmployeeSupermarket(reqBO.getOrderId());
        if (!flag.booleanValue()) {
            return;
        }
        Long shipVoucherId = pebOrderDeliveryAbilityRspBO.getShipVoucherId();
        UocBusinessPendingTodoAbilityAtomReqBO deal3085 = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo addBo3085 = new TodoBusinessWaitDoneAddReqBo();
        addBo3085.setBusiCode("3085");
        addBo3085.setCenterCode("order");
        addBo3085.setSystemCode("1");
        addBo3085.setSubmitTime(new Date());
        addBo3085.setObjId(String.valueOf(shipVoucherId));
        addBo3085.setSubmitUserName(reqBO.getUsername());
        addBo3085.setSubmitUserNo(String.valueOf(reqBO.getOccupation()));
        deal3085.setTodoBusinessWaitDoneAddReqBo(addBo3085);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(deal3085);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)addBo3085.getBusiCode(), (Object)JSON.toJSONString((Object)deal3085));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
        UocBusinessPendingTodoAbilityAtomReqBO deal3082 = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo AddBo3082 = new TodoBusinessWaitDoneDealReqBo();
        AddBo3082.setBusiCode("3082");
        AddBo3082.setCenterCode("order");
        AddBo3082.setSystemCode("1");
        AddBo3082.setDealTime(new Date());
        AddBo3082.setObjId(String.valueOf(reqBO.getOrderId()));
        AddBo3082.setDealUserNo(reqBO.getUsername());
        AddBo3082.setDealUserName(reqBO.getName());
        deal3082.setTodoBusinessWaitDoneDealReqBo(AddBo3082);
        UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(deal3082);
        if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
            log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)AddBo3082.getBusiCode(), (Object)JSON.toJSONString((Object)deal3082));
        }
    }

    @PostMapping(value={"dealUpdateDelivery"})
    public PebOrderDeliveryAbilityRspBO dealUpdateDelivery(@RequestBody PebOrderDeliveryAbilityReqBO reqBO) {
        return this.pebOrderDeliveryCombService.dealUpdateDelivery(reqBO);
    }

    @PostMapping(value={"dealPurDelivery"})
    public PebOrderDeliveryAbilityRspBO dealPurDelivery(@RequestBody PebOrderDeliveryAbilityReqBO reqBO) {
        PebOrderDeliveryAbilityRspBO rspBO = this.pebOrderDeliveryCombService.dealPurDelivery(reqBO);
        if (PebExtConstant.NO.equals(reqBO.getConfirm())) {
            this.pebSyncESGAtomService.syncESG(reqBO.getOrderId(), true);
            this.cancelSiKu(reqBO.getOrderId());
        } else {
            this.syncHt(reqBO, rspBO);
        }
        if ("0000".equals(rspBO.getRespCode())) {
            this.businessBacklog(reqBO);
        }
        return rspBO;
    }

    private void businessBacklog(PebOrderDeliveryAbilityReqBO reqBO) {
        UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo dealReqBo = new TodoBusinessWaitDoneDealReqBo();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        String orderSource = ordSalePO.getOrderSource();
        Integer modelSettle = ordSalePO.getModelSettle();
        if ("1".equals(orderSource) && INT_1.equals(modelSettle)) {
            dealReqBo.setBusiCode("3061");
        } else if (("1".equals(orderSource) || "3".equals(orderSource)) && INT_2.equals(modelSettle)) {
            dealReqBo.setBusiCode("3062");
        } else if ("4".equals(orderSource)) {
            dealReqBo.setBusiCode("3063");
        }
        dealReqBo.setObjId(String.valueOf(reqBO.getSaleVoucherId()));
        dealReqBo.setDealUserNo(String.valueOf(reqBO.getUserId()));
        dealReqBo.setDealUserName(reqBO.getName());
        uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25{}", (Object)dealReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)uocBusinessPendingTodoAbilityAtomReqBO));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25", (Throwable)e);
        }
    }

    private void syncHt(PebOrderDeliveryAbilityReqBO reqBO, PebOrderDeliveryAbilityRspBO rspBO) {
        try {
            PebSyncHtArriveAtomReqBO atomReqBO = new PebSyncHtArriveAtomReqBO();
            atomReqBO.setConfirmIdList(rspBO.getConfirmIdList());
            this.pebSyncHtArriveAtomService.syncHtArrive(atomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25", (Object)e.getMessage());
        }
    }

    private void addBacklog(PebOrderDeliveryAbilityReqBO reqBO, PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO) {
        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
        todoBusinessWaitDoneAddBo.setSubmitUserNo(reqBO.getOccupation());
        todoBusinessWaitDoneAddBo.setSubmitUserName(reqBO.getName());
        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(pebOrderDeliveryAbilityRspBO.getShipVoucherId()));
        todoBusinessWaitDoneAddBo.setHandleOrgNo(reqBO.getOrgCodeIn());
        todoBusinessWaitDoneAddBo.setHandleOrgName(reqBO.getOrgName());
        todoBusinessWaitDoneAddBo.setHandleUserNo(reqBO.getOccupation());
        todoBusinessWaitDoneAddBo.setHandleUserName(reqBO.getName());
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (Objects.nonNull(salePO)) {
            if (PecConstant.ORDER_SOURCE.INQUIRY_PRICE_A_SINGLE_PURCHASE.toString().equals(salePO.getOrderSource())) {
                todoBusinessWaitDoneAddBo.setBusiCode("3075");
            } else if (PecConstant.ORDER_SOURCE.INQUIRY_PRICE_FRAMEWORK_AGREEMENT.toString().equals(salePO.getOrderSource())) {
                todoBusinessWaitDoneAddBo.setBusiCode("3076");
            } else {
                return;
            }
        }
        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    private Boolean checkIsEmployeeSupermarket(Long orderId) {
        List generateMethods = this.ordExtMapMapper.getFieldValue(orderId);
        log.error("\u67e5\u8be2\u5e95\u88681\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)generateMethods));
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        OrderPO orderInfo = this.orderMapper.getModelBy(orderPO);
        log.error("\u67e5\u8be2\u5e95\u88682\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)orderInfo));
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        OrdSalePO ordSaleInfo = this.ordSaleMapper.getModelBy(ordSalePO);
        log.error("\u67e5\u8be2\u5e95\u88683\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)ordSaleInfo));
        Integer orderType = orderInfo.getOrderType();
        String orderSource = ordSaleInfo.getOrderSource();
        if (!(generateMethods.contains("1") || 4 != orderType && 5 != orderType || !"1".equals(orderSource) && !"2".equals(orderSource))) {
            return true;
        }
        return false;
    }

    private void cancelSiKu(Long orderId) {
        OrdAgreementPO agreementPO = this.ordAgreementMapper.queryById(orderId);
        if (Objects.nonNull(agreementPO) && Objects.nonNull(agreementPO.getContactType()) && ALLOWED_CONTRACT_TYPES.contains(Integer.valueOf(agreementPO.getContactType()))) {
            PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
            siKuOrderAbilityReqBO.setOrderType("UPDATE");
            siKuOrderAbilityReqBO.setOrderId(orderId);
            this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
        }
    }
}

