/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebUocUnifyContractQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebUocUnifyContractQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdContractBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocOrdContractPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebUocUnifyContractQryAbilityService"})
public class PebUocUnifyContractQryAbilityServiceImpl
implements PebUocUnifyContractQryAbilityService {
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;

    @PostMapping(value={"qryOrderContractInfo"})
    public PebUocUnifyContractQryAbilityRspBO qryOrderContractInfo(@RequestBody PebUocUnifyContractQryAbilityReqBO reqBO) {
        List orderAmtList;
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2orderIdList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderIdList(reqBO.getOrderIdList());
        List contractPOS = this.uocOrdContractMapper.getContractList(uocOrdContractPO);
        if (CollectionUtils.isEmpty((Collection)contractPOS)) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<Long> orderIdList = new ArrayList<Long>(contractPOS.size());
        ArrayList<Long> agreementIds = new ArrayList<Long>(contractPOS.size());
        HashMap<Long, Object> contractMap = new HashMap<Long, Object>(contractPOS.size());
        for (UocOrdContractPO contractPO : contractPOS) {
            if (contractPO.getPushStatus().equals(UocCoreConstant.PUSH_STATUS.FAIL)) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u53f7\uff1a[" + contractPO.getSaleVoucherNo() + "]\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u5931\u8d25\uff01");
            }
            orderIdList.add(contractPO.getOrderId());
            if (contractPO.getContractId() != null) {
                agreementIds.add(contractPO.getContractId());
            }
            UocOrdContractBO contractBO = new UocOrdContractBO();
            BeanUtils.copyProperties((Object)contractPO, (Object)contractBO);
            if (StringUtils.isEmpty((Object)contractBO.getContractNo())) {
                contractBO.setContractNo(contractPO.getVrContractNo());
            }
            contractMap.put(contractPO.getOrderId(), contractBO);
        }
        HashMap<Long, BigDecimal> itemMap = new HashMap<Long, BigDecimal>();
        if (!StringUtils.isEmpty((Object)((UocOrdContractPO)contractPOS.get(0)).getContractId())) {
            orderAmtList = this.ordItemMapper.getSumOrderAmtByAgreementIds(agreementIds, reqBO.getBuynerNo());
            for (OrdItemPO itemPO : orderAmtList) {
                itemMap.put(Long.valueOf(itemPO.getAgreementId()), itemPO.getTotalSaleAmount());
            }
        } else {
            orderAmtList = this.ordItemMapper.getSumOrderAmtList(orderIdList);
            for (OrdItemPO itemPO : orderAmtList) {
                itemMap.put(itemPO.getOrderId(), itemPO.getTotalSaleAmount());
            }
        }
        OrdCruxMapPO ordCruxMapPO = new OrdCruxMapPO();
        ordCruxMapPO.setOrderIds(orderIdList);
        ordCruxMapPO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        List cruxMapPOS = this.ordCruxMapMapper.getList(ordCruxMapPO);
        HashMap<Long, String> cruxMap = new HashMap<Long, String>(cruxMapPOS.size());
        for (OrdCruxMapPO cruxMapPO : cruxMapPOS) {
            cruxMap.put(cruxMapPO.getOrderId(), cruxMapPO.getFieldValue22());
        }
        for (Long orderId : contractMap.keySet()) {
            UocOrdContractBO contractBO = (UocOrdContractBO)contractMap.get(orderId);
            if (contractBO.getContractId() != null) {
                contractBO.setContractAmt((BigDecimal)itemMap.get(contractBO.getContractId()));
            } else {
                contractBO.setContractAmt((BigDecimal)itemMap.get(contractBO.getOrderId()));
            }
            contractBO.setErpOrderId((String)cruxMap.get(orderId));
        }
        PebUocUnifyContractQryAbilityRspBO rspBO = new PebUocUnifyContractQryAbilityRspBO();
        rspBO.setVendorSiteName(((UocOrdContractPO)contractPOS.get(0)).getVendorSiteName());
        rspBO.setContractMap(contractMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

