/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocApproveEntrustConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.api.UocGeneralCirculationAbilityService;
import com.tydic.uoc.common.ability.bo.OrderSmsReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushRealContractNoAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.UocApproveEntrustNotificationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocGeneralCirculationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocOrdItemUpdateBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.atom.api.UocOrderSubmitTimeAtomService;
import com.tydic.uoc.common.atom.bo.QrySaleReqBO;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.PebUpdateOrderBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.config.aop.DuplicateCommitLimit;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService"})
public class PebUpdateOrderAbilityServiceImpl
implements PebUpdateOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebUpdateOrderAbilityServiceImpl.class);
    @Autowired
    private PebUpdateOrderBusiService pebUpdateOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="dealPushRealContractNoProvider")
    private ProxyMessageProducer pushRealContractNoProvider;
    @Value(value="${DEAL_PUSH_REAL_CONTRACT_NO_TOPIC:DEAL_PUSH_REAL_CONTRACT_NO_TOPIC}")
    private String pushRealContractNoTopic;
    @Value(value="${DEAL_PUSH_REAL_CONTRACT_NO_TAG:DEAL_PUSH_REAL_CONTRACT_NO_TAG}")
    private String pushRealContractNoTag;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TOPIC:DEAL_PUSH_WMS_ORDER_TOPIC}")
    private String pushWmsOrderTopic;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TAG:DEAL_PUSH_WMS_ORDER_TAG}")
    private String pushWmsOrderTag;
    @Resource(name="dealPushWmsOrderProvider")
    private ProxyMessageProducer dealPushWmsOrderProvider;
    @Autowired
    private UocGeneralCirculationAbilityService uocGeneralCirculationAbilityService;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource(name="mqUocApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqUocApproveEntrustNotificationProvider;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC:UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String uocApproveEntrustNotificationTopic;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String uocApproveEntrustNotificationTag;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;
    @Autowired
    private UocOrderSubmitTimeAtomService uocOrderSubmitTimeAtomService;
    @Resource(name="uocOrderSmsMsgProvider")
    private ProxyMessageProducer uocOrderSmsMsgProvider;
    @Value(value="${UOC_ORDER_SMS_TOPIC:UOC_SMS_TOPIC}")
    private String orderSmsTopic;
    @Value(value="${UOC_ORDER_SMS_TAG:*}")
    private String orderSmsTag;

    @PostMapping(value={"updateOrderCycle"})
    public PebUpdateOrderRspBO updateOrderCycle(@RequestBody PebUpdateOrderReqBO reqBO) {
        return this.pebUpdateOrderBusiService.updateOrderCycle(reqBO);
    }

    @DuplicateCommitLimit
    @PostMapping(value={"updateOrder"})
    public PebUpdateOrderRspBO updateOrder(@RequestBody PebUpdateOrderReqBO reqBO) {
        reqBO.setLoginName(reqBO.getUsername());
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrder(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            QrySaleReqBO saleReqBO = new QrySaleReqBO();
            saleReqBO.setOrderId(reqBO.getOrderId());
            this.uocOrderSubmitTimeAtomService.dealSubmitOrder(saleReqBO);
            this.sync(reqBO);
            if (rspBO.getPushWmsId() != null) {
                PebExtPushWmsOrderReqBO wmsOrderReqBO = new PebExtPushWmsOrderReqBO();
                wmsOrderReqBO.setOrderId(rspBO.getPushWmsId());
                this.dealPushWmsOrderProvider.send(new ProxyMessage(this.pushWmsOrderTopic, this.pushWmsOrderTag, JSONObject.toJSONString((Object)wmsOrderReqBO)));
            }
            if (rspBO.getOrderId() != null) {
                this.pushTodoWait(rspBO.getOrderId());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
            UocApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(rspBO.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.SALE);
                approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.SALE);
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        return rspBO;
    }

    private void pushTodoWait(Long orderId) {
        try {
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(ordSalePO.getOrderId());
            uocTodoBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.COMMIT_APPROVE.getCode());
            uocTodoBO.setOperatorId(stakeholderPO.getPurPlaceOrderId());
            uocTodoBO.setOperatorNo(stakeholderPO.getPurLogName());
            uocTodoBO.setOperatorName(stakeholderPO.getPurPlaceOrderName());
            uocTodoBO.setOrgId(Long.valueOf(stakeholderPO.getPurOrgId()));
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }

    @PostMapping(value={"updateOrderArrivalTime"})
    public PebUpdateOrderRspBO updateOrderArrivalTime(@RequestBody PebUpdateOrderReqBO reqBO) {
        this.validateParam(reqBO);
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrderArrivalTime(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateMergeOrderArrivalTime"})
    public PebUpdateOrderRspBO updateMergeOrderArrivalTime(@RequestBody PebUpdateOrderReqBO reqBO) {
        this.validateMergeParam(reqBO);
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateMergeOrderArrivalTime(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateOrderTax"})
    public PebUpdateOrderRspBO updateOrderTax(@RequestBody PebUpdateOrderReqBO reqBO) {
        this.validateReq(reqBO);
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrderTax(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    private void validateMergeParam(PebUpdateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderItemArrivalTime())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderItemArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllArrivalTime() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllArrivalTime() != 1 && reqBO.getIsUpdateAllArrivalTime() != 2) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllArrivalTime]\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    private void validateReq(PebUpdateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempOrderId() == null && reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[tempOrderId]\u548c[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTax()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllTax() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllTax]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllTax() != 1 && reqBO.getIsUpdateAllTax() != 2) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllTax]\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    private void validateParam(PebUpdateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempOrderId() == null && reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[tempOrderId]\u548c[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderItemArrivalTime())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderItemArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllArrivalTime() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllArrivalTime() != 1 && reqBO.getIsUpdateAllArrivalTime() != 2) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllArrivalTime]\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    @PostMapping(value={"updateOrderByRecover"})
    public PebUpdateOrderRspBO updateOrderByRecover(@RequestBody PebUpdateOrderReqBO reqBO) {
        this.validate(reqBO);
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrderByRecover(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            try {
                this.dealBusinessWaitDone(reqBO);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u4e1a\u52a1\u5f85\u529e\u5f02\u5e38");
            }
            UocGeneralCirculationAbilityReqBO abilityReqBO = new UocGeneralCirculationAbilityReqBO();
            this.sync(reqBO);
            OrderSmsReqBO orderSmsReqBO = new OrderSmsReqBO();
            orderSmsReqBO.setNotifyName("\u4f9b\u5e94\u5546-\u9884\u8ba2\u5355\u63d0\u4ea4\u2014\u8ba2\u5355\u786e\u8ba4");
            orderSmsReqBO.setOrderId(reqBO.getOrderId());
            this.uocOrderSmsMsgProvider.send(new ProxyMessage(this.orderSmsTopic, this.orderSmsTag, JSON.toJSONString((Object)orderSmsReqBO)));
            if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
                UocApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
                try {
                    approveWaitNotificationReqBO.setAuditNoticeList(rspBO.getAuditNoticeList());
                    approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.SALE);
                    approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.SALE);
                    log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                    this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
                }
                catch (Exception e) {
                    log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
                }
            }
        }
        return rspBO;
    }

    private void dealBusinessWaitDone(PebUpdateOrderReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        List list = this.ordSaleMapper.getList(ordSalePO);
        if (CollectionUtils.isEmpty((Collection)list) || ((OrdSalePO)list.get(0)).getModelSettle() == null || StringUtils.isEmpty((CharSequence)((OrdSalePO)list.get(0)).getOrderSource())) {
            return;
        }
        Integer modelSettle = ((OrdSalePO)list.get(0)).getModelSettle();
        Integer orderSource = Integer.valueOf(((OrdSalePO)list.get(0)).getOrderSource());
        if (modelSettle == 1 && orderSource == 1) {
            UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
            TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
            todoBusinessWaitDoneAddBo.setBusiCode("3059");
            todoBusinessWaitDoneAddBo.setCenterCode("order");
            todoBusinessWaitDoneAddBo.setSystemCode("1");
            todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
            todoBusinessWaitDoneAddBo.setObjId(String.valueOf(reqBO.getOrderId()));
            todoBusinessWaitDoneAddBo.setHandleUserName(reqBO.getUsername());
            todoBusinessWaitDoneAddBo.setHandleUserNo(String.valueOf(reqBO.getOccupation()));
            todoBusinessWaitDoneAddBo.setSubmitUserName(reqBO.getUsername());
            todoBusinessWaitDoneAddBo.setSubmitUserNo(String.valueOf(reqBO.getOccupation()));
            todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
            try {
                UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
                if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                    log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
                }
            }
            catch (Exception e) {
                log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void validate(PebUpdateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrdItemUpdateList())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[ordItemUpdateList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocOrdItemUpdateBO uocOrdItemUpdateBO : reqBO.getOrdItemUpdateList()) {
            if (uocOrdItemUpdateBO.getOrdItemId() == null) {
                throw new UocProBusinessException("8888", "\u5165\u53c2[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uocOrdItemUpdateBO.getPurchaseCount() != null) continue;
            throw new UocProBusinessException("8888", "\u5165\u53c2[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @PostMapping(value={"updateHt"})
    public PebUpdateOrderRspBO updateHt(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateHt(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
            if (!StringUtils.isEmpty((CharSequence)reqBO.getContractNo())) {
                this.pushRealContractNo(reqBO);
            }
        }
        return rspBO;
    }

    private void pushRealContractNo(PebUpdateOrderReqBO reqBO) {
        PebExtPushRealContractNoAbilityReqBO pushRealContractNoAbilityReqBO = new PebExtPushRealContractNoAbilityReqBO();
        pushRealContractNoAbilityReqBO.setOrderId(reqBO.getOrderId());
        pushRealContractNoAbilityReqBO.setContractNo(reqBO.getContractNo());
        this.pushRealContractNoProvider.send(new ProxyMessage(this.pushRealContractNoTopic, this.pushRealContractNoTag, JSON.toJSONString((Object)pushRealContractNoAbilityReqBO)));
    }

    @PostMapping(value={"updateFscStatus"})
    public PebUpdateOrderRspBO updateFscStatus(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateFscStatus(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    private void sync(PebUpdateOrderReqBO reqBO) {
        UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        idxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
    }
}

