/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.uoc.base.constants.UocApproveEntrustConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.api.UocApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushContractLedgerAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocApproveEntrustNotificationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocNoTaskAuditOrderAuditNoticeBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebApproveRspBO;
import com.tydic.uoc.common.ability.bo.UocPebDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocPushContractMergeAbilityReqBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.atom.api.UocConvertNoticeUrlAtomService;
import com.tydic.uoc.common.atom.bo.UocConvertNoticeUrlAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocConvertNoticeUrlAtomRspBO;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.common.comb.api.UocPebApproveCombService;
import com.tydic.uoc.common.comb.api.UocSendApproveNoticeCombService;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.common.comb.bo.UocSendApproveNoticeCombReqBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocApprovalOrderAbilityService"})
public class UocApprovalOrderAbilityServiceImpl
implements UocApprovalOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocApprovalOrderAbilityServiceImpl.class);
    @Autowired
    private UocPebApproveCombService uocPebApproveCombService;
    @Value(value="${DEAL_PUSH_CONTRACT_ORDER_TOPIC:DEAL_PUSH_CONTRACT_ORDER_TOPIC}")
    private String pushContractOrderTopic;
    @Value(value="${DEAL_PUSH_CONTRACT_ORDER_TAG:DEAL_PUSH_CONTRACT_ORDER_TAG}")
    private String pushContractOrderTag;
    @Resource(name="dealPushContractOrderProvider")
    private ProxyMessageProducer pushContractOrderProvider;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC:DEAL_PUSH_FZ_ORDER_EVALUATE_TOPIC}")
    private String pushFzOrderEvaluateTopic;
    @Value(value="${DEAL_PUSH_FZ_ORDER_EVALUATE_TAG:DEAL_PUSH_FZ_ORDER_EVALUATE_TAG}")
    private String pushFzOrderEvaluateTag;
    @Resource(name="dealPushFzOrderEvaluateProvider")
    private ProxyMessageProducer dealPushFzOrderEvaluateProvider;
    @Value(value="${DEAL_WAREHOUSE_ORDER_SUBMIT_TOPIC:DEAL_WAREHOUSE_ORDER_SUBMIT_TOPIC}")
    private String pushWarehouseOrderSubmitTopic;
    @Value(value="${DEAL_WAREHOUSE_ORDER_SUBMIT_TAG:DEAL_WAREHOUSE_ORDER_SUBMIT_TAG}")
    private String pushWarehouseOrderSubmitTag;
    @Resource(name="dealPushWarehouseOrderSubmitProvider")
    private ProxyMessageProducer dealPushWarehouseOrderSubmitProvider;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private UocTodoCombService uocTodoCombService;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Resource(name="mqUocApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqUocApproveEntrustNotificationProvider;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC:UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String uocApproveEntrustNotificationTopic;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String uocApproveEntrustNotificationTag;
    @Autowired
    private UocConvertNoticeUrlAtomService uocConvertNoticeUrlAtomService;
    @Autowired
    private UocSendApproveNoticeCombService uocSendApproveNoticeCombService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;

    @PostMapping(value={"dealApprovalOrder"})
    public UocApprovalOrderRspBO dealApprovalOrder(@RequestBody UocApprovalOrderReqBO reqBO) {
        long startTime = System.currentTimeMillis();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealDesc())) {
            if ("1".equals(reqBO.getFlag())) {
                reqBO.setDealDesc("\u540c\u610f");
            } else {
                reqBO.setDealDesc("\u62d2\u7edd");
            }
        }
        UocApprovalOrderRspBO rspBO = new UocApprovalOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        for (UocPebDealOrderBO orderBO : reqBO.getOrderInfo()) {
            long orderTime = System.currentTimeMillis();
            String stationId = null;
            try {
                stationId = this.uocTodoCombService.getNextStationId(orderBO.getSaleVoucherId(), UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5f53\u524d\u5ba1\u6279\u4eba\u5c97\u4f4d\u5931\u8d25\uff1a" + e.getMessage());
            }
            UocPebApproveReqBO approveReqBO = new UocPebApproveReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approveReqBO);
            approveReqBO.setFlag(reqBO.getFlag());
            approveReqBO.setOrderId(orderBO.getOrderId());
            approveReqBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            approveReqBO.setDealDesc(reqBO.getDealDesc());
            approveReqBO.setDealReason(reqBO.getDealDesc());
            approveReqBO.setStepId(orderBO.getStepId());
            UocPebApproveRspBO approveRspBO = this.uocPebApproveCombService.dealPebApprove(approveReqBO);
            if (!"0000".equals(approveRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)approveRspBO, (Object)rspBO);
                return rspBO;
            }
            if (!CollectionUtils.isEmpty((Collection)approveRspBO.getAuditNoticeList())) {
                if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
                    rspBO.getAuditNoticeList().addAll(approveRspBO.getAuditNoticeList());
                } else {
                    rspBO.setAuditNoticeList(approveRspBO.getAuditNoticeList());
                }
            }
            if (approveRspBO.getFinish().booleanValue() && "1".equals(reqBO.getFlag())) {
                UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
                warehousePO.setOrderId(orderBO.getOrderId());
                warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
                if (warehousePO != null) {
                    PebExtWarehouseOrderSubmitAbilityReqBO submitAbilityReqBO = new PebExtWarehouseOrderSubmitAbilityReqBO();
                    submitAbilityReqBO.setOrderId(orderBO.getOrderId());
                    this.dealPushWarehouseOrderSubmitProvider.send(new ProxyMessage(this.pushWarehouseOrderSubmitTopic, this.pushWarehouseOrderSubmitTag, JSONObject.toJSONString((Object)submitAbilityReqBO)));
                }
                OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
                cruxMapPO.setOrderId(orderBO.getOrderId());
                cruxMapPO.setObjId(orderBO.getOrderId());
                cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
                cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
                UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
                zmInfoPO.setOrderId(orderBO.getOrderId());
                zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
                if (cruxMapPO != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cruxMapPO.getFieldValue10()) && !cruxMapPO.getFieldValue10().equals("0") && zmInfoPO.getIsPushErp() != null && zmInfoPO.getIsPushErp() == 0) {
                    PebExtPushContractLedgerAbilityReqBO abilityReqBO = new PebExtPushContractLedgerAbilityReqBO();
                    abilityReqBO.setOrderId(orderBO.getOrderId());
                    abilityReqBO.setPushType(cruxMapPO.getFieldValue10());
                    if (cruxMapPO.getFieldValue10().equals("2")) {
                        OrdSalePO salePO = new OrdSalePO();
                        salePO.setOrderId(orderBO.getOrderId());
                        salePO = this.ordSaleMapper.getModelBy(salePO);
                        if (salePO != null && salePO.getModelSettle() == 2) {
                            this.pushContractOrderProvider.send(new ProxyMessage(this.pushContractOrderTopic, this.pushContractOrderTag, JSONObject.toJSONString((Object)abilityReqBO)));
                        }
                    } else {
                        this.pushContractOrderProvider.send(new ProxyMessage(this.pushContractOrderTopic, this.pushContractOrderTag, JSONObject.toJSONString((Object)abilityReqBO)));
                    }
                }
                OrdSalePO salePO = new OrdSalePO();
                salePO.setOrderId(orderBO.getOrderId());
                salePO = this.ordSaleMapper.getModelBy(salePO);
                if (salePO != null && salePO.getModelSettle() == 1) {
                    UocPushContractMergeAbilityReqBO tzAbilityReqBO = new UocPushContractMergeAbilityReqBO();
                    tzAbilityReqBO.setOrderId(orderBO.getOrderId());
                    this.pushContractTzHeadProvider.send(new ProxyMessage(this.pushContractTzTopic, this.pushContractTzTag, JSONObject.toJSONString((Object)tzAbilityReqBO)));
                }
            }
            this.pushTodoWait(orderBO, reqBO, approveRspBO.getFinish(), stationId);
            log.error("3_0\u3001\u5ba1\u6279\u8017\u65f6dealPebApprove:{},{}", (Object)orderBO.getOrderId(), (Object)((double)(System.currentTimeMillis() - orderTime) / 1000.0));
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
            UocApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(rspBO.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.SALE);
                approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.SALE);
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        long endTime = System.currentTimeMillis();
        log.error("3\u3001\u5ba1\u6279\u8017\u65f6dealPebApprove:{},{}", (Object)JSON.toJSONString((Object)reqBO.getOrderInfo()), (Object)((double)(endTime - startTime) / 1000.0));
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNoticeUserInfo()) && !StringUtils.isEmpty((Object)reqBO.getObjCode())) {
            this.sendApproveNotice(reqBO, rspBO.getAuditNoticeList());
        }
        return rspBO;
    }

    private void pushTodoWait(UocPebDealOrderBO orderBO, UocApprovalOrderReqBO reqBO, Boolean finsh, String stationId) {
        try {
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(orderBO.getOrderId());
            uocTodoBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
            uocTodoBO.setOperatorId(reqBO.getUserId() + "");
            uocTodoBO.setOperatorNo(reqBO.getUsername());
            uocTodoBO.setOperatorName(reqBO.getName());
            uocTodoBO.setOrgId(reqBO.getOrgId());
            uocTodoBO.setFinishTime(new Date());
            uocTodoBO.setFinishYn(finsh);
            uocTodoBO.setAuditRemark(reqBO.getDealDesc());
            uocTodoBO.setAuditStatus("1".equals(reqBO.getFlag()));
            uocTodoBO.setStationId(stationId);
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }

    private void sendApproveNotice(UocApprovalOrderReqBO reqBO, List<UocNoTaskAuditOrderAuditNoticeBO> auditNoticeList) {
        if (!(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getNoticeUserInfo()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getObjCode()) || org.apache.commons.collections.CollectionUtils.isEmpty(auditNoticeList) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)auditNoticeList.get(0).getTaskId()))) {
            try {
                UocSendApproveNoticeCombReqBO combReqBO = new UocSendApproveNoticeCombReqBO();
                OrdSalePO qry = new OrdSalePO();
                qry.setOrderId(((UocPebDealOrderBO)reqBO.getOrderInfo().get(0)).getOrderId());
                qry = this.ordSaleMapper.getModelBy(qry);
                String typeStr = "";
                String objCode = reqBO.getObjCode();
                if (qry == null) {
                    throw new ZTBusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
                }
                UocConvertNoticeUrlAtomReqBO atomReqBO = new UocConvertNoticeUrlAtomReqBO();
                ArrayList<Long> objIds = new ArrayList<Long>();
                objIds.add(qry.getSaleVoucherId());
                atomReqBO.setObjIds(objIds);
                atomReqBO.setObjType(UocApproveEntrustConstant.ApproveEntrustType.SALE);
                Map<Object, Object> objIdMap = new HashMap();
                UocConvertNoticeUrlAtomRspBO atomRspBO = this.uocConvertNoticeUrlAtomService.convertNoticeUrl(atomReqBO);
                if (!CollectionUtils.isEmpty(atomRspBO.getObjIdMap())) {
                    objIdMap = atomRspBO.getObjIdMap();
                }
                objCode = qry.getSaleVoucherNo();
                String titelEndStr = "";
                String textEndStr = "";
                if ("1".equals(reqBO.getFlag())) {
                    titelEndStr = "\u5ba1\u6279\u901a\u8fc7";
                    textEndStr = "\u5df2\u901a\u8fc7\u5ba1\u6279\u3002";
                } else {
                    titelEndStr = "\u5ba1\u6279\u9a73\u56de";
                    textEndStr = "\u88ab\u5ba1\u6279\u9a73\u56de\u3002";
                }
                typeStr = UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(qry.getOrderSource()) ? "\u5bc4\u552e\u8865\u8d27\u5355" : (UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(qry.getOrderSource()) ? "\u8d85\u5e02\u8ba2\u5355" : (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(qry.getOrderSource()) && UocCoreConstant.TradeMode.TRADE_MODEL.equals(qry.getModelSettle()) ? "\u534f\u8bae\u8ba2\u5355" : ((UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(qry.getOrderSource()) || UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString().equals(qry.getOrderSource())) && UocCoreConstant.TradeMode.MATCHMAKING_MODE.equals(qry.getModelSettle()) ? "\u96c6\u91c7\u5206\u7b7e\u8ba2\u5355" : (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(qry.getOrderSource()) ? "\u5408\u540c\u8ba2\u5355" : "\u8ba2\u5355"))));
                String titel = objCode + "_" + typeStr + "_\u8ba2\u5355" + titelEndStr;
                String text = "\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u8ba2\u5355" + objCode + "\u5f53\u524d\u8282\u70b9" + textEndStr;
                String noticeUrl = null;
                if (objIdMap.containsKey(objIds.get(0))) {
                    noticeUrl = (String)objIdMap.get(objIds.get(0));
                }
                String noticeText = "";
                noticeText = !StringUtils.isEmpty(noticeUrl) ? "<a href=\"" + noticeUrl + "\">" + text + "</a>" : text;
                combReqBO.setText(noticeText);
                combReqBO.setTitel(titel);
                combReqBO.setUserId(reqBO.getUserId());
                combReqBO.setName(reqBO.getName());
                combReqBO.setUsername(reqBO.getUsername());
                combReqBO.setTaskId(auditNoticeList.get(0).getTaskId());
                combReqBO.setNoticeUserInfo(reqBO.getNoticeUserInfo());
                this.uocSendApproveNoticeCombService.sendApproveNotice(combReqBO);
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279\u6284\u9001\u7ad9\u5185\u4fe1\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

