/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocBigOrderAutoCreateAbilityService;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.UocBigOrderAutoCreateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocBigOrderAutoCreateAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocBigOrderAutoCreateBusiService;
import com.tydic.uoc.common.busi.bo.UocBigOrderAutoCreateBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocBigOrderAutoCreateBusiRspBO;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.po.UocBigOrderPO;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocBigOrderAutoCreateAbilityService"})
public class UocBigOrderAutoCreateAbilityServiceImpl
implements UocBigOrderAutoCreateAbilityService {
    @Autowired
    private UocBigOrderAutoCreateBusiService uocBigOrderAutoCreateBusiService;
    @Value(value="${PUSH_ERP_BIG_ORDER_TOPIC:PUSH_ERP_BIG_ORDER_TOPIC}")
    private String pushBigErpTopic;
    @Value(value="${PUSH_ERP_BIG_ORDER_TOPIC:*}")
    private String pushBigErpTag;
    @Resource(name="pushErpBigOrderOrderProvider")
    private ProxyMessageProducer pushErpBigOrderOrderProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @PostMapping(value={"createBigOrderAuto"})
    public UocBigOrderAutoCreateAbilityRspBO createBigOrderAuto(@RequestBody UocBigOrderAutoCreateAbilityReqBO reqBO) {
        UocBigOrderAutoCreateBusiReqBO busiReqBO = (UocBigOrderAutoCreateBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocBigOrderAutoCreateBusiReqBO.class);
        UocBigOrderAutoCreateBusiRspBO busiRspBO = this.uocBigOrderAutoCreateBusiService.createBigOrderAuto(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new BusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        if (CollectionUtils.isNotEmpty(busiRspBO.getUocBigOrderPOList())) {
            for (UocBigOrderPO uocBigOrderPO : busiRspBO.getUocBigOrderPOList()) {
                PebPushErpReqBO erpReqBO = new PebPushErpReqBO();
                erpReqBO.setBigOrderId(uocBigOrderPO.getId());
                this.pushErpBigOrderOrderProvider.send(new ProxyMessage(this.pushBigErpTopic, this.pushBigErpTag, JSON.toJSONString((Object)erpReqBO)));
            }
        }
        if (CollectionUtils.isNotEmpty(busiRspBO.getSale())) {
            for (PebDealOrderBO orderBO : busiRspBO.getSale()) {
                PebExtOrdIdxSyncReqBO syncReqBO = new PebExtOrdIdxSyncReqBO();
                syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                syncReqBO.setOrderId(orderBO.getOrderId());
                syncReqBO.setObjId(orderBO.getSaleVoucherId());
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)syncReqBO))));
            }
        }
        return (UocBigOrderAutoCreateAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), UocBigOrderAutoCreateAbilityRspBO.class);
    }
}

