/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocDealCancelMsgAbilityService;
import com.tydic.uoc.common.ability.bo.UocDealCancelMsgShipReqBO;
import com.tydic.uoc.common.ability.bo.UocDealCancelMsgShipRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocDealCancelMsgBusiService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocDealCancelMsgAbilityServiceImpl
implements UocDealCancelMsgAbilityService {
    @Autowired
    private UocDealCancelMsgBusiService uocDealCancelMsgBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_PID}")
    private String senderKey;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;

    public UocDealCancelMsgShipRspBO dealCancelMsg(UocDealCancelMsgShipReqBO reqBO) {
        UocDealCancelMsgShipRspBO rspBO = this.uocDealCancelMsgBusiService.dealCancelMsg(reqBO);
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
        if ("0000".equals(rspBO.getRespCode()) && rspBO.getSaleId() != null) {
            UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
            syncReqBO.setObjId(rspBO.getSaleId());
            syncReqBO.setOrderId(reqBO.getOrderId());
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
        }
        return rspBO;
    }
}

