/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.constants.BxConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocExportBxOrderAbilityService;
import com.tydic.uoc.common.ability.bo.UocExportBxOrderReqBo;
import com.tydic.uoc.common.ability.bo.UocExportBxOrderReqBoOrderList;
import com.tydic.uoc.common.ability.bo.UocExportBxOrderRspBo;
import com.tydic.uoc.common.utils.PdfNewUtils;
import com.tydic.uoc.dao.BiddingSingleGoodsMapper;
import com.tydic.uoc.dao.BiddingSingleMapper;
import com.tydic.uoc.po.BiddingSingleGoodsPO;
import com.tydic.uoc.po.BiddingSinglePO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocExportBxOrderAbilityService"})
public class UocExportBxOrderAbilityServiceImpl
implements UocExportBxOrderAbilityService {
    @Autowired
    private BiddingSingleGoodsMapper biddingSingleGoodsMapper;
    @Autowired
    private BiddingSingleMapper biddingSingleMapper;
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FileClient fileClient;

    @PostMapping(value={"exportBxOrder"})
    public UocExportBxOrderRspBo exportBxOrder(@RequestBody UocExportBxOrderReqBo reqBo) {
        this.val(reqBo);
        if (BxConstant.CART_SOURCE.equals(reqBo.getBxOrderSource())) {
            return this.cartSourceExt(reqBo);
        }
        if (BxConstant.ORDER_CONFIRM_PAGE_ORDER.equals(reqBo.getBxOrderSource())) {
            return this.orderConfirmPageOrder(reqBo);
        }
        if (BxConstant.ORDER_CONFIRM_PAGE_GOODS.equals(reqBo.getBxOrderSource())) {
            return this.orderConfirmPageGoods(reqBo);
        }
        if (BxConstant.CALCULATE_FLOW.equals(reqBo.getBxOrderSource())) {
            return this.calculateFlow(reqBo);
        }
        if (BxConstant.ORDER_DETAIL_PAGE_ORDER.equals(reqBo.getBxOrderSource())) {
            return this.orderDetailPageOrder(reqBo);
        }
        return this.orderDetailPageGoods(reqBo);
    }

    private UocExportBxOrderRspBo orderDetailPageOrder(UocExportBxOrderReqBo reqBo) {
        String exportUrl;
        String fileName;
        block52: {
            BaseFont baseFont;
            List noBjdList = reqBo.getOrderList().stream().filter(e -> e.getBiddingSingleId() == null).collect(Collectors.toList());
            List bjdList = reqBo.getOrderList().stream().filter(e -> e.getBiddingSingleId() != null).collect(Collectors.toList());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
            PdfWriter pdfWriter = null;
            try {
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e3) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e3);
            }
            Font contentFont = new Font(baseFont, 12.0f, 0);
            Font titleFont = new Font(baseFont, 12.0f, 1);
            document.open();
            int sort = 1;
            LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
            PdfPTable titleTable = new PdfPTable(100);
            tableList.add(titleTable);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)("\u8ba2\u5355\u53f7\uff1a" + reqBo.getSaleVoucherNo()), (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)40, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"", (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)("\u4e0b\u5355\u65f6\u95f4\uff1a" + reqBo.getCreateTime()), (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)40, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"", (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)15, (Integer)0);
            for (UocExportBxOrderReqBoOrderList uocExportBxOrderReqBoOrderList : bjdList) {
                Long biddingSingleId = uocExportBxOrderReqBoOrderList.getBiddingSingleId();
                BiddingSinglePO biddingSinglePO = new BiddingSinglePO();
                biddingSinglePO.setBiddingSingleId(biddingSingleId);
                biddingSinglePO = this.biddingSingleMapper.selectOne(biddingSinglePO);
                if (biddingSinglePO == null) {
                    throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u4e0d\u5b58\u5728");
                }
                BiddingSingleGoodsPO biddingSingleGoodsPO = new BiddingSingleGoodsPO();
                biddingSingleGoodsPO.setBiddingSingleId(biddingSingleId);
                List biddingSingleGoodsPOS = this.biddingSingleGoodsMapper.selectByCondition(biddingSingleGoodsPO);
                if (biddingSingleGoodsPOS == null || biddingSingleGoodsPOS.isEmpty()) {
                    throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                PdfPTable contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, this.coverNull(uocExportBxOrderReqBoOrderList.getSkuName()), titleFont, 0, 5, Float.valueOf(30.0f), 30, null);
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u5355\u53f7\uff1a", contentFont, 0, 5, Float.valueOf(30.0f), 4, null, Arrays.asList("right"));
                PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(biddingSinglePO.getBiddingSingleCode()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
                PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u4eba\uff1a" + this.coverNull(biddingSinglePO.getCreateUserName()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
                PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u65f6\u95f4\uff1a" + this.coverNull(biddingSinglePO.getUpdateTime()), contentFont, 0, 5, Float.valueOf(30.0f), 10, null, Arrays.asList("left"));
                int cols = biddingSingleGoodsPOS.size();
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u5546\u54c1\u540d\u79f0", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u7f16\u7801", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u7269\u8d44\u7f16\u7801", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMaterialCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u54c1\u724c", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getBrandName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u578b\u53f7", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getModel()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u89c4\u683c", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSpec()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u4ef7\uff08\u5143\uff09", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSalePrice()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u5355\u4f4d", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMeasureName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u9500\u91cf", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSaleNum()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u6750\u8d28", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getTexture()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u4ea4\u8d27\u65f6\u95f4", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getArrivalTime()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u6240\u5c5e\u4f9b\u5e94\u5546", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSupplierName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u72b6\u6001", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuStatusDesc()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u4e0b\u5355\u60c5\u51b5", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    String content = "";
                    content = uocExportBxOrderReqBoOrderList.getSkuId().equals(singleGoodsPO.getSkuId()) ? "\u4e0b\u5355\u5546\u54c1" : "-";
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(content) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                ++sort;
            }
            for (UocExportBxOrderReqBoOrderList uocExportBxOrderReqBoOrderList : noBjdList) {
                PdfPTable contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(uocExportBxOrderReqBoOrderList.getSkuName()), titleFont, 0, 5, Float.valueOf(30.0f), 30, null, null);
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u8be5\u5546\u54c1\u65e0\u6bd4\u9009\u5355", contentFont, 1, 5, Float.valueOf(30.0f), 30, null);
                ++sort;
            }
            PdfUtils.addTableListToDoc((Document)document, tableList);
            document.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            fileName = this.coverNull(new Date()) + "\u6bd4\u4ef7\u5355.pdf";
            try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)in);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block52;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block52;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e4) {
                throw new ZTBusinessException("pdf\u5f02\u5e38");
            }
        }
        UocExportBxOrderRspBo uocExportBxOrderRspBo = new UocExportBxOrderRspBo();
        uocExportBxOrderRspBo.setRespCode("0000");
        uocExportBxOrderRspBo.setRespDesc("\u6210\u529f");
        uocExportBxOrderRspBo.setFileName(fileName);
        uocExportBxOrderRspBo.setFileUrl(exportUrl);
        return uocExportBxOrderRspBo;
    }

    private UocExportBxOrderRspBo orderConfirmPageOrder(UocExportBxOrderReqBo reqBo) {
        String exportUrl;
        String fileName;
        block52: {
            BaseFont baseFont;
            List noBjdList = reqBo.getOrderList().stream().filter(e -> e.getBiddingSingleId() == null).collect(Collectors.toList());
            List bjdList = reqBo.getOrderList().stream().filter(e -> e.getBiddingSingleId() != null).collect(Collectors.toList());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
            PdfWriter pdfWriter = null;
            try {
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e3) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e3);
            }
            Font contentFont = new Font(baseFont, 12.0f, 0);
            Font titleFont = new Font(baseFont, 12.0f, 1);
            document.open();
            int sort = 1;
            LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
            for (UocExportBxOrderReqBoOrderList uocExportBxOrderReqBoOrderList : bjdList) {
                Long biddingSingleId = uocExportBxOrderReqBoOrderList.getBiddingSingleId();
                BiddingSinglePO biddingSinglePO = new BiddingSinglePO();
                biddingSinglePO.setBiddingSingleId(biddingSingleId);
                biddingSinglePO = this.biddingSingleMapper.selectOne(biddingSinglePO);
                if (biddingSinglePO == null) {
                    throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u4e0d\u5b58\u5728");
                }
                BiddingSingleGoodsPO biddingSingleGoodsPO = new BiddingSingleGoodsPO();
                biddingSingleGoodsPO.setBiddingSingleId(biddingSingleId);
                List biddingSingleGoodsPOS = this.biddingSingleGoodsMapper.selectByCondition(biddingSingleGoodsPO);
                if (biddingSingleGoodsPOS == null || biddingSingleGoodsPOS.isEmpty()) {
                    throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                PdfPTable contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, this.coverNull(uocExportBxOrderReqBoOrderList.getSkuName()), titleFont, 0, 5, Float.valueOf(30.0f), 30, null);
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u5355\u53f7\uff1a", contentFont, 0, 5, Float.valueOf(30.0f), 4, null, Arrays.asList("right"));
                PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(biddingSinglePO.getBiddingSingleCode()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
                PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u4eba\uff1a" + this.coverNull(biddingSinglePO.getCreateUserName()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
                PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u65f6\u95f4\uff1a" + this.coverNull(biddingSinglePO.getUpdateTime()), contentFont, 0, 5, Float.valueOf(30.0f), 10, null, Arrays.asList("left"));
                int cols = biddingSingleGoodsPOS.size();
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u5546\u54c1\u540d\u79f0", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u7f16\u7801", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u7269\u8d44\u7f16\u7801", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMaterialCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u54c1\u724c", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getBrandName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u578b\u53f7", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getModel()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u89c4\u683c", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSpec()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u4ef7\uff08\u5143\uff09", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSalePrice()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u5355\u4f4d", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMeasureName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u9500\u91cf", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSaleNum()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u6750\u8d28", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getTexture()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u4ea4\u8d27\u65f6\u95f4", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getArrivalTime()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u6240\u5c5e\u4f9b\u5e94\u5546", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSupplierName()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u72b6\u6001", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuStatusDesc()) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u4e0b\u5355\u60c5\u51b5", titleFont, 1, 5, null, 5, null);
                for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                    String content = "";
                    content = uocExportBxOrderReqBoOrderList.getSkuId().equals(singleGoodsPO.getSkuId()) ? "\u4e0b\u5355\u5546\u54c1" : "-";
                    PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(content) + "\n  ", contentFont, 1, 5, null, 5, null);
                }
                for (int i = 0; i < 5 - cols; ++i) {
                    PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
                }
                ++sort;
            }
            for (UocExportBxOrderReqBoOrderList uocExportBxOrderReqBoOrderList : noBjdList) {
                PdfPTable contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(uocExportBxOrderReqBoOrderList.getSkuName()), titleFont, 0, 5, Float.valueOf(30.0f), 30, null, null);
                contentTable = new PdfPTable(30);
                tableList.add(contentTable);
                PdfNewUtils.addCellToTable(contentTable, "\u8be5\u5546\u54c1\u65e0\u6bd4\u9009\u5355", contentFont, 1, 5, Float.valueOf(30.0f), 30, null);
                ++sort;
            }
            PdfUtils.addTableListToDoc((Document)document, tableList);
            document.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            fileName = this.coverNull(new Date()) + "\u6bd4\u4ef7\u5355.pdf";
            try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)in);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block52;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block52;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e4) {
                throw new ZTBusinessException("pdf\u5f02\u5e38");
            }
        }
        UocExportBxOrderRspBo uocExportBxOrderRspBo = new UocExportBxOrderRspBo();
        uocExportBxOrderRspBo.setRespCode("0000");
        uocExportBxOrderRspBo.setRespDesc("\u6210\u529f");
        uocExportBxOrderRspBo.setFileName(fileName);
        uocExportBxOrderRspBo.setFileUrl(exportUrl);
        return uocExportBxOrderRspBo;
    }

    private UocExportBxOrderRspBo orderDetailPageGoods(UocExportBxOrderReqBo reqBo) {
        String exportUrl;
        String fileName;
        block48: {
            BaseFont baseFont;
            Long biddingSingleId = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getBiddingSingleId();
            BiddingSinglePO biddingSinglePO = new BiddingSinglePO();
            biddingSinglePO.setBiddingSingleId(biddingSingleId);
            biddingSinglePO = this.biddingSingleMapper.selectOne(biddingSinglePO);
            if (biddingSinglePO == null) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u4e0d\u5b58\u5728");
            }
            BiddingSingleGoodsPO biddingSingleGoodsPO = new BiddingSingleGoodsPO();
            biddingSingleGoodsPO.setBiddingSingleId(biddingSingleId);
            List biddingSingleGoodsPOS = this.biddingSingleGoodsMapper.selectByCondition(biddingSingleGoodsPO);
            if (biddingSingleGoodsPOS == null || biddingSingleGoodsPOS.isEmpty()) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
            PdfWriter pdfWriter = null;
            try {
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            }
            Font contentFont = new Font(baseFont, 12.0f, 0);
            Font titleFont = new Font(baseFont, 12.0f, 1);
            document.open();
            LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
            PdfPTable titleTable = new PdfPTable(100);
            tableList.add(titleTable);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)("\u8ba2\u5355\u53f7\uff1a" + reqBo.getSaleVoucherNo()), (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)40, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"", (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)("\u4e0b\u5355\u65f6\u95f4\uff1a" + reqBo.getCreateTime()), (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)40, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"", (Font)contentFont, (Integer)0, (Integer)0, (Float)Float.valueOf(30.0f), (Integer)15, (Integer)0);
            PdfPTable contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, this.coverNull(((BiddingSingleGoodsPO)biddingSingleGoodsPOS.get(0)).getSkuName()), titleFont, 0, 5, Float.valueOf(30.0f), 30, null);
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u5355\u53f7\uff1a", contentFont, 0, 5, Float.valueOf(30.0f), 4, null, Arrays.asList("right"));
            PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(biddingSinglePO.getBiddingSingleCode()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u4eba\uff1a" + this.coverNull(biddingSinglePO.getCreateUserName()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u65f6\u95f4\uff1a" + this.coverNull(biddingSinglePO.getUpdateTime()), contentFont, 0, 5, Float.valueOf(30.0f), 10, null, Arrays.asList("left"));
            int cols = biddingSingleGoodsPOS.size();
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u7269\u8d44\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMaterialCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u54c1\u724c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getBrandName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u578b\u53f7", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getModel()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u89c4\u683c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSpec()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u4ef7\uff08\u5143\uff09", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSalePrice()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u5355\u4f4d", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMeasureName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u91cf", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSaleNum()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6750\u8d28", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getTexture()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u4ea4\u8d27\u65f6\u95f4", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getArrivalTime()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6240\u5c5e\u4f9b\u5e94\u5546", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSupplierName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u72b6\u6001", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuStatusDesc()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u4e0b\u5355\u60c5\u51b5", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                String content = "";
                content = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getSkuId().equals(singleGoodsPO.getSkuId()) ? content + "\u4e0b\u5355\u5546\u54c1" : content + "-";
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(content) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            PdfUtils.addTableListToDoc((Document)document, tableList);
            document.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            fileName = biddingSinglePO.getBiddingSingleCode() + ".pdf";
            try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)in);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block48;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block48;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("pdf\u5f02\u5e38");
            }
        }
        UocExportBxOrderRspBo uocExportBxOrderRspBo = new UocExportBxOrderRspBo();
        uocExportBxOrderRspBo.setRespCode("0000");
        uocExportBxOrderRspBo.setRespDesc("\u6210\u529f");
        uocExportBxOrderRspBo.setFileName(fileName);
        uocExportBxOrderRspBo.setFileUrl(exportUrl);
        return uocExportBxOrderRspBo;
    }

    private UocExportBxOrderRspBo calculateFlow(UocExportBxOrderReqBo reqBo) {
        String exportUrl;
        String fileName;
        block50: {
            BaseFont baseFont;
            Long biddingSingleId = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getBiddingSingleId();
            BiddingSinglePO biddingSinglePO = new BiddingSinglePO();
            biddingSinglePO.setBiddingSingleId(biddingSingleId);
            biddingSinglePO = this.biddingSingleMapper.selectOne(biddingSinglePO);
            if (biddingSinglePO == null) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u4e0d\u5b58\u5728");
            }
            BiddingSingleGoodsPO biddingSingleGoodsPO = new BiddingSingleGoodsPO();
            biddingSingleGoodsPO.setBiddingSingleId(biddingSingleId);
            List biddingSingleGoodsPOS = this.biddingSingleGoodsMapper.selectByCondition(biddingSingleGoodsPO);
            if (biddingSingleGoodsPOS == null || biddingSingleGoodsPOS.isEmpty()) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
            PdfWriter pdfWriter = null;
            try {
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            }
            Font contentFont = new Font(baseFont, 12.0f, 0);
            Font titleFont = new Font(baseFont, 12.0f, 1);
            document.open();
            LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
            PdfPTable contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTableNew(contentTable, "\u8ba1\u5212\u7f16\u53f7\uff1a" + this.coverNull(biddingSinglePO.getPlanNo()), contentFont, 0, 5, Float.valueOf(30.0f), 12, null, Arrays.asList("right"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u7269\u8d44\u7f16\u7801\uff1a" + this.coverNull(biddingSinglePO.getMaterialCode()), contentFont, 0, 5, Float.valueOf(30.0f), 18, null, Arrays.asList("left"));
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u5355\u53f7\uff1a", contentFont, 0, 5, Float.valueOf(30.0f), 4, null, Arrays.asList("right", "top"));
            PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(biddingSinglePO.getBiddingSingleCode()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left", "top"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u4eba\uff1a" + this.coverNull(biddingSinglePO.getCreateUserName()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left", "top"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u65f6\u95f4\uff1a" + this.coverNull(biddingSinglePO.getUpdateTime()), contentFont, 0, 5, Float.valueOf(30.0f), 10, null, Arrays.asList("left", "top"));
            int cols = biddingSingleGoodsPOS.size();
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5546\u54c1\u540d\u79f0", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u7269\u8d44\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMaterialCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u54c1\u724c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getBrandName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u578b\u53f7", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getModel()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u89c4\u683c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSpec()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u4ef7\uff08\u5143\uff09", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSalePrice()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u5355\u4f4d", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMeasureName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u91cf", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSaleNum()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6750\u8d28", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getTexture()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u4ea4\u8d27\u65f6\u95f4", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getArrivalTime()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6240\u5c5e\u4f9b\u5e94\u5546", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSupplierName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u72b6\u6001", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuStatusDesc()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u64cd\u4f5c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                String content = "";
                content = BxConstant.YES.equals(singleGoodsPO.getIsUse()) ? "\u5f53\u524d\u9009\u4e2d\u5546\u54c1" : "-";
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(content) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            PdfUtils.addTableListToDoc((Document)document, tableList);
            document.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            fileName = biddingSinglePO.getBiddingSingleCode() + ".pdf";
            try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)in);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block50;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block50;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("pdf\u5f02\u5e38");
            }
        }
        UocExportBxOrderRspBo uocExportBxOrderRspBo = new UocExportBxOrderRspBo();
        uocExportBxOrderRspBo.setRespCode("0000");
        uocExportBxOrderRspBo.setRespDesc("\u6210\u529f");
        uocExportBxOrderRspBo.setFileName(fileName);
        uocExportBxOrderRspBo.setFileUrl(exportUrl);
        return uocExportBxOrderRspBo;
    }

    private UocExportBxOrderRspBo orderConfirmPageGoods(UocExportBxOrderReqBo reqBo) {
        String exportUrl;
        String fileName;
        block50: {
            BaseFont baseFont;
            Long biddingSingleId = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getBiddingSingleId();
            BiddingSinglePO biddingSinglePO = new BiddingSinglePO();
            biddingSinglePO.setBiddingSingleId(biddingSingleId);
            biddingSinglePO = this.biddingSingleMapper.selectOne(biddingSinglePO);
            if (biddingSinglePO == null) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u4e0d\u5b58\u5728");
            }
            BiddingSingleGoodsPO biddingSingleGoodsPO = new BiddingSingleGoodsPO();
            biddingSingleGoodsPO.setBiddingSingleId(biddingSingleId);
            List biddingSingleGoodsPOS = this.biddingSingleGoodsMapper.selectByCondition(biddingSingleGoodsPO);
            if (biddingSingleGoodsPOS == null || biddingSingleGoodsPOS.isEmpty()) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
            PdfWriter pdfWriter = null;
            try {
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            }
            Font contentFont = new Font(baseFont, 12.0f, 0);
            Font titleFont = new Font(baseFont, 12.0f, 1);
            document.open();
            LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
            PdfPTable contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, this.coverNull(((BiddingSingleGoodsPO)biddingSingleGoodsPOS.get(0)).getSkuName()), titleFont, 0, 5, Float.valueOf(30.0f), 30, null);
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u5355\u53f7\uff1a", contentFont, 0, 5, Float.valueOf(30.0f), 4, null, Arrays.asList("right"));
            PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(biddingSinglePO.getBiddingSingleCode()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u4eba\uff1a" + this.coverNull(biddingSinglePO.getCreateUserName()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u65f6\u95f4\uff1a" + this.coverNull(biddingSinglePO.getUpdateTime()), contentFont, 0, 5, Float.valueOf(30.0f), 10, null, Arrays.asList("left"));
            int cols = biddingSingleGoodsPOS.size();
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5546\u54c1\u540d\u79f0", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u7269\u8d44\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMaterialCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u54c1\u724c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getBrandName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u578b\u53f7", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getModel()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u89c4\u683c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSpec()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u4ef7\uff08\u5143\uff09", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSalePrice()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u5355\u4f4d", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMeasureName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u91cf", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSaleNum()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6750\u8d28", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getTexture()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u4ea4\u8d27\u65f6\u95f4", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getArrivalTime()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6240\u5c5e\u4f9b\u5e94\u5546", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSupplierName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u72b6\u6001", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuStatusDesc()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u4e0b\u5355\u60c5\u51b5", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                String content = "";
                content = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getSkuId().equals(singleGoodsPO.getSkuId()) ? "\u4e0b\u5355\u5546\u54c1" : content + "-";
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(content) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            PdfUtils.addTableListToDoc((Document)document, tableList);
            document.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            fileName = biddingSinglePO.getBiddingSingleCode() + ".pdf";
            try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)in);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block50;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block50;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("pdf\u5f02\u5e38");
            }
        }
        UocExportBxOrderRspBo uocExportBxOrderRspBo = new UocExportBxOrderRspBo();
        uocExportBxOrderRspBo.setRespCode("0000");
        uocExportBxOrderRspBo.setRespDesc("\u6210\u529f");
        uocExportBxOrderRspBo.setFileName(fileName);
        uocExportBxOrderRspBo.setFileUrl(exportUrl);
        return uocExportBxOrderRspBo;
    }

    private UocExportBxOrderRspBo cartSourceExt(UocExportBxOrderReqBo reqBo) {
        String exportUrl;
        String fileName;
        block50: {
            BaseFont baseFont;
            Long biddingSingleId = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getBiddingSingleId();
            BiddingSinglePO biddingSinglePO = new BiddingSinglePO();
            biddingSinglePO.setBiddingSingleId(biddingSingleId);
            biddingSinglePO = this.biddingSingleMapper.selectOne(biddingSinglePO);
            if (biddingSinglePO == null) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u4e0d\u5b58\u5728");
            }
            BiddingSingleGoodsPO biddingSingleGoodsPO = new BiddingSingleGoodsPO();
            biddingSingleGoodsPO.setBiddingSingleId(biddingSingleId);
            List biddingSingleGoodsPOS = this.biddingSingleGoodsMapper.selectByCondition(biddingSingleGoodsPO);
            if (biddingSingleGoodsPOS == null || biddingSingleGoodsPOS.isEmpty()) {
                throw new UocProBusinessException("8888", "\u6bd4\u4ef7\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
            PdfWriter pdfWriter = null;
            try {
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            }
            Font contentFont = new Font(baseFont, 12.0f, 0);
            Font titleFont = new Font(baseFont, 12.0f, 1);
            document.open();
            LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
            PdfPTable contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u5355\u53f7\uff1a", contentFont, 0, 5, Float.valueOf(30.0f), 4, null, Arrays.asList("right"));
            PdfNewUtils.addCellToTableNew(contentTable, this.coverNull(biddingSinglePO.getBiddingSingleCode()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u4eba\uff1a" + this.coverNull(biddingSinglePO.getCreateUserName()), contentFont, 0, 5, Float.valueOf(30.0f), 8, null, Arrays.asList("right", "left"));
            PdfNewUtils.addCellToTableNew(contentTable, "\u6bd4\u9009\u65f6\u95f4\uff1a" + this.coverNull(biddingSinglePO.getUpdateTime()), contentFont, 0, 5, Float.valueOf(30.0f), 10, null, Arrays.asList("left"));
            int cols = biddingSingleGoodsPOS.size();
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5546\u54c1\u540d\u79f0", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u7269\u8d44\u7f16\u7801", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMaterialCode()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u54c1\u724c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getBrandName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u578b\u53f7", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getModel()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u89c4\u683c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSpec()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u4ef7\uff08\u5143\uff09", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSalePrice()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u552e\u5355\u4f4d", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getMeasureName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u9500\u91cf", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSaleNum()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6750\u8d28", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getTexture()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u4ea4\u8d27\u65f6\u95f4", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getArrivalTime()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u6240\u5c5e\u4f9b\u5e94\u5546", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSupplierName()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u5355\u54c1\u72b6\u6001", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(singleGoodsPO.getSkuStatusDesc()) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            contentTable = new PdfPTable(30);
            tableList.add(contentTable);
            PdfNewUtils.addCellToTable(contentTable, "\u64cd\u4f5c", titleFont, 1, 5, null, 5, null);
            for (BiddingSingleGoodsPO singleGoodsPO : biddingSingleGoodsPOS) {
                String content = "";
                content = ((UocExportBxOrderReqBoOrderList)reqBo.getOrderList().get(0)).getSkuId().equals(singleGoodsPO.getSkuId()) ? content + "\u5f53\u524d\u5546\u54c1\n" : content + "\n";
                content = singleGoodsPO.getCartId() == null ? content + "\u672a\u52a0\u5165\u8d2d\u7269\u8f66\n" : content + "\u5df2\u52a0\u5165\u8d2d\u7269\u8f66\n";
                content = BxConstant.YES.equals(singleGoodsPO.getIsAssociation()) ? content + "\u5df2\u5173\u8054\u6bd4\u9009\u5355\n" : content + "\u672a\u5173\u8054\u6bd4\u9009\u5355\n";
                PdfNewUtils.addCellToTable(contentTable, "  \n" + this.coverNull(content) + "\n  ", contentFont, 1, 5, null, 5, null);
            }
            for (int i = 0; i < 5 - cols; ++i) {
                PdfNewUtils.addCellToTable(contentTable, "", contentFont, 1, 5, null, 5, null);
            }
            PdfUtils.addTableListToDoc((Document)document, tableList);
            document.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            fileName = biddingSinglePO.getBiddingSingleCode() + ".pdf";
            try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)in);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block50;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block50;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("pdf\u5f02\u5e38");
            }
        }
        UocExportBxOrderRspBo uocExportBxOrderRspBo = new UocExportBxOrderRspBo();
        uocExportBxOrderRspBo.setRespCode("0000");
        uocExportBxOrderRspBo.setRespDesc("\u6210\u529f");
        uocExportBxOrderRspBo.setFileName(fileName);
        uocExportBxOrderRspBo.setFileUrl(exportUrl);
        return uocExportBxOrderRspBo;
    }

    private String coverNull(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).stripTrailingZeros().toPlainString();
        }
        if (obj instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format((Date)obj);
        }
        return obj.toString();
    }

    private void val(UocExportBxOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderList() == null || reqBo.getOrderList().isEmpty()) {
            throw new UocProBusinessException("100002", "\u6bd4\u9009\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBxOrderSource() == null) {
            throw new UocProBusinessException("100002", "\u6bd4\u9009\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Integer> sourceList = Arrays.asList(BxConstant.CART_SOURCE, BxConstant.ORDER_CONFIRM_PAGE_ORDER, BxConstant.ORDER_CONFIRM_PAGE_GOODS, BxConstant.CALCULATE_FLOW, BxConstant.ORDER_DETAIL_PAGE_ORDER, BxConstant.ORDER_DETAIL_PAGE_GOODS);
        if (!sourceList.contains(reqBo.getBxOrderSource())) {
            throw new UocProBusinessException("100002", "\u6bd4\u9009\u5355\u6765\u6e90\u4e0d\u6b63\u786e");
        }
    }
}

