/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionAbnormalAuditAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyOrdChangeBO;
import com.tydic.uoc.common.ability.bo.UocCoreOrdShipAbnormalBO;
import com.tydic.uoc.common.ability.bo.UocInspectionAbnormalAuditBO;
import com.tydic.uoc.common.ability.bo.UocInspectionAbnormalAuditReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionAbnormalAuditRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocInspectionAbnormalAuditBusiService;
import com.tydic.uoc.dao.OrdShipAbnormalMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocInspectionAbnormalAuditAbilityService"})
public class UocInspectionAbnormalAuditAbilityServiceImpl
implements UocInspectionAbnormalAuditAbilityService {
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipAbnormalMapper ordShipAbnormalMapper;
    @Autowired
    private UocInspectionAbnormalAuditBusiService UocInspectionAbnormalAuditBusiService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;

    @PostMapping(value={"dealInspectionAbnormalAudit"})
    public UocInspectionAbnormalAuditRspBO dealInspectionAbnormalAudit(@RequestBody UocInspectionAbnormalAuditReqBO reqBO) {
        UocInspectionAbnormalAuditRspBO rspBO = this.UocInspectionAbnormalAuditBusiService.dealInspectionAbnormalAudit(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocPebOrdIdxSyncReqBO idxSyncReqBO;
            Map esMap = rspBO.getEsMap();
            if (esMap.get("inspection") != null) {
                Map inspectionMap = (Map)esMap.get("inspection");
                for (Long inspectionId : inspectionMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
                    idxSyncReqBO.setObjId(inspectionId);
                    idxSyncReqBO.setOrderId((Long)inspectionMap.get(inspectionId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (esMap.get("abnormal") != null) {
                Map abnormalMap = (Map)esMap.get("abnormal");
                for (Long abnormalId : abnormalMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
                    idxSyncReqBO.setObjId(abnormalId);
                    idxSyncReqBO.setOrderId((Long)abnormalMap.get(abnormalId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (esMap.get("sale") != null) {
                Map saleMap = (Map)esMap.get("sale");
                for (Long saleId : saleMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    idxSyncReqBO.setObjId(saleId);
                    idxSyncReqBO.setOrderId((Long)saleMap.get(saleId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (esMap.get("ship") != null) {
                Map shipMap = (Map)esMap.get("ship");
                for (Object shipId : shipMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                    idxSyncReqBO.setObjId((Long)shipId);
                    idxSyncReqBO.setOrderId((Long)shipMap.get(shipId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getChangeList())) {
                ArrayList<Long> inspectionVoucherIds = new ArrayList<Long>(rspBO.getChangeList().size());
                ArrayList<Long> abnormalVoucherIds = new ArrayList<Long>(rspBO.getChangeList().size());
                for (PebExtUnifyOrdChangeBO changeBO : rspBO.getChangeList()) {
                    PebExtSyncUnifyChangeAbilityReqBO changeAbilityReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
                    changeAbilityReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
                    changeAbilityReqBO.setOrderId(changeBO.getOrderId());
                    changeAbilityReqBO.setApplyId(changeBO.getAbnormalId());
                    this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeAbilityReqBO);
                    abnormalVoucherIds.add(changeBO.getAbnormalId());
                    inspectionVoucherIds.add(changeBO.getInspectionVoucherId());
                }
                List abnormalList = this.ordShipAbnormalMapper.getAbnormalByInspection(inspectionVoucherIds, abnormalVoucherIds);
                for (UocCoreOrdShipAbnormalBO abnormalBO : abnormalList) {
                    UocPebOrdIdxSyncReqBO idxSyncReqBO2 = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO2.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
                    idxSyncReqBO2.setObjId(abnormalBO.getAbnormalVoucherId());
                    idxSyncReqBO2.setOrderId(abnormalBO.getOrderId());
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO2)));
                }
            }
            if (Objects.nonNull(reqBO.getAuditType()) && reqBO.getAuditType() == 1 && "2".equals(rspBO.getOrderSource())) {
                this.sendSiKuMessage(reqBO.getUocInspectionAbnormalAuditList(), true);
            }
        }
        return rspBO;
    }

    private void sendSiKuMessage(List<UocInspectionAbnormalAuditBO> bos, Boolean flag) {
        bos.forEach(x -> {
            PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
            siKuOrderAbilityReqBO.setOrderType("UPDATE");
            siKuOrderAbilityReqBO.setOrderId(x.getOrderId());
            siKuOrderAbilityReqBO.setElcOrderFlag(flag);
            this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
        });
    }
}

