/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoDeleteWaitDoneAbilityReqBO;
import com.tydic.uac.dao.ApprovalLogMapper;
import com.tydic.uac.po.ApprovalLogPO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocProOrderDeleteAbilityService;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocProOrderDeleteAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderDeleteAbilityRspBo;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.busi.api.UocProOrderDeleteBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderDeleteAbilityService"})
public class UocProOrderDeleteAbilityServiceImpl
implements UocProOrderDeleteAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocProOrderDeleteAbilityServiceImpl.class);
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocProOrderDeleteBusiService uocProOrderDeleteBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;
    @Autowired
    private ApprovalLogMapper approvalLogMapper;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;

    @PostMapping(value={"deleteOrder"})
    public UocProOrderDeleteAbilityRspBo deleteOrder(@RequestBody UocProOrderDeleteAbilityReqBo reqBo) {
        UocProOrderDeleteAbilityRspBo rspBo;
        this.validateArgs(reqBo);
        this.stateCheck(reqBo);
        if (null == reqBo.getUserId() || 0L == reqBo.getUserId()) {
            reqBo.setUserId(reqBo.getUserIdIn());
        }
        if (!"0000".equals((rspBo = this.uocProOrderDeleteBusiService.deleteOrder(reqBo)).getRespCode())) {
            throw new UocProBusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
        }
        this.syncSale(reqBo);
        if (rspBo.getPlanId() != null) {
            PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
            syncReqBO.setPlanIds(rspBo.getPlanId());
            this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
        }
        this.deleteXtFlow(reqBo);
        return rspBo;
    }

    private void deleteXtFlow(UocProOrderDeleteAbilityReqBo reqBo) {
        CompletableFuture.runAsync(() -> {
            try {
                Long orderId = reqBo.getOrderId();
                ApprovalLogPO approvalLogPO = new ApprovalLogPO();
                approvalLogPO.setOrderId(orderId);
                List list = this.approvalLogMapper.getList(approvalLogPO);
                if (list.isEmpty()) {
                    log.error("\u5220\u9664\u534f\u540c\u5f85\u529e\u6d41\u7a0b \u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u8bb0\u5f55\u5f02\u5e38, orderId: {}", (Object)orderId);
                    return;
                }
                Map<Long, List<ApprovalLogPO>> collect = list.stream().collect(Collectors.groupingBy(ApprovalLogPO::getAuditOrderId));
                for (Long auditId : collect.keySet()) {
                    List<ApprovalLogPO> approvalLogPOS = collect.get(auditId);
                    Long auditOrderId = approvalLogPOS.get(0).getAuditOrderId();
                    TodoDeleteWaitDoneAbilityReqBO todoDeleteWaitDoneAbilityReqBO = new TodoDeleteWaitDoneAbilityReqBO();
                    todoDeleteWaitDoneAbilityReqBO.setUserHandlerNo(reqBo.getUsername());
                    todoDeleteWaitDoneAbilityReqBO.setObjId(reqBo.getOrderId().toString());
                    todoDeleteWaitDoneAbilityReqBO.setFlowId(auditOrderId.toString());
                    this.todoWaitDoneWriteAbilityService.deleteWaitDone(todoDeleteWaitDoneAbilityReqBO);
                }
            }
            catch (EmptyResultDataAccessException e) {
                log.error("\u5220\u9664\u534f\u540c\u5f85\u529e\u6d41\u7a0b \u6570\u636e\u4e0d\u5b58\u5728, orderId: {}", (Object)reqBo.getOrderId(), (Object)e);
            }
            catch (NoSuchElementException e) {
                log.error("\u5ba1\u6279\u5386\u53f2\u8bb0\u5f55\u4e3a\u7a7a, orderId: {}", (Object)reqBo.getOrderId(), (Object)e);
            }
            catch (NullPointerException e) {
                log.error("\u5220\u9664\u534f\u540c\u5f85\u529e\u6d41\u7a0b \u51fa\u73b0\u7a7a\u6307\u9488\u5f02\u5e38, orderId: {}", (Object)reqBo.getOrderId(), (Object)e);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u534f\u540c\u5f85\u529e\u6d41\u7a0b \u5176\u4ed6\u5f02\u5e38, orderId: {}", (Object)reqBo.getOrderId(), (Object)e);
            }
        });
    }

    private void validateArgs(UocProOrderDeleteAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104039", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new UocProBusinessException("104039", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleVoucherId() || 0L == reqBo.getSaleVoucherId()) {
            throw new UocProBusinessException("104039", "\u5165\u53c2\u5bf9\u8c61[saleVoucherId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void stateCheck(UocProOrderDeleteAbilityReqBo reqBo) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode("ORDER_DELETE");
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setObjId(reqBo.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBo.getOrderId());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
        }
        reqBo.setSaleState(Integer.valueOf(uocCoreStateCheck.getObjState()));
    }

    private void syncSale(UocProOrderDeleteAbilityReqBo reqBo) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(reqBo.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

