/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocProQryPurchasedGoodsAndSalesOfSupAbilityService;
import com.tydic.uoc.common.ability.bo.UocProQryPurchasedGoodsAndSalesSupReqBo;
import com.tydic.uoc.common.ability.bo.UocProQryPurchasedGoodsAndSalesSupRspBo;
import com.tydic.uoc.common.ability.bo.UocProQryPurchasedGoodsBo;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProQryPurchasedGoodsAndSalesOfSupAbilityService"})
public class UocProQryPurchasedGoodsAndSalesOfSupAbilityServiceImpl
implements UocProQryPurchasedGoodsAndSalesOfSupAbilityService {
    public static final String COMMODITY_ENTRY = "1";
    public static final String SHOP_ENTRY = "2";
    @Autowired
    OrdGoodsMapper ordGoodsMapper;

    @PostMapping(value={"uocQryPurchasedGoodsAndSalesOfSup"})
    public UocProQryPurchasedGoodsAndSalesSupRspBo uocQryPurchasedGoodsAndSalesOfSup(@RequestBody UocProQryPurchasedGoodsAndSalesSupReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("100001", "\u63a5\u53e3\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getEntryCategory() == null) {
            throw new UocProBusinessException("100001", "\u63a5\u53e3\u5165\u53c2\u3010entryCategory\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List uocProQryPurchasedGoodsBos = null;
        UocProQryPurchasedGoodsAndSalesSupRspBo rsp = (UocProQryPurchasedGoodsAndSalesSupRspBo)UocProRspBoUtil.success(UocProQryPurchasedGoodsAndSalesSupRspBo.class);
        List ordGoodsPOList = null;
        try {
            if (COMMODITY_ENTRY.equals(reqBo.getEntryCategory())) {
                if (StringUtils.isBlank((CharSequence)reqBo.getSupNo()) || reqBo.getPurId() == null || reqBo.getPurId() == 0L) {
                    throw new UocProBusinessException("100001", "\u4f9b\u5e94\u5546\u7f16\u7801supNo\u3001\u7528\u6237\u7f16\u7801userId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ordGoodsPOList = this.ordGoodsMapper.getListBySupNoAndPurNo(reqBo.getSupNo(), String.valueOf(reqBo.getPurId()));
                if (ordGoodsPOList != null && ordGoodsPOList.size() >= 100) {
                    uocProQryPurchasedGoodsBos = ordGoodsPOList.stream().map(item -> this.covert((OrdGoodsPO)item)).collect(Collectors.toList());
                }
            } else if (SHOP_ENTRY.equals(reqBo.getEntryCategory())) {
                if (reqBo.getPurId() == null || reqBo.getPurId() == 0L) {
                    throw new UocProBusinessException("100001", "\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ordGoodsPOList = this.ordGoodsMapper.getListBySupNoAndPurNo(null, String.valueOf(reqBo.getPurId()));
                uocProQryPurchasedGoodsBos = ordGoodsPOList.stream().map(item -> this.covert((OrdGoodsPO)item)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        rsp.setPurchasedGoodsBoList(uocProQryPurchasedGoodsBos);
        return rsp;
    }

    private UocProQryPurchasedGoodsBo covert(OrdGoodsPO ordGoodsPO) {
        UocProQryPurchasedGoodsBo uocProQryPurchasedGoodsBo = new UocProQryPurchasedGoodsBo();
        uocProQryPurchasedGoodsBo.setSkuName(ordGoodsPO.getSkuName());
        uocProQryPurchasedGoodsBo.setSkuMainPicUrl(ordGoodsPO.getSkuMainPicUrl());
        uocProQryPurchasedGoodsBo.setSkuSalePrice(ordGoodsPO.getSkuSalePrice());
        return uocProQryPurchasedGoodsBo;
    }
}

