/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocPushContractPreMoneyPayLineAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPreMoneyTaskBO;
import com.tydic.uoc.common.ability.bo.UocPushContractPreMoneyPayLineAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPushContractPreMoneyPayLineAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPushContractTzHeadChangeBO;
import com.tydic.uoc.common.ability.bo.UocPushContractTzPayLineChangeBO;
import com.tydic.uoc.common.busi.api.UocPushContractTzBusiService;
import com.tydic.uoc.common.busi.bo.UocPushContractTzChangeBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPushContractTzChangeBusiRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdProContractHeadMapper;
import com.tydic.uoc.dao.UocOrdProContractMapper;
import com.tydic.uoc.dao.UocPreMoneyTaskMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdProContractHeadPO;
import com.tydic.uoc.po.UocOrdProContractPO;
import com.tydic.uoc.po.UocPreMoneyTaskPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPushContractPreMoneyPayLineAbilityService"})
public class UocPushContractPreMoneyPayLineAbilityServiceImpl
implements UocPushContractPreMoneyPayLineAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocPushContractPreMoneyPayLineAbilityServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdProContractHeadMapper uocOrdProContractHeadMapper;
    @Autowired
    private UocOrdProContractMapper uocOrdProContractMapper;
    @Value(value="${settle.stage:TWO}")
    private String settleStage;
    @Autowired
    private UocPushContractTzBusiService uocPushContractTzBusiService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private UocPreMoneyTaskMapper uocPreMoneyTaskMapper;

    @PostMapping(value={"dealPreMoney"})
    public UocPushContractPreMoneyPayLineAbilityRspBO dealPreMoney(@RequestBody UocPushContractPreMoneyPayLineAbilityReqBO reqBO) {
        UocPreMoneyTaskBO taskBO = reqBO.getTaskBO();
        Long orderId = taskBO.getOrderId();
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        if (orderPO.getUpperOrderId() != null) {
            orderId = orderPO.getUpperOrderId();
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        Boolean canPushFlag = this.valCanPush(ordSalePO);
        if (!canPushFlag.booleanValue()) {
            throw new BusinessException("8888", "\u8ba2\u5355\u4e0d\u7b26\u5408\u63a8\u9001\u6761\u4ef6");
        }
        UocOrdProContractPO contractPO = new UocOrdProContractPO();
        contractPO.setOrderId(orderId);
        contractPO = this.uocOrdProContractMapper.getModelBy(contractPO);
        if (contractPO == null) {
            throw new BusinessException("8888", "\u8ba2\u5355\u67e5\u8be2\u9500\u552e\u5408\u540c\u5931\u8d25");
        }
        UocOrdProContractHeadPO headPO = new UocOrdProContractHeadPO();
        headPO.setEgContractId(contractPO.getContractId());
        headPO = this.uocOrdProContractHeadMapper.getModelBy(headPO);
        if (headPO == null) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5408\u540c\u5934\u8868\u5931\u8d25");
        }
        UocPushContractTzHeadChangeBO uocPushContractTzHeadChangeBO = this.buildHeadChange(headPO);
        ArrayList<UocPushContractTzPayLineChangeBO> payLineBOS = new ArrayList<UocPushContractTzPayLineChangeBO>();
        this.coverPayLineChange(reqBO.getTaskBO(), payLineBOS, headPO);
        PebExtUnifySettleTokenQryAbilityRspBO tokenRspBO = this.qryToken(headPO.getExt1());
        String token = tokenRspBO.getData();
        UocPreMoneyTaskPO uocPreMoneyTaskPO = new UocPreMoneyTaskPO();
        uocPreMoneyTaskPO.setTaskId(taskBO.getTaskId());
        uocPreMoneyTaskPO = this.uocPreMoneyTaskMapper.getModelBy(uocPreMoneyTaskPO);
        if (uocPreMoneyTaskPO.getTaskStatus() != 3) {
            UocPushContractTzChangeBusiReqBO busiReqBO = new UocPushContractTzChangeBusiReqBO();
            busiReqBO.setToken(token);
            busiReqBO.setHeadChangeBO(uocPushContractTzHeadChangeBO);
            busiReqBO.setPayLineBOS(payLineBOS);
            busiReqBO.setOrderId(ordSalePO.getOrderId());
            busiReqBO.setSaleVoucherNo(ordSalePO.getSaleVoucherNo());
            UocPushContractTzChangeBusiRspBO uocPushContractTzChangeBusiRspBO = this.uocPushContractTzBusiService.dealPushContractTzPreMoney(busiReqBO);
            return (UocPushContractPreMoneyPayLineAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)uocPushContractTzChangeBusiRspBO)), UocPushContractPreMoneyPayLineAbilityRspBO.class);
        }
        log.info("taskId = " + taskBO.getTaskId() + "\u5df2\u6267\u884c\u6210\u529f!");
        UocPushContractPreMoneyPayLineAbilityRspBO uocPushContractPreMoneyPayLineAbilityRspBO = new UocPushContractPreMoneyPayLineAbilityRspBO();
        uocPushContractPreMoneyPayLineAbilityRspBO.setRespCode("0000");
        uocPushContractPreMoneyPayLineAbilityRspBO.setRespDesc("\u6267\u884c\u6210\u529f");
        return uocPushContractPreMoneyPayLineAbilityRspBO;
    }

    private PebExtUnifySettleTokenQryAbilityRspBO qryToken(String agentAccount) {
        if (StringUtils.isEmpty((CharSequence)agentAccount)) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u4e0b\u5355\u4ebaERP\u8d26\u53f7\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAtomReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAtomReqBO.setUserId(agentAccount);
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAtomRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAtomReqBO);
        if (!tokenQryAtomRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(tokenQryAtomRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97token\u5931\u8d25\uff01" + tokenQryAtomRspBO.getRespDesc());
        }
        return tokenQryAtomRspBO;
    }

    private void coverPayLineChange(UocPreMoneyTaskBO taskBO, List<UocPushContractTzPayLineChangeBO> payLineBOS, UocOrdProContractHeadPO headPO) {
        UocPushContractTzPayLineChangeBO payScheduleBO = new UocPushContractTzPayLineChangeBO();
        payScheduleBO.setPAY_TYPE("PRE");
        payScheduleBO.setPAY_TYPE_DIS("\u9884\u4ed8\u6b3e");
        payScheduleBO.setPAY_SCAL(taskBO.getPayScal());
        payScheduleBO.setPAY_AMOUNT(taskBO.getPayAmount());
        if (StringUtils.isNotBlank((CharSequence)taskBO.getExt3()) && taskBO.getPayScal() != null && StringUtils.isNotBlank((CharSequence)taskBO.getExt2())) {
            payScheduleBO.setPAY_DESC(taskBO.getExt2() + taskBO.getExt3() + "\u5929\u4ed8" + taskBO.getPayScal().stripTrailingZeros().toPlainString() + "%");
        }
        payScheduleBO.setORG_ID(headPO.getOrgId());
        payScheduleBO.setUSER_ID(headPO.getUserId());
        payScheduleBO.setHANDLE_TYPE("ADD");
        payScheduleBO.setEG_PAY_TERMS_ID(taskBO.getEgPayTermsId());
        payScheduleBO.setORG_NAME(headPO.getOrgName());
        if (StringUtils.isNotBlank((CharSequence)taskBO.getExt4())) {
            payScheduleBO.setPAY_DATE(taskBO.getExt4());
        }
        payLineBOS.add(payScheduleBO);
    }

    private UocPushContractTzHeadChangeBO buildHeadChange(UocOrdProContractHeadPO qryContract) {
        UocPushContractTzHeadChangeBO bo = new UocPushContractTzHeadChangeBO();
        bo.setCHG_TYPE("ORDER");
        bo.setCONTRACT_NUM(qryContract.getContractNum());
        bo.setN_PAY_TERMS("16");
        bo.setN_PAY_TERMS_DIS("\u6309\u5408\u540c\u7ea6\u5b9a");
        bo.setN_PERSON_ID(qryContract.getPersonId());
        bo.setN_PERSON_NAME(qryContract.getPersonName());
        bo.setN_DEPT_ID(qryContract.getDeptId());
        bo.setN_DEPT_NAME(qryContract.getDeptName());
        bo.setSTATUS("Y");
        bo.setORG_NAME(qryContract.getOrgName());
        bo.setORG_ID(qryContract.getOrgId());
        bo.setEG_CHANGE_ID(qryContract.getEgContractId() + "");
        bo.setSTAGE(this.settleStage);
        return bo;
    }

    private Boolean valCanPush(OrdSalePO ordSalePO) {
        Boolean canPush = false;
        if ("2".equals(ordSalePO.getOrderSource())) {
            canPush = true;
        } else if ("1".equals(ordSalePO.getOrderSource()) && UocCoreConstant.ModelSettle.TRADING.equals(ordSalePO.getModelSettle())) {
            canPush = true;
        } else if ("3".equals(ordSalePO.getOrderSource()) && UocCoreConstant.ModelSettle.MATCH_UP.equals(ordSalePO.getModelSettle())) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(ordSalePO.getOrderId());
            orderPO = this.orderMapper.getModelBy(orderPO);
            List<Integer> orderTypeList = Arrays.asList(3, 7);
            canPush = orderTypeList.contains(orderPO.getOrderType()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return canPush;
    }
}

