/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.umc.busi.ability.api.UmcOnlineConditionExportAbilityService;
import com.tydic.umc.busi.ability.bo.UmcOnlineConditionExportReqBo;
import com.tydic.umc.busi.ability.bo.UmcOnlineConditionExportRspBo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.common.ability.api.UocPushG7ShipAbilityService;
import com.tydic.uoc.common.ability.bo.UocPushG7ShipReqBO;
import com.tydic.uoc.common.ability.bo.UocPushG7ShipRspBO;
import com.tydic.uoc.common.busi.api.UocPushG7ShipBusiService;
import com.tydic.uoc.common.utils.g7.G7HttpUtil;
import com.tydic.uoc.common.utils.g7.G7RspBO;
import com.tydic.uoc.common.utils.g7.G7TaskBO;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocG7PushLogMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocShipGsevenCatchMapper;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocG7PushLogPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocShipGsevenCatchPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPushG7ShipAbilityService"})
public class UocPushG7ShipAbilityServiceImpl
implements UocPushG7ShipAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocPushG7ShipAbilityServiceImpl.class);
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private UocG7PushLogMapper uocG7PushLogMapper;
    @Autowired
    private UmcOnlineConditionExportAbilityService umcOnlineConditionExportAbilityService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Value(value="${uoc.g7.startLocationRadius:2000}")
    private Integer startLocationRadius;
    @Value(value="${uoc.g7.endLocationRadius:2000}")
    private Integer endLocationRadius;
    @Value(value="${uoc.g7.baseUrl:http://demo.dsp.chinawayltd.com/altair/rest}")
    private String baseUrl;
    @Value(value="${uoc.g7.taskPath:/v1/api/etoe/add_task_list}")
    private String taskPath;
    @Value(value="${uoc.g7.statePath:/v1/api/etoe/update_task_main_status}")
    private String statePath;
    @Value(value="${uoc.g7.qryPath:/v1/api/etoe/get_lookout_tower_share}")
    private String qryPath;
    @Value(value="${uoc.g7.accessId:wibp9z}")
    private String accessId;
    @Value(value="${uoc.g7.secretKey:b6girmjvs7s0czkvhhlobdehhb7wpzeh}")
    private String secretKey;
    @Autowired
    private UocShipGsevenCatchMapper uocShipGsevenCatchMapper;
    @Autowired
    private UocPushG7ShipBusiService uocPushG7ShipBusiService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @PostMapping(value={"dealPush"})
    public UocPushG7ShipRspBO dealPush(@RequestBody UocPushG7ShipReqBO reqBo) {
        UocPushG7ShipRspBO rspBO = new UocPushG7ShipRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (PebExtConstant.YES.equals(reqBo.getType())) {
            OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBo.getShipVoucherId().longValue());
            if (PebExtConstant.ER.toString().equals(ordShipPO.getShipCompanyId())) {
                return rspBO;
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(ordShipPO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            OrdLogisticsRelaPO relaPO = new OrdLogisticsRelaPO();
            OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
            stakeholderPO.setOrderId(ordShipPO.getOrderId());
            stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
            relaPO.setContactId(salePO.getContactId());
            relaPO = this.ordLogisticsRelaMapper.getModelBy(relaPO);
            UocOrdZmInfoPO infoPO = new UocOrdZmInfoPO();
            infoPO.setOrderId(ordShipPO.getOrderId());
            infoPO = this.uocOrdZmInfoMapper.selectOne(infoPO);
            this.dealPush(ordShipPO, relaPO, infoPO, reqBo, salePO, stakeholderPO);
            reqBo.setObjectId(reqBo.getShipVoucherId());
            reqBo.setObjectNo(ordShipPO.getShipVoucherCode());
            return this.uocPushG7ShipBusiService.dealPush(reqBo);
        }
        UocG7PushLogPO uocG7PushLogPO = new UocG7PushLogPO();
        uocG7PushLogPO.setObjectId(reqBo.getShipVoucherId());
        uocG7PushLogPO = this.uocG7PushLogMapper.getModelBy(uocG7PushLogPO);
        if (uocG7PushLogPO == null || uocG7PushLogPO.getId() == null) {
            return rspBO;
        }
        if (!PebExtConstant.YES.equals(uocG7PushLogPO.getPushStatus())) {
            return rspBO;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("missionNo", (Object)uocG7PushLogPO.getObjectNo());
        jsonObject.put("taskStatus", (Object)reqBo.getState());
        String result = G7HttpUtil.post(this.baseUrl, this.statePath, this.accessId, this.secretKey, jsonObject.toJSONString());
        log.info("G7" + reqBo.getState() + "\u63a8\u9001\u7ed3\u679c:" + result);
        return rspBO;
    }

    private void dealPush(OrdShipPO ordShipPO, OrdLogisticsRelaPO relaPO, UocOrdZmInfoPO infoPO, UocPushG7ShipReqBO reqBO, OrdSalePO salePO, OrdStakeholderPO stakeholderPO) {
        G7TaskBO g7TaskBO = this.buildG7TaskBO(ordShipPO, relaPO, infoPO);
        g7TaskBO.setExt_purchase_order_number(salePO.getSaleVoucherNo());
        g7TaskBO.setExt_supplier_name(stakeholderPO.getSupName());
        String reqJson = JSONObject.toJSONString((Object)g7TaskBO);
        String result = G7HttpUtil.post(this.baseUrl, this.taskPath, this.accessId, this.secretKey, reqJson);
        reqBO.setPushData(reqJson);
        reqBO.setRespData(result);
    }

    private G7TaskBO buildG7TaskBO(OrdShipPO ordShipPO, OrdLogisticsRelaPO relaPO, UocOrdZmInfoPO infoPO) {
        UmcOnlineConditionExportReqBo reqBo = new UmcOnlineConditionExportReqBo();
        reqBo.setOrgId(Long.valueOf(infoPO.getExt3()));
        G7TaskBO g7TaskBO = new G7TaskBO();
        try {
            UmcOnlineConditionExportRspBo rspBo = this.umcOnlineConditionExportAbilityService.getTwo(reqBo);
            g7TaskBO.setTaskDepartmentName(rspBo.getUnitName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        g7TaskBO.setMissionNo(ordShipPO.getShipVoucherCode());
        g7TaskBO.setVehicleNo(ordShipPO.getPackageId());
        g7TaskBO.setStartLocationName(ordShipPO.getProvinceName() + ordShipPO.getCityName() + ordShipPO.getCountyName() + ordShipPO.getTownName() + ordShipPO.getDetailAddress());
        g7TaskBO.setStartLocationAddress(ordShipPO.getProvinceName() + ordShipPO.getCityName() + ordShipPO.getCountyName() + ordShipPO.getTownName() + ordShipPO.getDetailAddress());
        g7TaskBO.setStartLocationRadius(this.startLocationRadius);
        g7TaskBO.setEndLocationName(relaPO.getContactProvinceName() + relaPO.getContactCityName() + relaPO.getContactCountyName() + relaPO.getContactTown() + relaPO.getContactAddress());
        g7TaskBO.setEndLocationAddress(relaPO.getContactProvinceName() + relaPO.getContactCityName() + relaPO.getContactCountyName() + relaPO.getContactTown() + relaPO.getContactAddress());
        g7TaskBO.setEndLocationRadius(this.endLocationRadius);
        g7TaskBO.setEstimatedStartTime(ordShipPO.getShipTime());
        g7TaskBO.setEstimatedEndTime(ordShipPO.getEstimateArrivalTime());
        g7TaskBO.setDriverName(ordShipPO.getDriverName());
        g7TaskBO.setDriverPhone(ordShipPO.getDriverPhone());
        return g7TaskBO;
    }

    @PostMapping(value={"dealRePush"})
    public UocPushG7ShipRspBO dealRePush(@RequestBody UocPushG7ShipReqBO reqBo) {
        List fail = this.uocG7PushLogMapper.getFailList();
        for (UocG7PushLogPO uocG7PushLogPO : fail) {
            OrdShipPO ordShipPO = this.ordShipMapper.getModelById(uocG7PushLogPO.getObjectId().longValue());
            if (ordShipPO == null || ordShipPO.getOrderId() == null) continue;
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(ordShipPO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            OrdLogisticsRelaPO relaPO = new OrdLogisticsRelaPO();
            relaPO.setContactId(salePO.getContactId());
            relaPO = this.ordLogisticsRelaMapper.getModelBy(relaPO);
            UocOrdZmInfoPO infoPO = new UocOrdZmInfoPO();
            infoPO.setOrderId(ordShipPO.getOrderId());
            infoPO = this.uocOrdZmInfoMapper.selectOne(infoPO);
            OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
            stakeholderPO.setOrderId(ordShipPO.getOrderId());
            stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
            this.dealPush(ordShipPO, relaPO, infoPO, reqBo, salePO, stakeholderPO);
            reqBo.setId(uocG7PushLogPO.getId());
            this.uocPushG7ShipBusiService.dealUpdate(reqBo);
        }
        UocPushG7ShipRspBO rspBO = new UocPushG7ShipRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"qryDetail"})
    public UocPushG7ShipRspBO qryDetail(@RequestBody UocPushG7ShipReqBO reqBo) {
        OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBo.getShipVoucherId().longValue());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("missionNo", (Object)ordShipPO.getShipVoucherCode());
        jsonObject.put("shardingType", (Object)reqBo.getShardingType());
        String result = G7HttpUtil.post(this.baseUrl, this.qryPath, this.accessId, this.secretKey, jsonObject.toJSONString());
        UocPushG7ShipRspBO rspBO = new UocPushG7ShipRspBO();
        if (StringUtils.isBlank((CharSequence)result)) {
            rspBO.setRespDesc("\u67e5\u8be2G7\u7269\u6d41\u65e0\u8fd4\u56de\u7ed3\u679c");
            rspBO.setRespCode("\u5931\u8d25");
            UocShipGsevenCatchPO ca = new UocShipGsevenCatchPO();
            ca.setShipVoucherId(ordShipPO.getShipVoucherId());
            ca.setOrderId(ordShipPO.getOrderId());
            ca.setShipVoucherCode(ordShipPO.getShipVoucherCode());
            UocShipGsevenCatchPO modelBy = this.uocShipGsevenCatchMapper.getModelBy(ca);
            if (ObjectUtil.isEmpty((Object)modelBy) || StringUtils.isEmpty((CharSequence)modelBy.getContent())) return rspBO;
            result = modelBy.getContent();
        } else {
            try {
                UocShipGsevenCatchPO catchPO = new UocShipGsevenCatchPO();
                catchPO.setShipVoucherId(ordShipPO.getShipVoucherId());
                catchPO.setOrderId(ordShipPO.getOrderId());
                catchPO.setShipVoucherCode(ordShipPO.getShipVoucherCode());
                this.uocShipGsevenCatchMapper.deleteBy(catchPO);
                catchPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                catchPO.setCreateTime(new Date());
                catchPO.setContent(result);
                this.uocShipGsevenCatchMapper.insert(catchPO);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u7f13\u5b58\u5931\u8d25" + e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        G7RspBO g7RspBO = (G7RspBO)JSONObject.parseObject((String)result, G7RspBO.class);
        if (PebExtConstant.YES.toString().equals(g7RspBO.getCode())) {
            rspBO.setRespDesc(g7RspBO.getMsg());
            return rspBO;
        }
        rspBO.setUrl(g7RspBO.getData());
        return rspBO;
    }
}

