/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocQueryOrdersInTransitAbilityService;
import com.tydic.uoc.common.ability.bo.UocQueryOrdersInTransitReqBo;
import com.tydic.uoc.common.ability.bo.UocQueryOrdersInTransitRspBo;
import com.tydic.uoc.common.ability.bo.UocQueryOrdersInTransitRspBoRows;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.po.OrdItemMapPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocQueryOrdersInTransitAbilityService"})
public class UocQueryOrdersInTransitAbilityServiceImpl
implements UocQueryOrdersInTransitAbilityService {
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    @Value(value="${uoc.order.detail:http://172.16.8.99/#/}")
    private String detail;
    @Value(value="${SUPPLIER_JD_ID:100055}")
    private Long supplierIdJD;
    @Value(value="${SUPPLIER_SUNING_ID:100057}")
    private Long supplierIdSn;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;

    @PostMapping(value={"queryOrdersInTransit"})
    public UocQueryOrdersInTransitRspBo queryOrdersInTransit(@RequestBody UocQueryOrdersInTransitReqBo reqBo) {
        this.val(reqBo);
        List rows = this.ordItemMapper.getTransOrderList(reqBo);
        UocQueryOrdersInTransitRspBo rspBo = new UocQueryOrdersInTransitRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRows(rows);
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            List dicDictionaries = this.sysDicDictionaryMapper.selectByPCode("SALE_ORDER_STATUS");
            Map<Integer, String> statusMap = dicDictionaries.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCode()) && StringUtils.isNotBlank((CharSequence)e.getDescrip())).collect(Collectors.toMap(e -> Integer.parseInt(e.getCode()), e -> e.getDescrip(), (k, v) -> k));
            List ordItemIds = rows.stream().map(e -> e.getOrdItemId()).collect(Collectors.toList());
            Map<Object, Object> itemMap = new HashMap();
            if (!CollectionUtils.isEmpty(ordItemIds)) {
                OrdItemMapPO ordItemMapCondition = new OrdItemMapPO();
                ordItemMapCondition.setOrdItemIdList(ordItemIds);
                ordItemMapCondition.setFieldCode("inboundPath");
                List ordItemMapList = this.ordItemMapMapper.getList(ordItemMapCondition);
                if (!CollectionUtils.isEmpty((Collection)ordItemMapList)) {
                    itemMap = ordItemMapList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getFieldValue()) && e.getOrderItemId() != null).collect(Collectors.toMap(e -> e.getOrderItemId(), e -> e.getFieldValue(), (k, v) -> v));
                }
            }
            for (UocQueryOrdersInTransitRspBoRows row : rows) {
                String[] split;
                row.setSaleStatusStr(statusMap.get(row.getSaleStatus()));
                row.setOrderTypeName("\u91c7\u8d2d\u8ba2\u5355");
                if (this.supplierIdSn.equals(row.getSupplierId())) {
                    row.setSaleVoucherNo(row.getUpperSaleVoucherNo());
                    row.setSaleStatusStr("\u5df2\u62c6\u5355");
                }
                if (this.supplierIdJD.equals(row.getSupplierId()) && Integer.valueOf(1).equals(row.getIsPlanOrder())) {
                    row.setSaleVoucherNo(row.getUpperSaleVoucherNo());
                    row.setSaleStatusStr("\u5df2\u62c6\u5355");
                }
                row.setPurchaseCount(this.coverCount(row.getPurchaseCount()));
                row.setAcceptanceCount(this.coverCount(row.getAcceptanceCount()));
                row.setRefuseCount(this.coverCount(row.getRefuseCount()));
                row.setReturnCount(this.coverCount(row.getReturnCount()));
                row.setPlanCount(this.coverCount(row.getPlanCount()));
                row.setInboundQuantity(this.coverCount(row.getInboundQuantity()));
                row.setPlanId(row.getLineId());
                String inboundPath = (String)itemMap.get(row.getOrdItemId());
                if (StringUtils.isBlank((CharSequence)inboundPath) || (split = inboundPath.split("-", 2)).length <= 1) continue;
                row.setInboundPath(split[1]);
            }
        }
        return rspBo;
    }

    BigDecimal coverCount(BigDecimal count) {
        if (count == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(count.stripTrailingZeros().toPlainString());
    }

    private void val(UocQueryOrdersInTransitReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getMatCodes())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u7269\u6599\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String matCode : reqBo.getMatCodes()) {
            if (!StringUtils.isBlank((CharSequence)matCode)) continue;
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrganizationId() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u5e93\u5b58\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreateTimeStart() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u521b\u5efa\u65f6\u95f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreateTimeEnd() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u521b\u5efa\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

