/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocQueryPurchaseInTransitAbilityService;
import com.tydic.uoc.common.ability.bo.UocQueryPurchaseInTransitReqBo;
import com.tydic.uoc.common.ability.bo.UocQueryPurchaseInTransitRspBo;
import com.tydic.uoc.common.ability.bo.UocQueryPurchaseInTransitRspBoRows;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.dao.UocPlanDiversionItemMapper;
import com.tydic.uoc.dao.UocPlanDiversionMapper;
import com.tydic.uoc.po.UocPlanDiversionItemPO;
import com.tydic.uoc.po.UocPlanDiversionPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocQueryPurchaseInTransitAbilityService"})
public class UocQueryPurchaseInTransitAbilityServiceImpl
implements UocQueryPurchaseInTransitAbilityService {
    @Autowired
    private UocPlanDiversionMapper uocPlanDiversionMapper;
    @Autowired
    private UocPlanDiversionItemMapper uocPlanDiversionItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @PostMapping(value={"queryPurchaseInTransit"})
    public UocQueryPurchaseInTransitRspBo queryPurchaseInTransit(@RequestBody UocQueryPurchaseInTransitReqBo reqBo) {
        List orderRows;
        this.val(reqBo);
        UocQueryPurchaseInTransitRspBo rspBo = new UocQueryPurchaseInTransitRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UocPlanDiversionPO uocPlanDiversionPO = new UocPlanDiversionPO();
        uocPlanDiversionPO.setItemNos(reqBo.getMatCodes());
        uocPlanDiversionPO.setErpOrgId(reqBo.getOrganizationId());
        uocPlanDiversionPO.setCreatedDateStart(reqBo.getCreateTimeStart());
        uocPlanDiversionPO.setCreatedDateEnd(reqBo.getCreateTimeEnd());
        List<String> planStatusList = Arrays.asList("100", "101", "102", "103");
        uocPlanDiversionPO.setPlanStatusList(planStatusList);
        List qryPlanList = this.uocPlanDiversionMapper.getList(uocPlanDiversionPO);
        Map<Long, UocPlanDiversionPO> planMap = qryPlanList.stream().collect(Collectors.toMap(e -> e.getPlanId(), e -> e, (k, v) -> k));
        ArrayList<UocQueryPurchaseInTransitRspBoRows> rows = new ArrayList<UocQueryPurchaseInTransitRspBoRows>();
        Map<Object, Object> planIdGroup = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)qryPlanList)) {
            List dzxList;
            List planIds = qryPlanList.stream().filter(e -> "101".equals(e.getPlanStatus()) || "102".equals(e.getPlanStatus())).map(e -> e.getPlanId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planIds)) {
                UocPlanDiversionItemPO uocPlanDiversionItemPO = new UocPlanDiversionItemPO();
                uocPlanDiversionItemPO.setPlanIds(planIds);
                uocPlanDiversionItemPO.setMatchStatus("1");
                Iterator list = this.uocPlanDiversionItemMapper.getList(uocPlanDiversionItemPO);
                planIdGroup = list.stream().filter(e -> e.getPlanId() != null).collect(Collectors.groupingBy(e -> e.getPlanId()));
            }
            if (!CollectionUtils.isEmpty(dzxList = qryPlanList.stream().filter(e -> "100".equals(e.getPlanStatus()) || "103".equals(e.getPlanStatus())).collect(Collectors.toList()))) {
                for (UocPlanDiversionPO planPo : dzxList) {
                    UocQueryPurchaseInTransitRspBoRows row = new UocQueryPurchaseInTransitRspBoRows();
                    row.setOrganizationName(planPo.getErpOrganizationName());
                    row.setMatCode(planPo.getItemNo());
                    row.setPlanNo(planPo.getScheduleNo());
                    row.setMatDesc(planPo.getItemDesc());
                    row.setMatUnit(planPo.getUomCode());
                    row.setObjTypeStr("\u8ba1\u5212\u5206\u6d41");
                    row.setObjNo(planPo.getScheduleNo());
                    row.setObjStatusStr("\u8ba1\u5212\u5f85\u6267\u884c");
                    row.setCount(planPo.getQuantity());
                    row.setPlanCount(planPo.getQuantity());
                    row.setCreateTime(planPo.getCreatedDate());
                    row.setPlanId(planPo.getPlanId());
                    rows.add(row);
                }
            }
            if (!CollectionUtils.isEmpty(planIdGroup.keySet())) {
                for (Long planId : planIdGroup.keySet()) {
                    UocPlanDiversionPO planPo = planMap.get(planId);
                    if (planPo == null) continue;
                    UocQueryPurchaseInTransitRspBoRows row = new UocQueryPurchaseInTransitRspBoRows();
                    row.setOrganizationName(planPo.getErpOrganizationName());
                    row.setMatCode(planPo.getItemNo());
                    row.setPlanNo(planPo.getScheduleNo());
                    row.setMatDesc(planPo.getItemDesc());
                    row.setMatUnit(planPo.getUomCode());
                    row.setObjTypeStr("\u8ba1\u5212\u5206\u6d41");
                    row.setObjNo(planPo.getScheduleNo());
                    UocPlanDiversionItemPO itemPO = (UocPlanDiversionItemPO)((List)planIdGroup.get(planId)).get(0);
                    if ("102".equals(planPo.getPlanStatus()) && Integer.valueOf(1).equals(itemPO.getSkuSource())) {
                        row.setObjStatusStr("\u8d85\u5e02\u5f85\u4e0b\u5355");
                    } else if ("101".equals(planPo.getPlanStatus()) && !Integer.valueOf(2).equals(itemPO.getOrderMethod()) || "102".equals(planPo.getPlanStatus()) && Integer.valueOf(3).equals(itemPO.getSkuSource()) && !Integer.valueOf(2).equals(itemPO.getOrderMethod())) {
                        row.setObjStatusStr("\u534f\u8bae\u5f85\u4e0b\u5355");
                    } else {
                        if ((!"101".equals(planPo.getPlanStatus()) || !Integer.valueOf(2).equals(itemPO.getOrderMethod())) && (!"102".equals(planPo.getPlanStatus()) || !Integer.valueOf(3).equals(itemPO.getSkuSource()) || !Integer.valueOf(2).equals(itemPO.getOrderMethod()))) continue;
                        row.setObjStatusStr("\u534f\u8bae\u5f85\u8bae\u4ef7");
                    }
                    row.setCount(planPo.getQuantity());
                    row.setPlanCount(planPo.getQuantity());
                    row.setCreateTime(planPo.getCreatedDate());
                    row.setPlanId(planPo.getPlanId());
                    rows.add(row);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(orderRows = this.ordItemMapper.getPurchaseInTransitOrder(reqBo)))) {
            List dicDictionaries = this.sysDicDictionaryMapper.selectByPCode("SALE_ORDER_STATUS");
            Map<Integer, String> statusMap = dicDictionaries.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCode()) && StringUtils.isNotBlank((CharSequence)e.getDescrip())).collect(Collectors.toMap(e -> Integer.parseInt(e.getCode()), e -> e.getDescrip(), (k, v) -> k));
            for (UocQueryPurchaseInTransitRspBoRows row : orderRows) {
                if (row.getObjStatus() != null) {
                    row.setObjStatusStr(statusMap.get(row.getObjStatus()));
                }
                if (Integer.valueOf(1101).equals(row.getObjStatus())) {
                    row.setAuditStatusStr("\u8ba2\u5355\u5ba1\u6279\u4e2d");
                    continue;
                }
                row.setAuditStatusStr("\u8ba2\u5355\u5f85\u63d0\u4ea4\u5ba1\u6279");
            }
            rows.addAll(orderRows);
        }
        rspBo.setRows(rows);
        return rspBo;
    }

    @PostMapping(value={"queryPlanInfo"})
    public UocQueryPurchaseInTransitRspBo queryPlanInfo(@RequestBody UocQueryPurchaseInTransitReqBo reqBo) {
        this.valPlan(reqBo);
        UocPlanDiversionPO uocPlanDiversionPO = new UocPlanDiversionPO();
        uocPlanDiversionPO.setPlanIds(reqBo.getPlanIds());
        List qryPlanList = this.uocPlanDiversionMapper.getList(uocPlanDiversionPO);
        ArrayList<UocQueryPurchaseInTransitRspBoRows> rows = new ArrayList<UocQueryPurchaseInTransitRspBoRows>();
        if (CollectionUtils.isEmpty((Collection)qryPlanList)) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba1\u5212\u5931\u8d25");
        }
        for (UocPlanDiversionPO planPo : qryPlanList) {
            UocQueryPurchaseInTransitRspBoRows row = new UocQueryPurchaseInTransitRspBoRows();
            row.setPlanNo(planPo.getScheduleNo());
            row.setPlanId(planPo.getPlanId());
            row.setPlanCount(planPo.getQuantity());
            row.setLineId(planPo.getLineId());
            rows.add(row);
        }
        UocQueryPurchaseInTransitRspBo rspBo = new UocQueryPurchaseInTransitRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRows(rows);
        return rspBo;
    }

    private void valPlan(UocQueryPurchaseInTransitReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getPlanIds())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u8ba1\u5212id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void val(UocQueryPurchaseInTransitReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getMatCodes())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u7269\u6599\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String matCode : reqBo.getMatCodes()) {
            if (!StringUtils.isBlank((CharSequence)matCode)) continue;
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrganizationId() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u5e93\u5b58\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreateTimeStart() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u521b\u5efa\u65f6\u95f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreateTimeEnd() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7684\u521b\u5efa\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

