/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.PebExtPushWarehouseShipAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseShipAtomRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebExtPushWarehouseShipAtomServiceImpl
implements PebExtPushWarehouseShipAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWarehouseShipAtomServiceImpl.class);

    @Override
    public PebExtPushWarehouseShipAtomRspBO pushWarehouseShip(PebExtPushWarehouseShipAtomReqBO reqBO) {
        PebExtPushWarehouseShipAtomRspBO rspBO;
        try {
            String reqStr = this.initPostStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ZM_ORDER_WAREHOUSE_SHIP")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ZM_ORDER_WAREHOUSE_SHIP") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("102001", "\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("106000", "\u63a8\u9001\u4f01\u914d\u4ed3\u53d1\u8d27\u5355\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u8ba2\u5355\u786e\u8ba4\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(PebExtPushWarehouseShipAtomReqBO reqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        String esbReqParam = ESBParamUtil.getEsbReqStr((String)reqBO.getData(), (String)hsn, (String)"BUSINESS_ORDER");
        log.error("\u8c03\u7528\u63a8\u9001\u53d1\u8d27\u5355ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        return esbReqParam;
    }

    private PebExtPushWarehouseShipAtomRspBO resolveRsp(String returnString) {
        log.error("\u8c03\u7528\u8ba2\u5355\u786e\u8ba4ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        PebExtPushWarehouseShipAtomRspBO rspBO = new PebExtPushWarehouseShipAtomRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        rspBO.setRspData(returnString);
        if ("0".equals(jsonObject.getString("code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

