/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocApproveEntrustConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.atom.api.UocConvertNoticeUrlAtomService;
import com.tydic.uoc.common.atom.bo.UocConvertNoticeUrlAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocConvertNoticeUrlAtomRspBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocConvertNoticeUrlAtomServiceImpl
implements UocConvertNoticeUrlAtomService {
    @Value(value="${APPROVE_ENTRUST_NOTICE_JUMP_URL_IP:http://172.20.175.3}")
    private String approveEntrustNoticeJumpUrlIp;
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;

    @Override
    public UocConvertNoticeUrlAtomRspBO convertNoticeUrl(UocConvertNoticeUrlAtomReqBO reqBO) {
        HashMap<Long, String> objIdMap = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty(reqBO.getObjIds()) && reqBO.getObjType() != null && (UocApproveEntrustConstant.ApproveEntrustType.Order.equals(reqBO.getObjType()) || UocApproveEntrustConstant.ApproveEntrustType.SALE.equals(reqBO.getObjType()) || UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder.equals(reqBO.getObjType()))) {
            OrdSalePO searchPO = new OrdSalePO();
            if (UocApproveEntrustConstant.ApproveEntrustType.Order.equals(reqBO.getObjType())) {
                searchPO.setOrderIdList(reqBO.getObjIds());
            } else if (UocApproveEntrustConstant.ApproveEntrustType.SALE.equals(reqBO.getObjType())) {
                searchPO.setSaleVoucherIdList(reqBO.getObjIds());
            } else {
                searchPO.setChangeOrderIdList(reqBO.getObjIds());
            }
            List ordSalePOS = this.ordSaleMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty((Collection)ordSalePOS)) {
                OrderPO searchOrderPO = new OrderPO();
                List orderIdList = ordSalePOS.stream().map(OrdSalePO::getOrderId).collect(Collectors.toList());
                searchOrderPO.setOrderIdList(orderIdList);
                List orderPOS = this.orderMapper.getList(searchOrderPO);
                Map<Object, Object> orderIdMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)orderPOS)) {
                    orderIdMap = orderPOS.stream().collect(Collectors.toMap(OrderPO::getOrderId, o -> o));
                }
                OrdAgreementPO searchAgrPO = new OrdAgreementPO();
                searchAgrPO.setOrderIdList(orderIdList);
                List ordAgreementPOS = this.ordAgreementMapper.selectByCondition(searchAgrPO);
                Map<Object, Object> orderIdAgrMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)ordAgreementPOS)) {
                    orderIdAgrMap = ordAgreementPOS.stream().collect(Collectors.groupingBy(OrdAgreementPO::getOrderId));
                }
                for (OrdSalePO qry : ordSalePOS) {
                    String url = "";
                    if (UocCoreConstant.QUERY_TYPE.CANCEL.equals(reqBO.getIsPriceAdjustmentApproval())) {
                        String agreementId = ((OrdAgreementPO)((List)orderIdAgrMap.get(qry.getOrderId())).get(0)).getAgreementId();
                        url = this.approveEntrustNoticeJumpUrlIp + "/#/index/agrOrderMenuDeatil?type=2&tableType=2&PDFId=&showType=2&planitemId=1&orderId=" + qry.getOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId() + "&showDistributionHistory=0&isproPay=0&protocolId=" + agreementId + "&stampApplyStatus=";
                    } else {
                        OrderPO orderPO = (OrderPO)orderIdMap.get(qry.getOrderId());
                        Long upperOrderId = null;
                        if (orderPO != null) {
                            upperOrderId = orderPO.getUpperOrderId();
                        }
                        String agreementId = "";
                        if (orderIdAgrMap.containsKey(qry.getOrderId())) {
                            agreementId = ((OrdAgreementPO)((List)orderIdAgrMap.get(qry.getOrderId())).get(0)).getAgreementId();
                        }
                        if (UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(qry.getOrderSource())) {
                            url = UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder.equals(reqBO.getObjType()) ? url + this.approveEntrustNoticeJumpUrlIp + "/#/index/replenishmentOrderChangeApplyDeatil?orderId=" + qry.getOrderId() + "&tempId=" + qry.getChangeOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId() + "&type=1&flag=0" : url + this.approveEntrustNoticeJumpUrlIp + "/#/index/replenishmentOrderDeatil?orderId=" + qry.getOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId();
                        } else if (UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(qry.getOrderSource())) {
                            url = this.approveEntrustNoticeJumpUrlIp + "/#/index/orderDetail?type=2&upperVoucherNo=" + qry.getSaleVoucherNo() + "&upperOrderId=" + upperOrderId + "&orderId=" + qry.getOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId() + "&isScFlag=0&erpAccountAliasName=-";
                        } else if (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(qry.getOrderSource()) && UocCoreConstant.TradeMode.TRADE_MODEL.equals(qry.getModelSettle())) {
                            url = this.approveEntrustNoticeJumpUrlIp + "/#/index/agrOrderMenuDeatil?type=2&tableType=2&PDFId=&showType=2&planitemId=1&orderId=" + qry.getOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId() + "&showDistributionHistory=0&isproPay=0&protocolId=" + agreementId + "&stampApplyStatus=";
                        } else if ((UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(qry.getOrderSource()) || UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString().equals(qry.getOrderSource())) && UocCoreConstant.TradeMode.MATCHMAKING_MODE.equals(qry.getModelSettle())) {
                            url = this.approveEntrustNoticeJumpUrlIp + "/#/index/agrOrderMenuDeatil?type=11&tableType=2&PDFId=2&showType=13&planitemId=1&orderId=" + qry.getOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId() + "&showDistributionHistory=0&isproPay=0&protocolId=" + agreementId + "&stampApplyStatus=";
                        } else if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(qry.getOrderSource())) {
                            url = UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder.equals(reqBO.getObjType()) ? url + this.approveEntrustNoticeJumpUrlIp + "/#/index/contractMyChangeApplyDeatil?orderId=" + qry.getOrderId() + "&tempId=" + qry.getChangeOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId() + "&type=1&flag=0" : url + this.approveEntrustNoticeJumpUrlIp + "/#/index/contractOrderMenuDeatil?orderId=" + qry.getOrderId() + "&saleVoucherId=" + qry.getSaleVoucherId();
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)url)) continue;
                    if (UocApproveEntrustConstant.ApproveEntrustType.Order.equals(reqBO.getObjType())) {
                        objIdMap.put(qry.getOrderId(), url);
                    }
                    if (UocApproveEntrustConstant.ApproveEntrustType.SALE.equals(reqBO.getObjType())) {
                        objIdMap.put(qry.getSaleVoucherId(), url);
                    }
                    if (!UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder.equals(reqBO.getObjType())) continue;
                    objIdMap.put(qry.getChangeOrderId(), url);
                }
            }
        }
        UocConvertNoticeUrlAtomRspBO rspBO = new UocConvertNoticeUrlAtomRspBO();
        rspBO.setObjIdMap(objIdMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

