/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.atom.api.UocReturnFeeDealNotaxMoneyAtomService;
import com.tydic.uoc.common.atom.bo.UocReturnFeeDealNotaxMoneyAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeDealNotaxMoneyAtomRspBO;
import com.tydic.uoc.dao.OrdAbnormalMapper;
import com.tydic.uoc.dao.OrdAsItemMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdShipAbnormalItemMapper;
import com.tydic.uoc.dao.OrdShipAbnormalMapper;
import com.tydic.uoc.po.OrdAsItemPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdShipAbnormalItemPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocReturnFeeDealNotaxMoneyAtomServiceImpl
implements UocReturnFeeDealNotaxMoneyAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocReturnFeeDealNotaxMoneyAtomServiceImpl.class);
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private OrdShipAbnormalMapper ordShipAbnormalMapper;
    @Autowired
    private OrdShipAbnormalItemMapper ordShipAbnormalItemMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;

    @Override
    public UocReturnFeeDealNotaxMoneyAtomRspBO getNotaxMoney(UocReturnFeeDealNotaxMoneyAtomReqBO reqBO) {
        UocReturnFeeDealNotaxMoneyAtomRspBO rspBO = new UocReturnFeeDealNotaxMoneyAtomRspBO();
        rspBO.setNoTaxProFee(BigDecimal.ZERO);
        rspBO.setProTaxFee(BigDecimal.ZERO);
        if (reqBO.getObjType() == 1) {
            OrdAsItemPO ordAsItemPO = new OrdAsItemPO();
            ordAsItemPO.setAfterServId(reqBO.getObjId());
            if (ordAsItemPO.getAfterServId() != null) {
                List asItemList = this.ordAsItemMapper.getList(ordAsItemPO);
                BigDecimal totalTaxMoney = BigDecimal.ZERO;
                BigDecimal totalNoTaxAmount = BigDecimal.ZERO;
                Map<Object, Object> itemTaxMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)asItemList)) {
                    List itemIdList = asItemList.stream().filter(e -> e.getOrdItemId() != null).map(e -> e.getOrdItemId()).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(itemIdList)) {
                        OrdItemPO ordItemPO = new OrdItemPO();
                        ordItemPO.setOrdItemIdList(itemIdList);
                        List itemList = this.ordItemMapper.getList(ordItemPO);
                        itemTaxMap = itemList.stream().collect(Collectors.toMap(e -> e.getOrdItemId(), e -> e.getTax()));
                    }
                    for (OrdAsItemPO asItemPO : asItemList) {
                        BigDecimal haveTaxAmount = MoneyUtil.l2B((Long)asItemPO.getRetPurchaseFee());
                        Long taxLong = itemTaxMap.get(asItemPO.getOrdItemId()) == null ? Long.valueOf(0L) : (Long)itemTaxMap.get(asItemPO.getOrdItemId());
                        BigDecimal tax = new BigDecimal(taxLong).multiply(new BigDecimal("0.01"));
                        BigDecimal noTaxAmount = haveTaxAmount.divide(BigDecimal.ONE.add(tax), 2, 4).stripTrailingZeros();
                        BigDecimal taxMoney = haveTaxAmount.subtract(noTaxAmount);
                        totalTaxMoney = totalTaxMoney.add(taxMoney);
                        totalNoTaxAmount = totalNoTaxAmount.add(noTaxAmount);
                    }
                }
                rspBO.setNoTaxProFee(MoneyUtil.coverTwo((BigDecimal)totalNoTaxAmount));
                rspBO.setProTaxFee(MoneyUtil.coverTwo((BigDecimal)totalTaxMoney));
            }
        } else if (reqBO.getObjType() == 2 || reqBO.getObjType() == 3) {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(reqBO.getOrderId());
            if (ordItemPO.getOrderId() != null) {
                List itemList = this.ordItemMapper.getList(ordItemPO);
                BigDecimal totalTaxMoney = BigDecimal.ZERO;
                BigDecimal totalNoTaxAmount = BigDecimal.ZERO;
                for (OrdItemPO itemPO : itemList) {
                    BigDecimal haveTaxAmount = itemPO.getTotalPurchaseDecimalPrice();
                    BigDecimal tax = new BigDecimal(itemPO.getTax()).multiply(new BigDecimal("0.01"));
                    BigDecimal noTaxAmount = haveTaxAmount.divide(BigDecimal.ONE.add(tax), 2, 4).stripTrailingZeros();
                    BigDecimal taxMoney = haveTaxAmount.subtract(noTaxAmount);
                    totalTaxMoney = totalTaxMoney.add(taxMoney);
                    totalNoTaxAmount = totalNoTaxAmount.add(noTaxAmount);
                }
                rspBO.setNoTaxProFee(MoneyUtil.coverTwo((BigDecimal)totalNoTaxAmount));
                rspBO.setProTaxFee(MoneyUtil.coverTwo((BigDecimal)totalTaxMoney));
            }
        } else if (reqBO.getObjType() == 4) {
            BigDecimal totalTaxMoney = BigDecimal.ZERO;
            BigDecimal totalNoTaxAmount = BigDecimal.ZERO;
            List listTax = this.ordShipAbnormalItemMapper.getListTax(reqBO.getObjId());
            if (!CollectionUtils.isEmpty((Collection)listTax)) {
                for (OrdShipAbnormalItemPO po : listTax) {
                    BigDecimal haveTaxAmount = MoneyUtil.l2B((Long)po.getPurchaseChangeFee());
                    BigDecimal tax = new BigDecimal(po.getTax()).multiply(new BigDecimal("0.01"));
                    BigDecimal noTaxAmount = haveTaxAmount.divide(BigDecimal.ONE.add(tax), 2, 4).stripTrailingZeros();
                    BigDecimal taxMoney = haveTaxAmount.subtract(noTaxAmount);
                    totalTaxMoney = totalTaxMoney.add(taxMoney);
                    totalNoTaxAmount = totalNoTaxAmount.add(noTaxAmount);
                }
            }
            rspBO.setNoTaxProFee(MoneyUtil.coverTwo((BigDecimal)totalNoTaxAmount));
            rspBO.setProTaxFee(MoneyUtil.coverTwo((BigDecimal)totalTaxMoney));
        }
        return rspBO;
    }
}

