/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.atom.api.PebExtPushContractLedgerAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushContractLedgerBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerBusiRspBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.UocContractPushLogMapper;
import com.tydic.uoc.dao.UocEcomContractSerialMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.UocContractPushLogPO;
import com.tydic.uoc.po.UocOrdContractPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushContractLedgerBusiServiceImpl
implements PebExtPushContractLedgerBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushContractLedgerBusiServiceImpl.class);
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private PebExtPushContractLedgerAtomService pebExtPushContractLedgerAtomService;
    @Autowired
    private UocContractPushLogMapper uocContractPushLogMapper;
    @Autowired
    private UocEcomContractSerialMapper uocEcomContractSerialMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;

    @Override
    public PebExtPushContractLedgerBusiRspBO dealPushContractLedger(PebExtPushContractLedgerBusiReqBO reqBO) {
        PebExtPushContractLedgerBusiRspBO rspBO = new PebExtPushContractLedgerBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setObjectId(reqBO.getOrderId());
        pushLogPO.setType(UocCoreConstant.PUSH_TYPE.CONTRACT_LEDGER);
        pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        pushLogPO = this.uocContractPushLogMapper.getModelBy(pushLogPO);
        if (pushLogPO != null) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        this.dealPushContract(reqBO, rspBO);
        return rspBO;
    }

    private void dealPushContract(PebExtPushContractLedgerBusiReqBO reqBO, PebExtPushContractLedgerBusiRspBO rspBO) {
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO, reqBO.getReqData(), reqBO.getParseData());
        PebExtPushContractLedgerAtomReqBO atomReqBO = new PebExtPushContractLedgerAtomReqBO();
        atomReqBO.setData(reqBO.getParseData());
        atomReqBO.setToken(reqBO.getToken());
        PebExtPushContractLedgerAtomRspBO atomRspBO = this.pebExtPushContractLedgerAtomService.pushContractLedger(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            this.insertOrderFailLog(reqBO, atomRspBO.getMsg());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
        } else {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            this.insertOrderSuccessLog(reqBO.getOrderId(), reqBO, reqBO.getOrderNo());
        }
        pushLogPO.setRespData(atomRspBO.toString());
        this.uocContractPushLogMapper.insert(pushLogPO);
    }

    private void insertOrderFailLog(PebExtPushContractLedgerBusiReqBO reqBO, String message) {
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderId(reqBO.getOrderId());
        uocOrdContractPO = this.uocOrdContractMapper.getModelBy(uocOrdContractPO);
        if (uocOrdContractPO != null) {
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            uocOrdContractPO.setUpdateTime(new Date());
            uocOrdContractPO.setFailReason(message);
            this.uocOrdContractMapper.update(uocOrdContractPO);
            uocOrdContractPO.setSaleVoucherNo(null);
            uocOrdContractPO.setExt2(reqBO.getOrderId().toString());
            this.uocOrdContractMapper.updateByUpperOrderId(uocOrdContractPO);
        } else {
            uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setExt2(reqBO.getUpperOrderId());
            uocOrdContractPO.setId(Long.valueOf(this.sequence.nextId()));
            uocOrdContractPO.setSaleVoucherNo(reqBO.getOrderNo());
            uocOrdContractPO.setExt1(reqBO.getBuynerNo());
            uocOrdContractPO.setOrderId(reqBO.getOrderId());
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            uocOrdContractPO.setCreateTime(new Date());
            uocOrdContractPO.setFailReason(message);
            this.uocOrdContractMapper.insert(uocOrdContractPO);
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO.setFieldName19("\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355id");
            cruxMapPO.setFieldValue19(reqBO.getOrderId().toString());
            this.ordCruxMapMapper.updateByOrder(cruxMapPO);
        }
    }

    private void insertOrderSuccessLog(Long orderId, PebExtPushContractLedgerBusiReqBO reqBO, String orderNo) {
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderId(orderId);
        uocOrdContractPO = this.uocOrdContractMapper.getModelBy(uocOrdContractPO);
        if (uocOrdContractPO != null) {
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            uocOrdContractPO.setSaleVoucherNo(orderNo);
            uocOrdContractPO.setExt1(reqBO.getBuynerNo());
            if (reqBO.getIsContract().booleanValue()) {
                uocOrdContractPO.setContractId(reqBO.getContractId());
                uocOrdContractPO.setContractNo(reqBO.getContractNo());
                uocOrdContractPO.setContractName(reqBO.getContractName());
            } else {
                uocOrdContractPO.setContractId(reqBO.getContractId());
                uocOrdContractPO.setVrContractNo(reqBO.getVrContractNo());
                uocOrdContractPO.setContractName(reqBO.getContractName());
            }
            uocOrdContractPO.setUnifyContractType(reqBO.getUnifyContractType());
            uocOrdContractPO.setUpdateTime(new Date());
            this.uocOrdContractMapper.update(uocOrdContractPO);
            uocOrdContractPO.setSaleVoucherNo(null);
            uocOrdContractPO.setExt2(reqBO.getOrderId().toString());
            this.uocOrdContractMapper.updateByUpperOrderId(uocOrdContractPO);
        } else {
            uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setId(Long.valueOf(this.sequence.nextId()));
            uocOrdContractPO.setOrderId(orderId);
            uocOrdContractPO.setSaleVoucherNo(orderNo);
            uocOrdContractPO.setExt1(reqBO.getBuynerNo());
            if (reqBO.getIsContract().booleanValue()) {
                uocOrdContractPO.setContractId(reqBO.getContractId());
                uocOrdContractPO.setContractName(reqBO.getContractName());
                uocOrdContractPO.setContractNo(reqBO.getContractNo());
            } else {
                uocOrdContractPO.setContractId(reqBO.getContractId());
                uocOrdContractPO.setVrContractNo(reqBO.getVrContractNo());
                uocOrdContractPO.setContractName(reqBO.getContractName());
            }
            uocOrdContractPO.setUnifyContractType(reqBO.getUnifyContractType());
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            uocOrdContractPO.setCreateTime(new Date());
            this.uocOrdContractMapper.insert(uocOrdContractPO);
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO.setFieldName19("\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355id");
            cruxMapPO.setFieldValue19(reqBO.getOrderId().toString());
            this.ordCruxMapMapper.updateByOrder(cruxMapPO);
        }
    }

    private UocContractPushLogPO buildPushLog(PebExtPushContractLedgerBusiReqBO reqBO, String reqData, String reqParseData) {
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setObjectId(reqBO.getOrderId());
        pushLogPO.setObjectNo(reqBO.getOrderNo());
        pushLogPO.setType(reqBO.getPushType());
        pushLogPO.setPushData(JSONObject.toJSONString((Object)((Object)reqBO)));
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setPushParseData(reqParseData);
        pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        pushLogPO.setPushData(reqData);
        return pushLogPO;
    }
}

