/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.PebExtPushContractLedgerAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushContractLedgerChangeBusiService;
import com.tydic.uoc.common.busi.bo.PebExtContractLedgerChangeBusiRspBO;
import com.tydic.uoc.common.busi.bo.PebExtPushContractLedgerChangeBusiReqBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.UocContractPushLogMapper;
import com.tydic.uoc.dao.UocEcomContractSerialMapper;
import com.tydic.uoc.dao.UocOrdContractChangeMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.UocContractPushLogPO;
import com.tydic.uoc.po.UocEcomContractSerialPO;
import com.tydic.uoc.po.UocOrdContractChangePO;
import com.tydic.uoc.po.UocOrdContractPO;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushContractLedgerChangeBusiServiceImpl
implements PebExtPushContractLedgerChangeBusiService {
    @Autowired
    private PebExtPushContractLedgerAtomService pebExtPushContractLedgerAtomService;
    @Autowired
    private UocContractPushLogMapper uocContractPushLogMapper;
    @Autowired
    private UocOrdContractChangeMapper uocOrdContractChangeMapper;
    @Autowired
    private UocEcomContractSerialMapper uocEcomContractSerialMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public PebExtContractLedgerChangeBusiRspBO dealPushContractLedgerChange(PebExtPushContractLedgerChangeBusiReqBO reqBO) {
        PebExtContractLedgerChangeBusiRspBO rspBO = new PebExtContractLedgerChangeBusiRspBO();
        if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_ADD)) {
            rspBO = this.dealPushOrderAdd(reqBO);
        } else if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE)) {
            rspBO = this.dealPushOrderChange(reqBO);
        } else if (reqBO.getPushType().equals(UocCoreConstant.PUSH_TYPE.CONTRACT_CHANGE)) {
            rspBO = this.dealPushContractChange(reqBO);
        }
        return rspBO;
    }

    private PebExtContractLedgerChangeBusiRspBO dealPushOrderAdd(PebExtPushContractLedgerChangeBusiReqBO reqBO) {
        PebExtContractLedgerChangeBusiRspBO rspBO = new PebExtContractLedgerChangeBusiRspBO();
        UocContractPushLogPO logPO = new UocContractPushLogPO();
        logPO.setObjectId(reqBO.getOrderId());
        logPO.setType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_ADD);
        logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        logPO = this.uocContractPushLogMapper.getModelBy(logPO);
        if (logPO != null) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        if (reqBO.getContractId() == null) {
            UocEcomContractSerialPO serialPO = this.uocEcomContractSerialMapper.queryByContractNo(reqBO.getVrContractNo());
            if (serialPO == null) {
                Calendar cal = Calendar.getInstance();
                int year = cal.get(1);
                serialPO = new UocEcomContractSerialPO();
                serialPO.setVrContractNo(reqBO.getVrContractNo());
                serialPO.setEffDate(String.valueOf(year));
                serialPO.setVrContractId(Long.valueOf(this.sequence.nextId()));
                this.uocEcomContractSerialMapper.insert(serialPO);
            }
            reqBO.setContractId(serialPO.getVrContractId());
        }
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        PebExtPushContractLedgerAtomReqBO atomReqBO = new PebExtPushContractLedgerAtomReqBO();
        atomReqBO.setData(reqBO.getParseData());
        atomReqBO.setToken(reqBO.getToken());
        PebExtPushContractLedgerAtomRspBO atomRspBO = this.pebExtPushContractLedgerAtomService.pushContractLedgerChange(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            this.insertOrderFailLog(reqBO, atomRspBO.getMsg());
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
        } else {
            this.insertOrderSuccessLog(reqBO.getOrderId(), reqBO, reqBO.getOrderNo());
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        pushLogPO.setRespData(atomRspBO.toString());
        this.uocContractPushLogMapper.insert(pushLogPO);
        return rspBO;
    }

    private PebExtContractLedgerChangeBusiRspBO dealPushContractChange(PebExtPushContractLedgerChangeBusiReqBO reqBO) {
        PebExtContractLedgerChangeBusiRspBO rspBO = new PebExtContractLedgerChangeBusiRspBO();
        UocOrdContractChangePO uocOrdContractChangePO = new UocOrdContractChangePO();
        uocOrdContractChangePO.setApplyId(reqBO.getApplyId());
        uocOrdContractChangePO = this.uocOrdContractChangeMapper.getModelBy(uocOrdContractChangePO);
        if (uocOrdContractChangePO != null && uocOrdContractChangePO.getPushStatus().equals(UocCoreConstant.PUSH_STATUS.SUCCESS)) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        PebExtPushContractLedgerAtomReqBO atomReqBO = new PebExtPushContractLedgerAtomReqBO();
        atomReqBO.setData(reqBO.getParseData());
        atomReqBO.setToken(reqBO.getToken());
        PebExtPushContractLedgerAtomRspBO atomRspBO = this.pebExtPushContractLedgerAtomService.pushContractLedgerChange(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            this.insertChangeLog(reqBO, UocCoreConstant.PUSH_STATUS.FAIL, uocOrdContractChangePO);
        } else {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            this.insertChangeLog(reqBO, UocCoreConstant.PUSH_STATUS.SUCCESS, uocOrdContractChangePO);
        }
        pushLogPO.setRespData(atomRspBO.toString());
        this.uocContractPushLogMapper.insert(pushLogPO);
        return rspBO;
    }

    private PebExtContractLedgerChangeBusiRspBO dealPushOrderChange(PebExtPushContractLedgerChangeBusiReqBO reqBO) {
        PebExtContractLedgerChangeBusiRspBO rspBO = new PebExtContractLedgerChangeBusiRspBO();
        UocOrdContractChangePO uocOrdContractChangePO = new UocOrdContractChangePO();
        uocOrdContractChangePO.setApplyId(reqBO.getApplyId());
        uocOrdContractChangePO = this.uocOrdContractChangeMapper.getModelBy(uocOrdContractChangePO);
        if (uocOrdContractChangePO != null && uocOrdContractChangePO.getPushStatus().equals(UocCoreConstant.PUSH_STATUS.SUCCESS)) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        PebExtPushContractLedgerAtomReqBO atomReqBO = new PebExtPushContractLedgerAtomReqBO();
        atomReqBO.setData(reqBO.getParseData());
        atomReqBO.setToken(reqBO.getToken());
        PebExtPushContractLedgerAtomRspBO atomRspBO = this.pebExtPushContractLedgerAtomService.pushContractLedgerChange(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            this.insertChangeLog(reqBO, UocCoreConstant.PUSH_STATUS.FAIL, uocOrdContractChangePO);
        } else {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            this.insertChangeLog(reqBO, UocCoreConstant.PUSH_STATUS.SUCCESS, uocOrdContractChangePO);
        }
        pushLogPO.setRespData(atomRspBO.toString());
        this.uocContractPushLogMapper.insert(pushLogPO);
        return rspBO;
    }

    private UocContractPushLogPO buildPushLog(PebExtPushContractLedgerChangeBusiReqBO reqBO) {
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setObjectId(reqBO.getOrderId());
        pushLogPO.setObjectNo(reqBO.getOrderNo());
        pushLogPO.setType(reqBO.getPushType());
        pushLogPO.setPushData(reqBO.getReqData());
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setPushParseData(reqBO.getParseData());
        return pushLogPO;
    }

    private void insertOrderFailLog(PebExtPushContractLedgerChangeBusiReqBO reqBO, String message) {
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderId(reqBO.getOrderId());
        uocOrdContractPO = this.uocOrdContractMapper.getModelBy(uocOrdContractPO);
        if (uocOrdContractPO != null) {
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            uocOrdContractPO.setUpdateTime(new Date());
            uocOrdContractPO.setFailReason(message);
            this.uocOrdContractMapper.update(uocOrdContractPO);
            uocOrdContractPO.setSaleVoucherNo(null);
            uocOrdContractPO.setExt2(reqBO.getOrderId().toString());
            this.uocOrdContractMapper.updateByUpperOrderId(uocOrdContractPO);
        } else {
            uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setExt2(reqBO.getUpperOrderId());
            uocOrdContractPO.setId(Long.valueOf(this.sequence.nextId()));
            uocOrdContractPO.setOrderId(reqBO.getOrderId());
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            uocOrdContractPO.setSaleVoucherNo(reqBO.getOrderNo());
            uocOrdContractPO.setExt1(reqBO.getBuynerNo());
            uocOrdContractPO.setCreateTime(new Date());
            uocOrdContractPO.setFailReason(message);
            this.uocOrdContractMapper.insert(uocOrdContractPO);
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO.setFieldName19("\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355id");
            cruxMapPO.setFieldValue19(reqBO.getOrderId().toString());
            this.ordCruxMapMapper.updateByOrder(cruxMapPO);
        }
    }

    private void insertOrderSuccessLog(Long orderId, PebExtPushContractLedgerChangeBusiReqBO reqBO, String orderNo) {
        UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
        uocOrdContractPO.setOrderId(orderId);
        uocOrdContractPO = this.uocOrdContractMapper.getModelBy(uocOrdContractPO);
        if (uocOrdContractPO != null) {
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            uocOrdContractPO.setSaleVoucherNo(orderNo);
            uocOrdContractPO.setContractId(reqBO.getContractId());
            uocOrdContractPO.setContractName(reqBO.getContractName());
            uocOrdContractPO.setContractNo(reqBO.getContractNo());
            uocOrdContractPO.setVrContractNo(reqBO.getVrContractNo());
            uocOrdContractPO.setUnifyContractType(reqBO.getUnifyContractType());
            uocOrdContractPO.setUpdateTime(new Date());
            uocOrdContractPO.setExt1(reqBO.getBuynerNo());
            this.uocOrdContractMapper.update(uocOrdContractPO);
            uocOrdContractPO.setSaleVoucherNo(null);
            uocOrdContractPO.setExt2(orderId.toString());
            this.uocOrdContractMapper.updateByUpperOrderId(uocOrdContractPO);
        } else {
            uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setExt2(reqBO.getUpperOrderId());
            uocOrdContractPO.setId(Long.valueOf(this.sequence.nextId()));
            uocOrdContractPO.setOrderId(orderId);
            uocOrdContractPO.setSaleVoucherNo(orderNo);
            uocOrdContractPO.setContractId(reqBO.getContractId());
            uocOrdContractPO.setContractName(reqBO.getContractName());
            uocOrdContractPO.setContractNo(reqBO.getContractNo());
            uocOrdContractPO.setVrContractNo(reqBO.getVrContractNo());
            uocOrdContractPO.setUnifyContractType(reqBO.getUnifyContractType());
            uocOrdContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            uocOrdContractPO.setCreateTime(new Date());
            uocOrdContractPO.setExt1(reqBO.getBuynerNo());
            uocOrdContractPO.setExt2(reqBO.getUpperOrderId());
            this.uocOrdContractMapper.insert(uocOrdContractPO);
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO.setFieldName19("\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97\u8ba2\u5355id");
            cruxMapPO.setFieldValue19(reqBO.getOrderId().toString());
            this.ordCruxMapMapper.updateByOrder(cruxMapPO);
        }
    }

    private void insertChangeLog(PebExtPushContractLedgerChangeBusiReqBO reqBO, Integer pushStatus2, UocOrdContractChangePO uocOrdContractChangePO) {
        if (uocOrdContractChangePO == null) {
            uocOrdContractChangePO = new UocOrdContractChangePO();
            uocOrdContractChangePO.setApplyId(reqBO.getApplyId());
            uocOrdContractChangePO.setApplyNo(reqBO.getApplyNo());
            uocOrdContractChangePO.setObjectId(reqBO.getOrderId());
            uocOrdContractChangePO.setObjectNo(reqBO.getOrderNo());
            uocOrdContractChangePO.setCreateTime(new Date());
            uocOrdContractChangePO.setType(reqBO.getPushType());
            uocOrdContractChangePO.setPushStatus(pushStatus2);
            uocOrdContractChangePO.setId(Long.valueOf(this.sequence.nextId()));
            uocOrdContractChangePO.setFailCount(Integer.valueOf(0));
            this.uocOrdContractChangeMapper.insert(uocOrdContractChangePO);
        } else {
            uocOrdContractChangePO.setPushStatus(pushStatus2);
            this.uocOrdContractChangeMapper.update(uocOrdContractChangePO);
        }
    }
}

