/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.common.atom.api.PebExtPushWarehouseRejectShipAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseRejectShipAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushWarehouseRejectShipAtomRspBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWarehouseRejectShipBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseRejectShipBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushWarehouseRejectShipBusiRspBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushWarehouseRejectShipBusiServiceImpl
implements PebExtPushWarehouseRejectShipBusiService {
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;
    @Autowired
    private PebExtPushWarehouseRejectShipAtomService pebExtPushWarehouseRejectShipAtomService;

    @Override
    public PebExtPushWarehouseRejectShipBusiRspBO dealPushWarehouseRejectShip(PebExtPushWarehouseRejectShipBusiReqBO reqBO) {
        UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
        warehousePO.setOrderId(reqBO.getOrderId());
        warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
        if (warehousePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4f01\u914d\u4ed3\u4fe1\u606f\uff01");
        }
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setOrderId(reqBO.getOrderId());
        shipPO.setShipVoucherId(reqBO.getShipVoucherId());
        shipPO = this.ordShipMapper.getModelBy(shipPO);
        if (shipPO == null) {
            throw new UocProBusinessException("8888", "\u672a\u6839\u636e\u53d1\u8d27\u5355[" + reqBO.getShipVoucherId() + "]\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f\uff01");
        }
        String warehouseId = this.getEcomWarehouseCode(warehousePO.getSupplierId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("warehouseId", (Object)warehouseId);
        jsonObject.put("shipId", (Object)reqBO.getShipVoucherId());
        String signStr = "warehouseId" + warehouseId + "shipId" + reqBO.getShipVoucherId().toString();
        String sign = MD5Util.MD5Encode((String)(signStr + this.warehouseSignKey), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + this.warehouseSignKey), (String)"");
        jsonObject.put("sign", (Object)sign);
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + warehousePO.getSupplierId()));
        jsonObject.put("hsn", (Object)hsn);
        UocOrdWarehouseLogPO warehouseLogPO = new UocOrdWarehouseLogPO();
        warehouseLogPO.setId(Long.valueOf(this.sequence.nextId()));
        warehouseLogPO.setReqData(jsonObject.toJSONString());
        warehouseLogPO.setCreateTime(new Date());
        warehouseLogPO.setOrderId(reqBO.getOrderId());
        warehouseLogPO.setShipVoucherId(reqBO.getShipVoucherId());
        warehouseLogPO.setType(UocConstant.WarehousePushType.REJECT_SHIP);
        PebExtPushWarehouseRejectShipBusiRspBO rspBO = new PebExtPushWarehouseRejectShipBusiRspBO();
        PebExtPushWarehouseRejectShipAtomReqBO atomReqBO = new PebExtPushWarehouseRejectShipAtomReqBO();
        atomReqBO.setReqData(jsonObject.toJSONString());
        PebExtPushWarehouseRejectShipAtomRspBO atomRspBO = this.pebExtPushWarehouseRejectShipAtomService.dealPushWarehouseRejectShip(atomReqBO);
        warehouseLogPO.setRespData(atomRspBO.getRespData());
        if (StringUtils.isEmpty((CharSequence)atomRspBO.getRespData())) {
            warehouseLogPO.setRespData(atomRspBO.getMessage());
        }
        if (atomRspBO.getCode().equals("0")) {
            warehouseLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            warehouseLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getMessage());
        }
        this.uocOrdWarehouseLogMapper.insert(warehouseLogPO);
        return rspBO;
    }

    private String getEcomWarehouseCode(Long supplierId) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(supplierId + "");
        dictReqBO.setPcode("UOC_ECOM_WAREHOUSE_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (!"0000".equals(dictRspBO.getRespCode()) || dictRspBO.getDicDictionarys() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178");
        }
        return dictRspBO.getDicDictionarys().getDescrip();
    }
}

