/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PushContractTzConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebPushWmsRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushWmsOrderBusiService;
import com.tydic.uoc.common.utils.DycAuthUtil;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.UocOrdWmsLogMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.UocOrdWmsLogPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushWmsOrderBusiServiceImpl
implements PebExtPushWmsOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushWmsOrderBusiServiceImpl.class);
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdWmsLogMapper uocOrdWmsLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${wms.app.key:YGDEC96EAF4001CAEB9E3E1F54E2E436}")
    private String appKey;
    @Value(value="${wms.order.url:http://172.16.91.185:8068/interface/delivery/push}")
    private String orderUrl;
    @Value(value="${wms.order.auth.path:/interface/wms/push/delivery}")
    private String authPath;

    @Override
    public PebExtPushWmsOrderRspBO dealPushWmsOrder(PebExtPushWmsOrderReqBO reqBO) {
        UocOrdZmInfoPO updateZmPo;
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (zmInfoPO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (zmInfoPO.getIsPushWms() == null || !PushContractTzConstant.pushStatus.SUCCESS.equals(zmInfoPO.getIsPushWms())) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u5355\u636e\u672a\u5bf9\u63a5wms,\u65e0\u9700\u63a8\u9001!");
        }
        HashMap<String, Object> reqData = new HashMap<String, Object>(4);
        reqData.put("key", "YG_CONSIGNED_ORDER");
        reqData.put("data", reqBO.getWmsList());
        PebPushWmsRspBO pushWmsRspBO = this.dealPushOrder(JSONObject.toJSONString(reqData));
        if (reqBO.getId() == null) {
            this.saveLog(JSONObject.toJSONString(reqData), pushWmsRspBO, reqBO);
        } else {
            this.updateLog(pushWmsRspBO, reqBO, JSONObject.toJSONString(reqData));
        }
        if (reqBO.getIsChange().booleanValue()) {
            updateZmPo = new UocOrdZmInfoPO();
            updateZmPo.setOrderId(reqBO.getOrderId());
            updateZmPo.setPushWmsChangeStatus("0000".equals(pushWmsRspBO.getRespCode()) ? PushContractTzConstant.pushStatus.SUCCESS : PushContractTzConstant.pushStatus.FAILE);
            updateZmPo.setPushWmsChangeRemark(pushWmsRspBO.getRespDesc());
            this.uocOrdZmInfoMapper.updateWmsChangeInfo(updateZmPo);
        } else {
            updateZmPo = new UocOrdZmInfoPO();
            updateZmPo.setOrderId(reqBO.getOrderId());
            updateZmPo.setPushWmsStatus("0000".equals(pushWmsRspBO.getRespCode()) ? PushContractTzConstant.pushStatus.SUCCESS : PushContractTzConstant.pushStatus.FAILE);
            updateZmPo.setPushWmsRemark(pushWmsRspBO.getRespDesc());
            this.uocOrdZmInfoMapper.updateWmsInfo(updateZmPo);
        }
        PebExtPushWmsOrderRspBO rspBO = new PebExtPushWmsOrderRspBO();
        rspBO.setRespCode(pushWmsRspBO.getRespCode());
        rspBO.setRespDesc(pushWmsRspBO.getRespDesc());
        return rspBO;
    }

    private PebPushWmsRspBO dealPushOrder(String reqData) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appKey", this.appKey);
        headerMap.put("requestTime", DateUtils.dateToStrLong((Date)new Date()));
        String sign = DycAuthUtil.sign(this.appKey, this.authPath, headerMap);
        headerMap.put("authSignature", sign);
        try {
            log.error("\u8c03\u7528WMS\u8865\u8d27\u5355\u63a5\u53e3\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.orderUrl);
            log.error("\u8c03\u7528WMS\u8865\u8d27\u5355\u63a5\u53e3\u8bf7\u6c42\u5730\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqData));
            log.error("\u8c03\u7528WMS\u8865\u8d27\u5355\u63a5\u53e3\u8bf7\u6c42header\uff1a{}", (Object)JSON.toJSONString(headerMap));
            String respStr = HttpUtil.doPost(this.orderUrl, reqData, headerMap);
            if (StringUtils.isEmpty((CharSequence)respStr)) {
                throw new UocProBusinessException("8888", "\u8c03\u7528WMS\u8865\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            log.error("\u8c03\u7528WMS\u8865\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)respStr);
            return this.resolveRsp(respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528WMS\u8865\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            PebPushWmsRspBO rspBO = new PebPushWmsRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    private void saveLog(String reqData, PebPushWmsRspBO rspBO, PebExtPushWmsOrderReqBO reqBO) {
        UocOrdWmsLogPO wmsLogPO = new UocOrdWmsLogPO();
        wmsLogPO.setId(Long.valueOf(this.sequence.nextId()));
        wmsLogPO.setOrderId(reqBO.getOrderId());
        wmsLogPO.setObjId(reqBO.getOrderId());
        wmsLogPO.setCreateTime(new Date());
        wmsLogPO.setObjType(UocConstant.WmsPushType.SALE);
        wmsLogPO.setObjNo(reqBO.getSaleVoucherNo());
        wmsLogPO.setReqData(reqData);
        wmsLogPO.setRspData(rspBO.getRespData());
        if (StringUtils.isEmpty((CharSequence)rspBO.getRespData())) {
            wmsLogPO.setRspData(rspBO.getRespDesc());
        }
        wmsLogPO.setDealStatus("0000".equals(rspBO.getRespCode()) ? PushContractTzConstant.pushStatus.SUCCESS : PushContractTzConstant.pushStatus.FAILE);
        int count = this.uocOrdWmsLogMapper.insert(wmsLogPO);
        if (count != 1) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u63a8\u9001WMS\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private PebPushWmsRspBO resolveRsp(String respStr) {
        PebPushWmsRspBO rspBO;
        try {
            rspBO = (PebPushWmsRspBO)JSONObject.parseObject((String)respStr, PebPushWmsRspBO.class);
            if ("200".equals(rspBO.getCode())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspBO.getMsg());
            }
        }
        catch (Exception e) {
            rspBO = new PebPushWmsRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u89e3\u6790\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        rspBO.setRespData(respStr);
        return rspBO;
    }

    private void updateLog(PebPushWmsRspBO rspBO, PebExtPushWmsOrderReqBO reqBO, String reqData) {
        UocOrdWmsLogPO wmsLogPO = this.uocOrdWmsLogMapper.queryById(reqBO.getId());
        wmsLogPO.setId(reqBO.getId());
        if ("0000".equals(rspBO.getRespCode())) {
            wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.SUCCESS);
        } else {
            wmsLogPO.setDealStatus(PushContractTzConstant.pushStatus.FAILE);
            wmsLogPO.setCount(Integer.valueOf(wmsLogPO.getCount() + 1));
        }
        wmsLogPO.setReqData(reqData);
        wmsLogPO.setRspData(rspBO.getRespData());
        this.uocOrdWmsLogMapper.update(wmsLogPO);
    }
}

