/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractOrderedAmountSynAbilityService;
import com.tydic.contract.ability.ContractPlanOrderAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityReqBO;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityRspBO;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityReqBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityRspBo;
import com.tydic.dyc.ssc.service.scheme.SchemeAmountService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountReqBO;
import com.tydic.fsc.common.ability.api.FscAccountAdvanceDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountAdvanceDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountAdvanceDeductAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.PayConfDetailBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocNoTaskAuditOrderAuditNoticeBO;
import com.tydic.uoc.common.ability.bo.UocOrdItemUpdateBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.UocFillMaterialCodeAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocSendNotificationExtAtomService;
import com.tydic.uoc.common.atom.api.plan.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.uoc.common.atom.bo.QrySaleReqBO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemBO;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.PebUpdateOrderBusiService;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PayConfDetailMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.UocOrdContractChangeMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempxMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrdZmItemMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PayConfDetailPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.UocOrdContractChangePO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrdZmItemPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebUpdateOrderBusiServiceImpl
implements PebUpdateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebUpdateOrderBusiServiceImpl.class);
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private UocOrdContractChangeMapper uocOrdContractChangeMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private UocOrdGoodsTempxMapper uocOrdGoodsTempxMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private PayConfDetailMapper payConfDetailMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private UocOrdZmItemMapper uocOrdZmItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;
    @Autowired
    private ContractPlanOrderAbilityService contractPlanOrderAbilityService;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;
    @Autowired
    private ContractOrderedAmountSynAbilityService contractOrderedAmountSynAbilityService;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private UocGeneralCirculationBusiService uocGeneralCirculationBusiService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private SchemeAmountService schemeAmountService;
    @Autowired
    private UocSendNotificationExtAtomService uocSendNotificationExtAtomService;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private FscAccountAdvanceDeductAbilityService fscAccountAdvanceDeductAbilityService;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private UocFillMaterialCodeAtomService uocFillMaterialCodeAtomService;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;

    @Override
    public PebUpdateOrderRspBO updateOrderCycle(PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getUocMallUpdateSupplyCycleBOS())) {
            return rspBO;
        }
        ArrayList list = new ArrayList();
        reqBO.getUocMallUpdateSupplyCycleBOS().forEach($ -> {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrdItemId($.getOrdItemId());
            ordItemPO.setOrderId($.getOrderId());
            ordItemPO.setRealSupplyCycle($.getRealSupplyCycle());
            ordItemPO.setArrivalTime($.getRealSupplyCycle().toString());
            list.add(ordItemPO);
        });
        log.info("updateOrderCycle param:{}", (Object)JSON.toJSONString(list));
        this.ordItemMapper.batchUpdate(list);
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateOrder(PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        if (reqBO.getZmInfoBO() != null) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            BeanUtils.copyProperties((Object)reqBO.getZmInfoBO(), (Object)zmInfoPO);
            zmInfoPO.setOrderId(reqBO.getOrderId());
            this.uocOrdZmInfoMapper.update(zmInfoPO);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSalePO update = new OrdSalePO();
        update.setSaleVoucherId(salePO.getSaleVoucherId());
        update.setOrderId(reqBO.getOrderId());
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setUpdateOperId(reqBO.getUserId().toString());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExt4())) {
            orderPO.setExt4(reqBO.getExt4());
        }
        orderPO.setOrderName(reqBO.getOrderName());
        if (reqBO.getAddressInfo() != null) {
            this.updateAddr(reqBO.getAddressInfo(), salePO);
        }
        orderPO.setOrderDesc(reqBO.getComment());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getGiveTime())) {
            update.setGiveTime(reqBO.getGiveTime());
        }
        if (reqBO.getPayType() != null) {
            this.updatePayConf(reqBO);
        }
        Long orderId = reqBO.getOrderId();
        this.updateExt("purUserNo", "\u91c7\u8d2d\u5458\u7f16\u7801", reqBO.getPurUserNo(), orderId);
        this.updateExt("purUserName", "\u91c7\u8d2d\u5458\u540d\u79f0", reqBO.getPurUserName(), orderId);
        this.updateExt("erpAgrNo", "\u91c7\u8d2d\u534f\u8bae\u7f16\u7801", reqBO.getErpAgrNo(), orderId);
        this.updateExt("erpAgrName", "\u91c7\u8d2d\u534f\u8bae\u540d\u79f0", reqBO.getErpAgrName(), orderId);
        this.updateExt("erpAgrId", "\u91c7\u8d2d\u534f\u8baeid", reqBO.getErpAgrId(), orderId);
        this.updateExt("adjustType", "\u8c03\u4ef7\u65b9\u5f0f", reqBO.getAdjustType(), orderId);
        reqBO.setDelAccessFlag(Boolean.valueOf(true));
        this.saveAccessory(reqBO, orderId);
        if (PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            if (PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(salePO.getOrderSource())) {
                this.dealCheckBhd(reqBO);
            }
            List<Integer> saleStateList = Arrays.asList(1107, 8888);
            if (salePO.getSaleState() == 1107) {
                this.orderMapper.updateProStateNull(salePO.getOrderId());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            boolean approvalFlag = true;
            if (PecConstant.ORDER_SOURCE.CONSIGNMENT_SALES.toString().equals(salePO.getOrderSource()) && "2".equals(reqBO.getIsprofess())) {
                rspBO.setPushWmsId(reqBO.getOrderId());
                map.put("submit", "2");
                approvalFlag = false;
            } else {
                map.put("submit", "1");
            }
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(salePO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(salePO.getOrderId());
            processRunReqBO.setOperId("1");
            processRunReqBO.setVariables(map);
            processRunReqBO.setPreState(UocConstant.SALE_ORDER_STATUS.TOBO_SUBMIT);
            UocProcessRunRspBO processRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(processRunRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", processRunRspBO.getRespDesc());
            }
            if (approvalFlag) {
                this.audit(salePO, reqBO, rspBO);
            }
        }
        this.saveItem(update, orderPO, reqBO, salePO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updatePayConf(PebUpdateOrderReqBO reqBO) {
        OrdPayPO payPO = new OrdPayPO();
        payPO.setOrderId(reqBO.getOrderId());
        payPO = this.ordPayMapper.getModelBy(payPO);
        if (payPO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PHASE)) {
            this.payConfDetailMapper.deleteByOrderId(reqBO.getOrderId());
        }
        this.ordPayConfMapper.deleteByOrderId(reqBO.getOrderId());
        if (!reqBO.getPayType().equals(payPO.getPayType())) {
            payPO.setPayType(reqBO.getPayType());
            this.ordPayMapper.updateById(payPO);
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO.setPayType(reqBO.getPayType() + "");
            this.orderMapper.updateById(orderPO);
        }
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        payConfPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        payConfPO.setOrderId(reqBO.getOrderId());
        payConfPO.setUserType(UocCoreConstant.UserType.PUR);
        payConfPO.setPayType(reqBO.getPayType());
        if (reqBO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PERIOD)) {
            payConfPO.setPayNodeRule(reqBO.getPayNodeRule());
            payConfPO.setPayAccountDayRule(reqBO.getPayAccountDayRule());
            payConfPO.setPayRule(reqBO.getPayRule());
            payConfPO.setPaymentDays(reqBO.getPaymentDays());
            payConfPO.setPayBreakScale(reqBO.getPayBreakScale());
            payConfPO.setPayAccountDay(reqBO.getPayAccountDay());
            if (reqBO.getPayBreakScale() == null) {
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
            }
            if (reqBO.getPayNodeRule().equals(FscConstants.MerchantPayNodeRule.ACCEPT)) {
                payConfPO.setPilPaySup(new BigDecimal(100));
            } else if (reqBO.getPayNodeRule().equals(FscConstants.MerchantPayNodeRule.ARRIVE)) {
                payConfPO.setVerPaySup(new BigDecimal(100));
            }
        } else if (reqBO.getPayType().equals(UocCoreConstant.PayType.PAY_TYPE_PHASE)) {
            ArrayList<PayConfDetailPO> detailPOList = new ArrayList<PayConfDetailPO>();
            BigDecimal prePaySup = BigDecimal.ZERO;
            BigDecimal verPaySup = BigDecimal.ZERO;
            BigDecimal pilPaySup = BigDecimal.ZERO;
            BigDecimal quaPaySup = BigDecimal.ZERO;
            for (PayConfDetailBO payConfDetailBO : reqBO.getPayDetailList()) {
                PayConfDetailPO detailPO = new PayConfDetailPO();
                BeanUtils.copyProperties((Object)payConfDetailBO, (Object)detailPO);
                detailPO.setPayConfId(payConfPO.getId());
                detailPO.setOrderId(reqBO.getOrderId());
                detailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                detailPOList.add(detailPO);
                if (payConfDetailBO.getPayType() == 1) {
                    quaPaySup = quaPaySup.add(payConfDetailBO.getPayPercent());
                }
                if (payConfDetailBO.getPayType() != 0) continue;
                if (payConfDetailBO.getPayNode().equals(UocCoreConstant.PayNode.CREATE)) {
                    prePaySup = prePaySup.add(payConfDetailBO.getPayPercent());
                    continue;
                }
                if (payConfDetailBO.getPayNode().equals(UocCoreConstant.PayNode.ARRIVE)) {
                    verPaySup = verPaySup.add(payConfDetailBO.getPayPercent());
                    continue;
                }
                if (!payConfDetailBO.getPayNode().equals(UocCoreConstant.PayNode.ACC)) continue;
                pilPaySup = pilPaySup.add(payConfDetailBO.getPayPercent());
            }
            this.payConfDetailMapper.insertBatch(detailPOList);
            payConfPO.setPrePaySup(prePaySup);
            payConfPO.setVerPaySup(verPaySup);
            payConfPO.setPilPaySup(pilPaySup);
            payConfPO.setQuaPaySup(quaPaySup);
        }
        this.ordPayConfMapper.insert(payConfPO);
    }

    @Override
    public PebUpdateOrderRspBO updateOrderByRecover(PebUpdateOrderReqBO reqBO) {
        if (reqBO.getZmInfoBO() != null) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            BeanUtils.copyProperties((Object)reqBO.getZmInfoBO(), (Object)zmInfoPO);
            zmInfoPO.setOrderId(reqBO.getOrderId());
            this.uocOrdZmInfoMapper.update(zmInfoPO);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (!UocConstant.SALE_ORDER_STATUS.REJECT_PENDING.equals(salePO.getSaleState())) {
            PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        OrdSalePO update = new OrdSalePO();
        update.setSaleVoucherId(salePO.getSaleVoucherId());
        update.setOrderId(reqBO.getOrderId());
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExt4())) {
            orderPO.setExt4(reqBO.getExt4());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getGiveTime())) {
            update.setGiveTime(reqBO.getGiveTime());
        }
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        ordLogisticsRelaPO.setOrderId(reqBO.getOrderId());
        this.ordLogisticsRelaMapper.deleteBy(ordLogisticsRelaPO);
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(reqBO.getOrderId(), reqBO.getAddressInfo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        Long contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
        update.setContactId(contactId);
        this.ordInvoiceMapper.deleteByOrderId(reqBO.getOrderId());
        this.saveInvoice(reqBO, reqBO.getOrderId(), reqBO.getSaleVoucherId());
        this.saveAccessory(reqBO, reqBO.getOrderId());
        this.dealItem(update, orderPO, reqBO);
        UocGeneralCirculationReqBO uocGeneralCirculationReqBO = new UocGeneralCirculationReqBO();
        uocGeneralCirculationReqBO = (UocGeneralCirculationReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)uocGeneralCirculationReqBO)), UocGeneralCirculationReqBO.class));
        uocGeneralCirculationReqBO.setActionCode("ACTPEB003");
        uocGeneralCirculationReqBO.setObjType(2);
        uocGeneralCirculationReqBO.setOrderId(reqBO.getOrderId());
        uocGeneralCirculationReqBO.setObjId(reqBO.getSaleVoucherId());
        UocGeneralCirculationRspBO uocGeneralCirculationRspBO = this.uocGeneralCirculationBusiService.dealGeneralCirculation(uocGeneralCirculationReqBO);
        if (!"0000".equals(uocGeneralCirculationRspBO.getRespCode())) {
            throw new UocProBusinessException(uocGeneralCirculationRspBO.getRespCode(), "\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5931\u8d25:" + uocGeneralCirculationRspBO.getRespDesc());
        }
        rspBO.setAuditNoticeList(uocGeneralCirculationRspBO.getAuditNoticeList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSendOrderIdList(uocGeneralCirculationRspBO.getSendOrderIdList());
        return rspBO;
    }

    private void freezeAdvanceAgr(OrdSalePO salePO) {
        OrderPO orderPO = this.orderMapper.getModelById(salePO.getOrderId().longValue());
        if (!"3".equals(orderPO.getPayType()) || !"1".equals(salePO.getOrderSource())) {
            return;
        }
        UocOrdZmInfoPO InfoPO = new UocOrdZmInfoPO();
        InfoPO.setOrderId(salePO.getOrderId());
        UocOrdZmInfoPO uocOrdZmInfoPO = this.uocOrdZmInfoMapper.selectOne(InfoPO);
        QrySaleReqBO qrySaleReqBO = new QrySaleReqBO();
        qrySaleReqBO.setOrderId(salePO.getOrderId());
        qrySaleReqBO.setSaleId(salePO.getSaleVoucherId());
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(salePO.getOrderId().longValue());
        FscAccountAdvanceDeductAbilityReqBO abilityReqBO = new FscAccountAdvanceDeductAbilityReqBO();
        abilityReqBO.setOperationType(Integer.valueOf(0));
        abilityReqBO.setCreditOrgCode(uocOrdZmInfoPO.getBuynerNo());
        abilityReqBO.setCreditOrgId(Long.valueOf(uocOrdZmInfoPO.getExt3()));
        abilityReqBO.setOrderNo(salePO.getSaleVoucherNo());
        try {
            abilityReqBO.setTotalAmount(MoneyUtils.Long2BigDecimal((Long)salePO.getSaleFee()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        abilityReqBO.setPayBusiness("2");
        abilityReqBO.setName(ordStakeholderPO.getPurPlaceOrderName());
        abilityReqBO.setUserName(ordStakeholderPO.getPurLogName());
        abilityReqBO.setDeptId(Long.valueOf(uocOrdZmInfoPO.getExt3()));
        abilityReqBO.setSupId(Long.valueOf(ordStakeholderPO.getProNo()));
        abilityReqBO.setOrderType(orderPO.getOrderType());
        abilityReqBO.setTradeMode(salePO.getModelSettle());
        FscAccountAdvanceDeductAbilityRspBO abilityRspBO = this.fscAccountAdvanceDeductAbilityService.dealAccountAdvanceDeduct(abilityReqBO);
        if (!("0000".equals(abilityRspBO.getRespCode()) || "0000".equals((abilityRspBO = this.fscAccountAdvanceDeductAbilityService.dealAccountAdvanceDeduct(abilityReqBO)).getRespCode()) || "0000".equals((abilityRspBO = this.fscAccountAdvanceDeductAbilityService.dealAccountAdvanceDeduct(abilityReqBO)).getRespCode()) || "0000".equals((abilityRspBO = this.fscAccountAdvanceDeductAbilityService.dealAccountAdvanceDeduct(abilityReqBO)).getRespCode()))) {
            log.error("\u6062\u590d\u8ba2\u5355 \u51bb\u7ed3\u8d26\u6237\u5931\u8d25 orderId:{},rsp:{}", (Object)salePO.getOrderId(), (Object)JSON.toJSONString((Object)abilityRspBO));
        }
    }

    @Override
    public PebUpdateOrderRspBO updateOrderArrivalTime(PebUpdateOrderReqBO reqBO) {
        UocOrdGoodsTempPO record;
        if (reqBO.getTempOrderId() != null) {
            record = new UocOrdGoodsTempPO();
            record.setOrderId(reqBO.getTempOrderId());
            record.setArrivalTime(reqBO.getOrderItemArrivalTime());
            if (reqBO.getIsUpdateAllArrivalTime() == 1) {
                this.uocOrdGoodsTempxMapper.updateArrivalTimeAll(record);
            } else {
                this.uocOrdGoodsTempxMapper.updateArrivalTime(record);
            }
        } else {
            record = new UocOrdGoodsTempPO();
            record.setOrderId(reqBO.getOrderId());
            record.setArrivalTime(reqBO.getOrderItemArrivalTime());
            if (reqBO.getIsUpdateAllArrivalTime() == 1) {
                this.uocOrdGoodsTempMapper.updateArrivalTimeAll(record);
            } else {
                this.uocOrdGoodsTempMapper.updateArrivalTime(record);
            }
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateOrderTax(PebUpdateOrderReqBO reqBO) {
        UocOrdGoodsTempPO record;
        if (reqBO.getTempOrderId() != null) {
            record = new UocOrdGoodsTempPO();
            record.setOrderId(reqBO.getTempOrderId());
            record.setTax(reqBO.getTax());
            if (reqBO.getIsUpdateAllTax() == 1) {
                this.uocOrdGoodsTempxMapper.updateTaxAll(record);
            } else {
                this.uocOrdGoodsTempxMapper.updateTax(record);
            }
        } else {
            record = new UocOrdGoodsTempPO();
            record.setOrderId(reqBO.getOrderId());
            record.setTax(reqBO.getTax());
            if (reqBO.getIsUpdateAllTax() == 1) {
                this.uocOrdGoodsTempMapper.updateTaxAll(record);
            } else {
                this.uocOrdGoodsTempMapper.updateTax(record);
            }
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateMergeOrderArrivalTime(PebUpdateOrderReqBO reqBO) {
        UocOrdGoodsTempPO record = new UocOrdGoodsTempPO();
        record.setOrderIds(reqBO.getOrderIds());
        record.setArrivalTime(reqBO.getOrderItemArrivalTime());
        if (reqBO.getIsUpdateAllArrivalTime() == 1) {
            this.uocOrdGoodsTempMapper.updateMergeArrivalTimeAll(record);
        } else {
            this.uocOrdGoodsTempMapper.updateMergeArrivalTime(record);
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BigDecimal calUntaxAmt(BigDecimal amt, BigDecimal taxRate, Integer SCALE) {
        return amt.divide(BigDecimal.ONE.add(taxRate), (int)SCALE, 4);
    }

    private void saveInvoice(PebUpdateOrderReqBO reqBO, Long orderId, Long saleId) {
        if (reqBO.getInvoiceBO() != null) {
            Long contactId;
            if (reqBO.getInvoiceAddressInfo() != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getInvoiceAddressInfo());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceUrl(reqBO.getInvoiceBO().getInvoiceUrl());
            ordInvoicePO.setBankAccount(reqBO.getInvoiceBO().getBankAccount());
            ordInvoicePO.setBuyerName(reqBO.getInvoiceBO().getBuyerName());
            ordInvoicePO.setCompanyAddress(reqBO.getInvoiceBO().getCompanyAddress());
            ordInvoicePO.setDepositBank(reqBO.getInvoiceBO().getDepositBank());
            ordInvoicePO.setFixPhone(reqBO.getInvoiceBO().getFixPhone());
            ordInvoicePO.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            ordInvoicePO.setInvoiceSn(reqBO.getInvoiceBO().getInvoiceSn());
            ordInvoicePO.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
            ordInvoicePO.setRelaEmail(reqBO.getInvoiceBO().getRelaEmail());
            ordInvoicePO.setRelaPhone(reqBO.getInvoiceBO().getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setOutInvoiceId(reqBO.getInvoiceBO().getUmcInvoiceId());
            ordInvoicePO.setInvoceCategory(reqBO.getInvoiceBO().getInvoceCategory());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return uocCoreCreateLogisticsRelaReqBO;
    }

    private void audit(OrdSalePO saleRspBO, PebUpdateOrderReqBO reqBO, PebUpdateOrderRspBO rspBO) {
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO;
        Long orderId = saleRspBO.getOrderId();
        OrdStakeholderPO stakeholderPo = this.ordStakeholderMapper.getModelById(orderId.longValue());
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(stakeholderPo.getPurPlaceOrderId());
        noTaskAuditCreateReqBO.setCreateOperName(stakeholderPo.getPurPlaceOrderName());
        noTaskAuditCreateReqBO.setCreateOperDept(stakeholderPo.getPurName());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setCreateOperId(stakeholderPo.getPurPlaceOrderId());
        infoReqBO.setUsername(stakeholderPo.getPurPlaceOrderName());
        infoReqBO.setRemark("\u521b\u5efa\u4f9b\u5e94\u5546\u63a5\u5355\u5ba1\u6279");
        infoReqBO.setOrderId(orderId);
        infoReqBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        Long saleId = saleRspBO.getSaleVoucherId();
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        approvalObjBO.setObjId(String.valueOf(saleId));
        ArrayList<ApprovalObjBO> objBoS = new ArrayList<ApprovalObjBO>(1);
        objBoS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBoS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBoS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBoS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBoS);
        noTaskAuditCreateReqBO.setLoginName(reqBO.getLoginName());
        noTaskAuditCreateReqBO.setOrgCode(reqBO.getOrgCodeIn());
        noTaskAuditCreateReqBO.setOrgId(stakeholderPo.getPurOrgId());
        noTaskAuditCreateReqBO.setOrgTreeId(stakeholderPo.getPurOrgPath());
        noTaskAuditCreateReqBO.setMenuId("M001103");
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(saleRspBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(saleRspBO.getOrderId());
        salePO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
        if (zmInfoPO != null) {
            if (StringUtils.isNotBlank((CharSequence)zmInfoPO.getExt1())) {
                noTaskAuditCreateReqBO.setProcDefKey(zmInfoPO.getExt1());
            }
            HashMap<String, Object> ows = new HashMap<String, Object>();
            ows.put("jhwzlb", ElUtils.getMaterialCategory(zmInfoPO.getMaterialCategory()));
            try {
                ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)ordSalePO.getSaleFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(ows, saleRspBO.getOrderId());
            noTaskAuditCreateReqBO.setVariables(ows);
        }
        if (!"0000".equals((uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO)).getRespCode())) {
            throw new UocProBusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new UocProBusinessException("8888", "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u6d41\u7a0b");
        }
        if (!CollectionUtils.isEmpty((Collection)uacNoTaskAuditCreateRspBO.getAuditNoticeList())) {
            List auditNoticeList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uacNoTaskAuditCreateRspBO.getAuditNoticeList()), UocNoTaskAuditOrderAuditNoticeBO.class);
            if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
                rspBO.getAuditNoticeList().addAll(auditNoticeList);
            } else {
                rspBO.setAuditNoticeList(auditNoticeList);
            }
        }
        SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
        sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
        sendNotificationExtAtomReqBO.setApprovalObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        sendNotificationExtAtomReqBO.setOrderId(reqBO.getOrderId());
        sendNotificationExtAtomReqBO.setOrderCode(salePO.getSaleVoucherNo());
        this.uocSendNotificationExtAtomService.sendOrderNotification(sendNotificationExtAtomReqBO);
        rspBO.setOrderId(saleRspBO.getOrderId());
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(orderId);
        ordSalePo.setSaleVoucherId(saleId);
        ordSalePo.setTbOrderId(uacNoTaskAuditCreateRspBO.getStepId());
        ordSalePo.setExt3("\u5ba1\u6279\u4e2d");
        this.ordSaleMapper.updateById(ordSalePo);
    }

    private void pushTodoWait(OrdSalePO ordSalePO) {
        try {
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(ordSalePO.getOrderId());
            uocTodoBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.COMMIT_APPROVE.getCode());
            uocTodoBO.setOperatorId(stakeholderPO.getPurPlaceOrderId());
            uocTodoBO.setOperatorNo(stakeholderPO.getPurLogName());
            uocTodoBO.setOperatorName(stakeholderPO.getPurPlaceOrderName());
            uocTodoBO.setOrgId(Long.valueOf(stakeholderPO.getPurOrgId()));
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }

    private void saveItem(OrdSalePO salePO, OrderPO orderPO, PebUpdateOrderReqBO reqBO, OrdSalePO last) {
        Long saleFee = 0L;
        OrdExtMapPO createType = new OrdExtMapPO();
        createType.setOrderId(salePO.getOrderId());
        createType.setFieldCode("createType");
        createType = this.ordExtMapMapper.getModelBy(createType);
        boolean pushFz = false;
        boolean pushHt = true;
        boolean pushScheme = false;
        if (createType != null) {
            if ("4".equals(createType.getFieldValue()) || "3".equals(createType.getFieldValue())) {
                pushFz = true;
                pushHt = false;
            } else if ("5".equals(createType.getFieldValue()) || "6".equals(createType.getFieldValue())) {
                pushHt = false;
                pushScheme = true;
            }
            if ("2".equals(createType.getFieldValue())) {
                pushHt = false;
            }
        }
        ArrayList<Integer> saleStateList = new ArrayList<Integer>();
        saleStateList.add(1107);
        ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
        ArrayList<ContractPlanOrderAbilityBo> planOrderReqBo = new ArrayList<ContractPlanOrderAbilityBo>();
        ArrayList<SscUpdateSchemeAmountBO> updateSchemeAmountBOS = new ArrayList<SscUpdateSchemeAmountBO>();
        boolean isYg = false;
        UocOrdGoodsTempPO tempPO = new UocOrdGoodsTempPO();
        tempPO.setOrderId(salePO.getOrderId());
        List list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        List xlist = new ArrayList();
        if (reqBO.getTempOrderId() != null) {
            tempPO.setOrderId(reqBO.getTempOrderId());
            xlist = this.uocOrdGoodsTempxMapper.selectByCondition(tempPO);
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(salePO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
        Map<Long, UocOrdGoodsTempPO> oldM = list.stream().collect(Collectors.toMap(UocOrdGoodsTempPO::getTempId, i -> i));
        if (CollectionUtils.isNotEmpty(xlist)) {
            ArrayList<Long> uIds = new ArrayList<Long>();
            for (UocOrdGoodsTempPO po : xlist) {
                UocOrdGoodsTempPO update = oldM.get(po.getTempId());
                po.setOrderId(reqBO.getOrderId());
                if (update != null) {
                    BeanUtils.copyProperties((Object)po, (Object)update);
                    this.uocOrdGoodsTempMapper.update(update);
                } else {
                    this.uocOrdGoodsTempMapper.insert(po);
                }
                uIds.add(po.getTempId());
            }
            ArrayList itemIds = new ArrayList();
            ArrayList<Long> delTemp = new ArrayList<Long>();
            for (UocOrdGoodsTempPO old : list) {
                if (uIds.contains(old.getTempId())) continue;
                itemIds.add(map.get(old.getTempId()).getOrdItemId());
                delTemp.add(old.getTempId());
                if (saleStateList.contains(last.getSaleState())) continue;
                if (pushFz) {
                    InterFaceContractUpdateOrderItemBO updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                    updateOrderItemBO.setGoodTypeId(old.getOutObjItemId());
                    updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                    updateOrderItemBO.setOperateType(0);
                    updateOrderItemBO.setOrderNum(old.getPurchaseCount());
                    operOrderItem.add(updateOrderItemBO);
                }
                if (pushHt) {
                    ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                    abilityBo.setItemId(old.getHtItemId());
                    abilityBo.setNum(old.getPurchaseCount().negate());
                    planOrderReqBo.add(abilityBo);
                }
                if (!pushScheme) continue;
                SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO = new SscUpdateSchemeAmountBO();
                sscUpdateSchemeAmountBO.setId(Long.valueOf(old.getOutObjItemId()));
                sscUpdateSchemeAmountBO.setOrderNum(old.getPurchaseCount());
                sscUpdateSchemeAmountBO.setOperateType(Integer.valueOf(0));
                sscUpdateSchemeAmountBO.setType(Integer.valueOf("5".equals(createType.getFieldValue()) ? 1 : 2));
                sscUpdateSchemeAmountBO.setQueryType(old.getFindSourceType());
                updateSchemeAmountBOS.add(sscUpdateSchemeAmountBO);
            }
            if (CollectionUtils.isNotEmpty((Collection)itemIds)) {
                OrdItemPO del = new OrdItemPO();
                del.setItemIds((List)itemIds);
                this.ordItemMapper.deleteByIds(del);
                UocOrdGoodsTempPO goodsTempPO = new UocOrdGoodsTempPO();
                goodsTempPO.setTempIds(delTemp);
                this.uocOrdGoodsTempMapper.deleteByIds(goodsTempPO);
                this.ordItemMapper.deletePurItemByIds(del);
                this.ordItemMapper.deletePayItemByIds(del);
                this.ordItemMapper.deleteZmItemByIds(del);
                ordItemPO = new OrdItemPO();
                ordItemPO.setOrderId(salePO.getOrderId());
                itemPOS = this.ordItemMapper.getList(ordItemPO);
                map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
            }
            tempPO = new UocOrdGoodsTempPO();
            tempPO.setOrderId(salePO.getOrderId());
            list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        }
        boolean haveTy = false;
        for (UocOrdGoodsTempPO goodsTempPO : list) {
            if (!goodsTempPO.getSkuMaterialId().endsWith("000000")) continue;
            haveTy = true;
            break;
        }
        if (haveTy) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(salePO.getOrderId());
            zmInfoPO.setIsPushErp(PebExtConstant.NO);
            this.uocOrdZmInfoMapper.update(zmInfoPO);
        }
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(reqBO.getOrderId());
        purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
        OrdPayPO payPO = new OrdPayPO();
        payPO.setOrderId(reqBO.getOrderId());
        payPO = this.ordPayMapper.getModelBy(payPO);
        ArrayList<UocOrdZmItemPO> zmItemInsert = new ArrayList<UocOrdZmItemPO>();
        ArrayList<OrdPayItemPO> payItemPOS = new ArrayList<OrdPayItemPO>();
        for (UocOrdGoodsTempPO goodsTempPO : list) {
            SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO;
            InterFaceContractUpdateOrderItemBO updateOrderItemBO;
            if ("10".equals(goodsTempPO.getOutObjType())) {
                isYg = true;
            }
            BigDecimal purChaseCountAll = goodsTempPO.getPurchaseCount();
            OrdPayItemPO payItemPO = new OrdPayItemPO();
            OrdItemPO itemPO = new OrdItemPO();
            OrdItemPO qry = map.get(goodsTempPO.getTempId());
            if (qry == null) {
                Long id = this.insertItem(goodsTempPO, payItemPOS, salePO.getSaleVoucherId(), purchasePO, payPO.getPayVoucherId());
                UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
                BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
                zmItemPO.setOrdItemId(id);
                zmItemInsert.add(zmItemPO);
                try {
                    saleFee = saleFee + MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!saleStateList.contains(last.getSaleState())) {
                    if (pushFz) {
                        InterFaceContractUpdateOrderItemBO updateOrderItemBO2 = new InterFaceContractUpdateOrderItemBO();
                        updateOrderItemBO2.setGoodTypeId(goodsTempPO.getOutObjItemId());
                        updateOrderItemBO2.setType(Integer.valueOf(createType.getFieldValue()));
                        updateOrderItemBO2.setOperateType(1);
                        updateOrderItemBO2.setOrderNum(goodsTempPO.getPurchaseCount());
                        operOrderItem.add(updateOrderItemBO2);
                    }
                    if (pushHt) {
                        ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                        abilityBo.setItemId(goodsTempPO.getHtItemId());
                        abilityBo.setNum(goodsTempPO.getPurchaseCount());
                        planOrderReqBo.add(abilityBo);
                    }
                    if (pushScheme) {
                        SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO2 = new SscUpdateSchemeAmountBO();
                        sscUpdateSchemeAmountBO2.setId(Long.valueOf(goodsTempPO.getOutObjItemId()));
                        sscUpdateSchemeAmountBO2.setOrderNum(goodsTempPO.getPurchaseCount());
                        sscUpdateSchemeAmountBO2.setOperateType(Integer.valueOf(1));
                        sscUpdateSchemeAmountBO2.setType(Integer.valueOf("5".equals(createType.getFieldValue()) ? 1 : 2));
                        sscUpdateSchemeAmountBO2.setQueryType(goodsTempPO.getFindSourceType());
                        updateSchemeAmountBOS.add(sscUpdateSchemeAmountBO2);
                    }
                }
                this.insertExtMap(purchasePO.getOrderId(), id, goodsTempPO);
            } else {
                if (!saleStateList.contains(last.getSaleState())) {
                    BigDecimal count;
                    if (pushFz) {
                        updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                        updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                        updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                        count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        if (count.compareTo(BigDecimal.ZERO) > 0) {
                            updateOrderItemBO.setOperateType(0);
                            updateOrderItemBO.setOrderNum(count);
                            operOrderItem.add(updateOrderItemBO);
                        } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                            updateOrderItemBO.setOperateType(1);
                            updateOrderItemBO.setOrderNum(count.negate());
                            operOrderItem.add(updateOrderItemBO);
                        }
                    }
                    if (pushHt) {
                        BigDecimal count2 = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                        abilityBo.setItemId(goodsTempPO.getHtItemId());
                        abilityBo.setNum(count2.negate());
                        if (count2.compareTo(BigDecimal.ZERO) > 0) {
                            planOrderReqBo.add(abilityBo);
                        } else if (count2.compareTo(BigDecimal.ZERO) < 0) {
                            planOrderReqBo.add(abilityBo);
                        }
                    }
                    if (pushScheme) {
                        sscUpdateSchemeAmountBO = new SscUpdateSchemeAmountBO();
                        sscUpdateSchemeAmountBO.setId(Long.valueOf(goodsTempPO.getOutObjItemId()));
                        sscUpdateSchemeAmountBO.setType(Integer.valueOf("5".equals(createType.getFieldValue()) ? 1 : 2));
                        sscUpdateSchemeAmountBO.setQueryType(goodsTempPO.getFindSourceType());
                        count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        if (count.compareTo(BigDecimal.ZERO) > 0) {
                            sscUpdateSchemeAmountBO.setOperateType(Integer.valueOf(0));
                            sscUpdateSchemeAmountBO.setOrderNum(count);
                            updateSchemeAmountBOS.add(sscUpdateSchemeAmountBO);
                        } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                            sscUpdateSchemeAmountBO.setOperateType(Integer.valueOf(1));
                            sscUpdateSchemeAmountBO.setOrderNum(count.negate());
                            updateSchemeAmountBOS.add(sscUpdateSchemeAmountBO);
                        }
                    }
                }
                itemPO.setOrdItemId(qry.getOrdItemId());
                itemPO.setOrderId(salePO.getOrderId());
                itemPO.setTempId(goodsTempPO.getTempId());
                itemPO.setTempId(goodsTempPO.getTempId());
                itemPO.setPurchaseCount(goodsTempPO.getPurchaseCount());
                itemPO.setSupAccount(goodsTempPO.getExt9());
                itemPO.setSkuSimpleName(goodsTempPO.getSkuSupplierName());
                try {
                    itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice()));
                    itemPO.setPurchaseDecimalPrice(goodsTempPO.getSalePrice());
                    itemPO.setSaleDecimalPrice(goodsTempPO.getSalePrice());
                    itemPO.setTotalSaleDecimalPrice(goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                    itemPO.setTotalPurchaseDecimalPrice(goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                    saleFee = saleFee + MoneyUtils.BigDecimal2Long((BigDecimal)itemPO.getTotalSaleDecimalPrice());
                    itemPO.setPurchasePrice(itemPO.getSalePrice());
                    itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalSalePrice()));
                    itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
                    itemPO.setNakedPrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalNakePrice()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                itemPO.setOrganizationId(goodsTempPO.getOrganizationId());
                itemPO.setOrganizationName(goodsTempPO.getOrganizationName());
                itemPO.setOrganizationCode(goodsTempPO.getOrganizationCode());
                itemPO.setArrivalTime(goodsTempPO.getArrivalTime());
                this.ordItemMapper.updateById(itemPO);
                payItemPO.setPayCount(itemPO.getPurchaseCount());
                payItemPO.setPayFee(itemPO.getSalePrice());
                payItemPO.setTotalFee(itemPO.getTotalSaleFee());
                payItemPO.setOrderId(itemPO.getOrderId());
                payItemPO.setOrdItemId(itemPO.getOrdItemId());
                this.ordPayItemMapper.updateById(payItemPO);
                UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
                BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
                zmItemPO.setOrdItemId(itemPO.getOrdItemId());
                this.uocOrdZmItemMapper.update(zmItemPO);
                OrdGoodsPO goodsPO = new OrdGoodsPO();
                goodsPO.setSkuMaterialRemark(goodsTempPO.getSkuMaterialRemark());
                goodsPO.setOrdItemId(itemPO.getOrdItemId());
                this.ordGoodsMapper.updateByItem(goodsPO);
                goodsTempPO.setPurchaseCount(itemPO.getPurchaseCount().subtract(qry.getPurchaseCount()));
                this.updateExtMap(qry, goodsTempPO);
            }
            if (!saleStateList.contains(last.getSaleState()) || !"1".equals(reqBO.getSubmit())) continue;
            if (pushFz) {
                updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                updateOrderItemBO.setOperateType(1);
                updateOrderItemBO.setOrderNum(purChaseCountAll);
                operOrderItem.add(updateOrderItemBO);
            }
            if (pushHt) {
                ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                abilityBo.setItemId(goodsTempPO.getHtItemId());
                abilityBo.setNum(purChaseCountAll);
                planOrderReqBo.add(abilityBo);
            }
            if (!pushScheme) continue;
            sscUpdateSchemeAmountBO = new SscUpdateSchemeAmountBO();
            sscUpdateSchemeAmountBO.setId(Long.valueOf(goodsTempPO.getOutObjItemId()));
            sscUpdateSchemeAmountBO.setOrderNum(goodsTempPO.getPurchaseCount());
            sscUpdateSchemeAmountBO.setOperateType(Integer.valueOf(1));
            sscUpdateSchemeAmountBO.setType(Integer.valueOf("5".equals(createType.getFieldValue()) ? 1 : 2));
            sscUpdateSchemeAmountBO.setQueryType(goodsTempPO.getFindSourceType());
            updateSchemeAmountBOS.add(sscUpdateSchemeAmountBO);
        }
        salePO.setSaleFee(saleFee);
        salePO.setPurchaseFee(saleFee);
        this.ordSaleMapper.updateById(salePO);
        orderPO.setTotalSaleFee(saleFee);
        orderPO.setTotalPurchaseFee(saleFee);
        this.orderMapper.updateById(orderPO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setPayFee(saleFee);
        this.ordPayMapper.updateById(ordPayPO);
        if (CollectionUtils.isNotEmpty(zmItemInsert)) {
            this.uocOrdZmItemMapper.insertBatch(zmItemInsert);
            this.ordPayItemMapper.insertBatch(payItemPOS);
        }
        BigDecimal fee = MoneyUtil.l4B((Long)(saleFee - last.getSaleFee()));
        if (pushHt && PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setOrderId(reqBO.getOrderId());
            extMapPO.setObjId(reqBO.getOrderId());
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            extMapPO.setFieldCode("contractFee");
            OrdExtMapPO qry = this.ordExtMapMapper.getModelBy(extMapPO);
            OrdAgreementPO agreementPO = new OrdAgreementPO();
            agreementPO.setOrderId(reqBO.getOrderId());
            agreementPO = (OrdAgreementPO)this.ordAgreementMapper.selectByCondition(agreementPO).get(0);
            ContractOrderedAmountSynAbilityReqBO abilityReqBO = new ContractOrderedAmountSynAbilityReqBO();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(agreementPO.getAgreementId()));
            abilityReqBO.setContractIds(ids);
            boolean flag = true;
            if (qry != null && PebExtConstant.YES.toString().equals(qry.getFieldValue())) {
                abilityReqBO.setOrderAmount(fee);
                if (fee.compareTo(BigDecimal.ZERO) > 0) {
                    abilityReqBO.setOperType("0");
                } else {
                    abilityReqBO.setOperType("1");
                }
                if (fee.compareTo(BigDecimal.ZERO) == 0) {
                    flag = false;
                }
            } else {
                BigDecimal pushFee = BigDecimal.ZERO;
                if (PebExtConstant.YES.equals(agreementPO.getAssignStatus())) {
                    pushFee = MoneyUtil.l4B((Long)saleFee);
                } else {
                    OrdItemPO ordItemPo = new OrdItemPO();
                    ordItemPo.setOrderId(reqBO.getOrderId());
                    List ordItemList = this.ordItemMapper.getList(ordItemPo);
                    for (OrdItemPO itemPO : ordItemList) {
                        try {
                            BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0) : new BigDecimal(itemPO.getTax()).divide(BigDecimal.valueOf(100L));
                            BigDecimal djs = MoneyUtil.l4B((Long)itemPO.getTotalSaleFee());
                            BigDecimal taxA = price.add(BigDecimal.ONE);
                            pushFee = pushFee.add(djs.subtract(djs.multiply(price).divide(taxA, 2, 4)));
                        }
                        catch (Exception exception) {}
                    }
                }
                abilityReqBO.setOrderAmount(pushFee);
                abilityReqBO.setOperType("0");
            }
            if (flag) {
                ContractOrderedAmountSynAbilityRspBO rspBO = this.contractOrderedAmountSynAbilityService.orderedAmountSyn(abilityReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
                }
                extMapPO.setFieldName("\u4fee\u6539\u5408\u540c\u9650\u989d");
                if (qry != null) {
                    extMapPO.setId(qry.getId());
                    extMapPO.setFieldValue(PebExtConstant.YES.toString());
                    this.ordExtMapMapper.updateById(extMapPO);
                } else {
                    extMapPO.setFieldValue(PebExtConstant.YES.toString());
                    extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                    this.ordExtMapMapper.insert(extMapPO);
                }
            }
        }
        if (!operOrderItem.isEmpty()) {
            if (isYg) {
                SscSchemeAmountReqBO amountReqBO = new SscSchemeAmountReqBO();
                amountReqBO.setTypeAmount(Integer.valueOf(1));
                ArrayList<SscSchemeAmountBO> ygList = new ArrayList<SscSchemeAmountBO>();
                for (InterFaceContractUpdateOrderItemBO skuInfo : operOrderItem) {
                    SscSchemeAmountBO bo = new SscSchemeAmountBO();
                    bo.setGoodTypeId(skuInfo.getGoodTypeId());
                    bo.setOperateType(skuInfo.getOperateType());
                    bo.setType(skuInfo.getType());
                    bo.setOrderNum(skuInfo.getOrderNum());
                    ygList.add(bo);
                }
                amountReqBO.setOrderItem(ygList);
                SscSchemeAmountRspBO rspBO = this.schemeAmountService.updateSchemeOrderAmount(amountReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException(rspBO.getRespCode(), "\u4fee\u6539\u65b9\u6848\u660e\u7ec6\u62a5\u9519\uff1a" + rspBO.getRespDesc());
                }
            } else {
                InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
                interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getToken());
                interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
                InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateSchemeOrderItemStatus(interFaceContractUpdateOrderItemAtomReqBO);
                if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                    throw new UocProBusinessException(interFaceContractUpdateOrderItemAtomRspBO.getRespCode(), "\u4fee\u6539\u65b9\u6848\u660e\u7ec6\u62a5\u9519\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
                }
            }
        }
        if (!planOrderReqBo.isEmpty()) {
            ContractPlanOrderAbilityReqBo reqBo = new ContractPlanOrderAbilityReqBo();
            reqBo.setPlanOrderReqBo(planOrderReqBo);
            ContractPlanOrderAbilityRspBo abilityRspBo = this.contractPlanOrderAbilityService.dealContractOrder(reqBo);
            if (!"0000".equals(abilityRspBo.getRespCode())) {
                throw new UocProBusinessException(abilityRspBo.getRespCode(), "\u5408\u540c\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a" + abilityRspBo.getRespDesc());
            }
        }
        if (CollectionUtils.isNotEmpty(updateSchemeAmountBOS)) {
            SscUpdateSchemeAmountReqBO sscUpdateSchemeAmountReqBO = new SscUpdateSchemeAmountReqBO();
            sscUpdateSchemeAmountReqBO.setReqBOs(updateSchemeAmountBOS);
            log.info("\u8be2\u6bd4/\u5b9a\u6807\u62a5\u544a\u4fee\u6539\u7ed3\u679c\u4e0b\u5355\u91cf\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)sscUpdateSchemeAmountReqBO));
            SscSchemeAmountRspBO updateRspBO = this.schemeAmountService.updateDdCount(sscUpdateSchemeAmountReqBO);
            log.info("\u8be2\u6bd4/\u5b9a\u6807\u62a5\u544a\u4fee\u6539\u7ed3\u679c\u4e0b\u5355\u91cf\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)updateRspBO));
            if (!"0000".equals(updateRspBO.getRespCode())) {
                log.error("\u8be2\u6bd4/\u5b9a\u6807\u62a5\u544a\u4fee\u6539\u7ed3\u679c\u4e0b\u5355\u91cf\u5f02\u5e38\uff1a" + updateRspBO.getRespDesc());
                throw new UocProBusinessException(updateRspBO.getRespCode(), "\u8be2\u6bd4/\u5b9a\u6807\u62a5\u544a\u4fee\u6539\u7ed3\u679c\u4e0b\u5355\u91cf\u5f02\u5e38\uff1a\uff1a" + updateRspBO.getRespDesc());
            }
        }
    }

    private void dealItem(OrdSalePO salePO, OrderPO orderPO, PebUpdateOrderReqBO reqBO) {
        HashSet<Long> ordItemIds = new HashSet<Long>();
        for (UocOrdItemUpdateBO pebExtOrdItemRspBO : reqBO.getOrdItemUpdateList()) {
            if (pebExtOrdItemRspBO.getOrdItemId() == null) continue;
            ordItemIds.add(pebExtOrdItemRspBO.getOrdItemId());
        }
        if (CollectionUtils.isEmpty(ordItemIds)) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a\u4f20\u5165\u7684ordItemId\u6709\u8bef");
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrdItemIdList(new ArrayList(ordItemIds));
        List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrdItemIdList(new ArrayList(ordItemIds));
        List ordGoodsPOS = this.ordGoodsMapper.getList(ordGoodsPO);
        if (CollectionUtils.isEmpty((Collection)ordItemPOS) || ordItemPOS.size() != ordItemIds.size()) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a\u4f20\u5165\u7684ordItemId\u6709\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)ordGoodsPOS) || ordGoodsPOS.size() != ordItemIds.size()) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a\u4f20\u5165\u7684ordItemId\u6709\u8bef");
        }
        Map<Long, OrdItemPO> itemPOMap = ordItemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, e -> e, (k, v) -> k));
        Map<Long, OrdGoodsPO> goodsPOMap = ordGoodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, e -> e, (k, v) -> k));
        Long totalSaleFee = 0L;
        Long totalPurchaseFee = 0L;
        for (UocOrdItemUpdateBO pebExtOrdItemRspBO : reqBO.getOrdItemUpdateList()) {
            if (itemPOMap.get(pebExtOrdItemRspBO.getOrdItemId()) == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a:\u660e\u7ec6id\u67e5\u8be2\u660e\u7ec6\u5931\u8d25");
            }
            OrdItemPO ordItemPO1 = itemPOMap.get(pebExtOrdItemRspBO.getOrdItemId());
            Long sumSaleFee = new BigDecimal(ordItemPO1.getSalePrice()).multiply(pebExtOrdItemRspBO.getPurchaseCount()).longValue();
            Long sumPurchaseFee = new BigDecimal(ordItemPO1.getPurchasePrice()).multiply(pebExtOrdItemRspBO.getPurchaseCount()).longValue();
            this.updatePrice(itemPOMap, goodsPOMap, pebExtOrdItemRspBO, sumSaleFee, sumPurchaseFee, pebExtOrdItemRspBO.getPurchaseCount());
            try {
                totalSaleFee = totalSaleFee + MoneyUtils.BigDecimal2Long((BigDecimal)ordItemPO1.getSaleDecimalPrice().multiply(pebExtOrdItemRspBO.getPurchaseCount()).setScale(2, 4));
                totalPurchaseFee = totalPurchaseFee + MoneyUtils.BigDecimal2Long((BigDecimal)ordItemPO1.getPurchaseDecimalPrice().multiply(pebExtOrdItemRspBO.getPurchaseCount()).setScale(2, 4));
            }
            catch (Exception exception) {}
        }
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(reqBO.getOrderId());
        purchasePO.setPurchaseFee(totalPurchaseFee);
        purchasePO.setSaleFee(totalSaleFee);
        purchasePO.setOrderId(reqBO.getOrderId());
        this.ordPurchaseMapper.updateById(purchasePO);
        salePO.setSaleFee(totalSaleFee);
        salePO.setPurchaseFee(totalPurchaseFee);
        this.ordSaleMapper.updateById(salePO);
        orderPO.setTotalSaleFee(totalSaleFee);
        orderPO.setTotalPurchaseFee(totalPurchaseFee);
        this.orderMapper.updateById(orderPO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setPayFee(totalSaleFee);
        this.ordPayMapper.updateById(ordPayPO);
    }

    private void updatePrice(Map<Long, OrdItemPO> itemPOMap, Map<Long, OrdGoodsPO> goodsPOMap, UocOrdItemUpdateBO pebExtOrdItemRspBO, Long sumSaleFee, Long sumPurchaseFee, BigDecimal purchaseCount) {
        Long ordItemId = pebExtOrdItemRspBO.getOrdItemId();
        if (itemPOMap.get(ordItemId) == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a:\u660e\u7ec6id\u67e5\u8be2\u660e\u7ec6\u5931\u8d25");
        }
        OrdItemPO ordItemPO = itemPOMap.get(ordItemId);
        OrdPurchaseItemPO ordPurchaseItemPO = new OrdPurchaseItemPO();
        ordPurchaseItemPO.setOrderItemId(ordItemId);
        ordPurchaseItemPO.setPurchaseCount(purchaseCount);
        ordPurchaseItemPO.setTotalPurchaseFee(sumPurchaseFee);
        ordPurchaseItemPO.setTotalSaleFee(sumSaleFee);
        ordPurchaseItemPO.setOrderId(ordItemPO.getOrderId());
        ordPurchaseItemPO.setTotalPurchaseDecimalPrice(ordItemPO.getPurchaseDecimalPrice().multiply(purchaseCount).setScale(2, 4));
        ordPurchaseItemPO.setTotalSaleDecimalPrice(ordItemPO.getSaleDecimalPrice().multiply(purchaseCount).setScale(2, 4));
        this.ordPurchaseItemMapper.updateById(ordPurchaseItemPO);
        OrdPayItemPO ordPayItemPO = new OrdPayItemPO();
        ordPayItemPO.setOrdItemId(ordItemId);
        ordPayItemPO.setPayFee(sumSaleFee);
        ordPayItemPO.setTotalPurchaseDecimalPrice(ordPurchaseItemPO.getTotalPurchaseDecimalPrice());
        ordPayItemPO.setTotalSaleDecimalPrice(ordPurchaseItemPO.getTotalSaleDecimalPrice());
        ordPayItemPO.setOrderId(ordItemPO.getOrderId());
        ordPayItemPO.setPurchaseCount(purchaseCount);
        this.ordPayItemMapper.updateById(ordPayItemPO);
        ordItemPO.setPurchaseCount(pebExtOrdItemRspBO.getPurchaseCount());
        ordItemPO.setTotalPurchaseFee(sumPurchaseFee);
        ordItemPO.setTotalSaleFee(sumSaleFee);
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getOrganizationId())) {
            ordItemPO.setOrganizationId(pebExtOrdItemRspBO.getOrganizationId());
        }
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getOrganizationName())) {
            ordItemPO.setOrganizationName(pebExtOrdItemRspBO.getOrganizationName());
        }
        ordItemPO.setTotalPurchaseDecimalPrice(ordPurchaseItemPO.getTotalPurchaseDecimalPrice());
        ordItemPO.setTotalSaleDecimalPrice(ordPurchaseItemPO.getTotalSaleDecimalPrice());
        this.ordItemMapper.updateById(ordItemPO);
        OrdGoodsPO OrdGoodsPO2 = goodsPOMap.get(ordItemId);
        if (OrdGoodsPO2 == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a:\u660e\u7ec6id\u67e5\u8be2\u5546\u54c1\u8868\u5931\u8d25");
        }
        boolean updateGoods = false;
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getMaterialRemark())) {
            OrdGoodsPO2.setSkuMaterialRemark(pebExtOrdItemRspBO.getMaterialRemark());
            updateGoods = true;
        }
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getTechnicalParameters())) {
            OrdGoodsPO2.setExt1(pebExtOrdItemRspBO.getTechnicalParameters());
            updateGoods = true;
        }
        if (updateGoods) {
            this.ordGoodsMapper.updateById(OrdGoodsPO2);
        }
    }

    private Long insertItem(UocOrdGoodsTempPO tempPO, List<OrdPayItemPO> list, Long saleId, OrdPurchasePO purchaseP, Long payId) {
        PlanDiversionInfo diversionInfo;
        OrdItemPO itemPO = new OrdItemPO();
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        itemPO.setOrdItemId(Long.valueOf(this.idUtil.nextId()));
        goodsPO.setOrdItemId(itemPO.getOrdItemId());
        goodsPO.setGoodsItemId(Long.valueOf(this.idUtil.nextId()));
        itemPO.setTempId(tempPO.getTempId());
        itemPO.setPurchaseVoucherId(purchaseP.getPurchaseVoucherId());
        goodsPO.setSkuCode(tempPO.getSkuCode());
        goodsPO.setSkuMaterialId(tempPO.getSkuMaterialId());
        goodsPO.setCreateTime(new Date());
        itemPO.setItemType(Integer.valueOf(2));
        if (StringUtils.isBlank((CharSequence)tempPO.getSkuId())) {
            itemPO.setSkuId(tempPO.getSkuMaterialId().trim());
            itemPO.setSkuName(tempPO.getSkuMaterialName());
            goodsPO.setSkuName(tempPO.getSkuMaterialName());
            goodsPO.setSkuId(tempPO.getSkuMaterialId().trim());
            goodsPO.setSpuId(tempPO.getSkuMaterialId());
        } else {
            itemPO.setSkuId(tempPO.getSkuId());
            itemPO.setSkuName(tempPO.getSkuName());
            goodsPO.setSkuId(tempPO.getSkuId());
            goodsPO.setSkuName(tempPO.getSkuName());
        }
        itemPO.setOrderId(purchaseP.getOrderId());
        itemPO.setExtField6(tempPO.getExt5());
        itemPO.setExtField7(tempPO.getExt4());
        goodsPO.setOrderId(purchaseP.getOrderId());
        itemPO.setSaleVoucherId(saleId);
        goodsPO.setSkuMaterialName(tempPO.getExt8());
        itemPO.setExtField2(tempPO.getSkuMaterialName());
        goodsPO.setSkuMaterialTypeId(tempPO.getExt1());
        goodsPO.setSkuMaterialTypeName(tempPO.getExt2());
        itemPO.setPurchaseCount(tempPO.getPurchaseCount());
        goodsPO.setExt4(tempPO.getExt6());
        goodsPO.setExt6(tempPO.getExt7());
        goodsPO.setFindSourceType(tempPO.getFindSourceType());
        itemPO.setSupAccount(tempPO.getExt9());
        itemPO.setSkuSimpleName(tempPO.getSkuSupplierName());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getHtId())) {
            itemPO.setExtField1(tempPO.getHtId());
        }
        try {
            itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice().multiply(tempPO.getPurchaseCount())));
            itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
            itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            itemPO.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            itemPO.setArriveCount(BigDecimal.ZERO);
            itemPO.setSendCount(BigDecimal.ZERO);
            itemPO.setRefuseCount(BigDecimal.ZERO);
            itemPO.setReturnCount(BigDecimal.ZERO);
            itemPO.setAcceptanceCount(BigDecimal.ZERO);
            itemPO.setInspChangeCount(BigDecimal.ZERO);
            itemPO.setAfterServingCount(BigDecimal.ZERO);
            itemPO.setSaleDecimalPrice(tempPO.getSalePrice());
            itemPO.setPurchaseDecimalPrice(tempPO.getSalePrice());
            itemPO.setTotalSaleDecimalPrice(tempPO.getSalePrice().multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            itemPO.setTotalPurchaseDecimalPrice(tempPO.getSalePrice().multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            goodsPO.setSaleDecimalPrice(tempPO.getSalePrice());
            goodsPO.setPurchaseDecimalPrice(tempPO.getSalePrice());
            goodsPO.setTotalSaleDecimalPrice(tempPO.getSalePrice().multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            goodsPO.setTotalPurchaseDecimalPrice(tempPO.getSalePrice().multiply(tempPO.getPurchaseCount()).setScale(2, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)tempPO.getPlanId())) {
            itemPO.setPlanId(Long.valueOf(tempPO.getPlanId()));
        }
        goodsPO.setSkuMaterialRemark(tempPO.getSkuMaterialRemark());
        itemPO.setOrganizationId(tempPO.getOrganizationId());
        itemPO.setOrganizationName(tempPO.getOrganizationName());
        itemPO.setOrganizationCode(tempPO.getOrganizationCode());
        itemPO.setExtField3(tempPO.getMaterialUnitName());
        itemPO.setTaxId(tempPO.getTaxCode());
        itemPO.setTax(tempPO.getTax());
        itemPO.setUnitName(tempPO.getUnitName());
        goodsPO.setModel(tempPO.getModel());
        goodsPO.setSpec(tempPO.getSpec());
        if (tempPO.getArrivalTime() != null) {
            itemPO.setArrivalTime(String.valueOf(tempPO.getArrivalTime()));
        } else {
            itemPO.setArrivalTime(this.maxShipTime);
        }
        itemPO.setSettleUnit(tempPO.getExt1());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getExt2())) {
            itemPO.setSalesUnitRate(new BigDecimal(tempPO.getExt2()));
        }
        itemPO.setSupNo(String.valueOf(tempPO.getSupplierShopId()));
        itemPO.setSupplierShopId(tempPO.getSupplierShopId());
        goodsPO.setSupplierShopId(tempPO.getSupplierShopId());
        goodsPO.setSupplierShopName(tempPO.getSkuSupplierName());
        goodsPO.setSkuCurrencyType("CNY");
        goodsPO.setSkuBrandName(tempPO.getPpcd());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getExt3())) {
            goodsPO.setSkuCommodityTypeId(Long.valueOf(tempPO.getExt3()));
        }
        goodsPO.setSkuMaterialTypeId(tempPO.getCateCode());
        goodsPO.setSkuMaterialTypeName(tempPO.getCateName());
        goodsPO.setMaterialBj(tempPO.getMaterialBj());
        goodsPO.setExt1(tempPO.getZljsyq());
        itemPO.setInspectionExcessPercent(Integer.valueOf(0));
        OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
        BeanUtils.copyProperties((Object)itemPO, (Object)purchaseItemPO);
        purchaseItemPO.setPurchaseItemId(Long.valueOf(this.idUtil.nextId()));
        purchaseItemPO.setOrderItemId(itemPO.getOrdItemId());
        if (itemPO.getPlanId() != null && (diversionInfo = this.planDiversionMapper.selectOneByPlanId(itemPO.getPlanId())) != null) {
            itemPO.setPlanItemId(diversionInfo.getLineId());
            itemPO.setPlanItemNo(diversionInfo.getScheduleNo());
        }
        this.ordItemMapper.insert(itemPO);
        this.ordGoodsMapper.insert(goodsPO);
        this.ordPurchaseItemMapper.insert(purchaseItemPO);
        OrdPayItemPO uocOrderPayItemBO = new OrdPayItemPO();
        uocOrderPayItemBO.setOrdItemId(itemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjId(itemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
        uocOrderPayItemBO.setPurchaseCount(itemPO.getPurchaseCount());
        uocOrderPayItemBO.setUnitName(itemPO.getUnitName());
        uocOrderPayItemBO.setSalePrice(itemPO.getSalePrice());
        uocOrderPayItemBO.setPurchasePrice(itemPO.getPurchasePrice());
        uocOrderPayItemBO.setCurrencyType(itemPO.getCurrencyType());
        uocOrderPayItemBO.setPayCount(itemPO.getPurchaseCount());
        uocOrderPayItemBO.setTotalFee(itemPO.getTotalSaleFee());
        uocOrderPayItemBO.setPayFee(itemPO.getTotalSaleFee());
        uocOrderPayItemBO.setOrderId(purchaseP.getOrderId());
        uocOrderPayItemBO.setPayItemId(Long.valueOf(this.idUtil.nextId()));
        uocOrderPayItemBO.setReduceFee(Long.valueOf(0L));
        uocOrderPayItemBO.setPayVoucherId(payId);
        uocOrderPayItemBO.setSaleDecimalPrice(tempPO.getSalePrice());
        uocOrderPayItemBO.setPurchaseDecimalPrice(tempPO.getSalePrice());
        uocOrderPayItemBO.setTotalSaleDecimalPrice(tempPO.getSalePrice().multiply(tempPO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP));
        uocOrderPayItemBO.setTotalPurchaseDecimalPrice(tempPO.getSalePrice().multiply(tempPO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP));
        list.add(uocOrderPayItemBO);
        return itemPO.getOrdItemId();
    }

    private void saveAccessory(PebUpdateOrderReqBO reqBO, Long orderId) {
        if (reqBO.getDelAccessFlag().booleanValue()) {
            OrdAccessoryPO po = new OrdAccessoryPO();
            po.setOrderId(orderId);
            po.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            po.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            this.ordAccessoryMapper.deleteBy(po);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("CREATE_ORDER");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void updateExt(String key, String name, String val, Long orderId) {
        if (val.equals("")) {
            val = " ";
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        extMapPO.setObjId(orderId);
        extMapPO.setOrderId(orderId);
        this.ordExtMapMapper.updateById(extMapPO);
    }

    private void updateAddr(PebExtAddressInfoIntfceReqBO addressInfoIntfceBO, OrdSalePO salePO) {
        OrdLogisticsRelaPO relaPO = new OrdLogisticsRelaPO();
        relaPO.setOrderId(salePO.getOrderId());
        relaPO.setContactId(salePO.getContactId());
        relaPO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        relaPO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        relaPO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        relaPO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        relaPO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        relaPO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        relaPO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        relaPO.setContactName(addressInfoIntfceBO.getReceiverName());
        relaPO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        relaPO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        relaPO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        relaPO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        relaPO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        relaPO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        relaPO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        relaPO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        this.ordLogisticsRelaMapper.updateById(relaPO);
    }

    @Override
    public PebUpdateOrderRspBO updateHt(PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String cz = "3";
        String cd = "4";
        if (cz.equals(reqBO.getType()) || cd.equals(reqBO.getType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (PebExtConstant.Modelsettle.CH.equals(salePO.getModelSettle())) {
                this.updateContact(reqBO);
            }
            OrdSalePO update = new OrdSalePO();
            update.setOrderId(reqBO.getOrderId());
            update.setSaleVoucherId(reqBO.getSaleVoucherId());
            update.setChnlId(reqBO.getType());
            this.ordSaleMapper.updateById(update);
            return rspBO;
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO.setExt1(reqBO.getType());
        this.ordSaleMapper.updateById(salePO);
        this.updateContact(reqBO);
        return rspBO;
    }

    private void updateContact(PebUpdateOrderReqBO reqBO) {
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getContractNo())) {
            UocOrdContractPO uocOrdContractPO = new UocOrdContractPO();
            uocOrdContractPO.setOrderId(reqBO.getOrderId());
            uocOrdContractPO.setContractId(reqBO.getContractId());
            uocOrdContractPO.setContractNo(reqBO.getContractNo());
            uocOrdContractPO.setContractName(reqBO.getContractName());
            this.uocOrdContractMapper.updateByOrderId(uocOrdContractPO);
            UocOrdContractChangePO uocOrdContractChangePO = new UocOrdContractChangePO();
            uocOrdContractChangePO.setId(Long.valueOf(this.idUtil.nextId()));
            uocOrdContractChangePO.setObjectId(reqBO.getOrderId());
            uocOrdContractChangePO.setApplyId(reqBO.getContractId());
            uocOrdContractChangePO.setApplyNo(reqBO.getContractNo());
            uocOrdContractChangePO.setPushStatus(UocCoreConstant.PUSH_STATUS.NO_PUSH);
            uocOrdContractChangePO.setType(UocCoreConstant.PUSH_TYPE.REAL_CONTRACT_NO);
            uocOrdContractChangePO.setCreateTime(new Date());
            this.uocOrdContractChangeMapper.insert(uocOrdContractChangePO);
        }
    }

    @Override
    public PebUpdateOrderRspBO updateFscStatus(PebUpdateOrderReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        reqBO.setSaleVoucherId(salePO.getSaleVoucherId());
        OrderPO orderPO = new OrderPO();
        orderPO.setExt9(reqBO.getFscStatus());
        orderPO.setExt10(reqBO.getFscStatus());
        orderPO.setOrderId(reqBO.getOrderId());
        this.orderMapper.updateById(orderPO);
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateExtMap(OrdItemPO qry, UocOrdGoodsTempPO goodsTempPO) {
        try {
            OrdItemMapPO itemPO = new OrdItemMapPO();
            itemPO.setOrderId(qry.getOrderId());
            itemPO.setOrderItemId(qry.getOrdItemId());
            itemPO.setFieldCode("inboundPath");
            itemPO.setFieldValue(StringUtils.isBlank((CharSequence)goodsTempPO.getExt11()) ? "" : goodsTempPO.getExt11());
            this.ordItemMapMapper.updateById(itemPO);
            itemPO.setFieldCode("inboundPathId");
            itemPO.setFieldValue(StringUtils.isBlank((CharSequence)goodsTempPO.getExt12()) ? "" : goodsTempPO.getExt12());
            this.ordItemMapMapper.updateById(itemPO);
        }
        catch (Exception exception) {
            log.error("\u66f4\u65b0\u6269\u5c55\u8868\u5f02\u5e38\uff1a" + exception);
        }
    }

    private void insertExtMap(Long orderId, Long itemOrderId, UocOrdGoodsTempPO goodsTempPO) {
        try {
            ArrayList<OrdItemMapPO> ordItemMapPOList = new ArrayList<OrdItemMapPO>();
            OrdItemMapPO insertPath = new OrdItemMapPO();
            insertPath.setId(Long.valueOf(this.idUtil.nextId()));
            insertPath.setOrderId(orderId);
            insertPath.setOrderItemId(itemOrderId);
            insertPath.setFieldCode("inboundPath");
            insertPath.setFieldName("\u5165\u5e93\u8def\u5f84");
            insertPath.setFieldValue(StringUtils.isBlank((CharSequence)goodsTempPO.getExt11()) ? "" : goodsTempPO.getExt11());
            ordItemMapPOList.add(insertPath);
            OrdItemMapPO insertId = new OrdItemMapPO();
            insertId.setId(Long.valueOf(this.idUtil.nextId()));
            insertId.setOrderId(orderId);
            insertId.setOrderItemId(itemOrderId);
            insertId.setFieldCode("inboundPathId");
            insertId.setFieldName("\u5165\u5e93\u8def\u5f84-\u6620\u5c04\u540e\u5e93\u5b58\u7ec4\u7ec7id");
            insertId.setFieldValue(StringUtils.isBlank((CharSequence)goodsTempPO.getExt12()) ? "" : goodsTempPO.getExt12());
            ordItemMapPOList.add(insertId);
            this.ordItemMapMapper.insertBatch(ordItemMapPOList);
        }
        catch (Exception exception) {
            log.error("\u65b0\u589e\u6269\u5c55\u8868\u5f02\u5e38\uff1a" + exception);
        }
    }

    private void dealCheckBhd(PebUpdateOrderReqBO reqBO) {
        if ("2".equals(reqBO.getIsprofess())) {
            OrdAgreementPO agreementPO = new OrdAgreementPO();
            agreementPO.setOrderId(reqBO.getOrderId());
            List agreementPOList = this.ordAgreementMapper.selectByCondition(agreementPO);
            if (CollectionUtils.isEmpty((Collection)agreementPOList)) {
                throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5408\u540c\u4fe1\u606f\uff01");
            }
            String contactId = ((OrdAgreementPO)agreementPOList.get(0)).getContactId();
            if (StringUtils.isEmpty((CharSequence)contactId)) {
                throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5408\u540cid\uff01");
            }
            ContractDetailQueryAbilityReqBO abilityReqBO = new ContractDetailQueryAbilityReqBO();
            abilityReqBO.setContractId(Long.valueOf(contactId));
            ContractDetailQueryAbilityRspBO abilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(abilityReqBO);
            if (abilityRspBO.getContractId() == null) {
                throw new UocProBusinessException("8888", contactId + "\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff1a" + abilityRspBO.getMessage());
            }
            if (abilityRspBO.getReplenishmentAuthority() == null || UocConstant.PRE_ORDER.NO.equals(abilityRspBO.getReplenishmentAuthority())) {
                throw new UocProBusinessException("8888", ((OrdAgreementPO)agreementPOList.get(0)).getContactNo() + "\u5408\u540c\u672a\u5f00\u653e\u4f9b\u5e94\u5546\u8865\u8d27\u6743\u9650\uff01");
            }
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        abilityReqBO.setOrgCode(reqBO.getZmInfoBO().getBuynerNo());
        UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(abilityReqBO);
        if (orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
            throw new UocProBusinessException("8888", reqBO.getZmInfoBO().getBuynerNo() + "\u67e5\u8be2\u4e70\u53d7\u4eba\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsPushWms() == null || UocConstant.IsPushWms.NO.equals(orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsPushWms())) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u4e70\u53d7\u4eba\u673a\u6784\u672a\u542f\u7528\u5bf9\u63a5WMS\u914d\u7f6e\u4fe1\u606f\uff01");
        }
    }
}

