/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.PropertiesUtil;
import com.tydic.uoc.common.ability.bo.UocAuditSignatureInitReqBo;
import com.tydic.uoc.common.ability.bo.UocAuditSignatureInitReqBoAuditInfo;
import com.tydic.uoc.common.ability.bo.UocAuditSignatureInitRspBo;
import com.tydic.uoc.common.busi.api.UocAuditSignatureInitBusiService;
import com.tydic.uoc.dao.UocOrderTaskInstMapper;
import com.tydic.uoc.dao.UocSignatureInitMapper;
import com.tydic.uoc.po.UocOrderTaskInstPo;
import com.tydic.uoc.po.UocSignatureInitPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UocAuditSignatureInitBusiServiceImpl
implements UocAuditSignatureInitBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocAuditSignatureInitBusiServiceImpl.class);
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocSignatureInitMapper uocSignatureInitMapper;

    @Override
    public UocAuditSignatureInitRspBo dealAuditSignatureInit(UocAuditSignatureInitReqBo reqBo) {
        EacApproveAbilityReqBO abilityReqBO = this.getEacApproveAbilityReqBO(reqBo);
        EacApproveAbilityRspBO approve = this.eacRuTaskAbilityService.approveByMq(abilityReqBO);
        log.debug("\u6d41\u7a0b\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)approve));
        if (!"0000".equals(approve.getRespCode())) {
            throw new UocProBusinessException("8888", approve.getRespDesc());
        }
        ArrayList<Long> completeSignatureInitIds = new ArrayList<Long>();
        Map<String, UocAuditSignatureInitReqBoAuditInfo> map = reqBo.getAuditInfo().stream().collect(Collectors.toMap(UocAuditSignatureInitReqBoAuditInfo::getProcInstId, a -> a));
        for (EacApproveAbilityRspInfoBO infoBO : approve.getData()) {
            UocAuditSignatureInitReqBoAuditInfo auditInfo = map.get(infoBO.getApproveInstId());
            if (auditInfo == null) continue;
            UocOrderTaskInstPo instPO = new UocOrderTaskInstPo();
            instPO.setOrderId(auditInfo.getOrderId());
            instPO.setObjType(UocConstant.OBJ_TYPE.SIGNATURE_INIT);
            instPO.setObjId(auditInfo.getSignatureInitId());
            instPO.setFinishTag(UocConstant.VALID_FLAG.YES);
            instPO.setDealOperId(reqBo.getUserId());
            instPO.setDealOperName(reqBo.getUsername());
            instPO.setDealName(reqBo.getName());
            instPO.setProcInstId(auditInfo.getProcInstId());
            instPO.setTaskInstId(auditInfo.getTaskInstId());
            instPO.setDealResult(auditInfo.getAuditFlag());
            instPO.setDealRemark(auditInfo.getRemark());
            instPO.setFinishTime(new Date());
            int i = this.uocOrderTaskInstMapper.updateDone(instPO);
            if (i == 0) {
                throw new UocProBusinessException("8888", "\u66f4\u65b0\u5df2\u529e\u5931\u8d25");
            }
            if (StringUtils.hasText((String)infoBO.getLinkJudge()) && Boolean.parseBoolean(infoBO.getLinkJudge())) {
                UocOrderTaskInstPo dealInstPO = new UocOrderTaskInstPo();
                dealInstPO.setOrderId(auditInfo.getOrderId());
                dealInstPO.setObjType(UocConstant.OBJ_TYPE.SIGNATURE_INIT);
                dealInstPO.setObjId(auditInfo.getSignatureInitId());
                dealInstPO.setFinishTag(UocConstant.VALID_FLAG.NO);
                dealInstPO.setProcInstId(auditInfo.getProcInstId());
                dealInstPO.setIsDelete(UocConstant.VALID_FLAG.YES);
                dealInstPO.setUpdateTime(new Date());
                this.uocOrderTaskInstMapper.updateDel(dealInstPO);
            }
            UocSignatureInitPo signatureInitPo = new UocSignatureInitPo();
            signatureInitPo.setSignatureInitId(auditInfo.getSignatureInitId());
            signatureInitPo.setCurrentApprovalUserId(reqBo.getUserId());
            signatureInitPo.setCurrentApprovalUserCode(reqBo.getUsername());
            signatureInitPo.setCurrentApprovalUserName(reqBo.getName());
            PropertiesUtil.setUpdateInfo((Object)reqBo, (Object)signatureInitPo);
            if (infoBO.getIsFinish().booleanValue()) {
                if (UocConstant.VALID_FLAG.YES.equals(auditInfo.getAuditFlag())) {
                    completeSignatureInitIds.add(auditInfo.getSignatureInitId());
                    signatureInitPo.setSignatureInitId(auditInfo.getSignatureInitId());
                    signatureInitPo.setPushState(UocConstant.PushState.PUSH_IN);
                    signatureInitPo.setSignatureStatus(UocConstant.SignatureStatus.WAIT_SIGN);
                    signatureInitPo.setSignatureApprovalStatus(UocConstant.SignatureApprovalStatus.APPROVED);
                } else {
                    signatureInitPo.setSignatureApprovalStatus(UocConstant.SignatureApprovalStatus.APPROVAL_REJECTION);
                }
            }
            this.uocSignatureInitMapper.updateById(signatureInitPo);
        }
        UocAuditSignatureInitRspBo rspBo = new UocAuditSignatureInitRspBo();
        rspBo.setCompleteSignatureInitIds(completeSignatureInitIds);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private EacApproveAbilityReqBO getEacApproveAbilityReqBO(UocAuditSignatureInitReqBo reqBo) {
        EacApproveAbilityReqBO abilityReqBO = new EacApproveAbilityReqBO();
        ArrayList<EacApproveAbilityReqInfoBO> data = new ArrayList<EacApproveAbilityReqInfoBO>();
        for (UocAuditSignatureInitReqBoAuditInfo auditInfo : reqBo.getAuditInfo()) {
            EacApproveAbilityReqInfoBO infoBO = new EacApproveAbilityReqInfoBO();
            infoBO.setApproveAdvice(auditInfo.getRemark());
            infoBO.setTaskId(Long.valueOf(Long.parseLong(auditInfo.getTaskInstId())));
            if (UocConstant.VALID_FLAG.YES.equals(auditInfo.getAuditFlag())) {
                infoBO.setApproveResult("pass");
            } else {
                infoBO.setApproveResult("reject");
            }
            data.add(infoBO);
        }
        abilityReqBO.setData(data);
        return abilityReqBO;
    }
}

