/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.fsc.common.ability.api.FscEfficiencyIndexAbilityService;
import com.tydic.fsc.common.ability.bo.FscEfficiencyIndexAbilityBO;
import com.tydic.fsc.common.ability.bo.FscEfficiencyIndexAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEfficiencyIndexAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.api.UmcQryMemInfoForNotifyExtService;
import com.tydic.umc.general.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryOfBusinessWaitDoneAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoForNotifyBo;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoForNotifyExtReqBo;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoForNotifyExtRspBo;
import com.tydic.uoc.common.ability.bo.PebExtSendMessageRspBO;
import com.tydic.uoc.common.ability.bo.UocSendMessageReqBO;
import com.tydic.uoc.common.busi.api.UocDealEfficiencyIndexBusiService;
import com.tydic.uoc.common.busi.bo.UocDealEfficiencyIndexBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocDealEfficiencyIndexBusiRspBO;
import com.tydic.uoc.common.enums.UocEfficiencyIndexNoticeEnum;
import com.tydic.uoc.common.utils.UocNotificationUtil;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdEfficiencyIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService;
import com.tydic.xwgl.ability.api.XwglRuleGetNoauthDetailAbilityService;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailReqBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailRspBo;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocDealEfficiencyIndexBusiServiceImpl
implements UocDealEfficiencyIndexBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocDealEfficiencyIndexBusiServiceImpl.class);
    public static final String LEVEL_ONE = "1";
    public static final String LEVEL_TWO = "2";
    @Value(value="${order.efficiency.index.notDispatchLongTimeNo.ruleValeOne:25}")
    private Integer NOT_DISPATCH_LONG_TIME_RULE_VALE_ONE;
    @Value(value="${order.efficiency.index.notDispatchLongTimeNo.ruleValeTwo:40}")
    private Integer NOT_DISPATCH_LONG_TIME_RULE_VALE_TWO;
    @Value(value="${order.efficiency.index.dispatchLongTimeArrived.ruleValeOne:25}")
    private Integer DISPATCH_LONG_TIME_ARRIVED_RULE_VALE_ONE;
    @Value(value="${order.efficiency.index.dispatchLongTimeArrived.ruleValeTwo:40}")
    private Integer DISPATCH_LONG_TIME_ARRIVED_RULE_VALE_TWO;
    @Value(value="${order.efficiency.index.notIssueTaxInvoice.ruleValeOne:14}")
    private Integer NOT_ISSUE_TAX_INVOICE_RULE_VALE_ONE;
    @Value(value="${order.efficiency.index.notReceiveReceipt.ruleValeOne:14}")
    private Integer NOT_RECEIVE_RECEIPT_RULE_VALE_ONE;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocNotificationUtil uocNotificationUtil;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private UmcQryMemInfoForNotifyExtService umcQryMemInfoForNotifyExtService;
    @Autowired
    private FscEfficiencyIndexAbilityService fscEfficiencyIndexAbilityService;
    @Autowired
    private XwglRuleGetNoauthDetailAbilityService xwglRuleGetNoauthDetailAbilityService;
    @Autowired
    private XwgLSaveLogAbilityService xwglSaveLogAbilityService;
    @Value(value="${order.efficiency.index.notDispatchLongTimeNo:YGSC-SP-00014}")
    private String notDispatchLongTimeNo;
    @Value(value="${order.efficiency.index.dispatchLongTimeArrivedNo:YGSC-SP-00015}")
    private String dispatchLongTimeArrivedNo;
    @Value(value="${order.efficiency.index.notIssueTaxInvoiceNo:YGSC-SP-00016}")
    private String notIssueTaxInvoiceNo;
    @Value(value="${order.efficiency.index.notReceiveReceiptNo:YGSC-SP-00017}")
    private String notReceiveReceiptNo;
    @Value(value="${order.efficiency.index.ip:http://172.20.175.3/#/index/}")
    private String IP;
    @Value(value="${order.efficiency.index.operation:[120052,106385,125933,104594]}")
    private String operations;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;

    @Override
    public UocDealEfficiencyIndexBusiRspBO dealEfficiencyIndex(UocDealEfficiencyIndexBusiReqBO reqBO) {
        String shardingParameter = reqBO.getShardingParameter();
        if (StringUtils.isEmpty((Object)shardingParameter)) {
            this.dealNotDispatchLongTime(reqBO);
            this.dealDispatchLongTimeArrived(reqBO);
            this.dealNotIssueTaxInvoice(reqBO);
            this.dealNotReceiveReceipt(reqBO);
        } else if ("NOT_DISPATCH_LONG_TIME".equals(shardingParameter)) {
            this.dealNotDispatchLongTime(reqBO);
        } else if ("DISPATCH_LONG_TIME_ARRIVED".equals(shardingParameter)) {
            this.dealDispatchLongTimeArrived(reqBO);
        } else if ("NOT_ISSUE_TAX_INVOICE".equals(shardingParameter)) {
            this.dealNotIssueTaxInvoice(reqBO);
        } else if ("NOT_RECEIVE_RECEIPT".equals(shardingParameter)) {
            this.dealNotReceiveReceipt(reqBO);
        }
        UocDealEfficiencyIndexBusiRspBO rspBO = new UocDealEfficiencyIndexBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealNotReceiveReceipt(UocDealEfficiencyIndexBusiReqBO reqBO) {
        List<OrdEfficiencyIndexPO> orderList = this.getNotReceiveReceiptList();
        log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(orderList));
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        try {
            Map<Long, List<FscEfficiencyIndexAbilityBO>> orderIdMap = this.dealPreProcessing(orderList, 1003);
            if (orderIdMap == null) {
                return;
            }
            List<OrdEfficiencyIndexPO> sendSuccessList = this.sendMsgOfInSitePartFour(orderList, orderIdMap);
            log.error("\u53d1\u9001\u6210\u529f\u5f97\u7ad9\u5185\u4fe1\u4e3a\uff1a{}", (Object)JSON.toJSONString(sendSuccessList));
        }
        catch (Exception e) {
            log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void sendMsgXwglPartFour(List<OrdEfficiencyIndexPO> orderList, XwglRuleGetNoauthDetailRspBo expRuleRspBo, Map<Long, List<FscEfficiencyIndexAbilityBO>> orderIdMap) {
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            List<FscEfficiencyIndexAbilityBO> list = orderIdMap.get(orderInfo.getOrderId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (FscEfficiencyIndexAbilityBO indexAbilityBO : list) {
                Integer updateDaysDif = indexAbilityBO.getUpdateDaysDif();
                if (updateDaysDif == null) continue;
                String orderNo = indexAbilityBO.getOrderNo();
                String text = MessageFormat.format("\u3010\u8d85\u5e02\u7ed3\u7b97\u5355\u3010{0}\u3011\uff0c\u5df2\u5f00\u5177\u53d1\u7968\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u4ed8\u6b3e\u3011", orderNo, orderInfo.getDaysDif());
                String textUrl = "";
                if (indexAbilityBO.getOrderId() != null && indexAbilityBO.getOrderId() != null) {
                    textUrl = this.IP + MessageFormat.format("purchaseSettlementApplicationDetail?id={0}&orderId={1}&tradeMode=1&goForm=detail", indexAbilityBO.getFscOrderId(), indexAbilityBO.getOrderId());
                }
                String noticeText = this.convertUrl(text, textUrl);
                XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
                ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
                XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
                BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
                x.setBusinessName(orderInfo.getOrderName());
                x.setBusinessId(orderInfo.getSaleVoucherId() + "");
                x.setBusinessCode(orderInfo.getSaleVoucherNo());
                x.setIsZj(Integer.valueOf(1));
                x.setBusinessUrl(noticeText);
                x.setRulId(expRuleRspBo.getRuleId());
                UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO detailQueryAbilityReqBO = new UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO();
                detailQueryAbilityReqBO.setMemId(Long.valueOf(orderInfo.getCreateOper()));
                UmcMemDetailQueryOfBusinessWaitDoneAbilityRspBO businessWaitDone = this.umcMemDetailQueryAbilityService.getErpOrderUserInfoOfBusinessWaitDone(detailQueryAbilityReqBO);
                log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u521b\u5efa\u4eba\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)businessWaitDone));
                if (!"0000".equals(businessWaitDone.getRespCode()) || businessWaitDone.getUmcMemDetailInfoAbilityRspBO() == null) {
                    log.error("\u521b\u5efa\u4eba\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u63a8\u9001\u9884\u8b66");
                    continue;
                }
                UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityRspBO = businessWaitDone.getUmcMemDetailInfoAbilityRspBO();
                x.setManagerId(umcMemDetailInfoAbilityRspBO.getMemId());
                x.setManagerName(umcMemDetailInfoAbilityRspBO.getMemName2());
                x.setCompanyId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
                x.setDeptId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
                x.setCompanyName(umcMemDetailInfoAbilityRspBO.getOrgName());
                x.setDeptName(umcMemDetailInfoAbilityRspBO.getOrgName());
                xwglLogs.add(x);
                reqBo.setXwglLogs(xwglLogs);
                log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reqBo));
                XwgLSaveLogRspBo rspBo = this.xwglSaveLogAbilityService.saveXwglLog(reqBo);
                log.debug("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)rspBo));
            }
        }
    }

    private List<OrdEfficiencyIndexPO> sendMsgOfInSitePartFour(List<OrdEfficiencyIndexPO> orderList, Map<Long, List<FscEfficiencyIndexAbilityBO>> orderIdMap) {
        ArrayList<OrdEfficiencyIndexPO> sendList = new ArrayList<OrdEfficiencyIndexPO>();
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            List<FscEfficiencyIndexAbilityBO> list = orderIdMap.get(orderInfo.getOrderId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (FscEfficiencyIndexAbilityBO indexAbilityBO : list) {
                ArrayList<Long> messageUserList = new ArrayList();
                Integer updateDaysDif = indexAbilityBO.getUpdateDaysDif();
                if (updateDaysDif == null) continue;
                String orderNo = indexAbilityBO.getOrderNo();
                List ext1List = new ArrayList<String>();
                if (updateDaysDif < this.NOT_RECEIVE_RECEIPT_RULE_VALE_ONE) continue;
                orderInfo.setFscCreateOper(indexAbilityBO.getCreateOperId());
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_RECEIVE_RECEIPT.getCode(), "7");
                String level = "7";
                if (!StringUtils.isEmpty((Object)orderInfo.getExt1()) && (ext1List = JSON.parseArray((String)orderInfo.getExt1(), String.class)).contains(level)) {
                    log.error("\u5f53\u524d {} \u6570\u636e\u5df2\u88ab\u9884\u8b66", (Object)JSON.toJSONString((Object)orderNo));
                    continue;
                }
                ext1List.add(level);
                if (CollectionUtils.isEmpty(messageUserList)) {
                    log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.NOT_RECEIVE_RECEIPT.getName());
                    continue;
                }
                log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
                String text = MessageFormat.format("\u3010\u8d85\u5e02\u7ed3\u7b97\u5355\u3010{0}\u3011\uff0c\u5df2\u5f00\u5177\u53d1\u7968\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u4ed8\u6b3e\u3011", orderNo, updateDaysDif);
                String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e\u5f02\u5e38", orderNo);
                String textUrl = "";
                if (indexAbilityBO.getOrderId() != null && indexAbilityBO.getFscOrderId() != null) {
                    if (indexAbilityBO.getReceiveType() == 1) {
                        textUrl = this.IP + MessageFormat.format("ecDownStatementDetails?fscOrderId={0}&type=0&submitFlag=0&orderState={1}&buttonShow=1", indexAbilityBO.getFscOrderId(), indexAbilityBO.getOrderState());
                    } else if (indexAbilityBO.getReceiveType() == 2) {
                        textUrl = this.IP + MessageFormat.format("ecUpStatementDetails?fscOrderId={0}&orderId={1}", indexAbilityBO.getFscOrderId(), indexAbilityBO.getOrderId());
                    } else {
                        log.error("\u65e0\u6cd5\u533a\u5206\u7ed3\u7b97\u5355\u4e0a\u4e0b\u6e38");
                        continue;
                    }
                }
                String noticeText = this.convertUrl(text, textUrl);
                log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u7ad9\u5185\u4fe1\u5185\u5bb9\uff1a{}", (Object)noticeText);
                PebExtSendMessageRspBO sendMessageRspBO = this.sendNotification(messageUserList, noticeText, title);
                if (!sendMessageRspBO.getRespCode().equals("0000")) continue;
                this.updateOrderSaleExt1(orderInfo, JSON.toJSONString(ext1List));
                sendList.add(orderInfo);
            }
        }
        return sendList;
    }

    private PebExtSendMessageRspBO sendNotification(List<Long> messageUserList, String text, String title) {
        UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
        uocSendMessageReqBO.setUserId(Long.valueOf(1L));
        uocSendMessageReqBO.setReceiveIds(messageUserList);
        uocSendMessageReqBO.setTitel(title);
        uocSendMessageReqBO.setText(text);
        uocSendMessageReqBO.setBusinessType(Integer.valueOf(1));
        log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e3a:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
        return this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
    }

    private void dealNotIssueTaxInvoice(UocDealEfficiencyIndexBusiReqBO reqBO) {
        List<OrdEfficiencyIndexPO> orderList = this.getNotIssueTaxInvoiceList();
        log.error("\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(orderList));
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        try {
            Map<Long, List<FscEfficiencyIndexAbilityBO>> orderIdMap = this.dealPreProcessing(orderList, null);
            if (orderIdMap == null) {
                return;
            }
            List<OrdEfficiencyIndexPO> sendSuccessList = this.sendMsgOfInSitePartThree(orderList, orderIdMap);
            log.error("\u53d1\u9001\u6210\u529f\u5f97\u7ad9\u5185\u4fe1\u4e3a\uff1a{}", (Object)JSON.toJSONString(sendSuccessList));
        }
        catch (Exception e) {
            log.error("\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private Map<Long, List<FscEfficiencyIndexAbilityBO>> dealPreProcessing(List<OrdEfficiencyIndexPO> orderList, Integer orderState) {
        List orderIds = orderList.stream().map(OrdEfficiencyIndexPO::getOrderId).collect(Collectors.toList());
        FscEfficiencyIndexAbilityReqBO indexAbilityReqBO = new FscEfficiencyIndexAbilityReqBO();
        indexAbilityReqBO.setOrderIds(orderIds);
        indexAbilityReqBO.setOrderState(orderState);
        FscEfficiencyIndexAbilityRspBO indexAbilityRspBO = this.fscEfficiencyIndexAbilityService.qryFscInfoByOrderId(indexAbilityReqBO);
        if (!indexAbilityRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)indexAbilityRspBO.getList())) {
            log.error("\u6548\u7387\u6307\u6807\u9884\u8b66\u6a21\u578b\uff0c\u67e5\u8be2\u7ed3\u7b97\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)indexAbilityRspBO));
            return null;
        }
        List fscEfficiencyIndexs = indexAbilityRspBO.getList();
        List distinctList = fscEfficiencyIndexs.stream().collect(Collectors.toMap(FscEfficiencyIndexAbilityBO::getOrderNo, bo -> bo, (oldBo, newBo) -> oldBo)).values().stream().collect(Collectors.toList());
        log.error("\u5e94\u6536\u6b3e\u672a\u53ca\u65f6\u56de\u6b3e-\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u6548\u7387\u6307\u6807\u9884\u8b66\u6a21\u578b\uff0c\u67e5\u8be2\u7ed3\u7b97\u6570\u636e\u6761\u6570\u4e3a\uff1a{};\u5171\uff1a{} \u6761", (Object)JSON.toJSONString(distinctList), (Object)distinctList.size());
        return distinctList.stream().filter(bo -> bo.getOrderId() != null).collect(Collectors.groupingBy(FscEfficiencyIndexAbilityBO::getOrderId));
    }

    private void sendMsgXwglPartThree(List<OrdEfficiencyIndexPO> orderList, XwglRuleGetNoauthDetailRspBo expRuleRspBo, Map<Long, List<FscEfficiencyIndexAbilityBO>> orderIdMap) {
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            List<FscEfficiencyIndexAbilityBO> list = orderIdMap.get(orderInfo.getOrderId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (FscEfficiencyIndexAbilityBO indexAbilityBO : list) {
                Integer createDaysDif = indexAbilityBO.getCreateDaysDif();
                if (createDaysDif == null) continue;
                String orderNo = indexAbilityBO.getOrderNo();
                String text = MessageFormat.format("\u3010\u8d85\u5e02\u7ed3\u7b97\u5355_\u3010{0}\u3011\u5f00\u7968\u8d85\u671f\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u5f00\u7968\uff0c\u8bf7\u8ddf\u8fdb\u5f00\u7968\u8fdb\u5ea6\u3011", orderNo, orderInfo.getDaysDif());
                String textUrl = "";
                if (indexAbilityBO.getOrderId() != null && indexAbilityBO.getOrderId() != null) {
                    textUrl = this.IP + MessageFormat.format("purchaseSettlementApplicationDetail?id={0}&orderId={1}&tradeMode=1&goForm=detail", indexAbilityBO.getFscOrderId(), indexAbilityBO.getOrderId());
                }
                String noticeText = this.convertUrl(text, textUrl);
                XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
                ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
                XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
                BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
                x.setBusinessName(orderInfo.getOrderName());
                x.setBusinessId(orderInfo.getSaleVoucherId() + "");
                x.setBusinessCode(orderInfo.getSaleVoucherNo());
                x.setIsZj(Integer.valueOf(1));
                x.setBusinessUrl(noticeText);
                x.setRulId(expRuleRspBo.getRuleId());
                UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO detailQueryAbilityReqBO = new UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO();
                detailQueryAbilityReqBO.setMemId(Long.valueOf(orderInfo.getCreateOper()));
                UmcMemDetailQueryOfBusinessWaitDoneAbilityRspBO businessWaitDone = this.umcMemDetailQueryAbilityService.getErpOrderUserInfoOfBusinessWaitDone(detailQueryAbilityReqBO);
                log.error("\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u521b\u5efa\u4eba\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)businessWaitDone));
                if (!"0000".equals(businessWaitDone.getRespCode()) || businessWaitDone.getUmcMemDetailInfoAbilityRspBO() == null) {
                    log.error("\u521b\u5efa\u4eba\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u63a8\u9001\u9884\u8b66");
                    continue;
                }
                UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityRspBO = businessWaitDone.getUmcMemDetailInfoAbilityRspBO();
                x.setManagerId(umcMemDetailInfoAbilityRspBO.getMemId());
                x.setManagerName(umcMemDetailInfoAbilityRspBO.getMemName2());
                x.setCompanyId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
                x.setDeptId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
                x.setCompanyName(umcMemDetailInfoAbilityRspBO.getOrgName());
                x.setDeptName(umcMemDetailInfoAbilityRspBO.getOrgName());
                xwglLogs.add(x);
                reqBo.setXwglLogs(xwglLogs);
                log.error("\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reqBo));
                XwgLSaveLogRspBo rspBo = this.xwglSaveLogAbilityService.saveXwglLog(reqBo);
                log.debug("dealContractEvaluationTimeOutScheduledTask-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)rspBo));
            }
        }
    }

    private List<OrdEfficiencyIndexPO> sendMsgOfInSitePartThree(List<OrdEfficiencyIndexPO> orderList, Map<Long, List<FscEfficiencyIndexAbilityBO>> orderIdMap) {
        ArrayList<OrdEfficiencyIndexPO> sendList = new ArrayList<OrdEfficiencyIndexPO>();
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            List<FscEfficiencyIndexAbilityBO> list = orderIdMap.get(orderInfo.getOrderId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (FscEfficiencyIndexAbilityBO indexAbilityBO : list) {
                ArrayList<Long> messageUserList = new ArrayList();
                Integer createDaysDif = indexAbilityBO.getCreateDaysDif();
                if (createDaysDif == null) continue;
                String orderNo = indexAbilityBO.getOrderNo();
                List ext1List = new ArrayList<String>();
                if (createDaysDif < this.NOT_ISSUE_TAX_INVOICE_RULE_VALE_ONE) continue;
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_ISSUE_TAX_INVOICE.getCode(), "5");
                String level = "5";
                if (!StringUtils.isEmpty((Object)orderInfo.getExt1()) && (ext1List = JSON.parseArray((String)orderInfo.getExt1(), String.class)).contains(level)) {
                    log.error("\u5f53\u524d {} \u6570\u636e\u5df2\u88ab\u9884\u8b66", (Object)JSON.toJSONString((Object)orderNo));
                    continue;
                }
                ext1List.add(level);
                if (CollectionUtils.isEmpty(messageUserList)) {
                    log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.NOT_ISSUE_TAX_INVOICE.getName());
                    continue;
                }
                log.error("\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
                String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968\u5f02\u5e38", orderNo);
                String text = MessageFormat.format("\u3010\u8d85\u5e02\u7ed3\u7b97\u5355_\u3010{0}\u3011\u5f00\u7968\u8d85\u671f\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u5f00\u7968\uff0c\u8bf7\u8ddf\u8fdb\u5f00\u7968\u8fdb\u5ea6\u3011", orderNo, createDaysDif);
                String textUrl = "";
                if (indexAbilityBO.getOrderId() != null && indexAbilityBO.getFscOrderId() != null) {
                    if (indexAbilityBO.getReceiveType() == 1) {
                        textUrl = this.IP + MessageFormat.format("ecDownStatementDetails?fscOrderId={0}&type=0&submitFlag=0&orderState={1}&buttonShow=1", indexAbilityBO.getFscOrderId(), indexAbilityBO.getOrderState());
                    } else if (indexAbilityBO.getReceiveType() == 2) {
                        textUrl = this.IP + MessageFormat.format("ecUpStatementDetails?fscOrderId={0}&orderId={1}", indexAbilityBO.getFscOrderId(), indexAbilityBO.getOrderId());
                    } else {
                        log.error("\u65e0\u6cd5\u533a\u5206\u7ed3\u7b97\u5355\u4e0a\u4e0b\u6e38");
                        continue;
                    }
                }
                String noticeText = this.convertUrl(text, textUrl);
                log.error("\u7ed3\u7b97\u5355\u751f\u6210\u540e\u672a\u53ca\u65f6\u5f00\u5177\u9500\u9879\u7968-\u7ad9\u5185\u4fe1\u4fe1\u606f\u4e3a\uff1a{}", (Object)text);
                PebExtSendMessageRspBO sendMessageRspBO = this.sendNotification(messageUserList, noticeText, title);
                if (!sendMessageRspBO.getRespCode().equals("0000")) continue;
                this.updateOrderSaleExt1(orderInfo, JSON.toJSONString(ext1List));
                sendList.add(orderInfo);
            }
        }
        return sendList;
    }

    private void dealDispatchLongTimeArrived(UocDealEfficiencyIndexBusiReqBO reqBO) {
        List<OrdEfficiencyIndexPO> orderList = this.getDispatchLongTimeArrivedList();
        log.error("\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295-\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(orderList));
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        try {
            List<OrdEfficiencyIndexPO> sendSuccessList = this.sendMsgOfInSitePartTwo(orderList);
            log.error("\u53d1\u9001\u6210\u529f\u5f97\u7ad9\u5185\u4fe1\u4e3a\uff1a{}", (Object)JSON.toJSONString(sendSuccessList));
        }
        catch (Exception e) {
            log.error("\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295-\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void sendMsgXwglPartTwo(List<OrdEfficiencyIndexPO> orderList, XwglRuleGetNoauthDetailRspBo expRuleRspBo) {
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            String text = MessageFormat.format("\u3010\u8d85\u5e02\u8ba2\u5355\u3010{0}\u3011\u7269\u6d41\u8d85\u671f\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u59a5\u6295\uff0c\u8bf7\u8ddf\u8fdb\u7269\u6d41\u8fdb\u5ea6\u3011", orderInfo.getSaleVoucherNo(), orderInfo.getDaysDif());
            String textUrl = "";
            if (!StringUtils.isEmpty((Object)orderInfo.getSaleVoucherNo()) && orderInfo.getOrderId() != null && orderInfo.getSaleVoucherId() != null) {
                textUrl = this.IP + MessageFormat.format("orderDetail?type=1&routerPathName=ecMyOrder&upperVoucherNo={0}&upperOrderId={1}&orderId={2}&saleVoucherId={3}&isScFlag=0&erpAccountAliasName=-", orderInfo.getSaleVoucherNo(), orderInfo.getOrderId(), orderInfo.getOrderId(), orderInfo.getSaleVoucherId());
            }
            String noticeText = this.convertUrl(text, textUrl);
            XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
            ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
            XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
            x.setBusinessName(orderInfo.getOrderName());
            x.setBusinessId(orderInfo.getSaleVoucherId() + "");
            x.setBusinessCode(orderInfo.getSaleVoucherNo());
            x.setIsZj(Integer.valueOf(1));
            x.setBusinessUrl(noticeText);
            x.setRulId(expRuleRspBo.getRuleId());
            UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO detailQueryAbilityReqBO = new UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO();
            detailQueryAbilityReqBO.setMemId(Long.valueOf(orderInfo.getCreateOper()));
            UmcMemDetailQueryOfBusinessWaitDoneAbilityRspBO businessWaitDone = this.umcMemDetailQueryAbilityService.getErpOrderUserInfoOfBusinessWaitDone(detailQueryAbilityReqBO);
            log.error("\u521b\u5efa\u4eba\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)businessWaitDone));
            if (!"0000".equals(businessWaitDone.getRespCode()) || businessWaitDone.getUmcMemDetailInfoAbilityRspBO() == null) {
                log.error("\u521b\u5efa\u4eba\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u63a8\u9001\u9884\u8b66");
                continue;
            }
            UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityRspBO = businessWaitDone.getUmcMemDetailInfoAbilityRspBO();
            x.setManagerId(umcMemDetailInfoAbilityRspBO.getMemId());
            x.setManagerName(umcMemDetailInfoAbilityRspBO.getMemName2());
            x.setCompanyId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
            x.setDeptId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
            x.setCompanyName(umcMemDetailInfoAbilityRspBO.getOrgName());
            x.setDeptName(umcMemDetailInfoAbilityRspBO.getOrgName());
            xwglLogs.add(x);
            reqBo.setXwglLogs(xwglLogs);
            log.error("\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reqBo));
            XwgLSaveLogRspBo rspBo = this.xwglSaveLogAbilityService.saveXwglLog(reqBo);
            log.debug("\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)rspBo));
        }
    }

    private List<OrdEfficiencyIndexPO> sendMsgOfInSitePartTwo(List<OrdEfficiencyIndexPO> orderList) {
        ArrayList<OrdEfficiencyIndexPO> sendList = new ArrayList<OrdEfficiencyIndexPO>();
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            String level;
            Integer daysDif = orderInfo.getDaysDif();
            ArrayList<Long> messageUserList = new ArrayList();
            List ext1List = new ArrayList<String>();
            if (daysDif >= this.DISPATCH_LONG_TIME_ARRIVED_RULE_VALE_ONE && daysDif < this.DISPATCH_LONG_TIME_ARRIVED_RULE_VALE_TWO) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getCode(), "3");
                level = "3";
                if (!StringUtils.isEmpty((Object)orderInfo.getExt1()) && (ext1List = JSON.parseArray((String)orderInfo.getExt1(), String.class)).contains(level)) {
                    log.error("\u5f53\u524d {} \u6570\u636e\u5df2\u88ab\u9884\u8b66", (Object)JSON.toJSONString((Object)orderInfo.getSaleVoucherNo()));
                    continue;
                }
                ext1List.add(level);
            } else {
                if (daysDif < this.DISPATCH_LONG_TIME_ARRIVED_RULE_VALE_TWO) continue;
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getCode(), "4");
                level = "4";
                if (!StringUtils.isEmpty((Object)orderInfo.getExt1()) && (ext1List = JSON.parseArray((String)orderInfo.getExt1(), String.class)).contains(level)) {
                    log.error("\u5f53\u524d {} \u6570\u636e\u5df2\u88ab\u9884\u8b66", (Object)JSON.toJSONString((Object)orderInfo.getSaleVoucherNo()));
                    continue;
                }
                ext1List.add(level);
            }
            if (CollectionUtils.isEmpty(messageUserList)) {
                log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getName());
                continue;
            }
            log.error("\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295-\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
            String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295\u5f02\u5e38", orderInfo.getSaleVoucherNo());
            String text = MessageFormat.format("\u3010\u8d85\u5e02\u8ba2\u5355\u3010{0}\u3011\u7269\u6d41\u8d85\u671f\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u59a5\u6295\uff0c\u8bf7\u8ddf\u8fdb\u7269\u6d41\u8fdb\u5ea6\u3011", orderInfo.getSaleVoucherNo(), orderInfo.getDaysDif());
            String textUrl = "";
            if (!StringUtils.isEmpty((Object)orderInfo.getSaleVoucherNo()) && orderInfo.getOrderId() != null && orderInfo.getSaleVoucherId() != null) {
                textUrl = this.IP + MessageFormat.format("orderDetail?type=1&routerPathName=ecMyOrder&upperVoucherNo={0}&upperOrderId={1}&orderId={2}&saleVoucherId={3}&isScFlag=0&erpAccountAliasName=-", orderInfo.getSaleVoucherNo(), orderInfo.getOrderId(), orderInfo.getOrderId(), orderInfo.getSaleVoucherId());
            }
            String noticeText = this.convertUrl(text, textUrl);
            log.error("\u5df2\u53d1\u8d27\u957f\u65f6\u95f4\u59a5\u6295-\u7ad9\u5185\u4fe1\u63a8\u9001\u5165\u53c2\uff1a{}", (Object)noticeText);
            PebExtSendMessageRspBO sendMessageRspBO = this.sendNotification(messageUserList, noticeText, title);
            if (!sendMessageRspBO.getRespCode().equals("0000")) continue;
            this.updateOrderSaleExt1(orderInfo, JSON.toJSONString(ext1List));
            sendList.add(orderInfo);
        }
        return sendList;
    }

    private void dealNotDispatchLongTime(UocDealEfficiencyIndexBusiReqBO reqBO) {
        List<OrdEfficiencyIndexPO> orderList = this.getNotDispatchLongTimeList();
        log.error("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(orderList));
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        try {
            List<OrdEfficiencyIndexPO> sendSuccessList = this.sendMsgOfInSitePartOne(orderList);
            log.error("\u53d1\u9001\u6210\u529f\u5f97\u7ad9\u5185\u4fe1\u4e3a\uff1a{}", (Object)JSON.toJSONString(sendSuccessList));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void sendMsgXwglPartOne(List<OrdEfficiencyIndexPO> orderList, XwglRuleGetNoauthDetailRspBo expRuleRspBo) {
        log.error("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u5373\u5c06\u53d1\u9001\u7684\u9884\u8b66\u4fe1\u606f\u6709:{} \u6761", (Object)orderList.size());
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            String text = MessageFormat.format("\u3010\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011\u53d1\u8d27\u5f02\u5e38\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3011", orderInfo.getSaleVoucherNo(), orderInfo.getDaysDif());
            String textUrl = "";
            if (!StringUtils.isEmpty((Object)orderInfo.getSaleVoucherNo()) && orderInfo.getOrderId() != null && orderInfo.getSaleVoucherId() != null) {
                textUrl = this.IP + MessageFormat.format("orderDetail?type=1&routerPathName=ecMyOrder&upperVoucherNo={0}&upperOrderId={1}&orderId={2}&saleVoucherId={3}&isScFlag=0&erpAccountAliasName=-", orderInfo.getSaleVoucherNo(), orderInfo.getOrderId(), orderInfo.getOrderId(), orderInfo.getSaleVoucherId());
            }
            String noticeText = this.convertUrl(text, textUrl);
            XwgLSaveLogReqBo reqBo = new XwgLSaveLogReqBo();
            ArrayList<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<XwgLSaveLogReqBoXwglLogs>();
            XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
            x.setBusinessName(orderInfo.getOrderName());
            x.setBusinessId(orderInfo.getSaleVoucherId() + "");
            x.setBusinessCode(orderInfo.getSaleVoucherNo());
            x.setIsZj(Integer.valueOf(1));
            x.setBusinessUrl(noticeText);
            x.setRulId(expRuleRspBo.getRuleId());
            UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO detailQueryAbilityReqBO = new UmcMemDetailQueryOfBusinessWaitDoneAbilityReqBO();
            detailQueryAbilityReqBO.setMemId(Long.valueOf(orderInfo.getCreateOper()));
            UmcMemDetailQueryOfBusinessWaitDoneAbilityRspBO businessWaitDone = this.umcMemDetailQueryAbilityService.getErpOrderUserInfoOfBusinessWaitDone(detailQueryAbilityReqBO);
            log.error("\u521b\u5efa\u4eba\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)businessWaitDone));
            if (!"0000".equals(businessWaitDone.getRespCode()) || businessWaitDone.getUmcMemDetailInfoAbilityRspBO() == null) {
                log.error("\u521b\u5efa\u4eba\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u63a8\u9001\u9884\u8b66");
                continue;
            }
            UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityRspBO = businessWaitDone.getUmcMemDetailInfoAbilityRspBO();
            log.error("\u5f53\u524d\u5f97umcMemDetailInfoAbilityRspBO\uff1a{}", (Object)JSON.toJSONString((Object)umcMemDetailInfoAbilityRspBO));
            x.setManagerId(umcMemDetailInfoAbilityRspBO.getMemId());
            x.setManagerName(umcMemDetailInfoAbilityRspBO.getMemName2());
            x.setCompanyId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
            x.setDeptId(String.valueOf(umcMemDetailInfoAbilityRspBO.getOrgId()));
            x.setCompanyName(umcMemDetailInfoAbilityRspBO.getOrgName());
            x.setDeptName(umcMemDetailInfoAbilityRspBO.getOrgName());
            xwglLogs.add(x);
            reqBo.setXwglLogs(xwglLogs);
            log.error("\u5f53\u524d\u5f97XwgLSaveLogReqBoXwglLogs\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
            log.error("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reqBo));
            XwgLSaveLogRspBo rspBo = this.xwglSaveLogAbilityService.saveXwglLog(reqBo);
            log.debug("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)rspBo));
        }
    }

    private List<OrdEfficiencyIndexPO> getNotDispatchLongTimeList() {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime startTimeTime = now.minusHours(this.NOT_DISPATCH_LONG_TIME_RULE_VALE_ONE * 24);
        Date startTime = Date.from(startTimeTime.toInstant());
        return this.orderMapper.getNotDispatchLongTime(startTime);
    }

    private List<OrdEfficiencyIndexPO> getDispatchLongTimeArrivedList() {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime startTimeTime = now.minusHours(this.DISPATCH_LONG_TIME_ARRIVED_RULE_VALE_ONE * 24);
        Date startTime = Date.from(startTimeTime.toInstant());
        return this.orderMapper.getDispatchLongTimeArrived(startTime);
    }

    private List<OrdEfficiencyIndexPO> getNotIssueTaxInvoiceList() {
        ZonedDateTime now = ZonedDateTime.now();
        Date startTime = Date.from(now.toInstant());
        return this.orderMapper.getNotIssueTaxInvoice(startTime);
    }

    private List<OrdEfficiencyIndexPO> getNotReceiveReceiptList() {
        ZonedDateTime now = ZonedDateTime.now();
        Date startTime = Date.from(now.toInstant());
        return this.orderMapper.getNotReceiveReceipt(startTime);
    }

    private List<OrdEfficiencyIndexPO> sendMsgOfInSitePartOne(List<OrdEfficiencyIndexPO> orderList) {
        ArrayList<OrdEfficiencyIndexPO> sendList = new ArrayList<OrdEfficiencyIndexPO>();
        for (OrdEfficiencyIndexPO orderInfo : orderList) {
            String level;
            Integer daysDif = orderInfo.getDaysDif();
            ArrayList<Long> messageUserList = new ArrayList();
            List ext1List = new ArrayList<String>();
            if (daysDif >= this.NOT_DISPATCH_LONG_TIME_RULE_VALE_ONE && daysDif < this.NOT_DISPATCH_LONG_TIME_RULE_VALE_TWO) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getCode(), LEVEL_ONE);
                level = LEVEL_ONE;
                if (!StringUtils.isEmpty((Object)orderInfo.getExt1()) && (ext1List = JSON.parseArray((String)orderInfo.getExt1(), String.class)).contains(level)) {
                    log.error("\u5f53\u524d {} \u6570\u636e\u5df2\u88ab\u9884\u8b66", (Object)JSON.toJSONString((Object)orderInfo.getSaleVoucherNo()));
                    continue;
                }
                ext1List.add(level);
            } else if (daysDif >= this.NOT_DISPATCH_LONG_TIME_RULE_VALE_TWO) {
                messageUserList = this.getMessageUserList(orderInfo, UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getCode(), LEVEL_TWO);
                level = LEVEL_TWO;
                if (!StringUtils.isEmpty((Object)orderInfo.getExt1()) && (ext1List = JSON.parseArray((String)orderInfo.getExt1(), String.class)).contains(level)) {
                    log.error("\u5f53\u524d {} \u6570\u636e\u5df2\u88ab\u9884\u8b66", (Object)JSON.toJSONString((Object)orderInfo.getSaleVoucherNo()));
                    continue;
                }
                ext1List.add(level);
            } else {
                log.error("\u5f53\u524d {} \u6570\u636e\uff0c\u4ee5\u88ab\u9884\u8b66\uff0c\u8df3\u8fc7\u6b64\u6570\u636e", (Object)orderInfo.getSaleVoucherNo());
                continue;
            }
            if (CollectionUtils.isEmpty(messageUserList)) {
                log.error("\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c{}\u63a8\u9001\u9884\u8b66\u901a\u77e5\u65f6\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002", (Object)orderInfo.getSaleVoucherNo(), (Object)UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getName());
                continue;
            }
            log.error("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(messageUserList));
            String title = MessageFormat.format("\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011,\u957f\u65f6\u95f4\u672a\u53d1\u8d27\u5f02\u5e38", orderInfo.getSaleVoucherNo());
            String text = MessageFormat.format("\u3010\u8d85\u5e02\u8ba2\u5355_\u3010{0}\u3011\u53d1\u8d27\u5f02\u5e38\uff0c\u5df2\u8d85\u8fc7\u3010{1}\u3011\u5929\u672a\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3011", orderInfo.getSaleVoucherNo(), orderInfo.getDaysDif());
            String textUrl = "";
            if (!StringUtils.isEmpty((Object)orderInfo.getSaleVoucherNo()) && orderInfo.getOrderId() != null && orderInfo.getSaleVoucherId() != null) {
                textUrl = this.IP + MessageFormat.format("orderDetail?type=1&routerPathName=ecMyOrder&upperVoucherNo={0}&upperOrderId={1}&orderId={2}&saleVoucherId={3}&isScFlag=0&erpAccountAliasName=-", orderInfo.getSaleVoucherNo(), orderInfo.getOrderId(), orderInfo.getOrderId(), orderInfo.getSaleVoucherId());
            }
            String noticeText = this.convertUrl(text, textUrl);
            log.error("\u5904\u7406\u957f\u65f6\u95f4\u672a\u53d1\u8d27-\u7ad9\u5185\u4fe1\u63a8\u9001\u5165\u53c2\uff1a{}", (Object)noticeText);
            PebExtSendMessageRspBO sendMessageRspBO = this.sendNotification(messageUserList, noticeText, title);
            if (!sendMessageRspBO.getRespCode().equals("0000")) continue;
            this.updateOrderSaleExt1(orderInfo, JSON.toJSONString(ext1List));
            sendList.add(orderInfo);
        }
        return sendList;
    }

    private XwglRuleGetNoauthDetailRspBo getXwglRuleGetNoauthDetailRspBo(String ruleNo) {
        XwglRuleGetNoauthDetailReqBo ruleReqBo = new XwglRuleGetNoauthDetailReqBo();
        ruleReqBo.setRuleNo(ruleNo);
        XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
        if (!"0000".equals(expRuleRspBo.getRespCode())) {
            throw new BusinessException(expRuleRspBo.getRespCode(), expRuleRspBo.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleManagementVariableValue()) || ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleContent()) || ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleName())) {
            throw new BusinessException("8888", "\u89c4\u5219\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
        }
        return expRuleRspBo;
    }

    private String convertUrl(String text, String textUrl) {
        String noticeText = "";
        noticeText = !StringUtils.isEmpty((Object)textUrl) ? "<a href=\"" + textUrl + "\">" + text + "</a>" : text;
        return noticeText;
    }

    private void updateOrderSaleExt1(OrdEfficiencyIndexPO orderInfo, String level) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleVoucherId(orderInfo.getSaleVoucherId());
        ordSalePO.setOrderId(orderInfo.getOrderId());
        ordSalePO.setExt1(level);
        log.error("\u5f00\u59cb\u4fee\u6539\u4fee\u6539\u63a8\u9001\u7ad9\u5185\u4fe1\u6807\u8bc6\uff1a{}", (Object)JSON.toJSONString((Object)ordSalePO));
        this.ordSaleMapper.updateById(ordSalePO);
    }

    private List<Long> getMessageUserList(OrdEfficiencyIndexPO orderInfo, String code, String level) {
        ArrayList<Long> messageUserList = new ArrayList<Long>();
        if (UocEfficiencyIndexNoticeEnum.NOT_DISPATCH_LONG_TIME.getCode().equals(code)) {
            if (level.equals(LEVEL_ONE)) {
                List operationList = JSON.parseArray((String)this.operations, Long.class);
                messageUserList.addAll(operationList);
                List<Long> supplierList = this.getSupplierByOrderId(orderInfo.getOrderId());
                if (!CollectionUtils.isEmpty(supplierList)) {
                    messageUserList.addAll(supplierList);
                }
            } else if (level.equals(LEVEL_TWO)) {
                List operationList = JSON.parseArray((String)this.operations, Long.class);
                messageUserList.addAll(operationList);
                List<Long> supplierList = this.getSupplierByOrderId(orderInfo.getOrderId());
                if (!CollectionUtils.isEmpty(supplierList)) {
                    messageUserList.addAll(supplierList);
                }
            } else {
                log.error("\u9884\u8b66\u7b49\u7ea7\u9519\u8bef");
            }
        } else if (UocEfficiencyIndexNoticeEnum.DISPATCH_LONG_TIME_ARRIVED.getCode().equals(code)) {
            if (level.equals("3")) {
                List operationList = JSON.parseArray((String)this.operations, Long.class);
                messageUserList.addAll(operationList);
                List<Long> supplierList = this.getSupplierByOrderId(orderInfo.getOrderId());
                if (!CollectionUtils.isEmpty(supplierList)) {
                    messageUserList.addAll(supplierList);
                }
            } else if (level.equals("4")) {
                List operationList = JSON.parseArray((String)this.operations, Long.class);
                messageUserList.addAll(operationList);
                List<Long> supplierList = this.getSupplierByOrderId(orderInfo.getOrderId());
                if (!CollectionUtils.isEmpty(supplierList)) {
                    messageUserList.addAll(supplierList);
                }
            } else {
                log.error("\u9884\u8b66\u7b49\u7ea7\u9519\u8bef");
            }
        } else if (UocEfficiencyIndexNoticeEnum.NOT_ISSUE_TAX_INVOICE.getCode().equals(code)) {
            if (level.equals("5")) {
                List operationList = JSON.parseArray((String)this.operations, Long.class);
                messageUserList.addAll(operationList);
            } else if (level.equals("6")) {
                List operationList = JSON.parseArray((String)this.operations, Long.class);
                messageUserList.addAll(operationList);
            } else {
                log.error("\u9884\u8b66\u7b49\u7ea7\u9519\u8bef");
            }
        } else if (UocEfficiencyIndexNoticeEnum.NOT_RECEIVE_RECEIPT.getCode().equals(code)) {
            if (level.equals("7")) {
                Long createOper = orderInfo.getCreateOper();
                if (createOper != null) {
                    messageUserList.add(createOper);
                }
                Long fscCreateOper = orderInfo.getFscCreateOper();
                if (createOper != null) {
                    messageUserList.add(fscCreateOper);
                }
            } else {
                log.error("\u9884\u8b66\u7b49\u7ea7\u9519\u8bef");
            }
        }
        return messageUserList;
    }

    private List<Long> getSupplierByOrderId(Long orderId) {
        List supplierList = this.ordGoodsMapper.getSupplierIdByOrderId(orderId);
        return this.getReceiveIds(null, supplierList);
    }

    private List<Long> getReceiveIds(List<Long> roleIdList, List<Long> orgIds) {
        UmcQryMemInfoForNotifyExtReqBo notifyExtReqBo = new UmcQryMemInfoForNotifyExtReqBo();
        notifyExtReqBo.setRoleIdList(roleIdList);
        notifyExtReqBo.setOrgIds(orgIds);
        notifyExtReqBo.setPageNo(Integer.valueOf(-1));
        notifyExtReqBo.setPageSize(Integer.valueOf(-1));
        log.info("\u4f1a\u5458\u901a\u77e5\u63a5\u6536\u4eba\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)notifyExtReqBo));
        UmcQryMemInfoForNotifyExtRspBo extRspBo = this.umcQryMemInfoForNotifyExtService.qryOWMemInfoExt(notifyExtReqBo);
        log.info("\u4f1a\u5458\u901a\u77e5\u63a5\u6536\u4eba\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)extRspBo));
        if ("0000".equals(extRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)extRspBo.getRows())) {
            return extRspBo.getRows().stream().map(UmcQryMemInfoForNotifyBo::getMemId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

