/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.busi.api.UocEsDeleteIndexBusiService;
import com.tydic.uoc.common.busi.bo.UocEsDeleteIndexReqBO;
import com.tydic.uoc.common.busi.bo.UocEsDeleteIndexRspBO;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uocEsDeleteIndexBusiService")
public class UocEsDeleteIndexBusiServiceImpl
implements UocEsDeleteIndexBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocEsDeleteIndexBusiServiceImpl.class);
    private final UocEsConfig uocEsConfig;
    private final UocElasticsearchUtil uocElasticsearchUtil;

    public UocEsDeleteIndexBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
    }

    @Override
    public UocEsDeleteIndexRspBO deleteIndex(UocEsDeleteIndexReqBO reqBO) {
        boolean deleteIndex;
        UocEsDeleteIndexRspBO rspBO = new UocEsDeleteIndexRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isNotBlank((CharSequence)reqBO.getIndexName()) && !(deleteIndex = this.uocElasticsearchUtil.deleteIndex(reqBO.getIndexName()))) {
            log.error("\u5220\u9664\u6307\u5b9aES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)reqBO.getIndexName());
            rspBO.setRespCode("100001");
            rspBO.setRespDesc("\u5220\u9664\u6307\u5b9aES\u7d22\u5f15\u5931\u8d25\uff1a" + reqBO.getIndexName() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
        }
        if (null != reqBO.getIsDeleteStatistics() && reqBO.getIsDeleteStatistics().booleanValue() && !(deleteIndex = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getStatisticsIndexName()))) {
            log.error("\u5220\u9664\u7edf\u8ba1ES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)this.uocEsConfig.getStatisticsIndexName());
            rspBO.setRespCode("100001");
            rspBO.setRespDesc("\u5220\u9664\u7edf\u8ba1ES\u7d22\u5f15\u5931\u8d25\uff1a" + this.uocEsConfig.getStatisticsIndexName() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
        }
        if (CollectionUtils.isNotEmpty(reqBO.getObjTypeList())) {
            for (Integer objType2 : reqBO.getObjTypeList()) {
                boolean deleteIndex2;
                if (UocCoreConstant.OBJ_TYPE.SALE.equals(objType2)) {
                    deleteIndex2 = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getOrderIndexName());
                    if (deleteIndex2) continue;
                    log.error("\u5220\u9664\u8ba2\u5355(\u9500\u552e\u5355)ES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)this.uocEsConfig.getOrderIndexName());
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u5220\u9664\u8ba2\u5355(\u9500\u552e\u5355)ES\u7d22\u5f15\u5931\u8d25\uff1a" + this.uocEsConfig.getOrderIndexName() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
                    continue;
                }
                if (UocCoreConstant.OBJ_TYPE.SHIP.equals(objType2)) {
                    deleteIndex2 = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getShipIndexName());
                    if (deleteIndex2) continue;
                    log.error("\u5220\u9664\u53d1\u8d27\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)this.uocEsConfig.getShipIndexName());
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u5220\u9664\u53d1\u8d27\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a" + this.uocEsConfig.getShipIndexName() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
                    continue;
                }
                if (UocCoreConstant.OBJ_TYPE.INSPECTION.equals(objType2)) {
                    deleteIndex2 = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getInspectionIndexName());
                    if (deleteIndex2) continue;
                    log.error("\u5220\u9664\u9a8c\u6536\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)this.uocEsConfig.getInspectionIndexName());
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u5220\u9664\u9a8c\u6536\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a" + this.uocEsConfig.getInspectionIndexName() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
                    continue;
                }
                if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(objType2)) {
                    deleteIndex2 = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getAfsIndexType());
                    if (deleteIndex2) continue;
                    log.error("\u5220\u9664\u552e\u540e\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)this.uocEsConfig.getAfsIndexType());
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u5220\u9664\u552e\u540e\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a" + this.uocEsConfig.getAfsIndexType() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
                    continue;
                }
                if (!UocCoreConstant.OBJ_TYPE.ABNORMAL.equals(objType2) || (deleteIndex2 = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getAbnormalIndexName()))) continue;
                log.error("\u5220\u9664\u5f02\u5e38\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a{}", (Object)this.uocEsConfig.getAbnormalIndexName());
                rspBO.setRespCode("100001");
                rspBO.setRespDesc("\u5220\u9664\u5f02\u5e38\u5355ES\u7d22\u5f15\u5931\u8d25\uff1a" + this.uocEsConfig.getAbnormalIndexName() + "\uff0c\u5177\u4f53\u4fe1\u606f\u8bf7\u770b\u65e5\u5fd7\uff01\uff01\uff01");
            }
        }
        return rspBO;
    }
}

