/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.busi.api.UocEsQryInspectionListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryInspectionListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryInspectionListRspBO;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryInspectionListBusiService")
public class UocEsQryInspectionListBusiServiceImpl
implements UocEsQryInspectionListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryInspectionListBusiServiceImpl.class);
    private final UocEsConfig uocEsConfig;
    private final UocElasticsearchUtil uocElasticsearchUtil;
    private final UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryInspectionListBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryInspectionListRspBO esQryInspectionList(UocEsQryInspectionListReqBO reqBO) {
        UocEsQryInspectionListRspBO rspBO = new UocEsQryInspectionListRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u4fe1\u606f\u6210\u529f!");
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryInspectionEsSql(reqBO);
        LOGGER.error("ES\u67e5\u8be2\u9a8c\u6536\u5355\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.uocEsConfig.getInspectionIndexName() + "/" + this.uocEsConfig.getInspectionIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getInspectionIndexName());
                if (!index) {
                    LOGGER.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    LOGGER.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("102057");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u9a8c\u6536\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBO;
                }
            }
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("102057");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u9a8c\u6536\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
            return rspBO;
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSumField())) {
            this.resolveReturnSum(result, rspBO, reqBO);
        } else if (reqBO.getIsQueryTab().booleanValue()) {
            this.resovelRetrunCounts(result, rspBO);
        } else if (reqBO.getOvertimeDate() != null) {
            this.resolveTodoCount(result, rspBO);
        } else {
            this.resovelRetrunData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        }
        return rspBO;
    }

    private void resovelRetrunData(String result, UocEsQryInspectionListRspBO rspBO, Integer pageSize, Integer pageNo) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<UocInspectionDetailsListBO> rows = new ArrayList<UocInspectionDetailsListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            UocInspectionDetailsListBO esQryInspectionListSingleBO = (UocInspectionDetailsListBO)JSON.toJavaObject((JSON)objJson, UocInspectionDetailsListBO.class);
            rows.add(esQryInspectionListSingleBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u9a8c\u6536\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }

    public void resolveReturnSum(String result, UocEsQryInspectionListRspBO rspBO, UocEsQryInspectionListReqBO reqBO) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        rspBO.setRecordsTotal(total);
        HashMap<String, Number> sumMap = new HashMap<String, Number>();
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        Iterator<String> iterator = reqBO.getSumField().iterator();
        while (iterator.hasNext()) {
            String sumField;
            JSONObject sum = (JSONObject)aggregationsObj.get((Object)(sumField = iterator.next()));
            String value = (String)sum.get((Object)"value_as_string");
            sumMap.put(sumField, value == null ? new BigDecimal("0.00") : new BigDecimal(value));
        }
        rspBO.setSumFieldInfo(sumMap);
    }

    public void resovelRetrunCounts(String result, UocEsQryInspectionListRspBO rspBO) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<Integer, Integer> tabCountsMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            tabCountsMap.put(bucketsObj.getInteger("key"), bucketsObj.getInteger("doc_count"));
        }
        rspBO.setTabCountsMap(tabCountsMap);
    }

    private void resolveTodoCount(String result, UocEsQryInspectionListRspBO rspBO) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"date_range_agg");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            resultMap.put(bucketsObj.getString("key"), bucketsObj.getInteger("doc_count"));
        }
        rspBO.setOvertimeCount((Integer)resultMap.get("overtime"));
        rspBO.setWillOvertimeCount((Integer)resultMap.get("willOvertime"));
        rspBO.setRecordsTotal(total);
    }
}

