/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocAttachmentBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractChangeReqBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractChangeRspBO;
import com.tydic.uoc.common.busi.api.UocExtensionOfflineContractChangeBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocContractPayConfMapper;
import com.tydic.uoc.dao.UocOfflineContractChangeMapper;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocContractPayConfPO;
import com.tydic.uoc.po.UocOfflineContractChangePO;
import com.tydic.uoc.po.UocOfflineContractPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UocExtensionOfflineContractChangeBusiServiceImpl
implements UocExtensionOfflineContractChangeBusiService {
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;
    @Autowired
    private UocOfflineContractChangeMapper uocOfflineContractChangeMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocContractPayConfMapper uocContractPayConfMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;

    @Override
    public UocExtensionOfflineContractChangeRspBO dealOfflineContractChange(UocExtensionOfflineContractChangeReqBO reqBO) {
        UocOfflineContractChangePO addChangePo = this.saveHistory(reqBO);
        UocOfflineContractPO contractPO = this.change(reqBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFileList())) {
            this.buildFiles(reqBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPayList())) {
            this.buildPay(reqBO, addChangePo);
        }
        UocExtensionOfflineContractChangeRspBO rspBO = new UocExtensionOfflineContractChangeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocOfflineContractPO change(UocExtensionOfflineContractChangeReqBO reqBO) {
        UocOfflineContractPO contractPO = (UocOfflineContractPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UocOfflineContractPO.class);
        contractPO.setUpdateTime(new Date());
        contractPO.setUpdateUserId(reqBO.getUserId());
        contractPO.setUpdateUserName(reqBO.getName());
        UocOfflineContractPO wherePo = new UocOfflineContractPO();
        wherePo.setContractId(reqBO.getContractId());
        contractPO.setContractId(null);
        if (!ObjectUtils.isEmpty((Object)wherePo.getContractId())) {
            this.uocOfflineContractMapper.updateByToChange(contractPO, wherePo);
        }
        return contractPO;
    }

    private UocOfflineContractChangePO saveHistory(UocExtensionOfflineContractChangeReqBO reqBO) {
        UocOfflineContractPO qry = new UocOfflineContractPO();
        qry.setContractId(reqBO.getContractId());
        UocOfflineContractPO modelBy = this.uocOfflineContractMapper.getModelBy(qry);
        if (null == modelBy) {
            throw new UocProBusinessException("8888", "\u4e3a\u67e5\u8be2\u5230\u76f8\u5173\u5408\u540c");
        }
        UocOfflineContractChangePO addChangePo = (UocOfflineContractChangePO)JSONObject.parseObject((String)JSON.toJSONString((Object)modelBy), UocOfflineContractChangePO.class);
        addChangePo.setId(Long.valueOf(this.idUtil.nextId()));
        int insertChange = this.uocOfflineContractChangeMapper.insert(addChangePo);
        if (insertChange != 1) {
            throw new UocProBusinessException("8888", "\u65b0\u589e\u5386\u53f2\u8bb0\u5f55\u5931\u8d25");
        }
        return addChangePo;
    }

    private void buildPay(UocExtensionOfflineContractChangeReqBO reqBo, UocOfflineContractChangePO addChangePo) {
        UocContractPayConfPO payConfPO = new UocContractPayConfPO();
        payConfPO.setContractId(reqBo.getContractId());
        List list = this.uocContractPayConfMapper.getList(payConfPO);
        this.uocContractPayConfMapper.deleteBy(payConfPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (UocContractPayConfPO contractPayConfPO : list) {
                contractPayConfPO.setContractId(addChangePo.getId());
                contractPayConfPO.setId(Long.valueOf(this.idUtil.nextId()));
            }
            this.uocContractPayConfMapper.insertBatch(list);
        }
        List addPayList = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBo.getPayList()), UocContractPayConfPO.class);
        for (UocContractPayConfPO addPayPo : addPayList) {
            if (addPayPo.getId() == null) {
                addPayPo.setId(Long.valueOf(this.idUtil.nextId()));
            }
            addPayPo.setContractId(reqBo.getContractId());
            addPayPo.setCreateTime(new Date());
        }
        this.uocContractPayConfMapper.insertBatch(addPayList);
    }

    private void buildFiles(UocExtensionOfflineContractChangeReqBO reqBo) {
        OrdAccessoryPO deleteFilePo = new OrdAccessoryPO();
        deleteFilePo.setObjectId(reqBo.getContractId());
        deleteFilePo.setObjectType(Integer.valueOf(101));
        deleteFilePo.setAttachmentType(Integer.valueOf(0));
        if (!ObjectUtils.isEmpty((Object)deleteFilePo.getObjectId())) {
            this.ordAccessoryMapper.deleteBy(deleteFilePo);
        }
        ArrayList<OrdAccessoryPO> addFileList = new ArrayList<OrdAccessoryPO>();
        for (UocAttachmentBO uocAttachmentBO : reqBo.getFileList()) {
            OrdAccessoryPO addFilePo = new OrdAccessoryPO();
            addFilePo.setId(Long.valueOf(this.idUtil.nextId()));
            addFilePo.setObjectId(reqBo.getContractId());
            addFilePo.setObjectType(Integer.valueOf(101));
            addFilePo.setOrderId(reqBo.getContractId());
            addFilePo.setAttachmentType(Integer.valueOf(0));
            addFilePo.setAccessoryName(uocAttachmentBO.getFileName());
            addFilePo.setAccessoryUrl(uocAttachmentBO.getFileUrl());
            addFilePo.setCreateTime(new Date());
            addFilePo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
            addFileList.add(addFilePo);
        }
        this.ordAccessoryMapper.insertBatch(addFileList);
    }
}

