/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRefundUpdateRspBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateRspBo;
import com.tydic.uoc.common.busi.api.UocOrderRelUpdateBusiService;
import com.tydic.uoc.dao.UocOrderRelItemMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.UocOrderRelItemPO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocOrderRelUpdateBusiServiceImpl
implements UocOrderRelUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRelUpdateBusiServiceImpl.class);
    @Autowired
    private UocOrderRelMapper orderRelMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private UocOrderRelItemMapper uocOrderRelItemMapper;
    private static final String DEL_FLAG = "1";

    @Override
    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        UocOrderRelUpdateRspBo rspBo = new UocOrderRelUpdateRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
        uocOrderRelPO.setOrderId(reqBo.getOrderId());
        uocOrderRelPO.setInspectionOrderId(reqBo.getInspectionVoucherId());
        uocOrderRelPO.setRelType(reqBo.getRelType());
        uocOrderRelPO.setSettleType(reqBo.getSettleType());
        uocOrderRelPO.setRefundId(reqBo.getRefundId());
        UocOrderRelPO modelBy = null;
        if (null != reqBo.getRelId()) {
            uocOrderRelPO.setRelId(reqBo.getRelId().toString());
            modelBy = this.orderRelMapper.getModelBy(uocOrderRelPO);
        } else if (null != reqBo.getRelState() && 2 == reqBo.getRelState()) {
            uocOrderRelPO.setRelStatus(reqBo.getRelState());
            modelBy = this.orderRelMapper.getModelByRelIdNull(uocOrderRelPO);
            if (null != modelBy) {
                reqBo.setDelFlag(DEL_FLAG);
            }
        } else {
            modelBy = this.orderRelMapper.getModelBy(uocOrderRelPO);
        }
        if (modelBy == null) {
            long id = this.orderGenerateIdUtil.nextId();
            uocOrderRelPO.setId(Long.valueOf(id));
            if (null != reqBo.getRelId()) {
                uocOrderRelPO.setRelId(String.valueOf(reqBo.getRelId()));
            }
            uocOrderRelPO.setRelStatus(reqBo.getRelState());
            this.orderRelMapper.insert(uocOrderRelPO);
        } else if (DEL_FLAG.equals(reqBo.getDelFlag())) {
            this.orderRelMapper.deleteById(modelBy.getId());
        } else {
            if (null != reqBo.getRelId()) {
                modelBy.setRelId(String.valueOf(reqBo.getRelId()));
            }
            modelBy.setRelStatus(reqBo.getRelState());
            this.orderRelMapper.updateById(modelBy);
        }
        UocOrderRelItemPO deletePo = new UocOrderRelItemPO();
        deletePo.setOrderRelId(modelBy == null ? uocOrderRelPO.getId() : modelBy.getId());
        if (null != deletePo.getOrderRelId()) {
            this.uocOrderRelItemMapper.deleteByOrderRelId(deletePo);
        }
        List uocOrderRelItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBo.getUocOrderRelItemBos()), UocOrderRelItemPO.class);
        for (UocOrderRelItemPO po : uocOrderRelItemPOS) {
            po.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            po.setOrderRelId(modelBy == null ? uocOrderRelPO.getId() : modelBy.getId());
            po.setRefundId(reqBo.getRefundId());
        }
        if (!CollectionUtils.isEmpty((Collection)uocOrderRelItemPOS)) {
            this.uocOrderRelItemMapper.insertBatch(uocOrderRelItemPOS);
        }
        return rspBo;
    }

    @Override
    public UocOrderRefundUpdateRspBo dealRefundUpdate(UocOrderRefundUpdateReqBo reqBo) {
        int count;
        UocOrderRefundUpdateRspBo rspBo = new UocOrderRefundUpdateRspBo();
        int checkCount = this.uocOrderRelItemMapper.getCheckByRefund(reqBo.getRelId());
        if (checkCount > 0) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u8be5\u9000\u7968\u5355\u5b58\u5728\u6570\u636e\u540c\u6b65\u9000\u7968\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u540c\u6b65\uff01");
            return rspBo;
        }
        ArrayList<UocOrderRelPO> relPOList = new ArrayList<UocOrderRelPO>();
        HashMap<Long, Long> acceptOrderIdMap = new HashMap<Long, Long>();
        for (Object acceptOrderId : reqBo.getAcceptOrderMap().keySet()) {
            UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
            uocOrderRelPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            uocOrderRelPO.setInspectionOrderId((Long)acceptOrderId);
            uocOrderRelPO.setOrderId((Long)reqBo.getAcceptOrderMap().get(acceptOrderId));
            uocOrderRelPO.setRelId(reqBo.getRelId() + "");
            uocOrderRelPO.setRelType(reqBo.getRelType());
            uocOrderRelPO.setRelStatus(reqBo.getRelStatus());
            uocOrderRelPO.setSettleType(reqBo.getSettleType());
            uocOrderRelPO.setRefundId(reqBo.getRelId());
            relPOList.add(uocOrderRelPO);
            acceptOrderIdMap.put(uocOrderRelPO.getInspectionOrderId(), uocOrderRelPO.getId());
        }
        List uocOrderRelItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBo.getUocOrderRelItemBos()), UocOrderRelItemPO.class);
        for (UocOrderRelItemPO po : uocOrderRelItemPOS) {
            po.setAmt(po.getAmt().negate());
            po.setNum(po.getNum().negate());
            po.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            po.setRelId(reqBo.getRelId());
            po.setRefundId(reqBo.getRelId());
            po.setOrderRelId((Long)acceptOrderIdMap.get(po.getAcceptOrderId()));
        }
        if (!CollectionUtils.isEmpty(relPOList) && (count = this.orderRelMapper.insertBatch(relPOList)) != relPOList.size()) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u9000\u7968\u5173\u8054\u6570\u636e\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)uocOrderRelItemPOS) && (count = this.uocOrderRelItemMapper.insertBatch(uocOrderRelItemPOS)) != uocOrderRelItemPOS.size()) {
            throw new UocProBusinessException("8888", "\u63d2\u5165\u9000\u7968\u5173\u8054\u660e\u7ec6\u6570\u636e\u5931\u8d25\uff01");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setSettleMap(reqBo.getAcceptOrderMap());
        return rspBo;
    }

    @Override
    public UocOrderRefundUpdateRspBo dealUpdateBatch(UocOrderRefundUpdateReqBo reqBo) {
        UocOrderRefundUpdateRspBo rspBo = new UocOrderRefundUpdateRspBo();
        UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
        uocOrderRelPO.setRelId(reqBo.getRelId() + "");
        uocOrderRelPO.setSettleType(reqBo.getSettleType());
        List uocOrderRelPOS = this.orderRelMapper.getList(uocOrderRelPO);
        if (CollectionUtils.isEmpty((Collection)uocOrderRelPOS)) {
            throw new UocProBusinessException("8888", "\u91ca\u653e\u8ba2\u5355\u5173\u8054\u8868\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        rspBo.setSettleMap(uocOrderRelPOS.stream().collect(Collectors.toMap(UocOrderRelPO::getInspectionOrderId, UocOrderRelPO::getOrderId)));
        List ids = uocOrderRelPOS.stream().map(UocOrderRelPO::getId).collect(Collectors.toList());
        if (reqBo.getDealType() == 1) {
            this.orderRelMapper.deleteByIds(ids);
            UocOrderRelItemPO relItemPO = new UocOrderRelItemPO();
            relItemPO.setOrderRelIds(ids);
            this.uocOrderRelItemMapper.deleteByOrderRelIds(relItemPO);
        } else {
            List pos = reqBo.getUocOrderRelItemBos().stream().map(x -> {
                UocOrderRelItemPO y = new UocOrderRelItemPO();
                y.setOrdItemId(x.getOrdItemId());
                y.setNum(x.getNum());
                y.setAmt(x.getAmt());
                y.setOrderId(x.getOrderId());
                return y;
            }).collect(Collectors.toList());
            this.uocOrderRelItemMapper.updateDownSettleBatch(pos, ids);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

