/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.ability.bo.AfterServBO;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdStakeholderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdStakeholderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderWarehouseInfoBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsQueryRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreShipDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipDetailsQueryRspBO;
import com.tydic.uoc.common.busi.api.UocShipDetailsListQueryBusiService;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uocShipDetailsQueryBusiService")
public class UocShipDetailsListQueryBusiServiceImpl
implements UocShipDetailsListQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocShipDetailsListQueryBusiServiceImpl.class);
    @Autowired
    private UocCoreShipDetailsQueryAtomService uocCoreShipDetailsQueryAtomService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Value(value="${uoc.sup.inspName}")
    private String supName;
    @Value(value="${uoc.sup.inspUrl}")
    private String inspUrl;
    @Value(value="${uoc.url.flag:true}")
    private Boolean flag;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public UocShipDetailsListQueryRspBO getShipDetailsQuery(UocShipDetailsListQueryReqBO reqBO) {
        UocShipDetailsListQueryRspBO rspBO = new UocShipDetailsListQueryRspBO();
        this.validateParams(reqBO);
        if (null != reqBO.getShipVoucherId()) {
            ArrayList<UocShipDetailsQueryRspBO> shipDetailsQueryRspBOList = new ArrayList<UocShipDetailsQueryRspBO>();
            OrdShipPO ordShipPO = this.ordShipMapper.getModelById(reqBO.getShipVoucherId().longValue());
            UocCoreShipDetailsQueryRspBO atomRspBO = this.transferAtomService(reqBO, false);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                rspBO.setRespCode(atomRspBO.getRespCode());
                rspBO.setRespDesc(atomRspBO.getRespDesc());
                return rspBO;
            }
            UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.buildAtomRspBO(atomRspBO, ordShipPO, true, reqBO);
            this.transOrdShip(uocShipDetailsQueryRspBO.getOrdShipRspBO());
            this.buildOrdStakeholderRspBO(uocShipDetailsQueryRspBO.getOrdShipRspBO(), true);
            shipDetailsQueryRspBOList.add(uocShipDetailsQueryRspBO);
            rspBO.setShipDetailsQueryRspBOList(shipDetailsQueryRspBOList);
        } else {
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setOrderId(reqBO.getOrderId());
            if (null != reqBO.getShipStatus()) {
                shipPO.setShipStatus(String.valueOf(reqBO.getShipStatus()));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getShipStatusList())) {
                shipPO.setShipStatusList(reqBO.getShipStatusList());
            }
            if (Integer.valueOf(1).equals(reqBO.getAbnormalDimension())) {
                shipPO.setShipStatusList(Arrays.asList("1203", "1205"));
            } else if (Integer.valueOf(2).equals(reqBO.getAbnormalDimension())) {
                shipPO.setShipStatusList(Arrays.asList("1204", "2205"));
            }
            List ordShipPOList = this.ordShipMapper.getList(shipPO);
            if (!CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u53d1\u8d27\u5355\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            ArrayList<UocShipDetailsQueryRspBO> shipDetailsQueryRspBOList = new ArrayList<UocShipDetailsQueryRspBO>();
            for (OrdShipPO ordShipPO : ordShipPOList) {
                reqBO.setShipVoucherId(ordShipPO.getShipVoucherId());
                UocCoreShipDetailsQueryRspBO atomRspBO = new UocCoreShipDetailsQueryRspBO();
                if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) && !"0000".equals((atomRspBO = this.transferAtomService(reqBO, true)).getRespCode())) {
                    rspBO.setRespCode(atomRspBO.getRespCode());
                    rspBO.setRespDesc(atomRspBO.getRespDesc());
                    return rspBO;
                }
                UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = this.buildAtomRspBO(atomRspBO, ordShipPO, true, reqBO);
                this.transOrdShip(uocShipDetailsQueryRspBO.getOrdShipRspBO());
                this.buildOrdStakeholderRspBO(uocShipDetailsQueryRspBO.getOrdShipRspBO(), false);
                shipDetailsQueryRspBOList.add(uocShipDetailsQueryRspBO);
            }
            rspBO.setShipDetailsQueryRspBOList(shipDetailsQueryRspBOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocShipDetailsListQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private UocOrdShipRspBO buildOrdShipRspBO(OrdShipPO ordShipPO) {
        UocOrdShipRspBO ordShipRspBO = new UocOrdShipRspBO();
        BeanUtils.copyProperties((Object)ordShipPO, (Object)ordShipRspBO);
        ordShipRspBO.setShipExtraMap(this.buildShipExtraInfoMap(ordShipPO));
        AfterServBO afterServBO = new AfterServBO();
        afterServBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        afterServBO.setOrderId(ordShipPO.getOrderId());
        ArrayList<Integer> notStatus = new ArrayList<Integer>(7);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.SUCCESS);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.CONFIRM);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.PUR_COMPLETE);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.APPROVAL_FAILURE);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.CANCEL);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.REFUSE);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.CANCEL);
        afterServBO.setNotStatus(notStatus);
        int notEndCount = this.ordAfterServiceMapper.getNotEndCount(afterServBO);
        if (0 < notEndCount) {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(0));
        } else {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(1));
        }
        UocOrdWarehousePO uocOrdWarehousePO = new UocOrdWarehousePO();
        uocOrdWarehousePO.setOrderId(ordShipPO.getOrderId());
        uocOrdWarehousePO = this.uocOrdWarehouseMapper.getModelBy(uocOrdWarehousePO);
        ordShipRspBO.setWarehouseInfo((UocOrderWarehouseInfoBO)JSON.parseObject((String)JSONObject.toJSONString((Object)uocOrdWarehousePO), UocOrderWarehouseInfoBO.class));
        return ordShipRspBO;
    }

    private Map<String, String> buildShipExtraInfoMap(OrdShipPO ordShipPO) {
        HashMap<String, String> orderExtraMap = new HashMap<String, String>(16);
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(ordShipPO.getOrderId());
        ordExtMapCondition.setObjId(ordShipPO.getShipVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private UocCoreShipDetailsQueryRspBO transferAtomService(UocShipDetailsListQueryReqBO reqBO, Boolean isQueryLevel) {
        UocCoreShipDetailsQueryReqBO atomReqBO = new UocCoreShipDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        if (isQueryLevel.booleanValue()) {
            atomReqBO.setQueryLevel(UocCoreConstant.QUERY_LEVEL.QUERY_ITEM);
        }
        return this.uocCoreShipDetailsQueryAtomService.getShipDetailsQuery(atomReqBO);
    }

    private UocShipDetailsQueryRspBO buildAtomRspBO(UocCoreShipDetailsQueryRspBO atomRspBO, OrdShipPO ordShipPO, Boolean isBuildPrimary, UocShipDetailsListQueryReqBO reqBO) {
        UocShipDetailsQueryRspBO uocShipDetailsQueryRspBO = new UocShipDetailsQueryRspBO();
        if (isBuildPrimary.booleanValue()) {
            uocShipDetailsQueryRspBO.setOrdShipRspBO(this.buildOrdShipRspBO(ordShipPO));
        } else {
            UocOrdShipRspBO uocOrdShipRspBO = new UocOrdShipRspBO();
            BeanUtils.copyProperties((Object)atomRspBO.getOrdShipRspBO(), (Object)uocOrdShipRspBO);
            uocShipDetailsQueryRspBO.setOrdShipRspBO(uocOrdShipRspBO);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getShipAccessoryRspList())) {
            ArrayList<UocOrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<UocOrdAccessoryRspBO>();
            for (OrdAccessoryRspBO ordAccessoryRspBO : atomRspBO.getShipAccessoryRspList()) {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = new UocOrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)ordAccessoryRspBO, (Object)uocOrdAccessoryRspBO);
                ordAccessoryRspBOList.add(uocOrdAccessoryRspBO);
            }
            uocShipDetailsQueryRspBO.setShipAccessoryRspList(ordAccessoryRspBOList);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getOrdShipItemRspBOList())) {
            ArrayList<UocOrdShipItemRspBO> ordShipItemRspBOList = new ArrayList<UocOrdShipItemRspBO>();
            for (OrdShipItemRspBO ordShipItemRspBO : atomRspBO.getOrdShipItemRspBOList()) {
                UocOrdShipItemRspBO uocOrdShipItemRspBO = new UocOrdShipItemRspBO();
                BeanUtils.copyProperties((Object)ordShipItemRspBO, (Object)uocOrdShipItemRspBO);
                if (null != reqBO.getAfterDimension()) {
                    if (UocCoreConstant.shipAfterDimension.SHIPPING.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getSendCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getSendCount());
                        }
                    } else if (UocCoreConstant.shipAfterDimension.ARRIVED.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getArriveCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getArriveCount());
                        }
                    } else if (UocCoreConstant.shipAfterDimension.ACCEPTED.equals(reqBO.getAfterDimension())) {
                        if (null != ordShipItemRspBO.getReturnCount() && BigDecimal.ZERO.compareTo(ordShipItemRspBO.getReturnCount()) < 0) {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getAcceptanceCount().subtract(ordShipItemRspBO.getReturnCount()));
                        } else {
                            uocOrdShipItemRspBO.setAvailableAfterServCount(ordShipItemRspBO.getAcceptanceCount());
                        }
                    }
                }
                ordShipItemRspBOList.add(uocOrdShipItemRspBO);
            }
            uocShipDetailsQueryRspBO.setOrdShipItemRspBOList(ordShipItemRspBOList);
        }
        uocShipDetailsQueryRspBO.setRespCode("0000");
        uocShipDetailsQueryRspBO.setRespDesc("\u6210\u529f");
        return uocShipDetailsQueryRspBO;
    }

    public void transOrdShip(UocOrdShipRspBO ordShipRspBO) {
        String vendorOrderType;
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(ordShipRspBO.getShipStatus() + "");
        dictReqBO.setPcode("SHIP_ORDER_STATUS");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordShipRspBO.setShipStatusStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ordShipRspBO.getShipCompanyName())) {
            dictReqBO.setCode(ordShipRspBO.getShipCompanyName() + "");
            dictReqBO.setPcode("LOGISTICS_CODE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordShipRspBO.setModifyOperId(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
        if (MapUtils.isNotEmpty((Map)ordShipRspBO.getShipExtraMap()) && (vendorOrderType = (String)ordShipRspBO.getShipExtraMap().get("vendorOrderType")) != null) {
            dictReqBO.setCode(vendorOrderType);
            dictReqBO.setPcode("VENDOR_ORDER_TYPE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordShipRspBO.setVendorOrderTypeStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
    }

    private void buildOrdStakeholderRspBO(UocOrdShipRspBO ordShipRspBO, boolean flag) {
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(ordShipRspBO.getOrderId().longValue());
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(ordShipRspBO.getOrderId());
        OrdSalePO salePO = this.ordSaleMapper.getModelBy(ordSalePO);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(ordShipRspBO.getOrderId());
        OrderPO ordPo = this.orderMapper.getModelBy(orderPO);
        if (null != salePO) {
            ordLogisticsRelaPO.setOrderId(ordShipRspBO.getOrderId());
            ordLogisticsRelaPO.setContactId(salePO.getContactId());
            OrdLogisticsRelaPO relaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
            OrdStakeholderRspBO ordStakeholderRspBO = new OrdStakeholderRspBO();
            if (null != ordStakeholderPO) {
                BeanUtils.copyProperties((Object)ordStakeholderPO, (Object)ordStakeholderRspBO);
            }
            if (null != relaPO) {
                ordStakeholderRspBO.setPurAddress(relaPO.getContactAddress());
                ordShipRspBO.setContactToAddress(relaPO.getContactProvinceName() + relaPO.getContactCityName());
            }
            UocOrdStakeholderRspBO uocOrdStakeholderRspBO = new UocOrdStakeholderRspBO();
            BeanUtils.copyProperties((Object)ordStakeholderRspBO, (Object)uocOrdStakeholderRspBO);
            ordShipRspBO.setOrdStakeholderRspBO(uocOrdStakeholderRspBO);
            ordShipRspBO.setSaleVoucherNo(salePO.getSaleVoucherNo());
            ordShipRspBO.setOrderSource(salePO.getOrderSource());
            if (ordPo.getOrderType() != null) {
                ordShipRspBO.setOrderType(ordPo.getOrderType() + "");
            }
        }
        if (null != ordStakeholderPO && null != salePO && "2".equals(salePO.getOrderSource()) && flag) {
            this.inspUrlMethod(ordShipRspBO, ordStakeholderPO, salePO);
        }
    }

    private void inspUrlMethod(UocOrdShipRspBO ordShipRspBO, OrdStakeholderPO ordStakeholderPO, OrdSalePO salePO) {
        try {
            if (!ordStakeholderPO.getSupName().contains("\u4eac\u4e1c")) {
                String reqStr = this.initPostStr(ordShipRspBO, ordStakeholderPO, salePO);
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.inspUrl), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
                log.info("\u8c03\u7528\u67e5\u8be2\u7535\u5546\u53d1\u8d27\u5355\u7684\u7535\u5b50\u9a8c\u6536\u5355\u4fe1\u606fESB\u63a5\u53e3\u54cd\u5e94\u62a5\u6587" + JSON.toJSONString((Object)httpRetBean));
                if (httpRetBean.getStatus() != 200) {
                    throw new RuntimeException("\u8c03\u7528\u67e5\u8be2\u7535\u5b50\u9a8c\u6536\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.inspUrl + "]");
                }
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    throw new UocProBusinessException("102001", "\u8c03\u7528ESB\u67e5\u8be2\u7535\u5b50\u9a8c\u6536\u5355\u4fe1\u606f\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                this.resolveRsp(returnString, ordShipRspBO, ordStakeholderPO);
            } else {
                this.dealJDUrl(ordShipRspBO, salePO, ordStakeholderPO);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ESB\u67e5\u8be2\u7535\u5b50\u9a8c\u6536\u5355\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
    }

    private String initPostStr(UocOrdShipRspBO ordShipRspBO, OrdStakeholderPO ordStakeholderPO, OrdSalePO salePO) {
        JSONObject jsonObject = new JSONObject();
        if (this.supName.contains(ordStakeholderPO.getSupName())) {
            if (ordStakeholderPO.getSupName().contains("\u4eac\u4e1c")) {
                jsonObject.put("reqSource", (Object)11);
            }
            jsonObject.put("orderId", (Object)ordShipRspBO.getExtOrderId());
            jsonObject.put("packageId", (Object)"");
        } else {
            jsonObject.put("orderId", (Object)"");
            jsonObject.put("packageId", (Object)ordShipRspBO.getPackageId());
        }
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + ordStakeholderPO.getSupNo()));
        String esbReqParam = ESBParamUtil.getEsbReqStr((String)jsonObject.toJSONString(), (String)hsn, (String)"BUSINESS_ORDER");
        log.info("\u8c03\u7528\u67e5\u8be2\u7535\u5546\u53d1\u8d27\u5355\u7684\u7535\u5b50\u9a8c\u6536\u5355\u4fe1\u606fESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        return esbReqParam;
    }

    private void resolveRsp(String returnString, UocOrdShipRspBO ordShipRspBO, OrdStakeholderPO ordStakeholderPO) {
        JSONArray jsonArray;
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (!ordStakeholderPO.getSupName().contains("\u4eac\u4e1c") && (jsonArray = jsonObject.containsKey((Object)"receiveUrls") ? jsonObject.getJSONArray("receiveUrls") : jsonObject.getJSONArray("result")) != null && jsonArray.size() > 0) {
            ordShipRspBO.setInspUrl(JSONArray.parseArray((String)jsonArray.toJSONString(), String.class));
        }
    }

    private void dealJDUrl(UocOrdShipRspBO ordShipRspBO, OrdSalePO salePO, OrdStakeholderPO ordStakeholderPO) throws Exception {
        String reqStr = this.initPostStr(ordShipRspBO, ordStakeholderPO, salePO);
        List<String> strings = Arrays.asList("ednSignBack", "enterpriseSignBack", "miniUserSign", "venderUploadSign");
        ArrayList urls = new ArrayList();
        for (String x : strings) {
            JSONArray urljson;
            JSONObject backType;
            JSONObject jsonObject = JSONObject.parseObject((String)reqStr);
            jsonObject.put("signBackTypes", (Object)x);
            log.info("\u8c03\u7528\u67e5\u8be2\u7535\u5546\u53d1\u8d27\u5355\u7684\u7535\u5b50\u9a8c\u6536\u5355JD\u4fe1\u606fESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.inspUrl), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])jsonObject.toJSONString().getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            log.info("\u8c03\u7528\u67e5\u8be2\u7535\u5546\u53d1\u8d27\u5355\u7684\u7535\u5b50\u9a8c\u6536\u5355JD\u4fe1\u606fESB\u63a5\u53e3\u54cd\u5e94\u62a5\u6587" + JSON.toJSONString((Object)httpRetBean));
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u67e5\u8be2\u7535\u5b50\u9a8c\u6536\u5355JD\u4fe1\u606f\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.inspUrl + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("102001", "\u8c03\u7528ESB\u67e5\u8be2\u7535\u5b50\u9a8c\u6536\u5355\u4fe1\u606fJD\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            JSONObject parseJSON = JSONObject.parseObject((String)returnString);
            JSONObject urlStr = parseJSON.getJSONObject("result");
            if (urlStr == null || (backType = urlStr.getJSONObject(x)) == null || (urljson = backType.getJSONArray("signUrls")) == null || urljson.size() <= 0) continue;
            urls.addAll(JSONArray.parseArray((String)urljson.toJSONString(), String.class));
        }
        ordShipRspBO.setInspUrl(urls);
    }
}

