/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.ContractHtGetTokenAbilityService;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebExtPushContractAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushContractPayLoadAbilityRspBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomReqBO;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushContractService;
import com.tydic.uoc.common.busi.bo.CheckIsNormalContractOrderBO;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocContractSyncFailLogMapper;
import com.tydic.uoc.dao.UocContractSyncLogMapper;
import com.tydic.uoc.dao.UocOrdLabelContractMapper;
import com.tydic.uoc.po.ContractOrderPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocContractSyncFailLogPO;
import com.tydic.uoc.po.UocContractSyncLogPO;
import com.tydic.uoc.po.UocOrdLabelContractPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="UccGateWayApplicationPushContractServiceImpl")
public class UccGateWayApplicationPushContractServiceImpl
implements UccGateWayApplicationPushContractService {
    private static final Logger log = LoggerFactory.getLogger(UccGateWayApplicationPushContractServiceImpl.class);
    public static final String SUCCESS = "200";
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private ContractHtGetTokenAbilityService contractHtGetTokenAbilityService;
    @Autowired
    private UocContractSyncFailLogMapper uocContractSyncFailLogMapper;
    @Autowired
    private UocContractSyncLogMapper uocContractSyncLogMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdLabelContractMapper uocOrdLabelContractMapper;

    @Override
    public boolean dealPushFunction(String reqStr, String url, Integer type, Long orderId) {
        log.error("\u5f00\u59cb\u7ec4\u88c5\u8bf7\u6c42\uff0c\u53d1\u9001HTTP\u8bf7\u6c42");
        Date time = new Date();
        String respStr = null;
        UocContractSyncLogPO uocContractSyncLogPO = new UocContractSyncLogPO();
        uocContractSyncLogPO.setObjId(orderId);
        uocContractSyncLogPO.setLogId(Long.valueOf(this.idUtil.nextId()));
        uocContractSyncLogPO.setCreateTime(time);
        uocContractSyncLogPO.setType(type);
        uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
        uocContractSyncLogPO.setUrl(url);
        uocContractSyncLogPO.setReqStr(reqStr);
        try {
            ContractHtGetTokenAbilityReqBO tokenAbilityReqBO = new ContractHtGetTokenAbilityReqBO();
            log.error("\u5f00\u59cb\u83b7\u53d6\u5408\u540c\u7cfb\u7edfToken......");
            ContractHtGetTokenAbilityRspBO htToken = this.contractHtGetTokenAbilityService.getHTToken(tokenAbilityReqBO);
            if (htToken == null || StringUtils.isEmpty((Object)htToken.getToken())) {
                uocContractSyncLogPO.setRspStr("\u83b7\u53d6\u5408\u540c\u7cfb\u7edfToken\u5931\u8d25");
                this.recordFailureInformation(uocContractSyncLogPO, respStr);
                log.error("\u83b7\u53d6\u5408\u540c\u7cfb\u7edfToken\u5931\u8d25");
                return false;
            }
            String token = htToken.getToken();
            log.error("\u83b7\u53d6\u5230\u5408\u540c\u7cfb\u7edfToken\u4e3a\uff1a------\u300b   {}", (Object)token);
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", token);
            log.error("\u63a8\u9001\u5165\u53c2\uff1a" + reqStr);
            log.error("\u63a8\u9001\u8def\u5f84\u4e3a\uff1a  {}", (Object)url);
            respStr = HttpUtil.doPost(url, reqStr, headMap);
            log.error("\u63a8\u9001\u51fa\u53c2\uff1a" + respStr);
            uocContractSyncLogPO.setRspStr(respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recordFailureInformation(uocContractSyncLogPO, respStr);
            log.error("\u63a8\u9001\u5f02\u5e38 {}", (Object)e.getMessage());
            return false;
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            this.recordFailureInformation(uocContractSyncLogPO, respStr);
            log.error("\u63a8\u9001\u5f02\u5e38\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a:");
            return false;
        }
        try {
            PebExtPushContractAbilityRspBO rspBO = (PebExtPushContractAbilityRspBO)JSONObject.parseObject((String)respStr, PebExtPushContractAbilityRspBO.class);
            if (SUCCESS.equals(rspBO.getStatus())) {
                if (!StringUtils.isEmpty((Object)rspBO.getPayload())) {
                    log.error("payLoad\u4fe1\u606f\u4e3a\uff1a {}", (Object)rspBO.getPayload());
                    PebExtPushContractPayLoadAbilityRspBO payLoadRspBO = (PebExtPushContractPayLoadAbilityRspBO)JSONObject.parseObject((String)rspBO.getPayload(), PebExtPushContractPayLoadAbilityRspBO.class);
                    log.error("\u8f6c\u6362\u540epayLoad\u5bf9\u8c61\u4e3a\uff1a {}", (Object)payLoadRspBO);
                    if (payLoadRspBO != null && !StringUtils.isEmpty((Object)payLoadRspBO.getCode()) && "S".equals(payLoadRspBO.getCode())) {
                        uocContractSyncLogPO.setRspStr(respStr);
                        uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.SUCCESS);
                        this.insertPushLog(uocContractSyncLogPO);
                        log.error("\u672c\u6b21\u63a8\u9001\u7ed3\u675f\uff0c\u63a8\u9001\u6210\u529f\uff01\uff01\uff01   \u63a8\u9001\u4fe1\u606f\u4e3a\uff1a{}", (Object)respStr);
                        return true;
                    }
                }
                this.recordFailureInformation(uocContractSyncLogPO, respStr);
                log.error("\u672c\u6b21\u63a8\u9001\u7ed3\u675f {}", (Object)respStr);
            } else {
                this.recordFailureInformation(uocContractSyncLogPO, respStr);
                log.error("\u672c\u6b21\u63a8\u9001\u7ed3\u675f\uff1a{}", (Object)respStr);
            }
            return false;
        }
        catch (Exception e) {
            this.recordFailureInformation(uocContractSyncLogPO, respStr);
            log.error("\u63a8\u9001\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
            return false;
        }
    }

    @Override
    public CheckIsNormalContractOrderBO checkIsNormalContractOrder(PebSyncHtPurchaseContractAtomReqBO reqBO) {
        OrdSalePO ordSalePO;
        CheckIsNormalContractOrderBO checkIsNormalContractOrderBO = new CheckIsNormalContractOrderBO();
        checkIsNormalContractOrderBO.setOrderId(reqBO.getOrderId());
        Integer isPushOutHt = this.orderMapper.getIsPushOutHt(reqBO.getOrderId());
        if (isPushOutHt == null || isPushOutHt.equals(0)) {
            return checkIsNormalContractOrderBO;
        }
        ContractOrderPO isContractIdOrder = this.orderMapper.checkIsContractOrder(reqBO.getOrderId(), Integer.valueOf(4), null);
        if (isContractIdOrder != null) {
            BeanUtils.copyProperties((Object)isContractIdOrder, (Object)checkIsNormalContractOrderBO);
            checkIsNormalContractOrderBO.setIsGatherOrder(0);
            return checkIsNormalContractOrderBO;
        }
        ContractOrderPO isPurchaseIdOrder = this.orderMapper.checkIsContractOrder(reqBO.getOrderId(), Integer.valueOf(1), Integer.valueOf(1));
        if (isPurchaseIdOrder != null) {
            BeanUtils.copyProperties((Object)isPurchaseIdOrder, (Object)checkIsNormalContractOrderBO);
            checkIsNormalContractOrderBO.setIsGatherOrder(0);
            return checkIsNormalContractOrderBO;
        }
        OrdSalePO searchSalePO = new OrdSalePO();
        ArrayList<Long> orderIdList = new ArrayList<Long>();
        orderIdList.add(reqBO.getOrderId());
        searchSalePO.setOrderIdList(orderIdList);
        List ordSalePOList = this.ordSaleMapper.getList(searchSalePO);
        if (!CollectionUtils.isEmpty((Collection)ordSalePOList) && (ordSalePO = (OrdSalePO)ordSalePOList.get(0)).getModelSettle() != null && !StringUtils.isEmpty((Object)ordSalePO.getOrderSource()) && ordSalePO.getModelSettle() == 2 && ordSalePO.getOrderSource().equals("1")) {
            checkIsNormalContractOrderBO.setIsGatherOrder(1);
            List labelContractPOS = this.uocOrdLabelContractMapper.getListByOrderId(reqBO.getOrderId());
            if (!CollectionUtils.isEmpty((Collection)labelContractPOS)) {
                UocOrdLabelContractPO labelContractPO = (UocOrdLabelContractPO)labelContractPOS.get(0);
                checkIsNormalContractOrderBO.setOrderId(reqBO.getOrderId());
                checkIsNormalContractOrderBO.setContractId(labelContractPO.getContractId());
                checkIsNormalContractOrderBO.setContractNo(labelContractPO.getContractCode());
                checkIsNormalContractOrderBO.setContractUuid(ordSalePO.getContractUuid());
            }
            return checkIsNormalContractOrderBO;
        }
        checkIsNormalContractOrderBO.setIsGatherOrder(0);
        return checkIsNormalContractOrderBO;
    }

    private void recordFailureInformation(UocContractSyncLogPO uocContractSyncLogPO, String respStr) {
        uocContractSyncLogPO.setStatus(UocConstant.ContractPushState.FAIL);
        uocContractSyncLogPO.setRspStr(respStr);
        this.insertPushLog(uocContractSyncLogPO);
        this.insertFailLog(uocContractSyncLogPO);
    }

    private void insertFailLog(UocContractSyncLogPO uocContractSyncLogPO) {
        UocContractSyncFailLogPO failLogPO = (UocContractSyncFailLogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)uocContractSyncLogPO), UocContractSyncFailLogPO.class);
        failLogPO.setLogId(Long.valueOf(this.idUtil.nextId()));
        this.uocContractSyncFailLogMapper.insert(failLogPO);
    }

    private void insertPushLog(UocContractSyncLogPO uocContractSyncLogPO) {
        this.uocContractSyncLogMapper.insert(uocContractSyncLogPO);
    }
}

