/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.common.ability.api.PebExtPushWarehouseRejectShipAbilityService;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseRejectShipAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectRspBO;
import com.tydic.uoc.common.busi.api.EsMsgLogBusiService;
import com.tydic.uoc.common.busi.api.PebPushErpBusiService;
import com.tydic.uoc.common.busi.api.PebPushWmsShipBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderDelieveredRejectBusiService;
import com.tydic.uoc.common.busi.api.UocSendMessageBusiService;
import com.tydic.uoc.common.busi.bo.EsMsgLogReqBO;
import com.tydic.uoc.common.busi.bo.EsMsgLogRspBO;
import com.tydic.uoc.common.busi.bo.UocReverseReqBO;
import com.tydic.uoc.common.busi.bo.UocSendMessageReqBO;
import com.tydic.uoc.common.comb.api.UocPebOrderDelieveredRejectCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdSendMessageMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdSendMessagePO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderDelieveredRejectCombService")
public class UocPebOrderDelieveredRejectCombServiceImpl
implements UocPebOrderDelieveredRejectCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderDelieveredRejectCombServiceImpl.class);
    @Autowired
    private UocPebOrderDelieveredRejectBusiService uocPebOrderDelieveredRejectBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;
    @Autowired
    private PebPushErpBusiService pebPushErpBusiService;
    @Autowired
    private EsMsgLogBusiService esMsgLogBusiService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Autowired
    private UocSendMessageBusiService uocSendMessageBusiService;
    @Resource
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdSendMessageMapper uocOrdSendMessageMapper;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebPushWmsShipBusiService pebPushWmsShipBusiService;
    @Autowired
    private PebExtPushWarehouseRejectShipAbilityService pebExtPushWarehouseRejectShipAbilityService;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;

    @Override
    public UocPebOrderDelieveredRejectRspBO executePebOrderDelieveredReject(UocPebOrderDelieveredRejectReqBO reqBO) {
        reqBO.setMsgId(null);
        reqBO.setOrderType(null);
        reqBO.setServiceId(null);
        UocPebOrderDelieveredRejectRspBO rspBO = this.uocPebOrderDelieveredRejectBusiService.executePebOrderDelieveredReject(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103004", "\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rspBO.getRespDesc());
        }
        if (null != rspBO.getIsPushArrivalAcceptanceOrder() && rspBO.getIsPushArrivalAcceptanceOrder().booleanValue()) {
            this.dealBusinessTodo(rspBO);
        }
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
        if (PebExtConstant.YES.equals(rspBO.getIsSendMsg())) {
            if (this.isSend()) {
                UocSendMessageReqBO msg = new UocSendMessageReqBO();
                msg.setOrderId(reqBO.getOrderId());
                this.uocSendMessageBusiService.dealSendMessage(msg);
            } else {
                UocOrdSendMessagePO uocOrdSendMessagePO = new UocOrdSendMessagePO();
                uocOrdSendMessagePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uocOrdSendMessagePO.setOrderId(reqBO.getOrderId());
                uocOrdSendMessagePO.setCreateId("666");
                uocOrdSendMessagePO.setCreateTime(new Date());
                uocOrdSendMessagePO.setHandleStatus(Integer.valueOf(0));
                this.uocOrdSendMessageMapper.insert(uocOrdSendMessagePO);
            }
        }
        if (PecConstant.EXT_ORDER_STATE.REFUSED.equals(reqBO.getStatus())) {
            if (this.reverse != null && this.reverse.booleanValue()) {
                UocReverseReqBO reverseReqBO = new UocReverseReqBO();
                reverseReqBO.setOrderId(reqBO.getOrderId());
                reverseReqBO.setObjId(rspBO.getShipVoucherId());
                reverseReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                this.uocPebOrderCancelMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)reverseReqBO)));
            }
        } else if (OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(String.valueOf(reqBO.getSupplierId()))) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(reqBO.getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (Objects.nonNull(zmInfoPO) && !PebExtConstant.YES.equals(zmInfoPO.getIsPlanOrder())) {
                PebPushErpReqBO erpReqBO = new PebPushErpReqBO();
                erpReqBO.setOrderId(reqBO.getOrderId());
                this.pebPushErpBusiService.dealPushErp(erpReqBO);
            }
        }
        UocPebOrdIdxSyncReqBO saleOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)saleOrdIdxSyncReqBO)));
        if ("0000".equals(rspBO.getRespCode())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
            for (OrdShipPO shipPO : ordShipPOList) {
                UocPebOrdIdxSyncReqBO shipOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(shipPO.getOrderId(), shipPO.getShipVoucherId(), UocConstant.OBJ_TYPE.SHIP);
                try {
                    EsMsgLogReqBO logReqBO = new EsMsgLogReqBO();
                    logReqBO.setObjId(shipOrdIdxSyncReqBO.getObjId());
                    logReqBO.setObjType(shipOrdIdxSyncReqBO.getObjType());
                    logReqBO.setOrderId(shipOrdIdxSyncReqBO.getOrderId());
                    EsMsgLogRspBO logRspBO = this.esMsgLogBusiService.dealSave(logReqBO);
                    shipOrdIdxSyncReqBO.setEsLogId(logRspBO.getId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)shipOrdIdxSyncReqBO)));
            }
        }
        if (reqBO.getStatus() != null && reqBO.getStatus() == 2) {
            UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
            warehousePO.setOrderId(reqBO.getOrderId());
            warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
            if (warehousePO != null) {
                PebExtPushWarehouseRejectShipAbilityReqBO rejectShipAbilityReqBO = new PebExtPushWarehouseRejectShipAbilityReqBO();
                rejectShipAbilityReqBO.setOrderId(reqBO.getOrderId());
                rejectShipAbilityReqBO.setShipVoucherId(rspBO.getShipVoucherId());
                this.pebExtPushWarehouseRejectShipAbilityService.dealPushWarehouseRejectShip(rejectShipAbilityReqBO);
            }
            this.sendSiKuMessage(reqBO.getOrderId(), true);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }

    private UocPebOrdIdxSyncReqBO bulidOrdIdxSyncReqBOParam(Long orderId, Long objId, Integer objType2) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(orderId);
        ordIdxSyncReqBO.setObjId(objId);
        ordIdxSyncReqBO.setObjType(objType2);
        return ordIdxSyncReqBO;
    }

    private boolean isSend() {
        LocalDate localDate = LocalDate.now();
        String dateStr = localDate.toString();
        String upStart = dateStr + " 09:30:00";
        String upEnd = dateStr + " 11:30:00";
        String downStart = dateStr + " 14:30:00";
        String downEnd = dateStr + " 18:00:00";
        Date date = new Date();
        Date upDateStart = DateUtils.strToDateLong((String)upStart);
        Date upDateEnd = DateUtils.strToDateLong((String)upEnd);
        Date downDateStart = DateUtils.strToDateLong((String)downStart);
        Date downDateEnd = DateUtils.strToDateLong((String)downEnd);
        boolean upAfter = date.after(upDateStart);
        boolean upBefore = date.before(upDateEnd);
        boolean downAfter = date.after(downDateStart);
        boolean downBefore = date.before(downDateEnd);
        return upAfter && upBefore || downAfter && downBefore;
    }

    private void sendSiKuMessage(Long orderId, Boolean flag) {
        PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
        siKuOrderAbilityReqBO.setOrderType("UPDATE");
        siKuOrderAbilityReqBO.setOrderId(orderId);
        siKuOrderAbilityReqBO.setElcOrderFlag(flag);
        this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
    }

    private void dealBusinessTodo(UocPebOrderDelieveredRejectRspBO rspBO) {
        try {
            TodoBusinessWaitDoneAddReqBo addReqBo = new TodoBusinessWaitDoneAddReqBo();
            addReqBo.setObjId(String.valueOf(rspBO.getOrderId()));
            addReqBo.setBusiCode("3031");
            UocBusinessPendingTodoAbilityAtomReqBO pendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
            pendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneAddReqBo(addReqBo);
            UocBusinessPendingTodoAbilityAtomRspBO pendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(pendingTodoAbilityAtomReqBO);
            if (!"0000".equals(pendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001-\u6dfb\u52a0\u5931\u8d25{}", (Object)addReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)addReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

