/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneDealReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipIReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocPebOrderRegistBusiService;
import com.tydic.uoc.common.busi.bo.UocPebOrderRegistRspBO;
import com.tydic.uoc.common.comb.api.UocPebOrderRegistCombService;
import com.tydic.uoc.common.comb.bo.UocPebOrderRegistReqBO;
import com.tydic.uoc.dao.OrdShipMapper;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPebOrderRegistCombServiceImpl
implements UocPebOrderRegistCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderRegistCombServiceImpl.class);
    @Autowired
    private UocPebOrderRegistBusiService uocPebOrderRegistBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;

    @Override
    public UocPebOrderRegistRspBO dealPebOrderRegist(UocPebOrderRegistReqBO reqBO) {
        UocPebOrderRegistRspBO rspBO = this.uocPebOrderRegistBusiService.dealPebOrderRegist(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        UocPebOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVourcherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        for (UocPebArrRegisterShipIReqBO arrRegisterShipReqBo : reqBO.getArrRegisterItemList()) {
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(arrRegisterShipReqBo.getShipVoucherId());
            ordIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            ordIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)ordIdxSyncReqBO)));
        }
        if (!StringUtils.isEmpty((CharSequence)String.valueOf(reqBO.getOrderId()))) {
            UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
            TodoBusinessWaitDoneDealReqBo dealReqBo = new TodoBusinessWaitDoneDealReqBo();
            dealReqBo.setBusiCode("3023");
            dealReqBo.setObjId(String.valueOf(reqBO.getOrderId()));
            dealReqBo.setDealUserNo(String.valueOf(reqBO.getUserId()));
            dealReqBo.setDealUserName(StringUtils.isEmpty((CharSequence)reqBO.getName()) ? String.valueOf(reqBO.getUserId()) : reqBO.getName());
            uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
            try {
                UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
                if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                    log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25{}", (Object)dealReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)uocBusinessPendingTodoAbilityAtomReqBO));
                }
            }
            catch (Exception e) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25{}", (Object)dealReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)uocBusinessPendingTodoAbilityAtomReqBO));
            }
        }
        return rspBO;
    }
}

